//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
	"net/http"
	"net/url"
	"regexp"
)

// TracksServer is a fake server for instances of the armmediaservices.TracksClient type.
type TracksServer struct {
	// BeginCreateOrUpdate is the fake for method TracksClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, accountName string, assetName string, trackName string, parameters armmediaservices.AssetTrack, options *armmediaservices.TracksClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmediaservices.TracksClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method TracksClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, assetName string, trackName string, options *armmediaservices.TracksClientBeginDeleteOptions) (resp azfake.PollerResponder[armmediaservices.TracksClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method TracksClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, assetName string, trackName string, options *armmediaservices.TracksClientGetOptions) (resp azfake.Responder[armmediaservices.TracksClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method TracksClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, assetName string, options *armmediaservices.TracksClientListOptions) (resp azfake.PagerResponder[armmediaservices.TracksClientListResponse])

	// BeginUpdate is the fake for method TracksClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, accountName string, assetName string, trackName string, parameters armmediaservices.AssetTrack, options *armmediaservices.TracksClientBeginUpdateOptions) (resp azfake.PollerResponder[armmediaservices.TracksClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateTrackData is the fake for method TracksClient.BeginUpdateTrackData
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginUpdateTrackData func(ctx context.Context, resourceGroupName string, accountName string, assetName string, trackName string, options *armmediaservices.TracksClientBeginUpdateTrackDataOptions) (resp azfake.PollerResponder[armmediaservices.TracksClientUpdateTrackDataResponse], errResp azfake.ErrorResponder)
}

// NewTracksServerTransport creates a new instance of TracksServerTransport with the provided implementation.
// The returned TracksServerTransport instance is connected to an instance of armmediaservices.TracksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTracksServerTransport(srv *TracksServer) *TracksServerTransport {
	return &TracksServerTransport{
		srv:                  srv,
		beginCreateOrUpdate:  newTracker[azfake.PollerResponder[armmediaservices.TracksClientCreateOrUpdateResponse]](),
		beginDelete:          newTracker[azfake.PollerResponder[armmediaservices.TracksClientDeleteResponse]](),
		newListPager:         newTracker[azfake.PagerResponder[armmediaservices.TracksClientListResponse]](),
		beginUpdate:          newTracker[azfake.PollerResponder[armmediaservices.TracksClientUpdateResponse]](),
		beginUpdateTrackData: newTracker[azfake.PollerResponder[armmediaservices.TracksClientUpdateTrackDataResponse]](),
	}
}

// TracksServerTransport connects instances of armmediaservices.TracksClient to instances of TracksServer.
// Don't use this type directly, use NewTracksServerTransport instead.
type TracksServerTransport struct {
	srv                  *TracksServer
	beginCreateOrUpdate  *tracker[azfake.PollerResponder[armmediaservices.TracksClientCreateOrUpdateResponse]]
	beginDelete          *tracker[azfake.PollerResponder[armmediaservices.TracksClientDeleteResponse]]
	newListPager         *tracker[azfake.PagerResponder[armmediaservices.TracksClientListResponse]]
	beginUpdate          *tracker[azfake.PollerResponder[armmediaservices.TracksClientUpdateResponse]]
	beginUpdateTrackData *tracker[azfake.PollerResponder[armmediaservices.TracksClientUpdateTrackDataResponse]]
}

// Do implements the policy.Transporter interface for TracksServerTransport.
func (t *TracksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TracksClient.BeginCreateOrUpdate":
		resp, err = t.dispatchBeginCreateOrUpdate(req)
	case "TracksClient.BeginDelete":
		resp, err = t.dispatchBeginDelete(req)
	case "TracksClient.Get":
		resp, err = t.dispatchGet(req)
	case "TracksClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	case "TracksClient.BeginUpdate":
		resp, err = t.dispatchBeginUpdate(req)
	case "TracksClient.BeginUpdateTrackData":
		resp, err = t.dispatchBeginUpdateTrackData(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TracksServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := t.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/assets/(?P<assetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tracks/(?P<trackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmediaservices.AssetTrack](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		assetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assetName")])
		if err != nil {
			return nil, err
		}
		trackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, accountNameParam, assetNameParam, trackNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		t.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		t.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		t.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (t *TracksServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if t.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := t.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/assets/(?P<assetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tracks/(?P<trackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		assetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assetName")])
		if err != nil {
			return nil, err
		}
		trackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, assetNameParam, trackNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		t.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		t.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		t.beginDelete.remove(req)
	}

	return resp, nil
}

func (t *TracksServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/assets/(?P<assetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tracks/(?P<trackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	assetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assetName")])
	if err != nil {
		return nil, err
	}
	trackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, assetNameParam, trackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AssetTrack, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TracksServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/assets/(?P<assetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tracks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		assetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assetName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListPager(resourceGroupNameParam, accountNameParam, assetNameParam, nil)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}

func (t *TracksServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := t.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/assets/(?P<assetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tracks/(?P<trackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmediaservices.AssetTrack](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		assetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assetName")])
		if err != nil {
			return nil, err
		}
		trackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginUpdate(req.Context(), resourceGroupNameParam, accountNameParam, assetNameParam, trackNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		t.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		t.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		t.beginUpdate.remove(req)
	}

	return resp, nil
}

func (t *TracksServerTransport) dispatchBeginUpdateTrackData(req *http.Request) (*http.Response, error) {
	if t.srv.BeginUpdateTrackData == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateTrackData not implemented")}
	}
	beginUpdateTrackData := t.beginUpdateTrackData.get(req)
	if beginUpdateTrackData == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/assets/(?P<assetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tracks/(?P<trackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateTrackData`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		assetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assetName")])
		if err != nil {
			return nil, err
		}
		trackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginUpdateTrackData(req.Context(), resourceGroupNameParam, accountNameParam, assetNameParam, trackNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateTrackData = &respr
		t.beginUpdateTrackData.add(req, beginUpdateTrackData)
	}

	resp, err := server.PollerResponderNext(beginUpdateTrackData, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		t.beginUpdateTrackData.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateTrackData) {
		t.beginUpdateTrackData.remove(req)
	}

	return resp, nil
}
