//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// StreamingEndpointsServer is a fake server for instances of the armmediaservices.StreamingEndpointsClient type.
type StreamingEndpointsServer struct {
	// AsyncOperation is the fake for method StreamingEndpointsClient.AsyncOperation
	// HTTP status codes to indicate success: http.StatusOK
	AsyncOperation func(ctx context.Context, resourceGroupName string, accountName string, operationID string, options *armmediaservices.StreamingEndpointsClientAsyncOperationOptions) (resp azfake.Responder[armmediaservices.StreamingEndpointsClientAsyncOperationResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method StreamingEndpointsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, accountName string, streamingEndpointName string, parameters armmediaservices.StreamingEndpoint, options *armmediaservices.StreamingEndpointsClientBeginCreateOptions) (resp azfake.PollerResponder[armmediaservices.StreamingEndpointsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method StreamingEndpointsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, streamingEndpointName string, options *armmediaservices.StreamingEndpointsClientBeginDeleteOptions) (resp azfake.PollerResponder[armmediaservices.StreamingEndpointsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method StreamingEndpointsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, streamingEndpointName string, options *armmediaservices.StreamingEndpointsClientGetOptions) (resp azfake.Responder[armmediaservices.StreamingEndpointsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method StreamingEndpointsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, options *armmediaservices.StreamingEndpointsClientListOptions) (resp azfake.PagerResponder[armmediaservices.StreamingEndpointsClientListResponse])

	// OperationLocation is the fake for method StreamingEndpointsClient.OperationLocation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	OperationLocation func(ctx context.Context, resourceGroupName string, accountName string, streamingEndpointName string, operationID string, options *armmediaservices.StreamingEndpointsClientOperationLocationOptions) (resp azfake.Responder[armmediaservices.StreamingEndpointsClientOperationLocationResponse], errResp azfake.ErrorResponder)

	// SKUs is the fake for method StreamingEndpointsClient.SKUs
	// HTTP status codes to indicate success: http.StatusOK
	SKUs func(ctx context.Context, resourceGroupName string, accountName string, streamingEndpointName string, options *armmediaservices.StreamingEndpointsClientSKUsOptions) (resp azfake.Responder[armmediaservices.StreamingEndpointsClientSKUsResponse], errResp azfake.ErrorResponder)

	// BeginScale is the fake for method StreamingEndpointsClient.BeginScale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginScale func(ctx context.Context, resourceGroupName string, accountName string, streamingEndpointName string, parameters armmediaservices.StreamingEntityScaleUnit, options *armmediaservices.StreamingEndpointsClientBeginScaleOptions) (resp azfake.PollerResponder[armmediaservices.StreamingEndpointsClientScaleResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method StreamingEndpointsClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, accountName string, streamingEndpointName string, options *armmediaservices.StreamingEndpointsClientBeginStartOptions) (resp azfake.PollerResponder[armmediaservices.StreamingEndpointsClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method StreamingEndpointsClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStop func(ctx context.Context, resourceGroupName string, accountName string, streamingEndpointName string, options *armmediaservices.StreamingEndpointsClientBeginStopOptions) (resp azfake.PollerResponder[armmediaservices.StreamingEndpointsClientStopResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method StreamingEndpointsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, accountName string, streamingEndpointName string, parameters armmediaservices.StreamingEndpoint, options *armmediaservices.StreamingEndpointsClientBeginUpdateOptions) (resp azfake.PollerResponder[armmediaservices.StreamingEndpointsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewStreamingEndpointsServerTransport creates a new instance of StreamingEndpointsServerTransport with the provided implementation.
// The returned StreamingEndpointsServerTransport instance is connected to an instance of armmediaservices.StreamingEndpointsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStreamingEndpointsServerTransport(srv *StreamingEndpointsServer) *StreamingEndpointsServerTransport {
	return &StreamingEndpointsServerTransport{
		srv:          srv,
		beginCreate:  newTracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientCreateResponse]](),
		beginDelete:  newTracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientDeleteResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armmediaservices.StreamingEndpointsClientListResponse]](),
		beginScale:   newTracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientScaleResponse]](),
		beginStart:   newTracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientStartResponse]](),
		beginStop:    newTracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientStopResponse]](),
		beginUpdate:  newTracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientUpdateResponse]](),
	}
}

// StreamingEndpointsServerTransport connects instances of armmediaservices.StreamingEndpointsClient to instances of StreamingEndpointsServer.
// Don't use this type directly, use NewStreamingEndpointsServerTransport instead.
type StreamingEndpointsServerTransport struct {
	srv          *StreamingEndpointsServer
	beginCreate  *tracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientCreateResponse]]
	beginDelete  *tracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientDeleteResponse]]
	newListPager *tracker[azfake.PagerResponder[armmediaservices.StreamingEndpointsClientListResponse]]
	beginScale   *tracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientScaleResponse]]
	beginStart   *tracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientStartResponse]]
	beginStop    *tracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientStopResponse]]
	beginUpdate  *tracker[azfake.PollerResponder[armmediaservices.StreamingEndpointsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for StreamingEndpointsServerTransport.
func (s *StreamingEndpointsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StreamingEndpointsClient.AsyncOperation":
		resp, err = s.dispatchAsyncOperation(req)
	case "StreamingEndpointsClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "StreamingEndpointsClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "StreamingEndpointsClient.Get":
		resp, err = s.dispatchGet(req)
	case "StreamingEndpointsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "StreamingEndpointsClient.OperationLocation":
		resp, err = s.dispatchOperationLocation(req)
	case "StreamingEndpointsClient.SKUs":
		resp, err = s.dispatchSKUs(req)
	case "StreamingEndpointsClient.BeginScale":
		resp, err = s.dispatchBeginScale(req)
	case "StreamingEndpointsClient.BeginStart":
		resp, err = s.dispatchBeginStart(req)
	case "StreamingEndpointsClient.BeginStop":
		resp, err = s.dispatchBeginStop(req)
	case "StreamingEndpointsClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchAsyncOperation(req *http.Request) (*http.Response, error) {
	if s.srv.AsyncOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method AsyncOperation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpointOperations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.AsyncOperation(req.Context(), resourceGroupNameParam, accountNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AsyncOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints/(?P<streamingEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armmediaservices.StreamingEndpoint](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		streamingEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingEndpointName")])
		if err != nil {
			return nil, err
		}
		autoStartUnescaped, err := url.QueryUnescape(qp.Get("autoStart"))
		if err != nil {
			return nil, err
		}
		autoStartParam, err := parseOptional(autoStartUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armmediaservices.StreamingEndpointsClientBeginCreateOptions
		if autoStartParam != nil {
			options = &armmediaservices.StreamingEndpointsClientBeginCreateOptions{
				AutoStart: autoStartParam,
			}
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), resourceGroupNameParam, accountNameParam, streamingEndpointNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints/(?P<streamingEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		streamingEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingEndpointName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, streamingEndpointNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints/(?P<streamingEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	streamingEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingEndpointName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, streamingEndpointNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StreamingEndpoint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, accountNameParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmediaservices.StreamingEndpointsClientListResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchOperationLocation(req *http.Request) (*http.Response, error) {
	if s.srv.OperationLocation == nil {
		return nil, &nonRetriableError{errors.New("fake for method OperationLocation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints/(?P<streamingEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationLocations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	streamingEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingEndpointName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.OperationLocation(req.Context(), resourceGroupNameParam, accountNameParam, streamingEndpointNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StreamingEndpoint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchSKUs(req *http.Request) (*http.Response, error) {
	if s.srv.SKUs == nil {
		return nil, &nonRetriableError{errors.New("fake for method SKUs not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints/(?P<streamingEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	streamingEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingEndpointName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.SKUs(req.Context(), resourceGroupNameParam, accountNameParam, streamingEndpointNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StreamingEndpointSKUInfoListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchBeginScale(req *http.Request) (*http.Response, error) {
	if s.srv.BeginScale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginScale not implemented")}
	}
	beginScale := s.beginScale.get(req)
	if beginScale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints/(?P<streamingEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmediaservices.StreamingEntityScaleUnit](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		streamingEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingEndpointName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginScale(req.Context(), resourceGroupNameParam, accountNameParam, streamingEndpointNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginScale = &respr
		s.beginScale.add(req, beginScale)
	}

	resp, err := server.PollerResponderNext(beginScale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginScale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginScale) {
		s.beginScale.remove(req)
	}

	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if s.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := s.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints/(?P<streamingEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		streamingEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingEndpointName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginStart(req.Context(), resourceGroupNameParam, accountNameParam, streamingEndpointNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		s.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		s.beginStart.remove(req)
	}

	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if s.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := s.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints/(?P<streamingEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		streamingEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingEndpointName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginStop(req.Context(), resourceGroupNameParam, accountNameParam, streamingEndpointNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		s.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		s.beginStop.remove(req)
	}

	return resp, nil
}

func (s *StreamingEndpointsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingEndpoints/(?P<streamingEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmediaservices.StreamingEndpoint](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		streamingEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingEndpointName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), resourceGroupNameParam, accountNameParam, streamingEndpointNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}
