//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagednetworkfabric

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// NetworkFabricSKUsClient contains the methods for the NetworkFabricSKUs group.
// Don't use this type directly, use NewNetworkFabricSKUsClient() instead.
type NetworkFabricSKUsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewNetworkFabricSKUsClient creates a new instance of NetworkFabricSKUsClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewNetworkFabricSKUsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*NetworkFabricSKUsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &NetworkFabricSKUsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Implements Network Fabric SKU GET method.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-15
//   - networkFabricSKUName - Name of the Network Fabric SKU.
//   - options - NetworkFabricSKUsClientGetOptions contains the optional parameters for the NetworkFabricSKUsClient.Get method.
func (client *NetworkFabricSKUsClient) Get(ctx context.Context, networkFabricSKUName string, options *NetworkFabricSKUsClientGetOptions) (NetworkFabricSKUsClientGetResponse, error) {
	var err error
	const operationName = "NetworkFabricSKUsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, networkFabricSKUName, options)
	if err != nil {
		return NetworkFabricSKUsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return NetworkFabricSKUsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return NetworkFabricSKUsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *NetworkFabricSKUsClient) getCreateRequest(ctx context.Context, networkFabricSKUName string, options *NetworkFabricSKUsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ManagedNetworkFabric/networkFabricSkus/{networkFabricSkuName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if networkFabricSKUName == "" {
		return nil, errors.New("parameter networkFabricSKUName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFabricSkuName}", url.PathEscape(networkFabricSKUName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *NetworkFabricSKUsClient) getHandleResponse(resp *http.Response) (NetworkFabricSKUsClientGetResponse, error) {
	result := NetworkFabricSKUsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkFabricSKU); err != nil {
		return NetworkFabricSKUsClientGetResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Implements Network Fabric SKUs list by subscription GET method.
//
// Generated from API version 2023-06-15
//   - options - NetworkFabricSKUsClientListBySubscriptionOptions contains the optional parameters for the NetworkFabricSKUsClient.NewListBySubscriptionPager
//     method.
func (client *NetworkFabricSKUsClient) NewListBySubscriptionPager(options *NetworkFabricSKUsClientListBySubscriptionOptions) *runtime.Pager[NetworkFabricSKUsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[NetworkFabricSKUsClientListBySubscriptionResponse]{
		More: func(page NetworkFabricSKUsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *NetworkFabricSKUsClientListBySubscriptionResponse) (NetworkFabricSKUsClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "NetworkFabricSKUsClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return NetworkFabricSKUsClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *NetworkFabricSKUsClient) listBySubscriptionCreateRequest(ctx context.Context, options *NetworkFabricSKUsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ManagedNetworkFabric/networkFabricSkus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *NetworkFabricSKUsClient) listBySubscriptionHandleResponse(resp *http.Response) (NetworkFabricSKUsClientListBySubscriptionResponse, error) {
	result := NetworkFabricSKUsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkFabricSKUsListResult); err != nil {
		return NetworkFabricSKUsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}
