//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armm365securityandcompliance_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/m365securityandcompliance/armm365securityandcompliance"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/m365securityandcompliance/resource-manager/Microsoft.M365SecurityAndCompliance/preview/2021-03-25-preview/examples/ComplianceCenterOperationsList.json
func ExampleOperationsClient_NewListPager_listComplianceCenterOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armm365securityandcompliance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armm365securityandcompliance.OperationListResult{
		// 	Value: []*armm365securityandcompliance.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365ComplianceCenter/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365ComplianceCenter/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365ComplianceCenter/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365ComplianceCenter/privateEndpointConnections/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365ComplianceCenter/privateEndpointConnections/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365ComplianceCenter/privateEndpointConnections/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365ComplianceCenter/privateLinkResources/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/m365securityandcompliance/resource-manager/Microsoft.M365SecurityAndCompliance/preview/2021-03-25-preview/examples/EdmUploadOperationsList.json
func ExampleOperationsClient_NewListPager_listEdmUploadOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armm365securityandcompliance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armm365securityandcompliance.OperationListResult{
		// 	Value: []*armm365securityandcompliance.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForEDMUpload/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForEDMUpload/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForEDMUpload/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForEDMUpload/privateEndpointConnections/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForEDMUpload/privateEndpointConnections/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForEDMUpload/privateEndpointConnections/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForEDMUpload/privateLinkResources/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/m365securityandcompliance/resource-manager/Microsoft.M365SecurityAndCompliance/preview/2021-03-25-preview/examples/MIPPolicySyncOperationsList.json
func ExampleOperationsClient_NewListPager_listMipPolicySyncOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armm365securityandcompliance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armm365securityandcompliance.OperationListResult{
		// 	Value: []*armm365securityandcompliance.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForMIPPolicySync/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForMIPPolicySync/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForMIPPolicySync/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForMIPPolicySync/privateEndpointConnections/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForMIPPolicySync/privateEndpointConnections/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForMIPPolicySync/privateEndpointConnections/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForMIPPolicySync/privateLinkResources/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/m365securityandcompliance/resource-manager/Microsoft.M365SecurityAndCompliance/preview/2021-03-25-preview/examples/ManagementAPIOperationsList.json
func ExampleOperationsClient_NewListPager_listManagementApiOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armm365securityandcompliance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armm365securityandcompliance.OperationListResult{
		// 	Value: []*armm365securityandcompliance.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForO365ManagementActivityAPI/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForO365ManagementActivityAPI/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForO365ManagementActivityAPI/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForO365ManagementActivityAPI/privateEndpointConnections/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForO365ManagementActivityAPI/privateEndpointConnections/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForO365ManagementActivityAPI/privateEndpointConnections/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForO365ManagementActivityAPI/privateLinkResources/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/m365securityandcompliance/resource-manager/Microsoft.M365SecurityAndCompliance/preview/2021-03-25-preview/examples/SCCPowershellOperationsList.json
func ExampleOperationsClient_NewListPager_listSccPowershellOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armm365securityandcompliance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armm365securityandcompliance.OperationListResult{
		// 	Value: []*armm365securityandcompliance.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForSCCPowershell/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForSCCPowershell/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForSCCPowershell/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForSCCPowershell/privateEndpointConnections/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForSCCPowershell/privateEndpointConnections/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForSCCPowershell/privateEndpointConnections/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForSCCPowershell/privateLinkResources/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/m365securityandcompliance/resource-manager/Microsoft.M365SecurityAndCompliance/preview/2021-03-25-preview/examples/SecurityCenterOperationsList.json
func ExampleOperationsClient_NewListPager_listSecurityCenterOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armm365securityandcompliance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armm365securityandcompliance.OperationListResult{
		// 	Value: []*armm365securityandcompliance.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365SecurityCenter/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365SecurityCenter/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365SecurityCenter/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365SecurityCenter/privateEndpointConnections/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365SecurityCenter/privateEndpointConnections/write"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365SecurityCenter/privateEndpointConnections/delete"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/privateLinkServicesForM365SecurityCenter/privateLinkResources/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/m365securityandcompliance/resource-manager/Microsoft.M365SecurityAndCompliance/preview/2021-03-25-preview/examples/OperationsList.json
func ExampleOperationsClient_NewListPager_listOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armm365securityandcompliance.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armm365securityandcompliance.OperationListResult{
		// 	Value: []*armm365securityandcompliance.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/locations/operationresults/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 				Description: to.Ptr("Get the status of an asynchronous operation"),
		// 				Operation: to.Ptr("read"),
		// 				Provider: to.Ptr("Microsoft.M365SecurityAndCompliance"),
		// 				Resource: to.Ptr("operationresults"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.M365SecurityAndCompliance/Operations/read"),
		// 			Display: &armm365securityandcompliance.OperationDisplay{
		// 				Description: to.Ptr("Get the list of operations supported by this Resource Provider."),
		// 				Operation: to.Ptr("read"),
		// 				Provider: to.Ptr("Microsoft.M365SecurityAndCompliance"),
		// 				Resource: to.Ptr("operations"),
		// 			},
		// 			Origin: to.Ptr("user,system"),
		// 	}},
		// }
	}
}
