//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armlogz_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logz/armlogz"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logz/resource-manager/Microsoft.Logz/stable/2020-10-01/examples/SingleSignOnConfigurations_List.json
func ExampleSingleSignOnClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogz.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSingleSignOnClient().NewListPager("myResourceGroup", "myMonitor", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SingleSignOnResourceListResponse = armlogz.SingleSignOnResourceListResponse{
		// 	Value: []*armlogz.SingleSignOnResource{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Logz/monitors"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Logz/monitors/myMonitor/singleSignOnConfigurations/default"),
		// 			Properties: &armlogz.SingleSignOnProperties{
		// 				EnterpriseAppID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				ProvisioningState: to.Ptr(armlogz.ProvisioningStateSucceeded),
		// 				SingleSignOnState: to.Ptr(armlogz.SingleSignOnStatesEnable),
		// 				SingleSignOnURL: to.Ptr("https://www.logz.io/IAmSomeHash"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logz/resource-manager/Microsoft.Logz/stable/2020-10-01/examples/SingleSignOnConfigurations_CreateOrUpdate.json
func ExampleSingleSignOnClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogz.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSingleSignOnClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myMonitor", "default", &armlogz.SingleSignOnClientBeginCreateOrUpdateOptions{Body: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SingleSignOnResource = armlogz.SingleSignOnResource{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Logz/monitors"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Logz/monitors/myMonitor/singleSignOnConfigurations/default"),
	// 	Properties: &armlogz.SingleSignOnProperties{
	// 		EnterpriseAppID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		ProvisioningState: to.Ptr(armlogz.ProvisioningStateSucceeded),
	// 		SingleSignOnState: to.Ptr(armlogz.SingleSignOnStatesEnable),
	// 		SingleSignOnURL: to.Ptr("https://www.logz.io/IAmSomeHash"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logz/resource-manager/Microsoft.Logz/stable/2020-10-01/examples/SingleSignOnConfigurations_Get.json
func ExampleSingleSignOnClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogz.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSingleSignOnClient().Get(ctx, "myResourceGroup", "myMonitor", "default", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SingleSignOnResource = armlogz.SingleSignOnResource{
	// 	Name: to.Ptr("default"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Logz/monitors/myMonitor/singleSignOnConfigurations/default"),
	// 	Properties: &armlogz.SingleSignOnProperties{
	// 		EnterpriseAppID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		ProvisioningState: to.Ptr(armlogz.ProvisioningStateSucceeded),
	// 		SingleSignOnState: to.Ptr(armlogz.SingleSignOnStatesEnable),
	// 		SingleSignOnURL: to.Ptr("https://www.loz.io/IAmSomeHash"),
	// 	},
	// }
}
