//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logz/armlogz"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// SubAccountTagRulesServer is a fake server for instances of the armlogz.SubAccountTagRulesClient type.
type SubAccountTagRulesServer struct {
	// CreateOrUpdate is the fake for method SubAccountTagRulesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, ruleSetName string, options *armlogz.SubAccountTagRulesClientCreateOrUpdateOptions) (resp azfake.Responder[armlogz.SubAccountTagRulesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SubAccountTagRulesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, ruleSetName string, options *armlogz.SubAccountTagRulesClientDeleteOptions) (resp azfake.Responder[armlogz.SubAccountTagRulesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SubAccountTagRulesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, ruleSetName string, options *armlogz.SubAccountTagRulesClientGetOptions) (resp azfake.Responder[armlogz.SubAccountTagRulesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method SubAccountTagRulesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, monitorName string, subAccountName string, options *armlogz.SubAccountTagRulesClientListOptions) (resp azfake.PagerResponder[armlogz.SubAccountTagRulesClientListResponse])
}

// NewSubAccountTagRulesServerTransport creates a new instance of SubAccountTagRulesServerTransport with the provided implementation.
// The returned SubAccountTagRulesServerTransport instance is connected to an instance of armlogz.SubAccountTagRulesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSubAccountTagRulesServerTransport(srv *SubAccountTagRulesServer) *SubAccountTagRulesServerTransport {
	return &SubAccountTagRulesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armlogz.SubAccountTagRulesClientListResponse]](),
	}
}

// SubAccountTagRulesServerTransport connects instances of armlogz.SubAccountTagRulesClient to instances of SubAccountTagRulesServer.
// Don't use this type directly, use NewSubAccountTagRulesServerTransport instead.
type SubAccountTagRulesServerTransport struct {
	srv          *SubAccountTagRulesServer
	newListPager *tracker[azfake.PagerResponder[armlogz.SubAccountTagRulesClientListResponse]]
}

// Do implements the policy.Transporter interface for SubAccountTagRulesServerTransport.
func (s *SubAccountTagRulesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SubAccountTagRulesClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SubAccountTagRulesClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SubAccountTagRulesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SubAccountTagRulesClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SubAccountTagRulesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tagRules/(?P<ruleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlogz.MonitoringTagRules](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
	if err != nil {
		return nil, err
	}
	ruleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleSetName")])
	if err != nil {
		return nil, err
	}
	var options *armlogz.SubAccountTagRulesClientCreateOrUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armlogz.SubAccountTagRulesClientCreateOrUpdateOptions{
			Body: &body,
		}
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, monitorNameParam, subAccountNameParam, ruleSetNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MonitoringTagRules, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubAccountTagRulesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tagRules/(?P<ruleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
	if err != nil {
		return nil, err
	}
	ruleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleSetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, monitorNameParam, subAccountNameParam, ruleSetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).Location; val != nil {
		resp.Header.Set("location", *val)
	}
	return resp, nil
}

func (s *SubAccountTagRulesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tagRules/(?P<ruleSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
	if err != nil {
		return nil, err
	}
	ruleSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("ruleSetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, monitorNameParam, subAccountNameParam, ruleSetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MonitoringTagRules, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubAccountTagRulesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logz/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accounts/(?P<subAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tagRules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		subAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subAccountName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, monitorNameParam, subAccountNameParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armlogz.SubAccountTagRulesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
