//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armlogic_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_ListBySubscription.json
func ExampleWorkflowsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkflowsClient().NewListBySubscriptionPager(&armlogic.WorkflowsClientListBySubscriptionOptions{Top: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkflowListResult = armlogic.WorkflowListResult{
		// 	Value: []*armlogic.Workflow{
		// 		{
		// 			Name: to.Ptr("test-workflow"),
		// 			Type: to.Ptr("Microsoft.Logic/workflows"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/workflows/test-workflow"),
		// 			Location: to.Ptr("brazilsouth"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armlogic.WorkflowProperties{
		// 				AccessControl: &armlogic.FlowAccessControlConfiguration{
		// 				},
		// 				AccessEndpoint: to.Ptr("http://tempuri.org"),
		// 				ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-09T22:54:54.353Z"); return t}()),
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-04-25T01:39:21.436Z"); return t}()),
		// 				Definition: map[string]any{
		// 					"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
		// 					"actions":map[string]any{
		// 					},
		// 					"contentVersion": "1.0.0.0",
		// 					"outputs":map[string]any{
		// 					},
		// 					"parameters":map[string]any{
		// 					},
		// 					"triggers":map[string]any{
		// 					},
		// 				},
		// 				EndpointsConfiguration: &armlogic.FlowEndpointsConfiguration{
		// 					Connector: &armlogic.FlowEndpoints{
		// 						OutgoingIPAddresses: []*armlogic.IPAddress{
		// 							{
		// 								Address: to.Ptr("40.84.145.61"),
		// 						}},
		// 					},
		// 					Workflow: &armlogic.FlowEndpoints{
		// 						AccessEndpointIPAddresses: []*armlogic.IPAddress{
		// 							{
		// 								Address: to.Ptr("104.210.153.89"),
		// 							},
		// 							{
		// 								Address: to.Ptr("13.85.79.155"),
		// 							},
		// 							{
		// 								Address: to.Ptr("13.65.39.247"),
		// 						}},
		// 						OutgoingIPAddresses: []*armlogic.IPAddress{
		// 							{
		// 								Address: to.Ptr("13.84.159.168"),
		// 							},
		// 							{
		// 								Address: to.Ptr("13.65.86.56"),
		// 							},
		// 							{
		// 								Address: to.Ptr("13.65.82.190"),
		// 						}},
		// 					},
		// 				},
		// 				IntegrationAccount: &armlogic.ResourceReference{
		// 					Name: to.Ptr("test-integration-account"),
		// 					Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
		// 					ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
		// 				},
		// 				Parameters: map[string]*armlogic.WorkflowParameter{
		// 				},
		// 				ProvisioningState: to.Ptr(armlogic.WorkflowProvisioningStateSucceeded),
		// 				State: to.Ptr(armlogic.WorkflowStateEnabled),
		// 				Version: to.Ptr("08586677515911718341"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_ListByResourceGroup.json
func ExampleWorkflowsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkflowsClient().NewListByResourceGroupPager("test-resource-group", &armlogic.WorkflowsClientListByResourceGroupOptions{Top: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkflowListResult = armlogic.WorkflowListResult{
		// 	Value: []*armlogic.Workflow{
		// 		{
		// 			Name: to.Ptr("test-workflow"),
		// 			Type: to.Ptr("Microsoft.Logic/workflows"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/workflows/test-workflow"),
		// 			Location: to.Ptr("brazilsouth"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armlogic.WorkflowProperties{
		// 				AccessControl: &armlogic.FlowAccessControlConfiguration{
		// 				},
		// 				AccessEndpoint: to.Ptr("http://tempuri.org"),
		// 				ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-09T22:54:54.353Z"); return t}()),
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-04-25T01:39:21.436Z"); return t}()),
		// 				Definition: map[string]any{
		// 					"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
		// 					"actions":map[string]any{
		// 					},
		// 					"contentVersion": "1.0.0.0",
		// 					"outputs":map[string]any{
		// 					},
		// 					"parameters":map[string]any{
		// 					},
		// 					"triggers":map[string]any{
		// 					},
		// 				},
		// 				EndpointsConfiguration: &armlogic.FlowEndpointsConfiguration{
		// 					Connector: &armlogic.FlowEndpoints{
		// 						OutgoingIPAddresses: []*armlogic.IPAddress{
		// 							{
		// 								Address: to.Ptr("40.84.145.61"),
		// 						}},
		// 					},
		// 					Workflow: &armlogic.FlowEndpoints{
		// 						AccessEndpointIPAddresses: []*armlogic.IPAddress{
		// 							{
		// 								Address: to.Ptr("104.210.153.89"),
		// 							},
		// 							{
		// 								Address: to.Ptr("13.85.79.155"),
		// 							},
		// 							{
		// 								Address: to.Ptr("13.65.39.247"),
		// 						}},
		// 						OutgoingIPAddresses: []*armlogic.IPAddress{
		// 							{
		// 								Address: to.Ptr("13.84.159.168"),
		// 							},
		// 							{
		// 								Address: to.Ptr("13.65.86.56"),
		// 							},
		// 							{
		// 								Address: to.Ptr("13.65.82.190"),
		// 						}},
		// 					},
		// 				},
		// 				IntegrationAccount: &armlogic.ResourceReference{
		// 					Name: to.Ptr("test-integration-account"),
		// 					Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
		// 					ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
		// 				},
		// 				Parameters: map[string]*armlogic.WorkflowParameter{
		// 				},
		// 				ProvisioningState: to.Ptr(armlogic.WorkflowProvisioningStateSucceeded),
		// 				State: to.Ptr(armlogic.WorkflowStateEnabled),
		// 				Version: to.Ptr("08586677515911718341"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_Get.json
func ExampleWorkflowsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkflowsClient().Get(ctx, "test-resource-group", "test-workflow", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workflow = armlogic.Workflow{
	// 	Name: to.Ptr("test-workflow"),
	// 	Type: to.Ptr("Microsoft.Logic/workflows"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/workflows/test-workflow"),
	// 	Location: to.Ptr("brazilsouth"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armlogic.WorkflowProperties{
	// 		AccessEndpoint: to.Ptr("http://tempuri.org"),
	// 		ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-09T22:54:54.353Z"); return t}()),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-04-25T01:39:21.436Z"); return t}()),
	// 		Definition: map[string]any{
	// 			"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2018-07-01-preview/workflowdefinition.json#",
	// 			"actions":map[string]any{
	// 			},
	// 			"contentVersion": "1.0.0.0",
	// 			"outputs":map[string]any{
	// 			},
	// 			"parameters":map[string]any{
	// 			},
	// 			"triggers":map[string]any{
	// 			},
	// 		},
	// 		EndpointsConfiguration: &armlogic.FlowEndpointsConfiguration{
	// 			Connector: &armlogic.FlowEndpoints{
	// 				OutgoingIPAddresses: []*armlogic.IPAddress{
	// 					{
	// 						Address: to.Ptr("40.84.145.61"),
	// 				}},
	// 			},
	// 			Workflow: &armlogic.FlowEndpoints{
	// 				AccessEndpointIPAddresses: []*armlogic.IPAddress{
	// 					{
	// 						Address: to.Ptr("104.210.153.89"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.85.79.155"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.65.39.247"),
	// 				}},
	// 				OutgoingIPAddresses: []*armlogic.IPAddress{
	// 					{
	// 						Address: to.Ptr("13.84.159.168"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.65.86.56"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.65.82.190"),
	// 				}},
	// 			},
	// 		},
	// 		IntegrationAccount: &armlogic.ResourceReference{
	// 			Name: to.Ptr("test-integration-account"),
	// 			Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
	// 		},
	// 		IntegrationServiceEnvironment: &armlogic.ResourceReference{
	// 			Name: to.Ptr("test-integration-service-environment"),
	// 			Type: to.Ptr("Microsoft.Logic/integrationServiceEnvironments"),
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationServiceEnvironments/test-integration-service-environment"),
	// 		},
	// 		Parameters: map[string]*armlogic.WorkflowParameter{
	// 		},
	// 		ProvisioningState: to.Ptr(armlogic.WorkflowProvisioningStateSucceeded),
	// 		State: to.Ptr(armlogic.WorkflowStateEnabled),
	// 		Version: to.Ptr("08586677515911718341"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_CreateOrUpdate.json
func ExampleWorkflowsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkflowsClient().CreateOrUpdate(ctx, "test-resource-group", "test-workflow", armlogic.Workflow{
		Location: to.Ptr("brazilsouth"),
		Tags:     map[string]*string{},
		Properties: &armlogic.WorkflowProperties{
			Definition: map[string]any{
				"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
				"actions": map[string]any{
					"Find_pet_by_ID": map[string]any{
						"type": "ApiConnection",
						"inputs": map[string]any{
							"path":   "/pet/@{encodeURIComponent('1')}",
							"method": "get",
							"host": map[string]any{
								"connection": map[string]any{
									"name": "@parameters('$connections')['test-custom-connector']['connectionId']",
								},
							},
						},
						"runAfter": map[string]any{},
					},
				},
				"contentVersion": "1.0.0.0",
				"outputs":        map[string]any{},
				"parameters": map[string]any{
					"$connections": map[string]any{
						"type":         "Object",
						"defaultValue": map[string]any{},
					},
				},
				"triggers": map[string]any{
					"manual": map[string]any{
						"type": "Request",
						"inputs": map[string]any{
							"schema": map[string]any{},
						},
						"kind": "Http",
					},
				},
			},
			IntegrationAccount: &armlogic.ResourceReference{
				ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
			},
			Parameters: map[string]*armlogic.WorkflowParameter{
				"$connections": {
					Value: map[string]any{
						"test-custom-connector": map[string]any{
							"connectionId":   "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Web/connections/test-custom-connector",
							"connectionName": "test-custom-connector",
							"id":             "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/brazilsouth/managedApis/test-custom-connector",
						},
					},
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workflow = armlogic.Workflow{
	// 	Properties: &armlogic.WorkflowProperties{
	// 		AccessEndpoint: to.Ptr("http://tempuri.org"),
	// 		ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-09T22:54:54.353Z"); return t}()),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-04-25T01:39:21.436Z"); return t}()),
	// 		Definition: map[string]any{
	// 			"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
	// 			"actions":map[string]any{
	// 			},
	// 			"contentVersion": "1.0.0.0",
	// 			"outputs":map[string]any{
	// 			},
	// 			"parameters":map[string]any{
	// 			},
	// 			"triggers":map[string]any{
	// 			},
	// 		},
	// 		EndpointsConfiguration: &armlogic.FlowEndpointsConfiguration{
	// 			Connector: &armlogic.FlowEndpoints{
	// 				OutgoingIPAddresses: []*armlogic.IPAddress{
	// 					{
	// 						Address: to.Ptr("40.84.145.61"),
	// 				}},
	// 			},
	// 			Workflow: &armlogic.FlowEndpoints{
	// 				AccessEndpointIPAddresses: []*armlogic.IPAddress{
	// 					{
	// 						Address: to.Ptr("104.210.153.89"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.85.79.155"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.65.39.247"),
	// 				}},
	// 				OutgoingIPAddresses: []*armlogic.IPAddress{
	// 					{
	// 						Address: to.Ptr("13.84.159.168"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.65.86.56"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.65.82.190"),
	// 				}},
	// 			},
	// 		},
	// 		IntegrationAccount: &armlogic.ResourceReference{
	// 			Name: to.Ptr("test-integration-account"),
	// 			Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
	// 		},
	// 		IntegrationServiceEnvironment: &armlogic.ResourceReference{
	// 			Name: to.Ptr("test-integration-service-environment"),
	// 			Type: to.Ptr("Microsoft.Logic/integrationServiceEnvironments"),
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationServiceEnvironments/test-integration-service-environment"),
	// 		},
	// 		Parameters: map[string]*armlogic.WorkflowParameter{
	// 		},
	// 		ProvisioningState: to.Ptr(armlogic.WorkflowProvisioningStateSucceeded),
	// 		State: to.Ptr(armlogic.WorkflowStateEnabled),
	// 		Version: to.Ptr("08586677515911718341"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_Update.json
func ExampleWorkflowsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkflowsClient().Update(ctx, "test-resource-group", "test-workflow", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Workflow = armlogic.Workflow{
	// 	Properties: &armlogic.WorkflowProperties{
	// 		AccessEndpoint: to.Ptr("http://tempuri.org"),
	// 		ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-09T22:54:54.353Z"); return t}()),
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-04-25T01:39:21.436Z"); return t}()),
	// 		Definition: map[string]any{
	// 			"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
	// 			"actions":map[string]any{
	// 			},
	// 			"contentVersion": "1.0.0.0",
	// 			"outputs":map[string]any{
	// 			},
	// 			"parameters":map[string]any{
	// 			},
	// 			"triggers":map[string]any{
	// 			},
	// 		},
	// 		EndpointsConfiguration: &armlogic.FlowEndpointsConfiguration{
	// 			Connector: &armlogic.FlowEndpoints{
	// 				OutgoingIPAddresses: []*armlogic.IPAddress{
	// 					{
	// 						Address: to.Ptr("40.84.145.61"),
	// 				}},
	// 			},
	// 			Workflow: &armlogic.FlowEndpoints{
	// 				AccessEndpointIPAddresses: []*armlogic.IPAddress{
	// 					{
	// 						Address: to.Ptr("104.210.153.89"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.85.79.155"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.65.39.247"),
	// 				}},
	// 				OutgoingIPAddresses: []*armlogic.IPAddress{
	// 					{
	// 						Address: to.Ptr("13.84.159.168"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.65.86.56"),
	// 					},
	// 					{
	// 						Address: to.Ptr("13.65.82.190"),
	// 				}},
	// 			},
	// 		},
	// 		IntegrationAccount: &armlogic.ResourceReference{
	// 			Name: to.Ptr("test-integration-account"),
	// 			Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
	// 		},
	// 		Parameters: map[string]*armlogic.WorkflowParameter{
	// 		},
	// 		ProvisioningState: to.Ptr(armlogic.WorkflowProvisioningStateSucceeded),
	// 		State: to.Ptr(armlogic.WorkflowStateEnabled),
	// 		Version: to.Ptr("08586677515911718341"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_Delete.json
func ExampleWorkflowsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWorkflowsClient().Delete(ctx, "test-resource-group", "test-workflow", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_Disable.json
func ExampleWorkflowsClient_Disable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWorkflowsClient().Disable(ctx, "test-resource-group", "test-workflow", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_Enable.json
func ExampleWorkflowsClient_Enable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWorkflowsClient().Enable(ctx, "test-resource-group", "test-workflow", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_GenerateUpgradedDefinition.json
func ExampleWorkflowsClient_GenerateUpgradedDefinition() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkflowsClient().GenerateUpgradedDefinition(ctx, "test-resource-group", "test-workflow", armlogic.GenerateUpgradedDefinitionParameters{
		TargetSchemaVersion: to.Ptr("2016-06-01"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Interface = map[string]any{
	// 	"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
	// 	"actions":map[string]any{
	// 	},
	// 	"contentVersion": "1.0.0.0",
	// 	"outputs":map[string]any{
	// 	},
	// 	"parameters":map[string]any{
	// 		"$connections":map[string]any{
	// 			"type": "Object",
	// 			"defaultValue":map[string]any{
	// 			},
	// 		},
	// 	},
	// 	"triggers":map[string]any{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_ListCallbackUrl.json
func ExampleWorkflowsClient_ListCallbackURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkflowsClient().ListCallbackURL(ctx, "testResourceGroup", "testWorkflow", armlogic.GetCallbackURLParameters{
		KeyType:  to.Ptr(armlogic.KeyTypePrimary),
		NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-04-19T16:00:00.000Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WorkflowTriggerCallbackURL = armlogic.WorkflowTriggerCallbackURL{
	// 	Method: to.Ptr("POST"),
	// 	BasePath: to.Ptr("https://prod-03.westus.logic.azure.com/workflows/d4690301f3b340de9330256bb2e83974"),
	// 	Queries: &armlogic.WorkflowTriggerListCallbackURLQueries{
	// 		APIVersion: to.Ptr("2018-07-01-preview"),
	// 		Se: to.Ptr("2018-04-19T16:00:00.0000000Z"),
	// 		Sig: to.Ptr("JXbHjs3qzLPDyk-IM_VzsN-WL_mNql3v_uWbBbKgtVk"),
	// 		Sp: to.Ptr("//*"),
	// 		Sv: to.Ptr("1.0"),
	// 	},
	// 	Value: to.Ptr("https://prod-03.westus.logic.azure.com/workflows/d4690301f3b340de9330256bb2e83974/triggers/requestTrigger/paths/invoke?api-version=2018-07-01-preview&se=2018-04-19T16%3A00%3A00.0000000Z&sp=%2Ftriggers%2FrequestTrigger%2Frun&sv=1.0&sig=JXbHjs3qzLPDyk-IM_VzsN-WL_mNql3v_uWbBbKgtVk"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_ListSwagger.json
func ExampleWorkflowsClient_ListSwagger() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkflowsClient().ListSwagger(ctx, "testResourceGroup", "testWorkflowName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Interface = map[string]any{
	// 	"info":map[string]any{
	// 		"description": "Azure Logic App.",
	// 		"title": "flow",
	// 	},
	// 	"basePath": "/workflows/2e420261710e423490d5d502fe9c4abb/triggers",
	// 	"consumes":[]any{
	// 		"application/json",
	// 	},
	// 	"host": "test-host",
	// 	"paths":map[string]any{
	// 		"/simpleManualTrigger/paths/invoke":map[string]any{
	// 			"post":map[string]any{
	// 				"operationId": "simpleManualTrigger-invoke",
	// 				"description": "Trigger a run of the logic app.",
	// 				"parameters":[]any{
	// 					map[string]any{
	// 						"name": "api-version",
	// 						"type": "string",
	// 						"description": "The service API version.",
	// 						"in": "query",
	// 						"required": true,
	// 					},
	// 					map[string]any{
	// 						"name": "sp",
	// 						"type": "string",
	// 						"description": "The permissions; generally 'read' or 'write'.",
	// 						"in": "query",
	// 						"required": true,
	// 					},
	// 					map[string]any{
	// 						"name": "sv",
	// 						"type": "string",
	// 						"description": "The version number of the query parameters.",
	// 						"in": "query",
	// 						"required": true,
	// 					},
	// 					map[string]any{
	// 						"name": "sig",
	// 						"type": "string",
	// 						"description": "The SHA 256 hash of the entire request URI with an internal key.",
	// 						"in": "query",
	// 						"required": true,
	// 					},
	// 				},
	// 				"responses":map[string]any{
	// 					"default":map[string]any{
	// 						"schema":map[string]any{
	// 							"type": "object",
	// 						},
	// 						"description": "The Logic App Response.",
	// 					},
	// 				},
	// 			},
	// 		},
	// 	},
	// 	"produces":[]any{
	// 		"application/json",
	// 	},
	// 	"schemes":[]any{
	// 		"http",
	// 	},
	// 	"swagger": "2.0",
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_Move.json
func ExampleWorkflowsClient_BeginMove() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewWorkflowsClient().BeginMove(ctx, "testResourceGroup", "testWorkflow", armlogic.WorkflowReference{
		ID: to.Ptr("subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/newResourceGroup/providers/Microsoft.Logic/workflows/newWorkflowName"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_RegenerateAccessKey.json
func ExampleWorkflowsClient_RegenerateAccessKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWorkflowsClient().RegenerateAccessKey(ctx, "testResourceGroup", "testWorkflowName", armlogic.RegenerateActionParameter{
		KeyType: to.Ptr(armlogic.KeyTypePrimary),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_ValidateByResourceGroup.json
func ExampleWorkflowsClient_ValidateByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWorkflowsClient().ValidateByResourceGroup(ctx, "test-resource-group", "test-workflow", armlogic.Workflow{
		Location: to.Ptr("brazilsouth"),
		Tags:     map[string]*string{},
		Properties: &armlogic.WorkflowProperties{
			Definition: map[string]any{
				"$schema":        "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
				"actions":        map[string]any{},
				"contentVersion": "1.0.0.0",
				"outputs":        map[string]any{},
				"parameters":     map[string]any{},
				"triggers":       map[string]any{},
			},
			IntegrationAccount: &armlogic.ResourceReference{
				ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/Workflows_ValidateByLocation.json
func ExampleWorkflowsClient_ValidateByLocation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewWorkflowsClient().ValidateByLocation(ctx, "test-resource-group", "brazilsouth", "test-workflow", armlogic.Workflow{
		Location: to.Ptr("brazilsouth"),
		Tags:     map[string]*string{},
		Properties: &armlogic.WorkflowProperties{
			Definition: map[string]any{
				"$schema":        "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
				"actions":        map[string]any{},
				"contentVersion": "1.0.0.0",
				"outputs":        map[string]any{},
				"parameters":     map[string]any{},
				"triggers":       map[string]any{},
			},
			IntegrationAccount: &armlogic.ResourceReference{
				ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
