//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkusto

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SandboxCustomImagesClient contains the methods for the SandboxCustomImages group.
// Don't use this type directly, use NewSandboxCustomImagesClient() instead.
type SandboxCustomImagesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSandboxCustomImagesClient creates a new instance of SandboxCustomImagesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSandboxCustomImagesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SandboxCustomImagesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SandboxCustomImagesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CheckNameAvailability - Checks that the sandbox custom image resource name is valid and is not already in use.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - clusterName - The name of the Kusto cluster.
//   - resourceName - The name of the resource.
//   - options - SandboxCustomImagesClientCheckNameAvailabilityOptions contains the optional parameters for the SandboxCustomImagesClient.CheckNameAvailability
//     method.
func (client *SandboxCustomImagesClient) CheckNameAvailability(ctx context.Context, resourceGroupName string, clusterName string, resourceName SandboxCustomImagesCheckNameRequest, options *SandboxCustomImagesClientCheckNameAvailabilityOptions) (SandboxCustomImagesClientCheckNameAvailabilityResponse, error) {
	var err error
	const operationName = "SandboxCustomImagesClient.CheckNameAvailability"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.checkNameAvailabilityCreateRequest(ctx, resourceGroupName, clusterName, resourceName, options)
	if err != nil {
		return SandboxCustomImagesClientCheckNameAvailabilityResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SandboxCustomImagesClientCheckNameAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SandboxCustomImagesClientCheckNameAvailabilityResponse{}, err
	}
	resp, err := client.checkNameAvailabilityHandleResponse(httpResp)
	return resp, err
}

// checkNameAvailabilityCreateRequest creates the CheckNameAvailability request.
func (client *SandboxCustomImagesClient) checkNameAvailabilityCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, resourceName SandboxCustomImagesCheckNameRequest, options *SandboxCustomImagesClientCheckNameAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/sandboxCustomImagesCheckNameAvailability"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resourceName); err != nil {
		return nil, err
	}
	return req, nil
}

// checkNameAvailabilityHandleResponse handles the CheckNameAvailability response.
func (client *SandboxCustomImagesClient) checkNameAvailabilityHandleResponse(resp *http.Response) (SandboxCustomImagesClientCheckNameAvailabilityResponse, error) {
	result := SandboxCustomImagesClientCheckNameAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckNameResult); err != nil {
		return SandboxCustomImagesClientCheckNameAvailabilityResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdate - Creates or updates a sandbox custom image.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - clusterName - The name of the Kusto cluster.
//   - sandboxCustomImageName - The name of the sandbox custom image.
//   - parameters - The sandbox custom image parameters.
//   - options - SandboxCustomImagesClientBeginCreateOrUpdateOptions contains the optional parameters for the SandboxCustomImagesClient.BeginCreateOrUpdate
//     method.
func (client *SandboxCustomImagesClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, parameters SandboxCustomImage, options *SandboxCustomImagesClientBeginCreateOrUpdateOptions) (*runtime.Poller[SandboxCustomImagesClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, clusterName, sandboxCustomImageName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SandboxCustomImagesClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SandboxCustomImagesClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Creates or updates a sandbox custom image.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-15
func (client *SandboxCustomImagesClient) createOrUpdate(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, parameters SandboxCustomImage, options *SandboxCustomImagesClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "SandboxCustomImagesClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, clusterName, sandboxCustomImageName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *SandboxCustomImagesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, parameters SandboxCustomImage, options *SandboxCustomImagesClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/sandboxCustomImages/{sandboxCustomImageName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if sandboxCustomImageName == "" {
		return nil, errors.New("parameter sandboxCustomImageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sandboxCustomImageName}", url.PathEscape(sandboxCustomImageName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes a sandbox custom image.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - clusterName - The name of the Kusto cluster.
//   - sandboxCustomImageName - The name of the sandbox custom image.
//   - options - SandboxCustomImagesClientBeginDeleteOptions contains the optional parameters for the SandboxCustomImagesClient.BeginDelete
//     method.
func (client *SandboxCustomImagesClient) BeginDelete(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, options *SandboxCustomImagesClientBeginDeleteOptions) (*runtime.Poller[SandboxCustomImagesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, clusterName, sandboxCustomImageName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SandboxCustomImagesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SandboxCustomImagesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes a sandbox custom image.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-15
func (client *SandboxCustomImagesClient) deleteOperation(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, options *SandboxCustomImagesClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "SandboxCustomImagesClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, clusterName, sandboxCustomImageName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SandboxCustomImagesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, options *SandboxCustomImagesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/sandboxCustomImages/{sandboxCustomImageName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if sandboxCustomImageName == "" {
		return nil, errors.New("parameter sandboxCustomImageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sandboxCustomImageName}", url.PathEscape(sandboxCustomImageName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Returns a sandbox custom image
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - clusterName - The name of the Kusto cluster.
//   - sandboxCustomImageName - The name of the sandbox custom image.
//   - options - SandboxCustomImagesClientGetOptions contains the optional parameters for the SandboxCustomImagesClient.Get method.
func (client *SandboxCustomImagesClient) Get(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, options *SandboxCustomImagesClientGetOptions) (SandboxCustomImagesClientGetResponse, error) {
	var err error
	const operationName = "SandboxCustomImagesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, clusterName, sandboxCustomImageName, options)
	if err != nil {
		return SandboxCustomImagesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SandboxCustomImagesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SandboxCustomImagesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SandboxCustomImagesClient) getCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, options *SandboxCustomImagesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/sandboxCustomImages/{sandboxCustomImageName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if sandboxCustomImageName == "" {
		return nil, errors.New("parameter sandboxCustomImageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sandboxCustomImageName}", url.PathEscape(sandboxCustomImageName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SandboxCustomImagesClient) getHandleResponse(resp *http.Response) (SandboxCustomImagesClientGetResponse, error) {
	result := SandboxCustomImagesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SandboxCustomImage); err != nil {
		return SandboxCustomImagesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByClusterPager - Returns the list of the existing sandbox custom images of the given Kusto cluster.
//
// Generated from API version 2023-08-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - clusterName - The name of the Kusto cluster.
//   - options - SandboxCustomImagesClientListByClusterOptions contains the optional parameters for the SandboxCustomImagesClient.NewListByClusterPager
//     method.
func (client *SandboxCustomImagesClient) NewListByClusterPager(resourceGroupName string, clusterName string, options *SandboxCustomImagesClientListByClusterOptions) *runtime.Pager[SandboxCustomImagesClientListByClusterResponse] {
	return runtime.NewPager(runtime.PagingHandler[SandboxCustomImagesClientListByClusterResponse]{
		More: func(page SandboxCustomImagesClientListByClusterResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *SandboxCustomImagesClientListByClusterResponse) (SandboxCustomImagesClientListByClusterResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SandboxCustomImagesClient.NewListByClusterPager")
			req, err := client.listByClusterCreateRequest(ctx, resourceGroupName, clusterName, options)
			if err != nil {
				return SandboxCustomImagesClientListByClusterResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return SandboxCustomImagesClientListByClusterResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SandboxCustomImagesClientListByClusterResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByClusterHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByClusterCreateRequest creates the ListByCluster request.
func (client *SandboxCustomImagesClient) listByClusterCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, options *SandboxCustomImagesClientListByClusterOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/sandboxCustomImages"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByClusterHandleResponse handles the ListByCluster response.
func (client *SandboxCustomImagesClient) listByClusterHandleResponse(resp *http.Response) (SandboxCustomImagesClientListByClusterResponse, error) {
	result := SandboxCustomImagesClientListByClusterResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SandboxCustomImagesListResult); err != nil {
		return SandboxCustomImagesClientListByClusterResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Updates a sandbox custom image.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - clusterName - The name of the Kusto cluster.
//   - sandboxCustomImageName - The name of the sandbox custom image.
//   - parameters - The sandbox custom image parameters.
//   - options - SandboxCustomImagesClientBeginUpdateOptions contains the optional parameters for the SandboxCustomImagesClient.BeginUpdate
//     method.
func (client *SandboxCustomImagesClient) BeginUpdate(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, parameters SandboxCustomImage, options *SandboxCustomImagesClientBeginUpdateOptions) (*runtime.Poller[SandboxCustomImagesClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, clusterName, sandboxCustomImageName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SandboxCustomImagesClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SandboxCustomImagesClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Updates a sandbox custom image.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-15
func (client *SandboxCustomImagesClient) update(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, parameters SandboxCustomImage, options *SandboxCustomImagesClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "SandboxCustomImagesClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, clusterName, sandboxCustomImageName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *SandboxCustomImagesClient) updateCreateRequest(ctx context.Context, resourceGroupName string, clusterName string, sandboxCustomImageName string, parameters SandboxCustomImage, options *SandboxCustomImagesClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/sandboxCustomImages/{sandboxCustomImageName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if clusterName == "" {
		return nil, errors.New("parameter clusterName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{clusterName}", url.PathEscape(clusterName))
	if sandboxCustomImageName == "" {
		return nil, errors.New("parameter sandboxCustomImageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sandboxCustomImageName}", url.PathEscape(sandboxCustomImageName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
