//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkusto

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAttachedDatabaseConfigurationsClient creates a new instance of AttachedDatabaseConfigurationsClient.
func (c *ClientFactory) NewAttachedDatabaseConfigurationsClient() *AttachedDatabaseConfigurationsClient {
	subClient, _ := NewAttachedDatabaseConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClusterPrincipalAssignmentsClient creates a new instance of ClusterPrincipalAssignmentsClient.
func (c *ClientFactory) NewClusterPrincipalAssignmentsClient() *ClusterPrincipalAssignmentsClient {
	subClient, _ := NewClusterPrincipalAssignmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClustersClient creates a new instance of ClustersClient.
func (c *ClientFactory) NewClustersClient() *ClustersClient {
	subClient, _ := NewClustersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataConnectionsClient creates a new instance of DataConnectionsClient.
func (c *ClientFactory) NewDataConnectionsClient() *DataConnectionsClient {
	subClient, _ := NewDataConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseClient creates a new instance of DatabaseClient.
func (c *ClientFactory) NewDatabaseClient() *DatabaseClient {
	subClient, _ := NewDatabaseClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabasePrincipalAssignmentsClient creates a new instance of DatabasePrincipalAssignmentsClient.
func (c *ClientFactory) NewDatabasePrincipalAssignmentsClient() *DatabasePrincipalAssignmentsClient {
	subClient, _ := NewDatabasePrincipalAssignmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabasesClient creates a new instance of DatabasesClient.
func (c *ClientFactory) NewDatabasesClient() *DatabasesClient {
	subClient, _ := NewDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagedPrivateEndpointsClient creates a new instance of ManagedPrivateEndpointsClient.
func (c *ClientFactory) NewManagedPrivateEndpointsClient() *ManagedPrivateEndpointsClient {
	subClient, _ := NewManagedPrivateEndpointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewOperationsResultsClient creates a new instance of OperationsResultsClient.
func (c *ClientFactory) NewOperationsResultsClient() *OperationsResultsClient {
	subClient, _ := NewOperationsResultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsResultsLocationClient creates a new instance of OperationsResultsLocationClient.
func (c *ClientFactory) NewOperationsResultsLocationClient() *OperationsResultsLocationClient {
	subClient, _ := NewOperationsResultsLocationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSKUsClient creates a new instance of SKUsClient.
func (c *ClientFactory) NewSKUsClient() *SKUsClient {
	subClient, _ := NewSKUsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSandboxCustomImagesClient creates a new instance of SandboxCustomImagesClient.
func (c *ClientFactory) NewSandboxCustomImagesClient() *SandboxCustomImagesClient {
	subClient, _ := NewSandboxCustomImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewScriptsClient creates a new instance of ScriptsClient.
func (c *ClientFactory) NewScriptsClient() *ScriptsClient {
	subClient, _ := NewScriptsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
