//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armkubernetesconfiguration_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/kubernetesconfiguration/armkubernetesconfiguration/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/kubernetesconfiguration/resource-manager/Microsoft.KubernetesConfiguration/stable/2023-05-01/examples/GetFluxConfiguration.json
func ExampleFluxConfigurationsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkubernetesconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFluxConfigurationsClient().Get(ctx, "rg1", "Microsoft.Kubernetes", "connectedClusters", "clusterName1", "srs-fluxconfig", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FluxConfiguration = armkubernetesconfiguration.FluxConfiguration{
	// 	Name: to.Ptr("srs-fluxconfig"),
	// 	Type: to.Ptr("Microsoft.KubernetesConfiguration/fluxConfigurations"),
	// 	ID: to.Ptr("/subscriptions/subId1/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/clusterName1/providers/Microsoft.KubernetesConfiguration/fluxConfigurations/srs-fluxconfig"),
	// 	Properties: &armkubernetesconfiguration.FluxConfigurationProperties{
	// 		ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 		ErrorMessage: to.Ptr(""),
	// 		GitRepository: &armkubernetesconfiguration.GitRepositoryDefinition{
	// 			RepositoryRef: &armkubernetesconfiguration.RepositoryRefDefinition{
	// 				Branch: to.Ptr("master"),
	// 			},
	// 			SyncIntervalInSeconds: to.Ptr[int64](600),
	// 			TimeoutInSeconds: to.Ptr[int64](600),
	// 			URL: to.Ptr("https://github.com/Azure/arc-k8s-demo"),
	// 		},
	// 		Kustomizations: map[string]*armkubernetesconfiguration.KustomizationDefinition{
	// 			"srs-kustomization1": &armkubernetesconfiguration.KustomizationDefinition{
	// 				Name: to.Ptr("srs-kustomization1"),
	// 				Path: to.Ptr("./test/path"),
	// 				DependsOn: []*string{
	// 				},
	// 				PostBuild: &armkubernetesconfiguration.PostBuildDefinition{
	// 					Substitute: map[string]*string{
	// 						"cluster_env": to.Ptr("prod"),
	// 						"replica_count": to.Ptr("2"),
	// 					},
	// 					SubstituteFrom: []*armkubernetesconfiguration.SubstituteFromDefinition{
	// 						{
	// 							Name: to.Ptr("cluster-test"),
	// 							Kind: to.Ptr("ConfigMap"),
	// 							Optional: to.Ptr(true),
	// 					}},
	// 				},
	// 				SyncIntervalInSeconds: to.Ptr[int64](600),
	// 				TimeoutInSeconds: to.Ptr[int64](600),
	// 				Wait: to.Ptr(true),
	// 			},
	// 			"srs-kustomization2": &armkubernetesconfiguration.KustomizationDefinition{
	// 				Name: to.Ptr("srs-kustomization2"),
	// 				Path: to.Ptr("./other/test/path"),
	// 				DependsOn: []*string{
	// 					to.Ptr("srs-kustomization1")},
	// 					PostBuild: &armkubernetesconfiguration.PostBuildDefinition{
	// 						SubstituteFrom: []*armkubernetesconfiguration.SubstituteFromDefinition{
	// 							{
	// 								Name: to.Ptr("cluster-values"),
	// 								Kind: to.Ptr("ConfigMap"),
	// 								Optional: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("secret-name"),
	// 								Kind: to.Ptr("Secret"),
	// 								Optional: to.Ptr(false),
	// 						}},
	// 					},
	// 					Prune: to.Ptr(false),
	// 					RetryIntervalInSeconds: to.Ptr[int64](600),
	// 					SyncIntervalInSeconds: to.Ptr[int64](600),
	// 					TimeoutInSeconds: to.Ptr[int64](600),
	// 					Wait: to.Ptr(false),
	// 				},
	// 			},
	// 			Namespace: to.Ptr("srs-namespace"),
	// 			ProvisioningState: to.Ptr(armkubernetesconfiguration.ProvisioningStateSucceeded),
	// 			RepositoryPublicKey: to.Ptr("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiNkrANrhtRy+02Xc7b5bwvgOKvQMbqUQaXeB6FCDkbLaavw/zO/vIhIBEQu+vbBt6IlI/Pui0rMFr5JjA8Vwwd85oabzU07TPzbFvKSU9eCXqWRKWf0DHNQj/kxPJNtyPYFv3lGoiZZ6QzejOxlW/lPPokUePN0oI10daWwqznm2q0Cmh1EgPUYveq3J5KCWncZXCdwY36zWYulCWFaqazoaGy4kxcqlVy+mPjE/UJthaoLm3mq+23uhlmmfCc1j7W6+H6fcOwTyOtcbimxz2Ug8HlTzSTXBPtEe7qyllMyk62EPNUUq4bVoVsex9sKBK6/hW0Cn2P5i5jslUPCQF"),
	// 			Scope: to.Ptr(armkubernetesconfiguration.ScopeTypeCluster),
	// 			SourceKind: to.Ptr(armkubernetesconfiguration.SourceKindTypeGitRepository),
	// 			SourceSyncedCommitID: to.Ptr("master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590"),
	// 			SourceUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
	// 			StatusUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
	// 			Statuses: []*armkubernetesconfiguration.ObjectStatusDefinition{
	// 				{
	// 					Name: to.Ptr("srs-fluxconfig"),
	// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 					Kind: to.Ptr("GitRepository"),
	// 					StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 						{
	// 							Type: to.Ptr("Ready"),
	// 							LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 							Message: to.Ptr("'Fetched revision: master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 							Reason: to.Ptr("GitOperationSucceed"),
	// 							Status: to.Ptr("True"),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("srs-fluxconfig-srs-kustomization1"),
	// 					AppliedBy: &armkubernetesconfiguration.ObjectReferenceDefinition{
	// 						Name: to.Ptr("my-name"),
	// 						Namespace: to.Ptr("my-namespace"),
	// 					},
	// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 					HelmReleaseProperties: &armkubernetesconfiguration.HelmReleasePropertiesDefinition{
	// 						HelmChartRef: &armkubernetesconfiguration.ObjectReferenceDefinition{
	// 							Name: to.Ptr("myname"),
	// 							Namespace: to.Ptr("mynamespace"),
	// 						},
	// 						LastRevisionApplied: to.Ptr[int64](1),
	// 					},
	// 					Kind: to.Ptr("Kustomization"),
	// 					StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 						{
	// 							Type: to.Ptr("Ready"),
	// 							LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 							Message: to.Ptr("'Applied revision: master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 							Reason: to.Ptr("ReconciliationSucceeded"),
	// 							Status: to.Ptr("True"),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("srs-fluxconfig-srs-kustomization2"),
	// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 					HelmReleaseProperties: &armkubernetesconfiguration.HelmReleasePropertiesDefinition{
	// 						HelmChartRef: &armkubernetesconfiguration.ObjectReferenceDefinition{
	// 							Name: to.Ptr("myname"),
	// 							Namespace: to.Ptr("mynamespace"),
	// 						},
	// 						LastRevisionApplied: to.Ptr[int64](1),
	// 					},
	// 					Kind: to.Ptr("Kustomization"),
	// 					StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 						{
	// 							Type: to.Ptr("Ready"),
	// 							LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 							Message: to.Ptr("'Applied revision: master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 							Reason: to.Ptr("ReconciliationSucceeded"),
	// 							Status: to.Ptr("True"),
	// 					}},
	// 			}},
	// 			Suspend: to.Ptr(false),
	// 		},
	// 		SystemData: &armkubernetesconfiguration.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T05:10:57.027Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-19T05:10:57.027Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/kubernetesconfiguration/resource-manager/Microsoft.KubernetesConfiguration/stable/2023-05-01/examples/CreateFluxConfiguration.json
func ExampleFluxConfigurationsClient_BeginCreateOrUpdate_createFluxConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkubernetesconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFluxConfigurationsClient().BeginCreateOrUpdate(ctx, "rg1", "Microsoft.Kubernetes", "connectedClusters", "clusterName1", "srs-fluxconfig", armkubernetesconfiguration.FluxConfiguration{
		Properties: &armkubernetesconfiguration.FluxConfigurationProperties{
			GitRepository: &armkubernetesconfiguration.GitRepositoryDefinition{
				HTTPSCACert: to.Ptr("ZXhhbXBsZWNlcnRpZmljYXRl"),
				RepositoryRef: &armkubernetesconfiguration.RepositoryRefDefinition{
					Branch: to.Ptr("master"),
				},
				SyncIntervalInSeconds: to.Ptr[int64](600),
				TimeoutInSeconds:      to.Ptr[int64](600),
				URL:                   to.Ptr("https://github.com/Azure/arc-k8s-demo"),
			},
			Kustomizations: map[string]*armkubernetesconfiguration.KustomizationDefinition{
				"srs-kustomization1": {
					Path:      to.Ptr("./test/path"),
					DependsOn: []*string{},
					PostBuild: &armkubernetesconfiguration.PostBuildDefinition{
						Substitute: map[string]*string{
							"cluster_env":   to.Ptr("prod"),
							"replica_count": to.Ptr("2"),
						},
						SubstituteFrom: []*armkubernetesconfiguration.SubstituteFromDefinition{
							{
								Name:     to.Ptr("cluster-test"),
								Kind:     to.Ptr("ConfigMap"),
								Optional: to.Ptr(true),
							}},
					},
					SyncIntervalInSeconds: to.Ptr[int64](600),
					TimeoutInSeconds:      to.Ptr[int64](600),
					Wait:                  to.Ptr(true),
				},
				"srs-kustomization2": {
					Path: to.Ptr("./other/test/path"),
					DependsOn: []*string{
						to.Ptr("srs-kustomization1")},
					PostBuild: &armkubernetesconfiguration.PostBuildDefinition{
						SubstituteFrom: []*armkubernetesconfiguration.SubstituteFromDefinition{
							{
								Name:     to.Ptr("cluster-values"),
								Kind:     to.Ptr("ConfigMap"),
								Optional: to.Ptr(true),
							},
							{
								Name:     to.Ptr("secret-name"),
								Kind:     to.Ptr("Secret"),
								Optional: to.Ptr(false),
							}},
					},
					Prune:                  to.Ptr(false),
					RetryIntervalInSeconds: to.Ptr[int64](600),
					SyncIntervalInSeconds:  to.Ptr[int64](600),
					TimeoutInSeconds:       to.Ptr[int64](600),
					Wait:                   to.Ptr(false),
				},
			},
			Namespace:                  to.Ptr("srs-namespace"),
			ReconciliationWaitDuration: to.Ptr("PT30M"),
			Scope:                      to.Ptr(armkubernetesconfiguration.ScopeTypeCluster),
			SourceKind:                 to.Ptr(armkubernetesconfiguration.SourceKindTypeGitRepository),
			Suspend:                    to.Ptr(false),
			WaitForReconciliation:      to.Ptr(true),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FluxConfiguration = armkubernetesconfiguration.FluxConfiguration{
	// 	Name: to.Ptr("srs-fluxconfig"),
	// 	Type: to.Ptr("Microsoft.KubernetesConfiguration/fluxConfigurations"),
	// 	ID: to.Ptr("/subscriptions/subId1/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/clusterName1/providers/Microsoft.KubernetesConfiguration/fluxConfigurations/srs-fluxconfig"),
	// 	Properties: &armkubernetesconfiguration.FluxConfigurationProperties{
	// 		ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 		ErrorMessage: to.Ptr(""),
	// 		GitRepository: &armkubernetesconfiguration.GitRepositoryDefinition{
	// 			HTTPSCACert: to.Ptr("ZXhhbXBsZWNlcnRpZmljYXRl"),
	// 			RepositoryRef: &armkubernetesconfiguration.RepositoryRefDefinition{
	// 				Branch: to.Ptr("master"),
	// 			},
	// 			SyncIntervalInSeconds: to.Ptr[int64](600),
	// 			TimeoutInSeconds: to.Ptr[int64](600),
	// 			URL: to.Ptr("https://github.com/Azure/arc-k8s-demo"),
	// 		},
	// 		Kustomizations: map[string]*armkubernetesconfiguration.KustomizationDefinition{
	// 			"srs-kustomization1": &armkubernetesconfiguration.KustomizationDefinition{
	// 				Name: to.Ptr("srs-kustomization1"),
	// 				Path: to.Ptr("./test/path"),
	// 				DependsOn: []*string{
	// 				},
	// 				PostBuild: &armkubernetesconfiguration.PostBuildDefinition{
	// 					Substitute: map[string]*string{
	// 						"cluster_env": to.Ptr("prod"),
	// 						"replica_count": to.Ptr("2"),
	// 					},
	// 					SubstituteFrom: []*armkubernetesconfiguration.SubstituteFromDefinition{
	// 						{
	// 							Name: to.Ptr("cluster-test"),
	// 							Kind: to.Ptr("ConfigMap"),
	// 							Optional: to.Ptr(true),
	// 					}},
	// 				},
	// 				SyncIntervalInSeconds: to.Ptr[int64](600),
	// 				TimeoutInSeconds: to.Ptr[int64](600),
	// 				Wait: to.Ptr(true),
	// 			},
	// 			"srs-kustomization2": &armkubernetesconfiguration.KustomizationDefinition{
	// 				Name: to.Ptr("srs-kustomization2"),
	// 				Path: to.Ptr("./other/test/path"),
	// 				DependsOn: []*string{
	// 					to.Ptr("srs-kustomization1")},
	// 					PostBuild: &armkubernetesconfiguration.PostBuildDefinition{
	// 						SubstituteFrom: []*armkubernetesconfiguration.SubstituteFromDefinition{
	// 							{
	// 								Name: to.Ptr("cluster-values"),
	// 								Kind: to.Ptr("ConfigMap"),
	// 								Optional: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("secret-name"),
	// 								Kind: to.Ptr("Secret"),
	// 								Optional: to.Ptr(false),
	// 						}},
	// 					},
	// 					Prune: to.Ptr(false),
	// 					RetryIntervalInSeconds: to.Ptr[int64](600),
	// 					SyncIntervalInSeconds: to.Ptr[int64](600),
	// 					TimeoutInSeconds: to.Ptr[int64](600),
	// 					Wait: to.Ptr(false),
	// 				},
	// 			},
	// 			Namespace: to.Ptr("srs-namespace"),
	// 			ProvisioningState: to.Ptr(armkubernetesconfiguration.ProvisioningStateSucceeded),
	// 			RepositoryPublicKey: to.Ptr("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiNkrANrhtRy+02Xc7b5bwvgOKvQMbqUQaXeB6FCDkbLaavw/zO/vIhIBEQu+vbBt6IlI/Pui0rMFr5JjA8Vwwd85oabzU07TPzbFvKSU9eCXqWRKWf0DHNQj/kxPJNtyPYFv3lGoiZZ6QzejOxlW/lPPokUePN0oI10daWwqznm2q0Cmh1EgPUYveq3J5KCWncZXCdwY36zWYulCWFaqazoaGy4kxcqlVy+mPjE/UJthaoLm3mq+23uhlmmfCc1j7W6+H6fcOwTyOtcbimxz2Ug8HlTzSTXBPtEe7qyllMyk62EPNUUq4bVoVsex9sKBK6/hW0Cn2P5i5jslUPCQF"),
	// 			Scope: to.Ptr(armkubernetesconfiguration.ScopeTypeCluster),
	// 			SourceKind: to.Ptr(armkubernetesconfiguration.SourceKindTypeGitRepository),
	// 			SourceSyncedCommitID: to.Ptr("master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590"),
	// 			SourceUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
	// 			StatusUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
	// 			Statuses: []*armkubernetesconfiguration.ObjectStatusDefinition{
	// 				{
	// 					Name: to.Ptr("srs-fluxconfig"),
	// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 					Kind: to.Ptr("GitRepository"),
	// 					StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 						{
	// 							Type: to.Ptr("Ready"),
	// 							LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 							Message: to.Ptr("'Fetched revision: master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 							Reason: to.Ptr("GitOperationSucceed"),
	// 							Status: to.Ptr("True"),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("srs-fluxconfig-srs-kustomization1"),
	// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 					HelmReleaseProperties: &armkubernetesconfiguration.HelmReleasePropertiesDefinition{
	// 						HelmChartRef: &armkubernetesconfiguration.ObjectReferenceDefinition{
	// 							Name: to.Ptr("myname"),
	// 							Namespace: to.Ptr("mynamespace"),
	// 						},
	// 						LastRevisionApplied: to.Ptr[int64](1),
	// 					},
	// 					Kind: to.Ptr("Kustomization"),
	// 					StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 						{
	// 							Type: to.Ptr("Ready"),
	// 							LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 							Message: to.Ptr("'Applied revision: master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 							Reason: to.Ptr("ReconciliationSucceeded"),
	// 							Status: to.Ptr("True"),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("srs-fluxconfig-srs-kustomization2"),
	// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 					HelmReleaseProperties: &armkubernetesconfiguration.HelmReleasePropertiesDefinition{
	// 						HelmChartRef: &armkubernetesconfiguration.ObjectReferenceDefinition{
	// 							Name: to.Ptr("myname"),
	// 							Namespace: to.Ptr("mynamespace"),
	// 						},
	// 						LastRevisionApplied: to.Ptr[int64](1),
	// 					},
	// 					Kind: to.Ptr("Kustomization"),
	// 					StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 						{
	// 							Type: to.Ptr("Ready"),
	// 							LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 							Message: to.Ptr("'Applied revision: master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 							Reason: to.Ptr("ReconciliationSucceeded"),
	// 							Status: to.Ptr("True"),
	// 					}},
	// 			}},
	// 			Suspend: to.Ptr(false),
	// 		},
	// 		SystemData: &armkubernetesconfiguration.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T05:10:57.027Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-19T05:10:57.027Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/kubernetesconfiguration/resource-manager/Microsoft.KubernetesConfiguration/stable/2023-05-01/examples/CreateFluxConfigurationWithBucket.json
func ExampleFluxConfigurationsClient_BeginCreateOrUpdate_createFluxConfigurationWithBucketSourceKind() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkubernetesconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFluxConfigurationsClient().BeginCreateOrUpdate(ctx, "rg1", "Microsoft.Kubernetes", "connectedClusters", "clusterName1", "srs-fluxconfig", armkubernetesconfiguration.FluxConfiguration{
		Properties: &armkubernetesconfiguration.FluxConfigurationProperties{
			Bucket: &armkubernetesconfiguration.BucketDefinition{
				AccessKey:             to.Ptr("fluxminiotest"),
				BucketName:            to.Ptr("flux"),
				SyncIntervalInSeconds: to.Ptr[int64](1000),
				TimeoutInSeconds:      to.Ptr[int64](1000),
				URL:                   to.Ptr("https://fluxminiotest.az.minio.io"),
			},
			Kustomizations: map[string]*armkubernetesconfiguration.KustomizationDefinition{
				"srs-kustomization1": {
					Path:                  to.Ptr("./test/path"),
					DependsOn:             []*string{},
					SyncIntervalInSeconds: to.Ptr[int64](600),
					TimeoutInSeconds:      to.Ptr[int64](600),
				},
				"srs-kustomization2": {
					Path: to.Ptr("./other/test/path"),
					DependsOn: []*string{
						to.Ptr("srs-kustomization1")},
					Prune:                  to.Ptr(false),
					RetryIntervalInSeconds: to.Ptr[int64](600),
					SyncIntervalInSeconds:  to.Ptr[int64](600),
					TimeoutInSeconds:       to.Ptr[int64](600),
				},
			},
			Namespace:  to.Ptr("srs-namespace"),
			Scope:      to.Ptr(armkubernetesconfiguration.ScopeTypeCluster),
			SourceKind: to.Ptr(armkubernetesconfiguration.SourceKindTypeBucket),
			Suspend:    to.Ptr(false),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FluxConfiguration = armkubernetesconfiguration.FluxConfiguration{
	// 	Name: to.Ptr("srs-fluxconfig"),
	// 	Type: to.Ptr("Microsoft.KubernetesConfiguration/fluxConfigurations"),
	// 	ID: to.Ptr("/subscriptions/subId1/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/clusterName1/providers/Microsoft.KubernetesConfiguration/fluxConfigurations/srs-fluxconfig"),
	// 	Properties: &armkubernetesconfiguration.FluxConfigurationProperties{
	// 		Bucket: &armkubernetesconfiguration.BucketDefinition{
	// 			AccessKey: to.Ptr("fluxminiotest"),
	// 			BucketName: to.Ptr("flux"),
	// 			SyncIntervalInSeconds: to.Ptr[int64](1000),
	// 			TimeoutInSeconds: to.Ptr[int64](1000),
	// 			URL: to.Ptr("https://fluxminiotest.az.minio.io"),
	// 		},
	// 		ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 		ErrorMessage: to.Ptr(""),
	// 		Kustomizations: map[string]*armkubernetesconfiguration.KustomizationDefinition{
	// 			"srs-kustomization1": &armkubernetesconfiguration.KustomizationDefinition{
	// 				Name: to.Ptr("srs-kustomization1"),
	// 				Path: to.Ptr("./test/path"),
	// 				DependsOn: []*string{
	// 				},
	// 				SyncIntervalInSeconds: to.Ptr[int64](600),
	// 				TimeoutInSeconds: to.Ptr[int64](600),
	// 			},
	// 			"srs-kustomization2": &armkubernetesconfiguration.KustomizationDefinition{
	// 				Name: to.Ptr("srs-kustomization2"),
	// 				Path: to.Ptr("./other/test/path"),
	// 				DependsOn: []*string{
	// 					to.Ptr("srs-kustomization1")},
	// 					Prune: to.Ptr(false),
	// 					RetryIntervalInSeconds: to.Ptr[int64](600),
	// 					SyncIntervalInSeconds: to.Ptr[int64](600),
	// 					TimeoutInSeconds: to.Ptr[int64](600),
	// 				},
	// 			},
	// 			Namespace: to.Ptr("srs-namespace"),
	// 			ProvisioningState: to.Ptr(armkubernetesconfiguration.ProvisioningStateSucceeded),
	// 			RepositoryPublicKey: to.Ptr(""),
	// 			Scope: to.Ptr(armkubernetesconfiguration.ScopeTypeCluster),
	// 			SourceKind: to.Ptr(armkubernetesconfiguration.SourceKindTypeBucket),
	// 			SourceSyncedCommitID: to.Ptr("0ba6f0d30760d567de0bac86c8c4eec13ce1a590"),
	// 			SourceUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
	// 			StatusUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
	// 			Statuses: []*armkubernetesconfiguration.ObjectStatusDefinition{
	// 				{
	// 					Name: to.Ptr("srs-fluxconfig"),
	// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 					Kind: to.Ptr("Bucket"),
	// 					StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 						{
	// 							Type: to.Ptr("Ready"),
	// 							LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-04T07:17:30.000Z"); return t}()),
	// 							Message: to.Ptr("stored artifact for revision '55396be14f18fa2b977c1f22becef26a94d1d9a7ccb1e19d12f9cac52d757a84'"),
	// 							Reason: to.Ptr("Succeeded"),
	// 							Status: to.Ptr("True"),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("srs-fluxconfig-srs-kustomization1"),
	// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 					HelmReleaseProperties: &armkubernetesconfiguration.HelmReleasePropertiesDefinition{
	// 						HelmChartRef: &armkubernetesconfiguration.ObjectReferenceDefinition{
	// 							Name: to.Ptr("myname"),
	// 							Namespace: to.Ptr("mynamespace"),
	// 						},
	// 						LastRevisionApplied: to.Ptr[int64](1),
	// 					},
	// 					Kind: to.Ptr("Kustomization"),
	// 					StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 						{
	// 							Type: to.Ptr("Ready"),
	// 							LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 							Message: to.Ptr("'Applied revision: 0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 							Reason: to.Ptr("ReconciliationSucceeded"),
	// 							Status: to.Ptr("True"),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("srs-fluxconfig-srs-kustomization2"),
	// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 					HelmReleaseProperties: &armkubernetesconfiguration.HelmReleasePropertiesDefinition{
	// 						HelmChartRef: &armkubernetesconfiguration.ObjectReferenceDefinition{
	// 							Name: to.Ptr("myname"),
	// 							Namespace: to.Ptr("mynamespace"),
	// 						},
	// 						LastRevisionApplied: to.Ptr[int64](1),
	// 					},
	// 					Kind: to.Ptr("Kustomization"),
	// 					StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 						{
	// 							Type: to.Ptr("Ready"),
	// 							LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 							Message: to.Ptr("'Applied revision: 0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 							Reason: to.Ptr("ReconciliationSucceeded"),
	// 							Status: to.Ptr("True"),
	// 					}},
	// 			}},
	// 			Suspend: to.Ptr(false),
	// 		},
	// 		SystemData: &armkubernetesconfiguration.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T05:10:57.027Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-19T05:10:57.027Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/kubernetesconfiguration/resource-manager/Microsoft.KubernetesConfiguration/stable/2023-05-01/examples/PatchFluxConfiguration.json
func ExampleFluxConfigurationsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkubernetesconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFluxConfigurationsClient().BeginUpdate(ctx, "rg1", "Microsoft.Kubernetes", "connectedClusters", "clusterName1", "srs-fluxconfig", armkubernetesconfiguration.FluxConfigurationPatch{
		Properties: &armkubernetesconfiguration.FluxConfigurationPatchProperties{
			GitRepository: &armkubernetesconfiguration.GitRepositoryPatchDefinition{
				URL: to.Ptr("https://github.com/jonathan-innis/flux2-kustomize-helm-example.git"),
			},
			Kustomizations: map[string]*armkubernetesconfiguration.KustomizationPatchDefinition{
				"srs-kustomization1": nil,
				"srs-kustomization2": {
					Path:                  to.Ptr("./test/alt-path"),
					SyncIntervalInSeconds: to.Ptr[int64](300),
				},
				"srs-kustomization3": {
					Path:                  to.Ptr("./test/another-path"),
					SyncIntervalInSeconds: to.Ptr[int64](300),
				},
			},
			Suspend: to.Ptr(true),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FluxConfiguration = armkubernetesconfiguration.FluxConfiguration{
	// 	Properties: &armkubernetesconfiguration.FluxConfigurationProperties{
	// 		ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 		ErrorMessage: to.Ptr(""),
	// 		GitRepository: &armkubernetesconfiguration.GitRepositoryDefinition{
	// 			RepositoryRef: &armkubernetesconfiguration.RepositoryRefDefinition{
	// 				Branch: to.Ptr("master"),
	// 			},
	// 			SyncIntervalInSeconds: to.Ptr[int64](600),
	// 			TimeoutInSeconds: to.Ptr[int64](600),
	// 			URL: to.Ptr("https://github.com/jonathan-innis/flux2-kustomize-helm-example.git"),
	// 		},
	// 		Kustomizations: map[string]*armkubernetesconfiguration.KustomizationDefinition{
	// 			"srs-kustomization2": &armkubernetesconfiguration.KustomizationDefinition{
	// 				Path: to.Ptr("./test/alt-path"),
	// 				Prune: to.Ptr(false),
	// 				RetryIntervalInSeconds: to.Ptr[int64](600),
	// 				SyncIntervalInSeconds: to.Ptr[int64](300),
	// 				TimeoutInSeconds: to.Ptr[int64](600),
	// 			},
	// 			"srs-kustomization3": &armkubernetesconfiguration.KustomizationDefinition{
	// 				Path: to.Ptr("./test/another-path"),
	// 				Prune: to.Ptr(false),
	// 				SyncIntervalInSeconds: to.Ptr[int64](300),
	// 				TimeoutInSeconds: to.Ptr[int64](600),
	// 			},
	// 		},
	// 		Namespace: to.Ptr("srs-namespace"),
	// 		ProvisioningState: to.Ptr(armkubernetesconfiguration.ProvisioningStateSucceeded),
	// 		RepositoryPublicKey: to.Ptr("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiNkrANrhtRy+02Xc7b5bwvgOKvQMbqUQaXeB6FCDkbLaavw/zO/vIhIBEQu+vbBt6IlI/Pui0rMFr5JjA8Vwwd85oabzU07TPzbFvKSU9eCXqWRKWf0DHNQj/kxPJNtyPYFv3lGoiZZ6QzejOxlW/lPPokUePN0oI10daWwqznm2q0Cmh1EgPUYveq3J5KCWncZXCdwY36zWYulCWFaqazoaGy4kxcqlVy+mPjE/UJthaoLm3mq+23uhlmmfCc1j7W6+H6fcOwTyOtcbimxz2Ug8HlTzSTXBPtEe7qyllMyk62EPNUUq4bVoVsex9sKBK6/hW0Cn2P5i5jslUPCQF"),
	// 		Scope: to.Ptr(armkubernetesconfiguration.ScopeTypeCluster),
	// 		SourceKind: to.Ptr(armkubernetesconfiguration.SourceKindTypeGitRepository),
	// 		SourceSyncedCommitID: to.Ptr("master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590"),
	// 		SourceUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
	// 		StatusUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
	// 		Statuses: []*armkubernetesconfiguration.ObjectStatusDefinition{
	// 			{
	// 				Name: to.Ptr("srs-fluxconfig"),
	// 				ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 				Kind: to.Ptr("GitRepository"),
	// 				StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 					{
	// 						Type: to.Ptr("Ready"),
	// 						LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 						Message: to.Ptr("'Fetched revision: master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 						Reason: to.Ptr("GitOperationSucceed"),
	// 						Status: to.Ptr("True"),
	// 				}},
	// 			},
	// 			{
	// 				Name: to.Ptr("srs-fluxconfig-srs-kustomization1"),
	// 				ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 				HelmReleaseProperties: &armkubernetesconfiguration.HelmReleasePropertiesDefinition{
	// 					HelmChartRef: &armkubernetesconfiguration.ObjectReferenceDefinition{
	// 						Name: to.Ptr("myname"),
	// 						Namespace: to.Ptr("mynamespace"),
	// 					},
	// 					LastRevisionApplied: to.Ptr[int64](1),
	// 				},
	// 				Kind: to.Ptr("Kustomization"),
	// 				StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 					{
	// 						Type: to.Ptr("Ready"),
	// 						LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 						Message: to.Ptr("'Applied revision: master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 						Reason: to.Ptr("ReconciliationSucceeded"),
	// 						Status: to.Ptr("True"),
	// 				}},
	// 			},
	// 			{
	// 				Name: to.Ptr("srs-fluxconfig-srs-kustomization2"),
	// 				ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
	// 				HelmReleaseProperties: &armkubernetesconfiguration.HelmReleasePropertiesDefinition{
	// 					HelmChartRef: &armkubernetesconfiguration.ObjectReferenceDefinition{
	// 						Name: to.Ptr("myname"),
	// 						Namespace: to.Ptr("mynamespace"),
	// 					},
	// 					LastRevisionApplied: to.Ptr[int64](1),
	// 				},
	// 				Kind: to.Ptr("Kustomization"),
	// 				StatusConditions: []*armkubernetesconfiguration.ObjectStatusConditionDefinition{
	// 					{
	// 						Type: to.Ptr("Ready"),
	// 						LastTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:12:40.000Z"); return t}()),
	// 						Message: to.Ptr("'Applied revision: master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590'"),
	// 						Reason: to.Ptr("ReconciliationSucceeded"),
	// 						Status: to.Ptr("True"),
	// 				}},
	// 		}},
	// 		Suspend: to.Ptr(false),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/kubernetesconfiguration/resource-manager/Microsoft.KubernetesConfiguration/stable/2023-05-01/examples/DeleteFluxConfiguration.json
func ExampleFluxConfigurationsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkubernetesconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFluxConfigurationsClient().BeginDelete(ctx, "rg1", "Microsoft.Kubernetes", "connectedClusters", "clusterName1", "srs-fluxconfig", &armkubernetesconfiguration.FluxConfigurationsClientBeginDeleteOptions{ForceDelete: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/kubernetesconfiguration/resource-manager/Microsoft.KubernetesConfiguration/stable/2023-05-01/examples/ListFluxConfigurations.json
func ExampleFluxConfigurationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkubernetesconfiguration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFluxConfigurationsClient().NewListPager("rg1", "Microsoft.Kubernetes", "connectedClusters", "clusterName1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FluxConfigurationsList = armkubernetesconfiguration.FluxConfigurationsList{
		// 	Value: []*armkubernetesconfiguration.FluxConfiguration{
		// 		{
		// 			Name: to.Ptr("srs-fluxconfig"),
		// 			Type: to.Ptr("Microsoft.KubernetesConfiguration/fluxConfigurations"),
		// 			ID: to.Ptr("/subscriptions/subId1/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/clusterName1/providers/Microsoft.KubernetesConfiguration/fluxConfigurations/srs-fluxconfig"),
		// 			Properties: &armkubernetesconfiguration.FluxConfigurationProperties{
		// 				ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
		// 				ErrorMessage: to.Ptr(""),
		// 				GitRepository: &armkubernetesconfiguration.GitRepositoryDefinition{
		// 					RepositoryRef: &armkubernetesconfiguration.RepositoryRefDefinition{
		// 						Branch: to.Ptr("master"),
		// 					},
		// 					SyncIntervalInSeconds: to.Ptr[int64](600),
		// 					TimeoutInSeconds: to.Ptr[int64](600),
		// 					URL: to.Ptr("https://github.com/Azure/arc-k8s-demo"),
		// 				},
		// 				Kustomizations: map[string]*armkubernetesconfiguration.KustomizationDefinition{
		// 					"srs-kustomization1": &armkubernetesconfiguration.KustomizationDefinition{
		// 						Name: to.Ptr("srs-kustomization1"),
		// 						Path: to.Ptr("./test/path"),
		// 						DependsOn: []*string{
		// 						},
		// 						PostBuild: &armkubernetesconfiguration.PostBuildDefinition{
		// 							Substitute: map[string]*string{
		// 								"cluster_env": to.Ptr("prod"),
		// 								"replica_count": to.Ptr("2"),
		// 							},
		// 							SubstituteFrom: []*armkubernetesconfiguration.SubstituteFromDefinition{
		// 								{
		// 									Name: to.Ptr("cluster-test"),
		// 									Kind: to.Ptr("ConfigMap"),
		// 									Optional: to.Ptr(true),
		// 							}},
		// 						},
		// 						SyncIntervalInSeconds: to.Ptr[int64](600),
		// 						TimeoutInSeconds: to.Ptr[int64](600),
		// 						Wait: to.Ptr(true),
		// 					},
		// 					"srs-kustomization2": &armkubernetesconfiguration.KustomizationDefinition{
		// 						Name: to.Ptr("srs-kustomization2"),
		// 						Path: to.Ptr("./other/test/path"),
		// 						DependsOn: []*string{
		// 							to.Ptr("srs-kustomization1")},
		// 							PostBuild: &armkubernetesconfiguration.PostBuildDefinition{
		// 								SubstituteFrom: []*armkubernetesconfiguration.SubstituteFromDefinition{
		// 									{
		// 										Name: to.Ptr("cluster-values"),
		// 										Kind: to.Ptr("ConfigMap"),
		// 										Optional: to.Ptr(true),
		// 									},
		// 									{
		// 										Name: to.Ptr("secret-name"),
		// 										Kind: to.Ptr("Secret"),
		// 										Optional: to.Ptr(false),
		// 								}},
		// 							},
		// 							Prune: to.Ptr(false),
		// 							RetryIntervalInSeconds: to.Ptr[int64](600),
		// 							SyncIntervalInSeconds: to.Ptr[int64](600),
		// 							TimeoutInSeconds: to.Ptr[int64](600),
		// 							Wait: to.Ptr(false),
		// 						},
		// 					},
		// 					Namespace: to.Ptr("srs-namespace"),
		// 					ProvisioningState: to.Ptr(armkubernetesconfiguration.ProvisioningStateSucceeded),
		// 					RepositoryPublicKey: to.Ptr("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiNkrANrhtRy+02Xc7b5bwvgOKvQMbqUQaXeB6FCDkbLaavw/zO/vIhIBEQu+vbBt6IlI/Pui0rMFr5JjA8Vwwd85oabzU07TPzbFvKSU9eCXqWRKWf0DHNQj/kxPJNtyPYFv3lGoiZZ6QzejOxlW/lPPokUePN0oI10daWwqznm2q0Cmh1EgPUYveq3J5KCWncZXCdwY36zWYulCWFaqazoaGy4kxcqlVy+mPjE/UJthaoLm3mq+23uhlmmfCc1j7W6+H6fcOwTyOtcbimxz2Ug8HlTzSTXBPtEe7qyllMyk62EPNUUq4bVoVsex9sKBK6/hW0Cn2P5i5jslUPCQF"),
		// 					Scope: to.Ptr(armkubernetesconfiguration.ScopeTypeCluster),
		// 					SourceKind: to.Ptr(armkubernetesconfiguration.SourceKindTypeGitRepository),
		// 					SourceSyncedCommitID: to.Ptr("master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590"),
		// 					SourceUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
		// 					StatusUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
		// 					Statuses: []*armkubernetesconfiguration.ObjectStatusDefinition{
		// 						{
		// 							Name: to.Ptr("srs-fluxconfig"),
		// 							ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
		// 							Kind: to.Ptr("GitRepository"),
		// 						},
		// 						{
		// 							Name: to.Ptr("srs-fluxconfig-srs-kustomization1"),
		// 							ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
		// 							Kind: to.Ptr("Kustomization"),
		// 						},
		// 						{
		// 							Name: to.Ptr("srs-fluxconfig-srs-kustomization2"),
		// 							ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
		// 							Kind: to.Ptr("Kustomization"),
		// 					}},
		// 					Suspend: to.Ptr(false),
		// 				},
		// 				SystemData: &armkubernetesconfiguration.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T05:10:57.027Z"); return t}()),
		// 					CreatedBy: to.Ptr("string"),
		// 					CreatedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-19T05:10:57.027Z"); return t}()),
		// 					LastModifiedBy: to.Ptr("string"),
		// 					LastModifiedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("srs-fluxconfig"),
		// 				Type: to.Ptr("Microsoft.KubernetesConfiguration/fluxConfigurations"),
		// 				ID: to.Ptr("/subscriptions/subId1/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/clusterName1/providers/Microsoft.KubernetesConfiguration/fluxConfigurations/srs-fluxconfig"),
		// 				Properties: &armkubernetesconfiguration.FluxConfigurationProperties{
		// 					ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
		// 					ErrorMessage: to.Ptr(""),
		// 					GitRepository: &armkubernetesconfiguration.GitRepositoryDefinition{
		// 						RepositoryRef: &armkubernetesconfiguration.RepositoryRefDefinition{
		// 							Branch: to.Ptr("master"),
		// 						},
		// 						SyncIntervalInSeconds: to.Ptr[int64](600),
		// 						TimeoutInSeconds: to.Ptr[int64](600),
		// 						URL: to.Ptr("https://github.com/Azure/arc-k8s-demo"),
		// 					},
		// 					Kustomizations: map[string]*armkubernetesconfiguration.KustomizationDefinition{
		// 						"srs-kustomization1": &armkubernetesconfiguration.KustomizationDefinition{
		// 							Name: to.Ptr("srs-kustomization1"),
		// 							Path: to.Ptr("./test/path"),
		// 							DependsOn: []*string{
		// 							},
		// 							SyncIntervalInSeconds: to.Ptr[int64](600),
		// 							TimeoutInSeconds: to.Ptr[int64](600),
		// 						},
		// 						"srs-kustomization2": &armkubernetesconfiguration.KustomizationDefinition{
		// 							Name: to.Ptr("srs-kustomization2"),
		// 							Path: to.Ptr("./other/test/path"),
		// 							DependsOn: []*string{
		// 								to.Ptr("srs-kustomization1")},
		// 								Prune: to.Ptr(false),
		// 								RetryIntervalInSeconds: to.Ptr[int64](600),
		// 								SyncIntervalInSeconds: to.Ptr[int64](600),
		// 								TimeoutInSeconds: to.Ptr[int64](600),
		// 							},
		// 						},
		// 						Namespace: to.Ptr("srs-namespace"),
		// 						ProvisioningState: to.Ptr(armkubernetesconfiguration.ProvisioningStateSucceeded),
		// 						RepositoryPublicKey: to.Ptr("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiNkrANrhtRy+02Xc7b5bwvgOKvQMbqUQaXeB6FCDkbLaavw/zO/vIhIBEQu+vbBt6IlI/Pui0rMFr5JjA8Vwwd85oabzU07TPzbFvKSU9eCXqWRKWf0DHNQj/kxPJNtyPYFv3lGoiZZ6QzejOxlW/lPPokUePN0oI10daWwqznm2q0Cmh1EgPUYveq3J5KCWncZXCdwY36zWYulCWFaqazoaGy4kxcqlVy+mPjE/UJthaoLm3mq+23uhlmmfCc1j7W6+H6fcOwTyOtcbimxz2Ug8HlTzSTXBPtEe7qyllMyk62EPNUUq4bVoVsex9sKBK6/hW0Cn2P5i5jslUPCQF"),
		// 						Scope: to.Ptr(armkubernetesconfiguration.ScopeTypeCluster),
		// 						SourceKind: to.Ptr(armkubernetesconfiguration.SourceKindTypeGitRepository),
		// 						SourceSyncedCommitID: to.Ptr("master/0ba6f0d30760d567de0bac86c8c4eec13ce1a590"),
		// 						SourceUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
		// 						StatusUpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T18:17:12.000Z"); return t}()),
		// 						Statuses: []*armkubernetesconfiguration.ObjectStatusDefinition{
		// 							{
		// 								Name: to.Ptr("srs-fluxconfig"),
		// 								ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
		// 								Kind: to.Ptr("GitRepository"),
		// 							},
		// 							{
		// 								Name: to.Ptr("srs-fluxconfig-srs-kustomization1"),
		// 								ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
		// 								Kind: to.Ptr("Kustomization"),
		// 							},
		// 							{
		// 								Name: to.Ptr("srs-fluxconfig-srs-kustomization2"),
		// 								ComplianceState: to.Ptr(armkubernetesconfiguration.FluxComplianceStateCompliant),
		// 								Kind: to.Ptr("Kustomization"),
		// 						}},
		// 						Suspend: to.Ptr(false),
		// 					},
		// 					SystemData: &armkubernetesconfiguration.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-05-19T05:10:57.027Z"); return t}()),
		// 						CreatedBy: to.Ptr("string"),
		// 						CreatedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-19T05:10:57.027Z"); return t}()),
		// 						LastModifiedBy: to.Ptr("string"),
		// 						LastModifiedByType: to.Ptr(armkubernetesconfiguration.CreatedByTypeApplication),
		// 					},
		// 			}},
		// 		}
	}
}
