//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotcentral

// App - The IoT Central application.
type App struct {
	// REQUIRED; The resource location.
	Location *string

	// REQUIRED; A valid instance SKU.
	SKU *AppSKUInfo

	// The managed identities for the IoT Central application.
	Identity *SystemAssignedServiceIdentity

	// The common properties of an IoT Central application.
	Properties *AppProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The ARM resource identifier.
	ID *string

	// READ-ONLY; The ARM resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// AppAvailabilityInfo - The properties indicating whether a given IoT Central application name or subdomain is available.
type AppAvailabilityInfo struct {
	// READ-ONLY; The detailed reason message.
	Message *string

	// READ-ONLY; The value which indicates whether the provided name is available.
	NameAvailable *bool

	// READ-ONLY; The reason for unavailability.
	Reason *string
}

// AppListResult - A list of IoT Central Applications with a next link.
type AppListResult struct {
	// The link used to get the next page of IoT Central Applications.
	NextLink *string

	// A list of IoT Central Applications.
	Value []*App
}

// AppPatch - The description of the IoT Central application.
type AppPatch struct {
	// The managed identities for the IoT Central application.
	Identity *SystemAssignedServiceIdentity

	// The common properties of an IoT Central application.
	Properties *AppProperties

	// A valid instance SKU.
	SKU *AppSKUInfo

	// Instance tags
	Tags map[string]*string
}

// AppProperties - The properties of an IoT Central application.
type AppProperties struct {
	// The display name of the application.
	DisplayName *string

	// The subdomain of the application.
	Subdomain *string

	// The ID of the application template, which is a blueprint that defines the characteristics and behaviors of an application.
	// Optional; if not specified, defaults to a blank blueprint and allows the
	// application to be defined from scratch.
	Template *string

	// READ-ONLY; The ID of the application.
	ApplicationID *string

	// READ-ONLY; The current state of the application.
	State *AppState
}

// AppSKUInfo - Information about the SKU of the IoT Central application.
type AppSKUInfo struct {
	// REQUIRED; The name of the SKU.
	Name *AppSKU
}

// AppTemplate - IoT Central Application Template.
type AppTemplate struct {
	// READ-ONLY; The description of the template.
	Description *string

	// READ-ONLY; The industry of the template.
	Industry *string

	// READ-ONLY; A list of locations that support the template.
	Locations []*AppTemplateLocations

	// READ-ONLY; The ID of the template.
	ManifestID *string

	// READ-ONLY; The version of the template.
	ManifestVersion *string

	// READ-ONLY; The name of the template.
	Name *string

	// READ-ONLY; The order of the template in the templates list.
	Order *float32

	// READ-ONLY; The title of the template.
	Title *string
}

// AppTemplateLocations - IoT Central Application Template Locations.
type AppTemplateLocations struct {
	// READ-ONLY; The display name of the location.
	DisplayName *string

	// READ-ONLY; The ID of the location.
	ID *string
}

// AppTemplatesResult - A list of IoT Central Application Templates with a next link.
type AppTemplatesResult struct {
	// The link used to get the next page of IoT Central application templates.
	NextLink *string

	// READ-ONLY; A list of IoT Central Application Templates.
	Value []*AppTemplate
}

// CloudErrorBody - Details of error response.
type CloudErrorBody struct {
	// A list of additional details about the error.
	Details []*CloudErrorBody

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The target of the particular error.
	Target *string
}

// Operation - IoT Central REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// READ-ONLY; Operation name: {provider}/{resource}/{read | write | action | delete}
	Name *string

	// READ-ONLY; The intended executor of the operation.
	Origin *string

	// READ-ONLY; Additional descriptions for the operation.
	Properties any
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Friendly description for the operation,
	Description *string

	// READ-ONLY; Name of the operation
	Operation *string

	// READ-ONLY; Service provider: Microsoft IoT Central
	Provider *string

	// READ-ONLY; Resource Type: IoT Central
	Resource *string
}

// OperationInputs - Input values.
type OperationInputs struct {
	// REQUIRED; The name of the IoT Central application instance to check.
	Name *string

	// The type of the IoT Central resource to query.
	Type *string
}

// OperationListResult - A list of IoT Central operations. It contains a list of operations and a URL link to get the next
// set of results.
type OperationListResult struct {
	// The link used to get the next page of IoT Central description objects.
	NextLink *string

	// READ-ONLY; A list of operations supported by the Microsoft.IoTCentral resource provider.
	Value []*Operation
}

// Resource - The common properties of an ARM resource.
type Resource struct {
	// REQUIRED; The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The ARM resource identifier.
	ID *string

	// READ-ONLY; The ARM resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// SystemAssignedServiceIdentity - Managed service identity (either system assigned, or none)
type SystemAssignedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (either system assigned, or none).
	Type *SystemAssignedServiceIdentityType

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}
