//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridnetwork/armhybridnetwork/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ComponentsServer is a fake server for instances of the armhybridnetwork.ComponentsClient type.
type ComponentsServer struct {
	// Get is the fake for method ComponentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, networkFunctionName string, componentName string, options *armhybridnetwork.ComponentsClientGetOptions) (resp azfake.Responder[armhybridnetwork.ComponentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByNetworkFunctionPager is the fake for method ComponentsClient.NewListByNetworkFunctionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByNetworkFunctionPager func(resourceGroupName string, networkFunctionName string, options *armhybridnetwork.ComponentsClientListByNetworkFunctionOptions) (resp azfake.PagerResponder[armhybridnetwork.ComponentsClientListByNetworkFunctionResponse])
}

// NewComponentsServerTransport creates a new instance of ComponentsServerTransport with the provided implementation.
// The returned ComponentsServerTransport instance is connected to an instance of armhybridnetwork.ComponentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewComponentsServerTransport(srv *ComponentsServer) *ComponentsServerTransport {
	return &ComponentsServerTransport{
		srv:                           srv,
		newListByNetworkFunctionPager: newTracker[azfake.PagerResponder[armhybridnetwork.ComponentsClientListByNetworkFunctionResponse]](),
	}
}

// ComponentsServerTransport connects instances of armhybridnetwork.ComponentsClient to instances of ComponentsServer.
// Don't use this type directly, use NewComponentsServerTransport instead.
type ComponentsServerTransport struct {
	srv                           *ComponentsServer
	newListByNetworkFunctionPager *tracker[azfake.PagerResponder[armhybridnetwork.ComponentsClientListByNetworkFunctionResponse]]
}

// Do implements the policy.Transporter interface for ComponentsServerTransport.
func (c *ComponentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ComponentsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ComponentsClient.NewListByNetworkFunctionPager":
		resp, err = c.dispatchNewListByNetworkFunctionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ComponentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridNetwork/networkFunctions/(?P<networkFunctionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/components/(?P<componentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkFunctionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionName")])
	if err != nil {
		return nil, err
	}
	componentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("componentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, networkFunctionNameParam, componentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Component, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ComponentsServerTransport) dispatchNewListByNetworkFunctionPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByNetworkFunctionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByNetworkFunctionPager not implemented")}
	}
	newListByNetworkFunctionPager := c.newListByNetworkFunctionPager.get(req)
	if newListByNetworkFunctionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridNetwork/networkFunctions/(?P<networkFunctionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/components`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFunctionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByNetworkFunctionPager(resourceGroupNameParam, networkFunctionNameParam, nil)
		newListByNetworkFunctionPager = &resp
		c.newListByNetworkFunctionPager.add(req, newListByNetworkFunctionPager)
		server.PagerResponderInjectNextLinks(newListByNetworkFunctionPager, req, func(page *armhybridnetwork.ComponentsClientListByNetworkFunctionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByNetworkFunctionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByNetworkFunctionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByNetworkFunctionPager) {
		c.newListByNetworkFunctionPager.remove(req)
	}
	return resp, nil
}
