//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhybridnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridnetwork/armhybridnetwork/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestListByArtifactStore.json
func ExampleArtifactManifestsClient_NewListByArtifactStorePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewArtifactManifestsClient().NewListByArtifactStorePager("rg", "TestPublisher", "TestArtifactStore", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ArtifactManifestListResult = armhybridnetwork.ArtifactManifestListResult{
		// 	Value: []*armhybridnetwork.ArtifactManifest{
		// 		{
		// 			Name: to.Ptr("TestManifest"),
		// 			Type: to.Ptr("microsoft.hybridnetwork/publishers/artifactStores/artifactManifests"),
		// 			ID: to.Ptr("/subscriptions/subid/providers/microsoft.hybridnetwork/publishers/TestPublisher/artifactStores/TestArtifactStore/artifactManifests/TestManifest"),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armhybridnetwork.ArtifactManifestPropertiesFormat{
		// 				ArtifactManifestState: to.Ptr(armhybridnetwork.ArtifactManifestStateUploaded),
		// 				Artifacts: []*armhybridnetwork.ManifestArtifactFormat{
		// 					{
		// 						ArtifactName: to.Ptr("fed-rbac"),
		// 						ArtifactType: to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
		// 						ArtifactVersion: to.Ptr("1.0.0"),
		// 					},
		// 					{
		// 						ArtifactName: to.Ptr("nginx"),
		// 						ArtifactType: to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
		// 						ArtifactVersion: to.Ptr("v1"),
		// 				}},
		// 				ProvisioningState: to.Ptr(armhybridnetwork.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestDelete.json
func ExampleArtifactManifestsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewArtifactManifestsClient().BeginDelete(ctx, "rg", "TestPublisher", "TestArtifactStore", "TestManifest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestCreate.json
func ExampleArtifactManifestsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewArtifactManifestsClient().BeginCreateOrUpdate(ctx, "rg", "TestPublisher", "TestArtifactStore", "TestManifest", armhybridnetwork.ArtifactManifest{
		Location: to.Ptr("eastus"),
		Properties: &armhybridnetwork.ArtifactManifestPropertiesFormat{
			Artifacts: []*armhybridnetwork.ManifestArtifactFormat{
				{
					ArtifactName:    to.Ptr("fed-rbac"),
					ArtifactType:    to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
					ArtifactVersion: to.Ptr("1.0.0"),
				},
				{
					ArtifactName:    to.Ptr("nginx"),
					ArtifactType:    to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
					ArtifactVersion: to.Ptr("v1"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ArtifactManifest = armhybridnetwork.ArtifactManifest{
	// 	Name: to.Ptr("TestManifest"),
	// 	Type: to.Ptr("microsoft.hybridnetwork/publishers/artifactStores/artifactManifests"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/UnityCloud/artifactStores/TestArtifactStore/artifactManifests/TestManifest"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armhybridnetwork.ArtifactManifestPropertiesFormat{
	// 		ArtifactManifestState: to.Ptr(armhybridnetwork.ArtifactManifestStateUploaded),
	// 		Artifacts: []*armhybridnetwork.ManifestArtifactFormat{
	// 			{
	// 				ArtifactName: to.Ptr("fed-rbac"),
	// 				ArtifactType: to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
	// 				ArtifactVersion: to.Ptr("1.0.0"),
	// 			},
	// 			{
	// 				ArtifactName: to.Ptr("nginx"),
	// 				ArtifactType: to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
	// 				ArtifactVersion: to.Ptr("v1"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armhybridnetwork.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestGet.json
func ExampleArtifactManifestsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewArtifactManifestsClient().Get(ctx, "rg", "TestPublisher", "TestArtifactStore", "TestManifest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ArtifactManifest = armhybridnetwork.ArtifactManifest{
	// 	Name: to.Ptr("TestManifest"),
	// 	Type: to.Ptr("microsoft.hybridnetwork/publishers/artifactStores/artifactManifests"),
	// 	ID: to.Ptr("/subscriptions/subid/providers/microsoft.hybridnetwork/publishers/UnityCloud/artifactStores/TestArtifactStore/artifactManifests/TestManifest"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armhybridnetwork.ArtifactManifestPropertiesFormat{
	// 		ArtifactManifestState: to.Ptr(armhybridnetwork.ArtifactManifestStateUploaded),
	// 		Artifacts: []*armhybridnetwork.ManifestArtifactFormat{
	// 			{
	// 				ArtifactName: to.Ptr("fed-rbac"),
	// 				ArtifactType: to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
	// 				ArtifactVersion: to.Ptr("1.0.0"),
	// 			},
	// 			{
	// 				ArtifactName: to.Ptr("nginx"),
	// 				ArtifactType: to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
	// 				ArtifactVersion: to.Ptr("v1"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armhybridnetwork.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestUpdateTags.json
func ExampleArtifactManifestsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewArtifactManifestsClient().Update(ctx, "rg", "TestPublisher", "TestArtifactStore", "TestManifest", armhybridnetwork.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ArtifactManifest = armhybridnetwork.ArtifactManifest{
	// 	Name: to.Ptr("TestManifest"),
	// 	Type: to.Ptr("microsoft.hybridnetwork/publishers/artifactStores/artifactManifests"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/rg/providers/microsoft.hybridnetwork/publishers/UnityCloud/artifactStores/TestArtifactStore/artifactManifests/TestManifest"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armhybridnetwork.ArtifactManifestPropertiesFormat{
	// 		ArtifactManifestState: to.Ptr(armhybridnetwork.ArtifactManifestStateUploaded),
	// 		Artifacts: []*armhybridnetwork.ManifestArtifactFormat{
	// 			{
	// 				ArtifactName: to.Ptr("fed-rbac"),
	// 				ArtifactType: to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
	// 				ArtifactVersion: to.Ptr("1.0.0"),
	// 			},
	// 			{
	// 				ArtifactName: to.Ptr("nginx"),
	// 				ArtifactType: to.Ptr(armhybridnetwork.ArtifactTypeOCIArtifact),
	// 				ArtifactVersion: to.Ptr("v1"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armhybridnetwork.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestListCredential.json
func ExampleArtifactManifestsClient_ListCredential() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewArtifactManifestsClient().ListCredential(ctx, "rg", "TestPublisher", "TestArtifactStore", "TestArtifactManifestName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armhybridnetwork.ArtifactManifestsClientListCredentialResponse{
	// 	                            ArtifactAccessCredentialClassification: &armhybridnetwork.AzureContainerRegistryScopedTokenCredential{
	// 		CredentialType: to.Ptr(armhybridnetwork.CredentialTypeAzureContainerRegistryScopedToken),
	// 		AcrServerURL: to.Ptr("test.azurecr.io"),
	// 		AcrToken: to.Ptr("dummytoken"),
	// 		Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-06-07T18:01:41.334Z"); return t}()),
	// 		Repositories: []*string{
	// 			to.Ptr("")},
	// 			Username: to.Ptr("dummyuser"),
	// 		},
	// 		                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/stable/2023-09-01/examples/ArtifactManifestUpdateState.json
func ExampleArtifactManifestsClient_BeginUpdateState() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewArtifactManifestsClient().BeginUpdateState(ctx, "rg", "TestPublisher", "TestArtifactStore", "TestArtifactManifestName", armhybridnetwork.ArtifactManifestUpdateState{
		ArtifactManifestState: to.Ptr(armhybridnetwork.ArtifactManifestStateUploaded),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ArtifactManifestUpdateState = armhybridnetwork.ArtifactManifestUpdateState{
	// 	ArtifactManifestState: to.Ptr(armhybridnetwork.ArtifactManifestStateUploaded),
	// }
}
