//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybriddatamanager

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybriddatamanager/armhybriddatamanager"
	moduleVersion = "v1.2.0"
)

// IsJobCancellable - Describes whether the job is cancellable.
type IsJobCancellable string

const (
	IsJobCancellableCancellable    IsJobCancellable = "Cancellable"
	IsJobCancellableNotCancellable IsJobCancellable = "NotCancellable"
)

// PossibleIsJobCancellableValues returns the possible values for the IsJobCancellable const type.
func PossibleIsJobCancellableValues() []IsJobCancellable {
	return []IsJobCancellable{
		IsJobCancellableCancellable,
		IsJobCancellableNotCancellable,
	}
}

// JobStatus - Status of the job.
type JobStatus string

const (
	JobStatusCancelled          JobStatus = "Cancelled"
	JobStatusCancelling         JobStatus = "Cancelling"
	JobStatusFailed             JobStatus = "Failed"
	JobStatusInProgress         JobStatus = "InProgress"
	JobStatusNone               JobStatus = "None"
	JobStatusPartiallySucceeded JobStatus = "PartiallySucceeded"
	JobStatusSucceeded          JobStatus = "Succeeded"
	JobStatusWaitingForAction   JobStatus = "WaitingForAction"
)

// PossibleJobStatusValues returns the possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{
		JobStatusCancelled,
		JobStatusCancelling,
		JobStatusFailed,
		JobStatusInProgress,
		JobStatusNone,
		JobStatusPartiallySucceeded,
		JobStatusSucceeded,
		JobStatusWaitingForAction,
	}
}

// RunLocation - This is the preferred geo location for the job to run.
type RunLocation string

const (
	RunLocationAustraliaeast      RunLocation = "australiaeast"
	RunLocationAustraliasoutheast RunLocation = "australiasoutheast"
	RunLocationBrazilsouth        RunLocation = "brazilsouth"
	RunLocationCanadacentral      RunLocation = "canadacentral"
	RunLocationCanadaeast         RunLocation = "canadaeast"
	RunLocationCentralindia       RunLocation = "centralindia"
	RunLocationCentralus          RunLocation = "centralus"
	RunLocationEastasia           RunLocation = "eastasia"
	RunLocationEastus             RunLocation = "eastus"
	RunLocationEastus2            RunLocation = "eastus2"
	RunLocationJapaneast          RunLocation = "japaneast"
	RunLocationJapanwest          RunLocation = "japanwest"
	RunLocationKoreacentral       RunLocation = "koreacentral"
	RunLocationKoreasouth         RunLocation = "koreasouth"
	RunLocationNone               RunLocation = "none"
	RunLocationNorthcentralus     RunLocation = "northcentralus"
	RunLocationNortheurope        RunLocation = "northeurope"
	RunLocationSouthcentralus     RunLocation = "southcentralus"
	RunLocationSoutheastasia      RunLocation = "southeastasia"
	RunLocationSouthindia         RunLocation = "southindia"
	RunLocationUksouth            RunLocation = "uksouth"
	RunLocationUkwest             RunLocation = "ukwest"
	RunLocationWestcentralus      RunLocation = "westcentralus"
	RunLocationWesteurope         RunLocation = "westeurope"
	RunLocationWestindia          RunLocation = "westindia"
	RunLocationWestus             RunLocation = "westus"
	RunLocationWestus2            RunLocation = "westus2"
)

// PossibleRunLocationValues returns the possible values for the RunLocation const type.
func PossibleRunLocationValues() []RunLocation {
	return []RunLocation{
		RunLocationAustraliaeast,
		RunLocationAustraliasoutheast,
		RunLocationBrazilsouth,
		RunLocationCanadacentral,
		RunLocationCanadaeast,
		RunLocationCentralindia,
		RunLocationCentralus,
		RunLocationEastasia,
		RunLocationEastus,
		RunLocationEastus2,
		RunLocationJapaneast,
		RunLocationJapanwest,
		RunLocationKoreacentral,
		RunLocationKoreasouth,
		RunLocationNone,
		RunLocationNorthcentralus,
		RunLocationNortheurope,
		RunLocationSouthcentralus,
		RunLocationSoutheastasia,
		RunLocationSouthindia,
		RunLocationUksouth,
		RunLocationUkwest,
		RunLocationWestcentralus,
		RunLocationWesteurope,
		RunLocationWestindia,
		RunLocationWestus,
		RunLocationWestus2,
	}
}

// State - State of the data service.
type State string

const (
	StateDisabled  State = "Disabled"
	StateEnabled   State = "Enabled"
	StateSupported State = "Supported"
)

// PossibleStateValues returns the possible values for the State const type.
func PossibleStateValues() []State {
	return []State{
		StateDisabled,
		StateEnabled,
		StateSupported,
	}
}

// SupportedAlgorithm - The encryption algorithm used to encrypt data.
type SupportedAlgorithm string

const (
	SupportedAlgorithmNone      SupportedAlgorithm = "None"
	SupportedAlgorithmPlainText SupportedAlgorithm = "PlainText"
	SupportedAlgorithmRSA15     SupportedAlgorithm = "RSA1_5"
	SupportedAlgorithmRSAOAEP   SupportedAlgorithm = "RSA_OAEP"
)

// PossibleSupportedAlgorithmValues returns the possible values for the SupportedAlgorithm const type.
func PossibleSupportedAlgorithmValues() []SupportedAlgorithm {
	return []SupportedAlgorithm{
		SupportedAlgorithmNone,
		SupportedAlgorithmPlainText,
		SupportedAlgorithmRSA15,
		SupportedAlgorithmRSAOAEP,
	}
}

// UserConfirmation - Enum to detect if user confirmation is required. If not passed will default to NotRequired.
type UserConfirmation string

const (
	UserConfirmationNotRequired UserConfirmation = "NotRequired"
	UserConfirmationRequired    UserConfirmation = "Required"
)

// PossibleUserConfirmationValues returns the possible values for the UserConfirmation const type.
func PossibleUserConfirmationValues() []UserConfirmation {
	return []UserConfirmation{
		UserConfirmationNotRequired,
		UserConfirmationRequired,
	}
}
