//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridcontainerservice

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAgentPoolClient creates a new instance of AgentPoolClient.
func (c *ClientFactory) NewAgentPoolClient() *AgentPoolClient {
	subClient, _ := NewAgentPoolClient(c.credential, c.options)
	return subClient
}

// NewClient creates a new instance of Client.
func (c *ClientFactory) NewClient() *Client {
	subClient, _ := NewClient(c.credential, c.options)
	return subClient
}

// NewHybridIdentityMetadataClient creates a new instance of HybridIdentityMetadataClient.
func (c *ClientFactory) NewHybridIdentityMetadataClient() *HybridIdentityMetadataClient {
	subClient, _ := NewHybridIdentityMetadataClient(c.credential, c.options)
	return subClient
}

// NewKubernetesVersionsClient creates a new instance of KubernetesVersionsClient.
func (c *ClientFactory) NewKubernetesVersionsClient() *KubernetesVersionsClient {
	subClient, _ := NewKubernetesVersionsClient(c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewProvisionedClusterInstancesClient creates a new instance of ProvisionedClusterInstancesClient.
func (c *ClientFactory) NewProvisionedClusterInstancesClient() *ProvisionedClusterInstancesClient {
	subClient, _ := NewProvisionedClusterInstancesClient(c.credential, c.options)
	return subClient
}

// NewVMSKUsClient creates a new instance of VMSKUsClient.
func (c *ClientFactory) NewVMSKUsClient() *VMSKUsClient {
	subClient, _ := NewVMSKUsClient(c.credential, c.options)
	return subClient
}

// NewVirtualNetworksClient creates a new instance of VirtualNetworksClient.
func (c *ClientFactory) NewVirtualNetworksClient() *VirtualNetworksClient {
	subClient, _ := NewVirtualNetworksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
