//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsight/armhdinsight"
	"net/http"
	"net/url"
	"regexp"
)

// ExtensionsServer is a fake server for instances of the armhdinsight.ExtensionsClient type.
type ExtensionsServer struct {
	// BeginCreate is the fake for method ExtensionsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, clusterName string, extensionName string, parameters armhdinsight.Extension, options *armhdinsight.ExtensionsClientBeginCreateOptions) (resp azfake.PollerResponder[armhdinsight.ExtensionsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ExtensionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, clusterName string, extensionName string, options *armhdinsight.ExtensionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armhdinsight.ExtensionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDisableAzureMonitor is the fake for method ExtensionsClient.BeginDisableAzureMonitor
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDisableAzureMonitor func(ctx context.Context, resourceGroupName string, clusterName string, options *armhdinsight.ExtensionsClientBeginDisableAzureMonitorOptions) (resp azfake.PollerResponder[armhdinsight.ExtensionsClientDisableAzureMonitorResponse], errResp azfake.ErrorResponder)

	// BeginDisableMonitoring is the fake for method ExtensionsClient.BeginDisableMonitoring
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDisableMonitoring func(ctx context.Context, resourceGroupName string, clusterName string, options *armhdinsight.ExtensionsClientBeginDisableMonitoringOptions) (resp azfake.PollerResponder[armhdinsight.ExtensionsClientDisableMonitoringResponse], errResp azfake.ErrorResponder)

	// BeginEnableAzureMonitor is the fake for method ExtensionsClient.BeginEnableAzureMonitor
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginEnableAzureMonitor func(ctx context.Context, resourceGroupName string, clusterName string, parameters armhdinsight.AzureMonitorRequest, options *armhdinsight.ExtensionsClientBeginEnableAzureMonitorOptions) (resp azfake.PollerResponder[armhdinsight.ExtensionsClientEnableAzureMonitorResponse], errResp azfake.ErrorResponder)

	// BeginEnableMonitoring is the fake for method ExtensionsClient.BeginEnableMonitoring
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginEnableMonitoring func(ctx context.Context, resourceGroupName string, clusterName string, parameters armhdinsight.ClusterMonitoringRequest, options *armhdinsight.ExtensionsClientBeginEnableMonitoringOptions) (resp azfake.PollerResponder[armhdinsight.ExtensionsClientEnableMonitoringResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ExtensionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, clusterName string, extensionName string, options *armhdinsight.ExtensionsClientGetOptions) (resp azfake.Responder[armhdinsight.ExtensionsClientGetResponse], errResp azfake.ErrorResponder)

	// GetAzureAsyncOperationStatus is the fake for method ExtensionsClient.GetAzureAsyncOperationStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetAzureAsyncOperationStatus func(ctx context.Context, resourceGroupName string, clusterName string, extensionName string, operationID string, options *armhdinsight.ExtensionsClientGetAzureAsyncOperationStatusOptions) (resp azfake.Responder[armhdinsight.ExtensionsClientGetAzureAsyncOperationStatusResponse], errResp azfake.ErrorResponder)

	// GetAzureMonitorStatus is the fake for method ExtensionsClient.GetAzureMonitorStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetAzureMonitorStatus func(ctx context.Context, resourceGroupName string, clusterName string, options *armhdinsight.ExtensionsClientGetAzureMonitorStatusOptions) (resp azfake.Responder[armhdinsight.ExtensionsClientGetAzureMonitorStatusResponse], errResp azfake.ErrorResponder)

	// GetMonitoringStatus is the fake for method ExtensionsClient.GetMonitoringStatus
	// HTTP status codes to indicate success: http.StatusOK
	GetMonitoringStatus func(ctx context.Context, resourceGroupName string, clusterName string, options *armhdinsight.ExtensionsClientGetMonitoringStatusOptions) (resp azfake.Responder[armhdinsight.ExtensionsClientGetMonitoringStatusResponse], errResp azfake.ErrorResponder)
}

// NewExtensionsServerTransport creates a new instance of ExtensionsServerTransport with the provided implementation.
// The returned ExtensionsServerTransport instance is connected to an instance of armhdinsight.ExtensionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExtensionsServerTransport(srv *ExtensionsServer) *ExtensionsServerTransport {
	return &ExtensionsServerTransport{
		srv:                      srv,
		beginCreate:              newTracker[azfake.PollerResponder[armhdinsight.ExtensionsClientCreateResponse]](),
		beginDelete:              newTracker[azfake.PollerResponder[armhdinsight.ExtensionsClientDeleteResponse]](),
		beginDisableAzureMonitor: newTracker[azfake.PollerResponder[armhdinsight.ExtensionsClientDisableAzureMonitorResponse]](),
		beginDisableMonitoring:   newTracker[azfake.PollerResponder[armhdinsight.ExtensionsClientDisableMonitoringResponse]](),
		beginEnableAzureMonitor:  newTracker[azfake.PollerResponder[armhdinsight.ExtensionsClientEnableAzureMonitorResponse]](),
		beginEnableMonitoring:    newTracker[azfake.PollerResponder[armhdinsight.ExtensionsClientEnableMonitoringResponse]](),
	}
}

// ExtensionsServerTransport connects instances of armhdinsight.ExtensionsClient to instances of ExtensionsServer.
// Don't use this type directly, use NewExtensionsServerTransport instead.
type ExtensionsServerTransport struct {
	srv                      *ExtensionsServer
	beginCreate              *tracker[azfake.PollerResponder[armhdinsight.ExtensionsClientCreateResponse]]
	beginDelete              *tracker[azfake.PollerResponder[armhdinsight.ExtensionsClientDeleteResponse]]
	beginDisableAzureMonitor *tracker[azfake.PollerResponder[armhdinsight.ExtensionsClientDisableAzureMonitorResponse]]
	beginDisableMonitoring   *tracker[azfake.PollerResponder[armhdinsight.ExtensionsClientDisableMonitoringResponse]]
	beginEnableAzureMonitor  *tracker[azfake.PollerResponder[armhdinsight.ExtensionsClientEnableAzureMonitorResponse]]
	beginEnableMonitoring    *tracker[azfake.PollerResponder[armhdinsight.ExtensionsClientEnableMonitoringResponse]]
}

// Do implements the policy.Transporter interface for ExtensionsServerTransport.
func (e *ExtensionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExtensionsClient.BeginCreate":
		resp, err = e.dispatchBeginCreate(req)
	case "ExtensionsClient.BeginDelete":
		resp, err = e.dispatchBeginDelete(req)
	case "ExtensionsClient.BeginDisableAzureMonitor":
		resp, err = e.dispatchBeginDisableAzureMonitor(req)
	case "ExtensionsClient.BeginDisableMonitoring":
		resp, err = e.dispatchBeginDisableMonitoring(req)
	case "ExtensionsClient.BeginEnableAzureMonitor":
		resp, err = e.dispatchBeginEnableAzureMonitor(req)
	case "ExtensionsClient.BeginEnableMonitoring":
		resp, err = e.dispatchBeginEnableMonitoring(req)
	case "ExtensionsClient.Get":
		resp, err = e.dispatchGet(req)
	case "ExtensionsClient.GetAzureAsyncOperationStatus":
		resp, err = e.dispatchGetAzureAsyncOperationStatus(req)
	case "ExtensionsClient.GetAzureMonitorStatus":
		resp, err = e.dispatchGetAzureMonitorStatus(req)
	case "ExtensionsClient.GetMonitoringStatus":
		resp, err = e.dispatchGetMonitoringStatus(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := e.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/(?P<extensionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhdinsight.Extension](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		extensionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCreate(req.Context(), resourceGroupNameParam, clusterNameParam, extensionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		e.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		e.beginCreate.remove(req)
	}

	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if e.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := e.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/(?P<extensionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		extensionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginDelete(req.Context(), resourceGroupNameParam, clusterNameParam, extensionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		e.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		e.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		e.beginDelete.remove(req)
	}

	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchBeginDisableAzureMonitor(req *http.Request) (*http.Response, error) {
	if e.srv.BeginDisableAzureMonitor == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisableAzureMonitor not implemented")}
	}
	beginDisableAzureMonitor := e.beginDisableAzureMonitor.get(req)
	if beginDisableAzureMonitor == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/azureMonitor`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginDisableAzureMonitor(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisableAzureMonitor = &respr
		e.beginDisableAzureMonitor.add(req, beginDisableAzureMonitor)
	}

	resp, err := server.PollerResponderNext(beginDisableAzureMonitor, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		e.beginDisableAzureMonitor.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisableAzureMonitor) {
		e.beginDisableAzureMonitor.remove(req)
	}

	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchBeginDisableMonitoring(req *http.Request) (*http.Response, error) {
	if e.srv.BeginDisableMonitoring == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisableMonitoring not implemented")}
	}
	beginDisableMonitoring := e.beginDisableMonitoring.get(req)
	if beginDisableMonitoring == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/clustermonitoring`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginDisableMonitoring(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisableMonitoring = &respr
		e.beginDisableMonitoring.add(req, beginDisableMonitoring)
	}

	resp, err := server.PollerResponderNext(beginDisableMonitoring, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		e.beginDisableMonitoring.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisableMonitoring) {
		e.beginDisableMonitoring.remove(req)
	}

	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchBeginEnableAzureMonitor(req *http.Request) (*http.Response, error) {
	if e.srv.BeginEnableAzureMonitor == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginEnableAzureMonitor not implemented")}
	}
	beginEnableAzureMonitor := e.beginEnableAzureMonitor.get(req)
	if beginEnableAzureMonitor == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/azureMonitor`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhdinsight.AzureMonitorRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginEnableAzureMonitor(req.Context(), resourceGroupNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginEnableAzureMonitor = &respr
		e.beginEnableAzureMonitor.add(req, beginEnableAzureMonitor)
	}

	resp, err := server.PollerResponderNext(beginEnableAzureMonitor, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginEnableAzureMonitor.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginEnableAzureMonitor) {
		e.beginEnableAzureMonitor.remove(req)
	}

	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchBeginEnableMonitoring(req *http.Request) (*http.Response, error) {
	if e.srv.BeginEnableMonitoring == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginEnableMonitoring not implemented")}
	}
	beginEnableMonitoring := e.beginEnableMonitoring.get(req)
	if beginEnableMonitoring == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/clustermonitoring`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhdinsight.ClusterMonitoringRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginEnableMonitoring(req.Context(), resourceGroupNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginEnableMonitoring = &respr
		e.beginEnableMonitoring.add(req, beginEnableMonitoring)
	}

	resp, err := server.PollerResponderNext(beginEnableMonitoring, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginEnableMonitoring.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginEnableMonitoring) {
		e.beginEnableMonitoring.remove(req)
	}

	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/(?P<extensionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	extensionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, clusterNameParam, extensionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ClusterMonitoringResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchGetAzureAsyncOperationStatus(req *http.Request) (*http.Response, error) {
	if e.srv.GetAzureAsyncOperationStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAzureAsyncOperationStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/(?P<extensionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/azureAsyncOperations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	extensionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetAzureAsyncOperationStatus(req.Context(), resourceGroupNameParam, clusterNameParam, extensionNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AsyncOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchGetAzureMonitorStatus(req *http.Request) (*http.Response, error) {
	if e.srv.GetAzureMonitorStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAzureMonitorStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/azureMonitor`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetAzureMonitorStatus(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureMonitorResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchGetMonitoringStatus(req *http.Request) (*http.Response, error) {
	if e.srv.GetMonitoringStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMonitoringStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extensions/clustermonitoring`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetMonitoringStatus(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ClusterMonitoringResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
