//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hardwaresecuritymodules/armhardwaresecuritymodules/v2"
	"net/http"
	"net/url"
	"regexp"
)

// PrivateEndpointConnectionsServer is a fake server for instances of the armhardwaresecuritymodules.PrivateEndpointConnectionsClient type.
type PrivateEndpointConnectionsServer struct {
	// NewListByCloudHsmClusterPager is the fake for method PrivateEndpointConnectionsClient.NewListByCloudHsmClusterPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByCloudHsmClusterPager func(resourceGroupName string, cloudHsmClusterName string, options *armhardwaresecuritymodules.PrivateEndpointConnectionsClientListByCloudHsmClusterOptions) (resp azfake.PagerResponder[armhardwaresecuritymodules.PrivateEndpointConnectionsClientListByCloudHsmClusterResponse])
}

// NewPrivateEndpointConnectionsServerTransport creates a new instance of PrivateEndpointConnectionsServerTransport with the provided implementation.
// The returned PrivateEndpointConnectionsServerTransport instance is connected to an instance of armhardwaresecuritymodules.PrivateEndpointConnectionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateEndpointConnectionsServerTransport(srv *PrivateEndpointConnectionsServer) *PrivateEndpointConnectionsServerTransport {
	return &PrivateEndpointConnectionsServerTransport{
		srv:                           srv,
		newListByCloudHsmClusterPager: newTracker[azfake.PagerResponder[armhardwaresecuritymodules.PrivateEndpointConnectionsClientListByCloudHsmClusterResponse]](),
	}
}

// PrivateEndpointConnectionsServerTransport connects instances of armhardwaresecuritymodules.PrivateEndpointConnectionsClient to instances of PrivateEndpointConnectionsServer.
// Don't use this type directly, use NewPrivateEndpointConnectionsServerTransport instead.
type PrivateEndpointConnectionsServerTransport struct {
	srv                           *PrivateEndpointConnectionsServer
	newListByCloudHsmClusterPager *tracker[azfake.PagerResponder[armhardwaresecuritymodules.PrivateEndpointConnectionsClientListByCloudHsmClusterResponse]]
}

// Do implements the policy.Transporter interface for PrivateEndpointConnectionsServerTransport.
func (p *PrivateEndpointConnectionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateEndpointConnectionsClient.NewListByCloudHsmClusterPager":
		resp, err = p.dispatchNewListByCloudHsmClusterPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateEndpointConnectionsServerTransport) dispatchNewListByCloudHsmClusterPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByCloudHsmClusterPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByCloudHsmClusterPager not implemented")}
	}
	newListByCloudHsmClusterPager := p.newListByCloudHsmClusterPager.get(req)
	if newListByCloudHsmClusterPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HardwareSecurityModules/cloudHsmClusters/(?P<cloudHsmClusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cloudHsmClusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cloudHsmClusterName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByCloudHsmClusterPager(resourceGroupNameParam, cloudHsmClusterNameParam, nil)
		newListByCloudHsmClusterPager = &resp
		p.newListByCloudHsmClusterPager.add(req, newListByCloudHsmClusterPager)
		server.PagerResponderInjectNextLinks(newListByCloudHsmClusterPager, req, func(page *armhardwaresecuritymodules.PrivateEndpointConnectionsClientListByCloudHsmClusterResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByCloudHsmClusterPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByCloudHsmClusterPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByCloudHsmClusterPager) {
		p.newListByCloudHsmClusterPager.remove(req)
	}
	return resp, nil
}
