//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armfluidrelay

import "time"

// Container - A FluidRelay Container.
type Container struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The resource-specific properties for this resource.
	Properties *ContainerProperties

	// READ-ONLY; System meta data for this resource, including creation and modification information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ContainerList - Paged response
type ContainerList struct {
	// A sequence of FluidRelay containers.
	Value []*Container

	// READ-ONLY; A link to the next page of results, if any.
	NextLink *string
}

// ContainerProperties - The properties of a Fluid Relay Container resource.
type ContainerProperties struct {
	// READ-ONLY; The creation time of this resource
	CreationTime *time.Time

	// READ-ONLY; The frsContainerId for this container
	FrsContainerID *string

	// READ-ONLY; The Fluid tenantId for this container
	FrsTenantID *string

	// READ-ONLY; Last time when user access this resource
	LastAccessTime *time.Time

	// READ-ONLY; Provision states for FluidRelay RP
	ProvisioningState *ProvisioningState
}

// CustomerManagedKeyEncryptionProperties - All Customer-managed key encryption properties for the resource.
type CustomerManagedKeyEncryptionProperties struct {
	// All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
	KeyEncryptionKeyIdentity *CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentity

	// key encryption key Url, with or without a version. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
	// or https://contosovault.vault.azure.net/keys/contosokek.
	// Key auto rotation is enabled by providing a key uri without version. Otherwise, customer is responsible for rotating the
	// key. The keyEncryptionKeyIdentity(either SystemAssigned or UserAssigned) should
	// have permission to access this key url.
	KeyEncryptionKeyURL *string
}

// CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentity - All identity configuration for Customer-managed key settings
// defining which identity should be used to auth to Key Vault.
type CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentity struct {
	// Values can be SystemAssigned or UserAssigned
	IdentityType *CmkIdentityType

	// user assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/
	// /providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with identityType systemAssignedIdentity.
	UserAssignedIdentityResourceID *string
}

// EncryptionProperties - All encryption configuration for a resource.
type EncryptionProperties struct {
	// All Customer-managed key encryption properties for the resource.
	CustomerManagedKeyEncryption *CustomerManagedKeyEncryptionProperties
}

// Endpoints - The Fluid Relay endpoints for this server
type Endpoints struct {
	// READ-ONLY; The Fluid Relay Orderer endpoints.
	OrdererEndpoints []*string

	// READ-ONLY; The Fluid Relay service endpoints.
	ServiceEndpoints []*string

	// READ-ONLY; The Fluid Relay storage endpoints.
	StorageEndpoints []*string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType

	// The list of user identities associated with the resource.
	UserAssignedIdentities map[string]*UserAssignedIdentitiesValue

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation, e.g., 'Write confluent'.
	Description *string

	// Operation type, e.g., read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.FluidRelay
	Provider *string

	// Type on which the operation is performed, e.g., 'servers'.
	Resource *string
}

// OperationListResult - Result of GET request to list FluidRelay operations.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of FluidRelay operations supported by the Microsoft.FluidRelay provider.
	Value []*OperationResult
}

// OperationResult - A FluidRelay REST API operation.
type OperationResult struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RegenerateKeyRequest - Specifies which key should be generated.
type RegenerateKeyRequest struct {
	// REQUIRED; The key to regenerate.
	KeyName *KeyName
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Server - A FluidRelay Server.
type Server struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The type of identity used for the resource.
	Identity *Identity

	// The resource-specific properties for this resource.
	Properties *ServerProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; System meta data for this resource, including creation and modification information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerKeys - The set of available keys for this server.
type ServerKeys struct {
	// READ-ONLY; The primary key for this server
	Key1 *string

	// READ-ONLY; The secondary key for this server
	Key2 *string
}

// ServerList - Paged response
type ServerList struct {
	// REQUIRED; A sequence of FluidRelay servers.
	Value []*Server

	// A link to the next page of results, if any.
	NextLink *string
}

// ServerProperties - The properties of a Fluid Relay Service resource.
type ServerProperties struct {
	// All encryption configuration for a resource.
	Encryption *EncryptionProperties

	// Provision states for FluidRelay RP
	ProvisioningState *ProvisioningState

	// Sku of the storage associated with the resource
	Storagesku *StorageSKU

	// READ-ONLY; The Fluid Relay Service endpoints for this server.
	FluidRelayEndpoints *Endpoints

	// READ-ONLY; The Fluid tenantId for this server
	FrsTenantID *string
}

// ServerUpdate - The updatable properties of a Fluid Relay server
type ServerUpdate struct {
	// The type of identity used for the resource.
	Identity *Identity

	// The geo-location where the resource lives
	Location *string

	// The resource-specific properties that can be updated for this resource.
	Properties *ServerUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// ServerUpdateProperties - The properties that can be provided when updating FluidRelayServer resource
type ServerUpdateProperties struct {
	// All encryption configuration for a resource.
	Encryption *EncryptionProperties
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type UserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}
