//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/education/armeducation"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// LabsServer is a fake server for instances of the armeducation.LabsClient type.
type LabsServer struct {
	// CreateOrUpdate is the fake for method LabsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, parameters armeducation.LabDetails, options *armeducation.LabsClientCreateOrUpdateOptions) (resp azfake.Responder[armeducation.LabsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method LabsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *armeducation.LabsClientDeleteOptions) (resp azfake.Responder[armeducation.LabsClientDeleteResponse], errResp azfake.ErrorResponder)

	// GenerateInviteCode is the fake for method LabsClient.GenerateInviteCode
	// HTTP status codes to indicate success: http.StatusOK
	GenerateInviteCode func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, parameters armeducation.InviteCodeGenerateRequest, options *armeducation.LabsClientGenerateInviteCodeOptions) (resp azfake.Responder[armeducation.LabsClientGenerateInviteCodeResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LabsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *armeducation.LabsClientGetOptions) (resp azfake.Responder[armeducation.LabsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method LabsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(billingAccountName string, billingProfileName string, invoiceSectionName string, options *armeducation.LabsClientListOptions) (resp azfake.PagerResponder[armeducation.LabsClientListResponse])

	// NewListAllPager is the fake for method LabsClient.NewListAllPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllPager func(billingAccountName string, billingProfileName string, options *armeducation.LabsClientListAllOptions) (resp azfake.PagerResponder[armeducation.LabsClientListAllResponse])
}

// NewLabsServerTransport creates a new instance of LabsServerTransport with the provided implementation.
// The returned LabsServerTransport instance is connected to an instance of armeducation.LabsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLabsServerTransport(srv *LabsServer) *LabsServerTransport {
	return &LabsServerTransport{
		srv:             srv,
		newListPager:    newTracker[azfake.PagerResponder[armeducation.LabsClientListResponse]](),
		newListAllPager: newTracker[azfake.PagerResponder[armeducation.LabsClientListAllResponse]](),
	}
}

// LabsServerTransport connects instances of armeducation.LabsClient to instances of LabsServer.
// Don't use this type directly, use NewLabsServerTransport instead.
type LabsServerTransport struct {
	srv             *LabsServer
	newListPager    *tracker[azfake.PagerResponder[armeducation.LabsClientListResponse]]
	newListAllPager *tracker[azfake.PagerResponder[armeducation.LabsClientListAllResponse]]
}

// Do implements the policy.Transporter interface for LabsServerTransport.
func (l *LabsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LabsClient.CreateOrUpdate":
		resp, err = l.dispatchCreateOrUpdate(req)
	case "LabsClient.Delete":
		resp, err = l.dispatchDelete(req)
	case "LabsClient.GenerateInviteCode":
		resp, err = l.dispatchGenerateInviteCode(req)
	case "LabsClient.Get":
		resp, err = l.dispatchGet(req)
	case "LabsClient.NewListPager":
		resp, err = l.dispatchNewListPager(req)
	case "LabsClient.NewListAllPager":
		resp, err = l.dispatchNewListAllPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LabsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armeducation.LabDetails](req)
	if err != nil {
		return nil, err
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.CreateOrUpdate(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LabDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if l.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Delete(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchGenerateInviteCode(req *http.Request) (*http.Response, error) {
	if l.srv.GenerateInviteCode == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateInviteCode not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs/default/generateInviteCode`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	body, err := server.UnmarshalRequestAsJSON[armeducation.InviteCodeGenerateRequest](req)
	if err != nil {
		return nil, err
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
	if err != nil {
		return nil, err
	}
	onlyUpdateStudentCountParameterUnescaped, err := url.QueryUnescape(qp.Get("onlyUpdateStudentCountParameter"))
	if err != nil {
		return nil, err
	}
	onlyUpdateStudentCountParameterParam, err := parseOptional(onlyUpdateStudentCountParameterUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armeducation.LabsClientGenerateInviteCodeOptions
	if onlyUpdateStudentCountParameterParam != nil {
		options = &armeducation.LabsClientGenerateInviteCodeOptions{
			OnlyUpdateStudentCountParameter: onlyUpdateStudentCountParameterParam,
		}
	}
	respr, errRespr := l.srv.GenerateInviteCode(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LabDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
	if err != nil {
		return nil, err
	}
	includeBudgetUnescaped, err := url.QueryUnescape(qp.Get("includeBudget"))
	if err != nil {
		return nil, err
	}
	includeBudgetParam, err := parseOptional(includeBudgetUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armeducation.LabsClientGetOptions
	if includeBudgetParam != nil {
		options = &armeducation.LabsClientGetOptions{
			IncludeBudget: includeBudgetParam,
		}
	}
	respr, errRespr := l.srv.Get(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LabDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := l.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
		if err != nil {
			return nil, err
		}
		includeBudgetUnescaped, err := url.QueryUnescape(qp.Get("includeBudget"))
		if err != nil {
			return nil, err
		}
		includeBudgetParam, err := parseOptional(includeBudgetUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armeducation.LabsClientListOptions
		if includeBudgetParam != nil {
			options = &armeducation.LabsClientListOptions{
				IncludeBudget: includeBudgetParam,
			}
		}
		resp := l.srv.NewListPager(billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, options)
		newListPager = &resp
		l.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armeducation.LabsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		l.newListPager.remove(req)
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchNewListAllPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListAllPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllPager not implemented")}
	}
	newListAllPager := l.newListAllPager.get(req)
	if newListAllPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		includeBudgetUnescaped, err := url.QueryUnescape(qp.Get("includeBudget"))
		if err != nil {
			return nil, err
		}
		includeBudgetParam, err := parseOptional(includeBudgetUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		includeDeletedUnescaped, err := url.QueryUnescape(qp.Get("includeDeleted"))
		if err != nil {
			return nil, err
		}
		includeDeletedParam, err := parseOptional(includeDeletedUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armeducation.LabsClientListAllOptions
		if includeBudgetParam != nil || includeDeletedParam != nil {
			options = &armeducation.LabsClientListAllOptions{
				IncludeBudget:  includeBudgetParam,
				IncludeDeleted: includeDeletedParam,
			}
		}
		resp := l.srv.NewListAllPager(billingAccountNameParam, billingProfileNameParam, options)
		newListAllPager = &resp
		l.newListAllPager.add(req, newListAllPager)
		server.PagerResponderInjectNextLinks(newListAllPager, req, func(page *armeducation.LabsClientListAllResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAllPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListAllPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllPager) {
		l.newListAllPager.remove(req)
	}
	return resp, nil
}
