//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armedgeorder

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagementClient contains the methods for the EdgeOrderManagementClient group.
// Don't use this type directly, use NewManagementClient() instead.
type ManagementClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewManagementClient creates a new instance of ManagementClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewManagementClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagementClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ManagementClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CancelOrderItem - Cancel order item.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - orderItemName - The name of the order item
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - cancellationReason - Reason for cancellation.
//   - options - ManagementClientCancelOrderItemOptions contains the optional parameters for the ManagementClient.CancelOrderItem
//     method.
func (client *ManagementClient) CancelOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, cancellationReason CancellationReason, options *ManagementClientCancelOrderItemOptions) (ManagementClientCancelOrderItemResponse, error) {
	var err error
	const operationName = "ManagementClient.CancelOrderItem"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.cancelOrderItemCreateRequest(ctx, orderItemName, resourceGroupName, cancellationReason, options)
	if err != nil {
		return ManagementClientCancelOrderItemResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementClientCancelOrderItemResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ManagementClientCancelOrderItemResponse{}, err
	}
	return ManagementClientCancelOrderItemResponse{}, nil
}

// cancelOrderItemCreateRequest creates the CancelOrderItem request.
func (client *ManagementClient) cancelOrderItemCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, cancellationReason CancellationReason, options *ManagementClientCancelOrderItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}/cancel"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, cancellationReason); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginCreateAddress - Creates a new address with the specified parameters. Existing address can be updated with this API
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - addressName - The name of the address Resource within the specified resource group. address names must be between 3 and
//     24 characters in length and use any alphanumeric and underscore only
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - addressResource - Address details from request body.
//   - options - ManagementClientBeginCreateAddressOptions contains the optional parameters for the ManagementClient.BeginCreateAddress
//     method.
func (client *ManagementClient) BeginCreateAddress(ctx context.Context, addressName string, resourceGroupName string, addressResource AddressResource, options *ManagementClientBeginCreateAddressOptions) (*runtime.Poller[ManagementClientCreateAddressResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createAddress(ctx, addressName, resourceGroupName, addressResource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ManagementClientCreateAddressResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ManagementClientCreateAddressResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateAddress - Creates a new address with the specified parameters. Existing address can be updated with this API
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
func (client *ManagementClient) createAddress(ctx context.Context, addressName string, resourceGroupName string, addressResource AddressResource, options *ManagementClientBeginCreateAddressOptions) (*http.Response, error) {
	var err error
	const operationName = "ManagementClient.BeginCreateAddress"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createAddressCreateRequest(ctx, addressName, resourceGroupName, addressResource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createAddressCreateRequest creates the CreateAddress request.
func (client *ManagementClient) createAddressCreateRequest(ctx context.Context, addressName string, resourceGroupName string, addressResource AddressResource, options *ManagementClientBeginCreateAddressOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}"
	if addressName == "" {
		return nil, errors.New("parameter addressName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressName}", url.PathEscape(addressName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, addressResource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginCreateOrderItem - Creates an order item. Existing order item cannot be updated with this api and should instead be
// updated with the Update order item API.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - orderItemName - The name of the order item
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - orderItemResource - Order item details from request body.
//   - options - ManagementClientBeginCreateOrderItemOptions contains the optional parameters for the ManagementClient.BeginCreateOrderItem
//     method.
func (client *ManagementClient) BeginCreateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource OrderItemResource, options *ManagementClientBeginCreateOrderItemOptions) (*runtime.Poller[ManagementClientCreateOrderItemResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrderItem(ctx, orderItemName, resourceGroupName, orderItemResource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ManagementClientCreateOrderItemResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ManagementClientCreateOrderItemResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrderItem - Creates an order item. Existing order item cannot be updated with this api and should instead be updated
// with the Update order item API.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
func (client *ManagementClient) createOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource OrderItemResource, options *ManagementClientBeginCreateOrderItemOptions) (*http.Response, error) {
	var err error
	const operationName = "ManagementClient.BeginCreateOrderItem"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrderItemCreateRequest(ctx, orderItemName, resourceGroupName, orderItemResource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrderItemCreateRequest creates the CreateOrderItem request.
func (client *ManagementClient) createOrderItemCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource OrderItemResource, options *ManagementClientBeginCreateOrderItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, orderItemResource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDeleteAddressByName - Deletes an address.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - addressName - The name of the address Resource within the specified resource group. address names must be between 3 and
//     24 characters in length and use any alphanumeric and underscore only
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ManagementClientBeginDeleteAddressByNameOptions contains the optional parameters for the ManagementClient.BeginDeleteAddressByName
//     method.
func (client *ManagementClient) BeginDeleteAddressByName(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientBeginDeleteAddressByNameOptions) (*runtime.Poller[ManagementClientDeleteAddressByNameResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteAddressByName(ctx, addressName, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ManagementClientDeleteAddressByNameResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ManagementClientDeleteAddressByNameResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteAddressByName - Deletes an address.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
func (client *ManagementClient) deleteAddressByName(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientBeginDeleteAddressByNameOptions) (*http.Response, error) {
	var err error
	const operationName = "ManagementClient.BeginDeleteAddressByName"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAddressByNameCreateRequest(ctx, addressName, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteAddressByNameCreateRequest creates the DeleteAddressByName request.
func (client *ManagementClient) deleteAddressByNameCreateRequest(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientBeginDeleteAddressByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}"
	if addressName == "" {
		return nil, errors.New("parameter addressName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressName}", url.PathEscape(addressName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeleteOrderItemByName - Deletes an order item.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - orderItemName - The name of the order item
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ManagementClientBeginDeleteOrderItemByNameOptions contains the optional parameters for the ManagementClient.BeginDeleteOrderItemByName
//     method.
func (client *ManagementClient) BeginDeleteOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientBeginDeleteOrderItemByNameOptions) (*runtime.Poller[ManagementClientDeleteOrderItemByNameResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOrderItemByName(ctx, orderItemName, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ManagementClientDeleteOrderItemByNameResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ManagementClientDeleteOrderItemByNameResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteOrderItemByName - Deletes an order item.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
func (client *ManagementClient) deleteOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientBeginDeleteOrderItemByNameOptions) (*http.Response, error) {
	var err error
	const operationName = "ManagementClient.BeginDeleteOrderItemByName"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteOrderItemByNameCreateRequest(ctx, orderItemName, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteOrderItemByNameCreateRequest creates the DeleteOrderItemByName request.
func (client *ManagementClient) deleteOrderItemByNameCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientBeginDeleteOrderItemByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetAddressByName - Gets information about the specified address.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - addressName - The name of the address Resource within the specified resource group. address names must be between 3 and
//     24 characters in length and use any alphanumeric and underscore only
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ManagementClientGetAddressByNameOptions contains the optional parameters for the ManagementClient.GetAddressByName
//     method.
func (client *ManagementClient) GetAddressByName(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientGetAddressByNameOptions) (ManagementClientGetAddressByNameResponse, error) {
	var err error
	const operationName = "ManagementClient.GetAddressByName"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAddressByNameCreateRequest(ctx, addressName, resourceGroupName, options)
	if err != nil {
		return ManagementClientGetAddressByNameResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementClientGetAddressByNameResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementClientGetAddressByNameResponse{}, err
	}
	resp, err := client.getAddressByNameHandleResponse(httpResp)
	return resp, err
}

// getAddressByNameCreateRequest creates the GetAddressByName request.
func (client *ManagementClient) getAddressByNameCreateRequest(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientGetAddressByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}"
	if addressName == "" {
		return nil, errors.New("parameter addressName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressName}", url.PathEscape(addressName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAddressByNameHandleResponse handles the GetAddressByName response.
func (client *ManagementClient) getAddressByNameHandleResponse(resp *http.Response) (ManagementClientGetAddressByNameResponse, error) {
	result := ManagementClientGetAddressByNameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressResource); err != nil {
		return ManagementClientGetAddressByNameResponse{}, err
	}
	return result, nil
}

// GetOrderByName - Gets an order.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - orderName - The name of the order
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of Azure region.
//   - options - ManagementClientGetOrderByNameOptions contains the optional parameters for the ManagementClient.GetOrderByName
//     method.
func (client *ManagementClient) GetOrderByName(ctx context.Context, orderName string, resourceGroupName string, location string, options *ManagementClientGetOrderByNameOptions) (ManagementClientGetOrderByNameResponse, error) {
	var err error
	const operationName = "ManagementClient.GetOrderByName"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getOrderByNameCreateRequest(ctx, orderName, resourceGroupName, location, options)
	if err != nil {
		return ManagementClientGetOrderByNameResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementClientGetOrderByNameResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementClientGetOrderByNameResponse{}, err
	}
	resp, err := client.getOrderByNameHandleResponse(httpResp)
	return resp, err
}

// getOrderByNameCreateRequest creates the GetOrderByName request.
func (client *ManagementClient) getOrderByNameCreateRequest(ctx context.Context, orderName string, resourceGroupName string, location string, options *ManagementClientGetOrderByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/locations/{location}/orders/{orderName}"
	if orderName == "" {
		return nil, errors.New("parameter orderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderName}", url.PathEscape(orderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOrderByNameHandleResponse handles the GetOrderByName response.
func (client *ManagementClient) getOrderByNameHandleResponse(resp *http.Response) (ManagementClientGetOrderByNameResponse, error) {
	result := ManagementClientGetOrderByNameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderResource); err != nil {
		return ManagementClientGetOrderByNameResponse{}, err
	}
	return result, nil
}

// GetOrderItemByName - Gets an order item.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - orderItemName - The name of the order item
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ManagementClientGetOrderItemByNameOptions contains the optional parameters for the ManagementClient.GetOrderItemByName
//     method.
func (client *ManagementClient) GetOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientGetOrderItemByNameOptions) (ManagementClientGetOrderItemByNameResponse, error) {
	var err error
	const operationName = "ManagementClient.GetOrderItemByName"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getOrderItemByNameCreateRequest(ctx, orderItemName, resourceGroupName, options)
	if err != nil {
		return ManagementClientGetOrderItemByNameResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementClientGetOrderItemByNameResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementClientGetOrderItemByNameResponse{}, err
	}
	resp, err := client.getOrderItemByNameHandleResponse(httpResp)
	return resp, err
}

// getOrderItemByNameCreateRequest creates the GetOrderItemByName request.
func (client *ManagementClient) getOrderItemByNameCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientGetOrderItemByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOrderItemByNameHandleResponse handles the GetOrderItemByName response.
func (client *ManagementClient) getOrderItemByNameHandleResponse(resp *http.Response) (ManagementClientGetOrderItemByNameResponse, error) {
	result := ManagementClientGetOrderItemByNameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderItemResource); err != nil {
		return ManagementClientGetOrderItemByNameResponse{}, err
	}
	return result, nil
}

// NewListAddressesAtResourceGroupLevelPager - Lists all the addresses available under the given resource group.
//
// Generated from API version 2021-12-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ManagementClientListAddressesAtResourceGroupLevelOptions contains the optional parameters for the ManagementClient.NewListAddressesAtResourceGroupLevelPager
//     method.
func (client *ManagementClient) NewListAddressesAtResourceGroupLevelPager(resourceGroupName string, options *ManagementClientListAddressesAtResourceGroupLevelOptions) *runtime.Pager[ManagementClientListAddressesAtResourceGroupLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListAddressesAtResourceGroupLevelResponse]{
		More: func(page ManagementClientListAddressesAtResourceGroupLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListAddressesAtResourceGroupLevelResponse) (ManagementClientListAddressesAtResourceGroupLevelResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListAddressesAtResourceGroupLevelPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAddressesAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return ManagementClientListAddressesAtResourceGroupLevelResponse{}, err
			}
			return client.listAddressesAtResourceGroupLevelHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAddressesAtResourceGroupLevelCreateRequest creates the ListAddressesAtResourceGroupLevel request.
func (client *ManagementClient) listAddressesAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, options *ManagementClientListAddressesAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAddressesAtResourceGroupLevelHandleResponse handles the ListAddressesAtResourceGroupLevel response.
func (client *ManagementClient) listAddressesAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementClientListAddressesAtResourceGroupLevelResponse, error) {
	result := ManagementClientListAddressesAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressResourceList); err != nil {
		return ManagementClientListAddressesAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// NewListAddressesAtSubscriptionLevelPager - Lists all the addresses available under the subscription.
//
// Generated from API version 2021-12-01
//   - options - ManagementClientListAddressesAtSubscriptionLevelOptions contains the optional parameters for the ManagementClient.NewListAddressesAtSubscriptionLevelPager
//     method.
func (client *ManagementClient) NewListAddressesAtSubscriptionLevelPager(options *ManagementClientListAddressesAtSubscriptionLevelOptions) *runtime.Pager[ManagementClientListAddressesAtSubscriptionLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListAddressesAtSubscriptionLevelResponse]{
		More: func(page ManagementClientListAddressesAtSubscriptionLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListAddressesAtSubscriptionLevelResponse) (ManagementClientListAddressesAtSubscriptionLevelResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListAddressesAtSubscriptionLevelPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAddressesAtSubscriptionLevelCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ManagementClientListAddressesAtSubscriptionLevelResponse{}, err
			}
			return client.listAddressesAtSubscriptionLevelHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAddressesAtSubscriptionLevelCreateRequest creates the ListAddressesAtSubscriptionLevel request.
func (client *ManagementClient) listAddressesAtSubscriptionLevelCreateRequest(ctx context.Context, options *ManagementClientListAddressesAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/addresses"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAddressesAtSubscriptionLevelHandleResponse handles the ListAddressesAtSubscriptionLevel response.
func (client *ManagementClient) listAddressesAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementClientListAddressesAtSubscriptionLevelResponse, error) {
	result := ManagementClientListAddressesAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressResourceList); err != nil {
		return ManagementClientListAddressesAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// NewListConfigurationsPager - This method provides the list of configurations for the given product family, product line
// and product under subscription.
//
// Generated from API version 2021-12-01
//   - configurationsRequest - Filters for showing the configurations.
//   - options - ManagementClientListConfigurationsOptions contains the optional parameters for the ManagementClient.NewListConfigurationsPager
//     method.
func (client *ManagementClient) NewListConfigurationsPager(configurationsRequest ConfigurationsRequest, options *ManagementClientListConfigurationsOptions) *runtime.Pager[ManagementClientListConfigurationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListConfigurationsResponse]{
		More: func(page ManagementClientListConfigurationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListConfigurationsResponse) (ManagementClientListConfigurationsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListConfigurationsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listConfigurationsCreateRequest(ctx, configurationsRequest, options)
			}, nil)
			if err != nil {
				return ManagementClientListConfigurationsResponse{}, err
			}
			return client.listConfigurationsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listConfigurationsCreateRequest creates the ListConfigurations request.
func (client *ManagementClient) listConfigurationsCreateRequest(ctx context.Context, configurationsRequest ConfigurationsRequest, options *ManagementClientListConfigurationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/listConfigurations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, configurationsRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// listConfigurationsHandleResponse handles the ListConfigurations response.
func (client *ManagementClient) listConfigurationsHandleResponse(resp *http.Response) (ManagementClientListConfigurationsResponse, error) {
	result := ManagementClientListConfigurationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Configurations); err != nil {
		return ManagementClientListConfigurationsResponse{}, err
	}
	return result, nil
}

// NewListOperationsPager - This method gets all the operations that are exposed for customer.
//
// Generated from API version 2021-12-01
//   - options - ManagementClientListOperationsOptions contains the optional parameters for the ManagementClient.NewListOperationsPager
//     method.
func (client *ManagementClient) NewListOperationsPager(options *ManagementClientListOperationsOptions) *runtime.Pager[ManagementClientListOperationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOperationsResponse]{
		More: func(page ManagementClientListOperationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOperationsResponse) (ManagementClientListOperationsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListOperationsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listOperationsCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ManagementClientListOperationsResponse{}, err
			}
			return client.listOperationsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listOperationsCreateRequest creates the ListOperations request.
func (client *ManagementClient) listOperationsCreateRequest(ctx context.Context, options *ManagementClientListOperationsOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.EdgeOrder/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOperationsHandleResponse handles the ListOperations response.
func (client *ManagementClient) listOperationsHandleResponse(resp *http.Response) (ManagementClientListOperationsResponse, error) {
	result := ManagementClientListOperationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationListResult); err != nil {
		return ManagementClientListOperationsResponse{}, err
	}
	return result, nil
}

// NewListOrderAtResourceGroupLevelPager - Lists order at resource group level.
//
// Generated from API version 2021-12-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ManagementClientListOrderAtResourceGroupLevelOptions contains the optional parameters for the ManagementClient.NewListOrderAtResourceGroupLevelPager
//     method.
func (client *ManagementClient) NewListOrderAtResourceGroupLevelPager(resourceGroupName string, options *ManagementClientListOrderAtResourceGroupLevelOptions) *runtime.Pager[ManagementClientListOrderAtResourceGroupLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOrderAtResourceGroupLevelResponse]{
		More: func(page ManagementClientListOrderAtResourceGroupLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOrderAtResourceGroupLevelResponse) (ManagementClientListOrderAtResourceGroupLevelResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListOrderAtResourceGroupLevelPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listOrderAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return ManagementClientListOrderAtResourceGroupLevelResponse{}, err
			}
			return client.listOrderAtResourceGroupLevelHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listOrderAtResourceGroupLevelCreateRequest creates the ListOrderAtResourceGroupLevel request.
func (client *ManagementClient) listOrderAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, options *ManagementClientListOrderAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orders"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOrderAtResourceGroupLevelHandleResponse handles the ListOrderAtResourceGroupLevel response.
func (client *ManagementClient) listOrderAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementClientListOrderAtResourceGroupLevelResponse, error) {
	result := ManagementClientListOrderAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderResourceList); err != nil {
		return ManagementClientListOrderAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// NewListOrderAtSubscriptionLevelPager - Lists order at subscription level.
//
// Generated from API version 2021-12-01
//   - options - ManagementClientListOrderAtSubscriptionLevelOptions contains the optional parameters for the ManagementClient.NewListOrderAtSubscriptionLevelPager
//     method.
func (client *ManagementClient) NewListOrderAtSubscriptionLevelPager(options *ManagementClientListOrderAtSubscriptionLevelOptions) *runtime.Pager[ManagementClientListOrderAtSubscriptionLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOrderAtSubscriptionLevelResponse]{
		More: func(page ManagementClientListOrderAtSubscriptionLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOrderAtSubscriptionLevelResponse) (ManagementClientListOrderAtSubscriptionLevelResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListOrderAtSubscriptionLevelPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listOrderAtSubscriptionLevelCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ManagementClientListOrderAtSubscriptionLevelResponse{}, err
			}
			return client.listOrderAtSubscriptionLevelHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listOrderAtSubscriptionLevelCreateRequest creates the ListOrderAtSubscriptionLevel request.
func (client *ManagementClient) listOrderAtSubscriptionLevelCreateRequest(ctx context.Context, options *ManagementClientListOrderAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/orders"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOrderAtSubscriptionLevelHandleResponse handles the ListOrderAtSubscriptionLevel response.
func (client *ManagementClient) listOrderAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementClientListOrderAtSubscriptionLevelResponse, error) {
	result := ManagementClientListOrderAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderResourceList); err != nil {
		return ManagementClientListOrderAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// NewListOrderItemsAtResourceGroupLevelPager - Lists order item at resource group level.
//
// Generated from API version 2021-12-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ManagementClientListOrderItemsAtResourceGroupLevelOptions contains the optional parameters for the ManagementClient.NewListOrderItemsAtResourceGroupLevelPager
//     method.
func (client *ManagementClient) NewListOrderItemsAtResourceGroupLevelPager(resourceGroupName string, options *ManagementClientListOrderItemsAtResourceGroupLevelOptions) *runtime.Pager[ManagementClientListOrderItemsAtResourceGroupLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOrderItemsAtResourceGroupLevelResponse]{
		More: func(page ManagementClientListOrderItemsAtResourceGroupLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOrderItemsAtResourceGroupLevelResponse) (ManagementClientListOrderItemsAtResourceGroupLevelResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListOrderItemsAtResourceGroupLevelPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listOrderItemsAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return ManagementClientListOrderItemsAtResourceGroupLevelResponse{}, err
			}
			return client.listOrderItemsAtResourceGroupLevelHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listOrderItemsAtResourceGroupLevelCreateRequest creates the ListOrderItemsAtResourceGroupLevel request.
func (client *ManagementClient) listOrderItemsAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, options *ManagementClientListOrderItemsAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOrderItemsAtResourceGroupLevelHandleResponse handles the ListOrderItemsAtResourceGroupLevel response.
func (client *ManagementClient) listOrderItemsAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementClientListOrderItemsAtResourceGroupLevelResponse, error) {
	result := ManagementClientListOrderItemsAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderItemResourceList); err != nil {
		return ManagementClientListOrderItemsAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// NewListOrderItemsAtSubscriptionLevelPager - Lists order item at subscription level.
//
// Generated from API version 2021-12-01
//   - options - ManagementClientListOrderItemsAtSubscriptionLevelOptions contains the optional parameters for the ManagementClient.NewListOrderItemsAtSubscriptionLevelPager
//     method.
func (client *ManagementClient) NewListOrderItemsAtSubscriptionLevelPager(options *ManagementClientListOrderItemsAtSubscriptionLevelOptions) *runtime.Pager[ManagementClientListOrderItemsAtSubscriptionLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOrderItemsAtSubscriptionLevelResponse]{
		More: func(page ManagementClientListOrderItemsAtSubscriptionLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOrderItemsAtSubscriptionLevelResponse) (ManagementClientListOrderItemsAtSubscriptionLevelResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListOrderItemsAtSubscriptionLevelPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listOrderItemsAtSubscriptionLevelCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ManagementClientListOrderItemsAtSubscriptionLevelResponse{}, err
			}
			return client.listOrderItemsAtSubscriptionLevelHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listOrderItemsAtSubscriptionLevelCreateRequest creates the ListOrderItemsAtSubscriptionLevel request.
func (client *ManagementClient) listOrderItemsAtSubscriptionLevelCreateRequest(ctx context.Context, options *ManagementClientListOrderItemsAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/orderItems"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOrderItemsAtSubscriptionLevelHandleResponse handles the ListOrderItemsAtSubscriptionLevel response.
func (client *ManagementClient) listOrderItemsAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementClientListOrderItemsAtSubscriptionLevelResponse, error) {
	result := ManagementClientListOrderItemsAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderItemResourceList); err != nil {
		return ManagementClientListOrderItemsAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// NewListProductFamiliesPager - This method provides the list of product families for the given subscription.
//
// Generated from API version 2021-12-01
//   - productFamiliesRequest - Filters for showing the product families.
//   - options - ManagementClientListProductFamiliesOptions contains the optional parameters for the ManagementClient.NewListProductFamiliesPager
//     method.
func (client *ManagementClient) NewListProductFamiliesPager(productFamiliesRequest ProductFamiliesRequest, options *ManagementClientListProductFamiliesOptions) *runtime.Pager[ManagementClientListProductFamiliesResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListProductFamiliesResponse]{
		More: func(page ManagementClientListProductFamiliesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListProductFamiliesResponse) (ManagementClientListProductFamiliesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListProductFamiliesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listProductFamiliesCreateRequest(ctx, productFamiliesRequest, options)
			}, nil)
			if err != nil {
				return ManagementClientListProductFamiliesResponse{}, err
			}
			return client.listProductFamiliesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listProductFamiliesCreateRequest creates the ListProductFamilies request.
func (client *ManagementClient) listProductFamiliesCreateRequest(ctx context.Context, productFamiliesRequest ProductFamiliesRequest, options *ManagementClientListProductFamiliesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/listProductFamilies"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, productFamiliesRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// listProductFamiliesHandleResponse handles the ListProductFamilies response.
func (client *ManagementClient) listProductFamiliesHandleResponse(resp *http.Response) (ManagementClientListProductFamiliesResponse, error) {
	result := ManagementClientListProductFamiliesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProductFamilies); err != nil {
		return ManagementClientListProductFamiliesResponse{}, err
	}
	return result, nil
}

// NewListProductFamiliesMetadataPager - This method provides the list of product families metadata for the given subscription.
//
// Generated from API version 2021-12-01
//   - options - ManagementClientListProductFamiliesMetadataOptions contains the optional parameters for the ManagementClient.NewListProductFamiliesMetadataPager
//     method.
func (client *ManagementClient) NewListProductFamiliesMetadataPager(options *ManagementClientListProductFamiliesMetadataOptions) *runtime.Pager[ManagementClientListProductFamiliesMetadataResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListProductFamiliesMetadataResponse]{
		More: func(page ManagementClientListProductFamiliesMetadataResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListProductFamiliesMetadataResponse) (ManagementClientListProductFamiliesMetadataResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementClient.NewListProductFamiliesMetadataPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listProductFamiliesMetadataCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ManagementClientListProductFamiliesMetadataResponse{}, err
			}
			return client.listProductFamiliesMetadataHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listProductFamiliesMetadataCreateRequest creates the ListProductFamiliesMetadata request.
func (client *ManagementClient) listProductFamiliesMetadataCreateRequest(ctx context.Context, options *ManagementClientListProductFamiliesMetadataOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/productFamiliesMetadata"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listProductFamiliesMetadataHandleResponse handles the ListProductFamiliesMetadata response.
func (client *ManagementClient) listProductFamiliesMetadataHandleResponse(resp *http.Response) (ManagementClientListProductFamiliesMetadataResponse, error) {
	result := ManagementClientListProductFamiliesMetadataResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProductFamiliesMetadata); err != nil {
		return ManagementClientListProductFamiliesMetadataResponse{}, err
	}
	return result, nil
}

// BeginReturnOrderItem - Return order item.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - orderItemName - The name of the order item
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - returnOrderItemDetails - Return order item CurrentStatus.
//   - options - ManagementClientBeginReturnOrderItemOptions contains the optional parameters for the ManagementClient.BeginReturnOrderItem
//     method.
func (client *ManagementClient) BeginReturnOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails ReturnOrderItemDetails, options *ManagementClientBeginReturnOrderItemOptions) (*runtime.Poller[ManagementClientReturnOrderItemResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.returnOrderItem(ctx, orderItemName, resourceGroupName, returnOrderItemDetails, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ManagementClientReturnOrderItemResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ManagementClientReturnOrderItemResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// ReturnOrderItem - Return order item.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
func (client *ManagementClient) returnOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails ReturnOrderItemDetails, options *ManagementClientBeginReturnOrderItemOptions) (*http.Response, error) {
	var err error
	const operationName = "ManagementClient.BeginReturnOrderItem"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.returnOrderItemCreateRequest(ctx, orderItemName, resourceGroupName, returnOrderItemDetails, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// returnOrderItemCreateRequest creates the ReturnOrderItem request.
func (client *ManagementClient) returnOrderItemCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails ReturnOrderItemDetails, options *ManagementClientBeginReturnOrderItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}/return"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, returnOrderItemDetails); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginUpdateAddress - Updates the properties of an existing address.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - addressName - The name of the address Resource within the specified resource group. address names must be between 3 and
//     24 characters in length and use any alphanumeric and underscore only
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - addressUpdateParameter - Address update parameters from request body.
//   - options - ManagementClientBeginUpdateAddressOptions contains the optional parameters for the ManagementClient.BeginUpdateAddress
//     method.
func (client *ManagementClient) BeginUpdateAddress(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter AddressUpdateParameter, options *ManagementClientBeginUpdateAddressOptions) (*runtime.Poller[ManagementClientUpdateAddressResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateAddress(ctx, addressName, resourceGroupName, addressUpdateParameter, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ManagementClientUpdateAddressResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ManagementClientUpdateAddressResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateAddress - Updates the properties of an existing address.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
func (client *ManagementClient) updateAddress(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter AddressUpdateParameter, options *ManagementClientBeginUpdateAddressOptions) (*http.Response, error) {
	var err error
	const operationName = "ManagementClient.BeginUpdateAddress"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateAddressCreateRequest(ctx, addressName, resourceGroupName, addressUpdateParameter, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateAddressCreateRequest creates the UpdateAddress request.
func (client *ManagementClient) updateAddressCreateRequest(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter AddressUpdateParameter, options *ManagementClientBeginUpdateAddressOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}"
	if addressName == "" {
		return nil, errors.New("parameter addressName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressName}", url.PathEscape(addressName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, addressUpdateParameter); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginUpdateOrderItem - Updates the properties of an existing order item.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - orderItemName - The name of the order item
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - orderItemUpdateParameter - order item update parameters from request body.
//   - options - ManagementClientBeginUpdateOrderItemOptions contains the optional parameters for the ManagementClient.BeginUpdateOrderItem
//     method.
func (client *ManagementClient) BeginUpdateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter OrderItemUpdateParameter, options *ManagementClientBeginUpdateOrderItemOptions) (*runtime.Poller[ManagementClientUpdateOrderItemResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateOrderItem(ctx, orderItemName, resourceGroupName, orderItemUpdateParameter, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ManagementClientUpdateOrderItemResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ManagementClientUpdateOrderItemResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateOrderItem - Updates the properties of an existing order item.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
func (client *ManagementClient) updateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter OrderItemUpdateParameter, options *ManagementClientBeginUpdateOrderItemOptions) (*http.Response, error) {
	var err error
	const operationName = "ManagementClient.BeginUpdateOrderItem"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateOrderItemCreateRequest(ctx, orderItemName, resourceGroupName, orderItemUpdateParameter, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateOrderItemCreateRequest creates the UpdateOrderItem request.
func (client *ManagementClient) updateOrderItemCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter OrderItemUpdateParameter, options *ManagementClientBeginUpdateOrderItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, orderItemUpdateParameter); err != nil {
		return nil, err
	}
	return req, nil
}
