//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dnsresolver/armdnsresolver"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// OutboundEndpointsServer is a fake server for instances of the armdnsresolver.OutboundEndpointsClient type.
type OutboundEndpointsServer struct {
	// BeginCreateOrUpdate is the fake for method OutboundEndpointsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, dnsResolverName string, outboundEndpointName string, parameters armdnsresolver.OutboundEndpoint, options *armdnsresolver.OutboundEndpointsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdnsresolver.OutboundEndpointsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method OutboundEndpointsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, dnsResolverName string, outboundEndpointName string, options *armdnsresolver.OutboundEndpointsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdnsresolver.OutboundEndpointsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method OutboundEndpointsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, dnsResolverName string, outboundEndpointName string, options *armdnsresolver.OutboundEndpointsClientGetOptions) (resp azfake.Responder[armdnsresolver.OutboundEndpointsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method OutboundEndpointsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, dnsResolverName string, options *armdnsresolver.OutboundEndpointsClientListOptions) (resp azfake.PagerResponder[armdnsresolver.OutboundEndpointsClientListResponse])

	// BeginUpdate is the fake for method OutboundEndpointsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, dnsResolverName string, outboundEndpointName string, parameters armdnsresolver.OutboundEndpointPatch, options *armdnsresolver.OutboundEndpointsClientBeginUpdateOptions) (resp azfake.PollerResponder[armdnsresolver.OutboundEndpointsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewOutboundEndpointsServerTransport creates a new instance of OutboundEndpointsServerTransport with the provided implementation.
// The returned OutboundEndpointsServerTransport instance is connected to an instance of armdnsresolver.OutboundEndpointsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOutboundEndpointsServerTransport(srv *OutboundEndpointsServer) *OutboundEndpointsServerTransport {
	return &OutboundEndpointsServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armdnsresolver.OutboundEndpointsClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armdnsresolver.OutboundEndpointsClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armdnsresolver.OutboundEndpointsClientListResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armdnsresolver.OutboundEndpointsClientUpdateResponse]](),
	}
}

// OutboundEndpointsServerTransport connects instances of armdnsresolver.OutboundEndpointsClient to instances of OutboundEndpointsServer.
// Don't use this type directly, use NewOutboundEndpointsServerTransport instead.
type OutboundEndpointsServerTransport struct {
	srv                 *OutboundEndpointsServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armdnsresolver.OutboundEndpointsClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armdnsresolver.OutboundEndpointsClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armdnsresolver.OutboundEndpointsClientListResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armdnsresolver.OutboundEndpointsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for OutboundEndpointsServerTransport.
func (o *OutboundEndpointsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OutboundEndpointsClient.BeginCreateOrUpdate":
		resp, err = o.dispatchBeginCreateOrUpdate(req)
	case "OutboundEndpointsClient.BeginDelete":
		resp, err = o.dispatchBeginDelete(req)
	case "OutboundEndpointsClient.Get":
		resp, err = o.dispatchGet(req)
	case "OutboundEndpointsClient.NewListPager":
		resp, err = o.dispatchNewListPager(req)
	case "OutboundEndpointsClient.BeginUpdate":
		resp, err = o.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OutboundEndpointsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if o.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := o.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundEndpoints/(?P<outboundEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdnsresolver.OutboundEndpoint](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
		if err != nil {
			return nil, err
		}
		outboundEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("outboundEndpointName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
		var options *armdnsresolver.OutboundEndpointsClientBeginCreateOrUpdateOptions
		if ifMatchParam != nil || ifNoneMatchParam != nil {
			options = &armdnsresolver.OutboundEndpointsClientBeginCreateOrUpdateOptions{
				IfMatch:     ifMatchParam,
				IfNoneMatch: ifNoneMatchParam,
			}
		}
		respr, errRespr := o.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, dnsResolverNameParam, outboundEndpointNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		o.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		o.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		o.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (o *OutboundEndpointsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if o.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := o.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundEndpoints/(?P<outboundEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
		if err != nil {
			return nil, err
		}
		outboundEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("outboundEndpointName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armdnsresolver.OutboundEndpointsClientBeginDeleteOptions
		if ifMatchParam != nil {
			options = &armdnsresolver.OutboundEndpointsClientBeginDeleteOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := o.srv.BeginDelete(req.Context(), resourceGroupNameParam, dnsResolverNameParam, outboundEndpointNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		o.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		o.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		o.beginDelete.remove(req)
	}

	return resp, nil
}

func (o *OutboundEndpointsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if o.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundEndpoints/(?P<outboundEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
	if err != nil {
		return nil, err
	}
	outboundEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("outboundEndpointName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.Get(req.Context(), resourceGroupNameParam, dnsResolverNameParam, outboundEndpointNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OutboundEndpoint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (o *OutboundEndpointsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if o.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := o.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundEndpoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdnsresolver.OutboundEndpointsClientListOptions
		if topParam != nil {
			options = &armdnsresolver.OutboundEndpointsClientListOptions{
				Top: topParam,
			}
		}
		resp := o.srv.NewListPager(resourceGroupNameParam, dnsResolverNameParam, options)
		newListPager = &resp
		o.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdnsresolver.OutboundEndpointsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		o.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		o.newListPager.remove(req)
	}
	return resp, nil
}

func (o *OutboundEndpointsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if o.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := o.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundEndpoints/(?P<outboundEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdnsresolver.OutboundEndpointPatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
		if err != nil {
			return nil, err
		}
		outboundEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("outboundEndpointName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armdnsresolver.OutboundEndpointsClientBeginUpdateOptions
		if ifMatchParam != nil {
			options = &armdnsresolver.OutboundEndpointsClientBeginUpdateOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := o.srv.BeginUpdate(req.Context(), resourceGroupNameParam, dnsResolverNameParam, outboundEndpointNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		o.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		o.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		o.beginUpdate.remove(req)
	}

	return resp, nil
}
