//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdigitaltwins_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/digitaltwins/armdigitaltwins"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsGet_example.json
func ExampleClient_Get_getADigitalTwinsInstanceResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Get(ctx, "resRg", "myDigitalTwinsService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("d2baee3d-44c0-41b6-9961-92563de66a97"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeApplication),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsGet_WithPrivateEndpointConnection_example.json
func ExampleClient_Get_getADigitalTwinsInstanceResourceWithAPrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Get(ctx, "resRg", "myDigitalTwinsService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("d2baee3d-44c0-41b6-9961-92563de66a97"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeApplication),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		PrivateEndpointConnections: []*armdigitaltwins.PrivateEndpointConnection{
	// 			{
	// 				ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService/privateEndpointConnections/myPrivateConnection"),
	// 				Properties: &armdigitaltwins.ConnectionProperties{
	// 					GroupIDs: []*string{
	// 						to.Ptr("digitalTwinsInstance")},
	// 						PrivateEndpoint: &armdigitaltwins.PrivateEndpoint{
	// 							ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/resRg/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
	// 						},
	// 						PrivateLinkServiceConnectionState: &armdigitaltwins.ConnectionPropertiesPrivateLinkServiceConnectionState{
	// 							Description: to.Ptr("Please approve my request, thanks."),
	// 							ActionsRequired: to.Ptr("None"),
	// 							Status: to.Ptr(armdigitaltwins.PrivateLinkServiceConnectionStatusPending),
	// 						},
	// 					},
	// 			}},
	// 			ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 			PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsGet_WithIdentity_example.json
func ExampleClient_Get_getADigitalTwinsInstanceResourceWithIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Get(ctx, "resRg", "myDigitalTwinsService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Identity: &armdigitaltwins.Identity{
	// 		Type: to.Ptr(armdigitaltwins.DigitalTwinsIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("544215a9-21d8-4fb5-8094-8efbcc311dd0"),
	// 		TenantID: to.Ptr("544215a9-21d8-4fb5-8094-8efbcc311dd0"),
	// 		UserAssignedIdentities: map[string]*armdigitaltwins.UserAssignedIdentity{
	// 			"/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity": &armdigitaltwins.UserAssignedIdentity{
	// 				ClientID: to.Ptr("544215a9-21d8-4fb5-8094-8efbcc311dd0"),
	// 				PrincipalID: to.Ptr("50016170-c839-41ba-a724-51e9df440b9e"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("d2baee3d-44c0-41b6-9961-92563de66a97"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeApplication),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsPut_example.json
func ExampleClient_BeginCreateOrUpdate_putADigitalTwinsInstanceResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdate(ctx, "resRg", "myDigitalTwinsService", armdigitaltwins.Description{
		Location: to.Ptr("WestUS2"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:15:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 		"purpose": to.Ptr("dev"),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsPut_WithIdentity_example.json
func ExampleClient_BeginCreateOrUpdate_putADigitalTwinsInstanceResourceWithIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdate(ctx, "resRg", "myDigitalTwinsService", armdigitaltwins.Description{
		Identity: &armdigitaltwins.Identity{
			Type: to.Ptr(armdigitaltwins.DigitalTwinsIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armdigitaltwins.UserAssignedIdentity{
				"/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity": {},
			},
		},
		Location: to.Ptr("WestUS2"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Identity: &armdigitaltwins.Identity{
	// 		Type: to.Ptr(armdigitaltwins.DigitalTwinsIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("544215a9-21d8-4fb5-8094-8efbcc311dd0"),
	// 		TenantID: to.Ptr("544215a9-21d8-4fb5-8094-8efbcc311dd0"),
	// 		UserAssignedIdentities: map[string]*armdigitaltwins.UserAssignedIdentity{
	// 			"/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourceGroups/testrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testidentity": &armdigitaltwins.UserAssignedIdentity{
	// 				ClientID: to.Ptr("544215a9-21d8-4fb5-8094-8efbcc311dd0"),
	// 				PrincipalID: to.Ptr("50016170-c839-41ba-a724-51e9df440b9e"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:15:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 		"purpose": to.Ptr("dev"),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsPut_WithPublicNetworkAccess.json
func ExampleClient_BeginCreateOrUpdate_putADigitalTwinsInstanceResourceWithPublicNetworkAccessProperty() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdate(ctx, "resRg", "myDigitalTwinsService", armdigitaltwins.Description{
		Location: to.Ptr("WestUS2"),
		Properties: &armdigitaltwins.Properties{
			PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:15:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsPatch_example.json
func ExampleClient_BeginUpdate_patchADigitalTwinsInstanceResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginUpdate(ctx, "resRg", "myDigitalTwinsService", armdigitaltwins.PatchDescription{
		Tags: map[string]*string{
			"purpose": to.Ptr("dev"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:15:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 		"purpose": to.Ptr("dev"),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessDisabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsPatch_WithIdentity_example.json
func ExampleClient_BeginUpdate_patchADigitalTwinsInstanceResourceWithIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginUpdate(ctx, "resRg", "myDigitalTwinsService", armdigitaltwins.PatchDescription{
		Identity: &armdigitaltwins.Identity{
			Type: to.Ptr(armdigitaltwins.DigitalTwinsIdentityTypeNone),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:15:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 		"purpose": to.Ptr("dev"),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsPatch_WithPublicNetworkAccess.json
func ExampleClient_BeginUpdate_patchADigitalTwinsInstanceResourceWithPublicNetworkAccessProperty() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginUpdate(ctx, "resRg", "myDigitalTwinsService", armdigitaltwins.PatchDescription{
		Properties: &armdigitaltwins.PatchProperties{
			PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessDisabled),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:15:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 		"purpose": to.Ptr("dev"),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 		PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessDisabled),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsDelete_example.json
func ExampleClient_BeginDelete_deleteADigitalTwinsInstanceResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginDelete(ctx, "resRg", "myDigitalTwinsService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsDelete_WithIdentity_example.json
func ExampleClient_BeginDelete_deleteADigitalTwinsInstanceResourceWithIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginDelete(ctx, "resRg", "myDigitalTwinsService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Description = armdigitaltwins.Description{
	// 	Name: to.Ptr("myDigitalTwinsService"),
	// 	Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	// 	ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
	// 	Identity: &armdigitaltwins.Identity{
	// 		Type: to.Ptr(armdigitaltwins.DigitalTwinsIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("544215a9-21d8-4fb5-8094-8efbcc311dd0"),
	// 		TenantID: to.Ptr("544215a9-21d8-4fb5-8094-8efbcc311dd0"),
	// 	},
	// 	Location: to.Ptr("westus2"),
	// 	SystemData: &armdigitaltwins.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@example.com"),
	// 		CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@example.com"),
	// 		LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdigitaltwins.Properties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
	// 		HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-06T12:21:58.610Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsList_example.json
func ExampleClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DescriptionListResult = armdigitaltwins.DescriptionListResult{
		// 	Value: []*armdigitaltwins.Description{
		// 		{
		// 			Name: to.Ptr("myDigitalTwinsService"),
		// 			Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
		// 			ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
		// 			Location: to.Ptr("westus2"),
		// 			SystemData: &armdigitaltwins.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@example.com"),
		// 				CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("d2baee3d-44c0-41b6-9961-92563de66a97"),
		// 				LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeApplication),
		// 			},
		// 			Properties: &armdigitaltwins.Properties{
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
		// 				HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
		// 				LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:07.229Z"); return t}()),
		// 				ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myDigitalTwinsService2"),
		// 			Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
		// 			ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg2/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService2"),
		// 			Location: to.Ptr("westus2"),
		// 			SystemData: &armdigitaltwins.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:59.403Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@example.com"),
		// 				CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:15:02.528Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("429f7e65-6d99-455e-a469-7a885be68642"),
		// 				LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeApplication),
		// 			},
		// 			Properties: &armdigitaltwins.Properties{
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
		// 				LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:07.229Z"); return t}()),
		// 				ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsListByResourceGroup_example.json
func ExampleClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListByResourceGroupPager("resRg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DescriptionListResult = armdigitaltwins.DescriptionListResult{
		// 	Value: []*armdigitaltwins.Description{
		// 		{
		// 			Name: to.Ptr("myDigitalTwinsService"),
		// 			Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
		// 			ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService"),
		// 			Location: to.Ptr("westus2"),
		// 			SystemData: &armdigitaltwins.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:13:59.403Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@example.com"),
		// 				CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:02.528Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("d2baee3d-44c0-41b6-9961-92563de66a97"),
		// 				LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeApplication),
		// 			},
		// 			Properties: &armdigitaltwins.Properties{
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:05.229Z"); return t}()),
		// 				HostName: to.Ptr("https://myDigitalTwinsService.api.wus2.ss.azuredigitaltwins-test.net"),
		// 				LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:51:05.229Z"); return t}()),
		// 				ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myDigitalTwinsService2"),
		// 			Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
		// 			ID: to.Ptr("/subscriptions/50016170-c839-41ba-a724-51e9df440b9e/resourcegroups/resRg/providers/Microsoft.DigitalTwins/digitalTwinsInstances/myDigitalTwinsService2"),
		// 			Location: to.Ptr("westus2"),
		// 			SystemData: &armdigitaltwins.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:14:59.403Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@example.com"),
		// 				CreatedByType: to.Ptr(armdigitaltwins.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T17:15:02.528Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("429f7e65-6d99-455e-a469-7a885be68642"),
		// 				LastModifiedByType: to.Ptr(armdigitaltwins.CreatedByTypeApplication),
		// 			},
		// 			Properties: &armdigitaltwins.Properties{
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:07.229Z"); return t}()),
		// 				LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-11-19T12:55:07.229Z"); return t}()),
		// 				ProvisioningState: to.Ptr(armdigitaltwins.ProvisioningStateSucceeded),
		// 				PublicNetworkAccess: to.Ptr(armdigitaltwins.PublicNetworkAccessEnabled),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a60468a0c5e2beb054680ae488fb9f92699f0a0d/specification/digitaltwins/resource-manager/Microsoft.DigitalTwins/stable/2023-01-31/examples/DigitalTwinsCheckNameAvailability_example.json
func ExampleClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdigitaltwins.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().CheckNameAvailability(ctx, "WestUS2", armdigitaltwins.CheckNameRequest{
		Name: to.Ptr("myadtinstance"),
		Type: to.Ptr("Microsoft.DigitalTwins/digitalTwinsInstances"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameResult = armdigitaltwins.CheckNameResult{
	// 	Message: to.Ptr("Name 'myadtinstance' is already taken. Please specify a different name"),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr(armdigitaltwins.ReasonAlreadyExists),
	// }
}
