//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/deviceprovisioningservices/armdeviceprovisioningservices"
	"net/http"
	"net/url"
	"regexp"
)

// IotDpsResourceServer is a fake server for instances of the armdeviceprovisioningservices.IotDpsResourceClient type.
type IotDpsResourceServer struct {
	// CheckProvisioningServiceNameAvailability is the fake for method IotDpsResourceClient.CheckProvisioningServiceNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckProvisioningServiceNameAvailability func(ctx context.Context, arguments armdeviceprovisioningservices.OperationInputs, options *armdeviceprovisioningservices.IotDpsResourceClientCheckProvisioningServiceNameAvailabilityOptions) (resp azfake.Responder[armdeviceprovisioningservices.IotDpsResourceClientCheckProvisioningServiceNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method IotDpsResourceClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, provisioningServiceName string, iotDpsDescription armdeviceprovisioningservices.ProvisioningServiceDescription, options *armdeviceprovisioningservices.IotDpsResourceClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdatePrivateEndpointConnection is the fake for method IotDpsResourceClient.BeginCreateOrUpdatePrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdatePrivateEndpointConnection func(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, privateEndpointConnection armdeviceprovisioningservices.PrivateEndpointConnection, options *armdeviceprovisioningservices.IotDpsResourceClientBeginCreateOrUpdatePrivateEndpointConnectionOptions) (resp azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientCreateOrUpdatePrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method IotDpsResourceClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound
	BeginDelete func(ctx context.Context, provisioningServiceName string, resourceGroupName string, options *armdeviceprovisioningservices.IotDpsResourceClientBeginDeleteOptions) (resp azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeletePrivateEndpointConnection is the fake for method IotDpsResourceClient.BeginDeletePrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeletePrivateEndpointConnection func(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, options *armdeviceprovisioningservices.IotDpsResourceClientBeginDeletePrivateEndpointConnectionOptions) (resp azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientDeletePrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method IotDpsResourceClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, provisioningServiceName string, resourceGroupName string, options *armdeviceprovisioningservices.IotDpsResourceClientGetOptions) (resp azfake.Responder[armdeviceprovisioningservices.IotDpsResourceClientGetResponse], errResp azfake.ErrorResponder)

	// GetOperationResult is the fake for method IotDpsResourceClient.GetOperationResult
	// HTTP status codes to indicate success: http.StatusOK
	GetOperationResult func(ctx context.Context, operationID string, resourceGroupName string, provisioningServiceName string, asyncinfo string, options *armdeviceprovisioningservices.IotDpsResourceClientGetOperationResultOptions) (resp azfake.Responder[armdeviceprovisioningservices.IotDpsResourceClientGetOperationResultResponse], errResp azfake.ErrorResponder)

	// GetPrivateEndpointConnection is the fake for method IotDpsResourceClient.GetPrivateEndpointConnection
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateEndpointConnection func(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, options *armdeviceprovisioningservices.IotDpsResourceClientGetPrivateEndpointConnectionOptions) (resp azfake.Responder[armdeviceprovisioningservices.IotDpsResourceClientGetPrivateEndpointConnectionResponse], errResp azfake.ErrorResponder)

	// GetPrivateLinkResources is the fake for method IotDpsResourceClient.GetPrivateLinkResources
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateLinkResources func(ctx context.Context, resourceGroupName string, resourceName string, groupID string, options *armdeviceprovisioningservices.IotDpsResourceClientGetPrivateLinkResourcesOptions) (resp azfake.Responder[armdeviceprovisioningservices.IotDpsResourceClientGetPrivateLinkResourcesResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method IotDpsResourceClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armdeviceprovisioningservices.IotDpsResourceClientListByResourceGroupOptions) (resp azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method IotDpsResourceClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armdeviceprovisioningservices.IotDpsResourceClientListBySubscriptionOptions) (resp azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListBySubscriptionResponse])

	// NewListKeysPager is the fake for method IotDpsResourceClient.NewListKeysPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListKeysPager func(provisioningServiceName string, resourceGroupName string, options *armdeviceprovisioningservices.IotDpsResourceClientListKeysOptions) (resp azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListKeysResponse])

	// ListKeysForKeyName is the fake for method IotDpsResourceClient.ListKeysForKeyName
	// HTTP status codes to indicate success: http.StatusOK
	ListKeysForKeyName func(ctx context.Context, provisioningServiceName string, keyName string, resourceGroupName string, options *armdeviceprovisioningservices.IotDpsResourceClientListKeysForKeyNameOptions) (resp azfake.Responder[armdeviceprovisioningservices.IotDpsResourceClientListKeysForKeyNameResponse], errResp azfake.ErrorResponder)

	// ListPrivateEndpointConnections is the fake for method IotDpsResourceClient.ListPrivateEndpointConnections
	// HTTP status codes to indicate success: http.StatusOK
	ListPrivateEndpointConnections func(ctx context.Context, resourceGroupName string, resourceName string, options *armdeviceprovisioningservices.IotDpsResourceClientListPrivateEndpointConnectionsOptions) (resp azfake.Responder[armdeviceprovisioningservices.IotDpsResourceClientListPrivateEndpointConnectionsResponse], errResp azfake.ErrorResponder)

	// ListPrivateLinkResources is the fake for method IotDpsResourceClient.ListPrivateLinkResources
	// HTTP status codes to indicate success: http.StatusOK
	ListPrivateLinkResources func(ctx context.Context, resourceGroupName string, resourceName string, options *armdeviceprovisioningservices.IotDpsResourceClientListPrivateLinkResourcesOptions) (resp azfake.Responder[armdeviceprovisioningservices.IotDpsResourceClientListPrivateLinkResourcesResponse], errResp azfake.ErrorResponder)

	// NewListValidSKUsPager is the fake for method IotDpsResourceClient.NewListValidSKUsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListValidSKUsPager func(provisioningServiceName string, resourceGroupName string, options *armdeviceprovisioningservices.IotDpsResourceClientListValidSKUsOptions) (resp azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListValidSKUsResponse])

	// BeginUpdate is the fake for method IotDpsResourceClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK
	BeginUpdate func(ctx context.Context, resourceGroupName string, provisioningServiceName string, provisioningServiceTags armdeviceprovisioningservices.TagsResource, options *armdeviceprovisioningservices.IotDpsResourceClientBeginUpdateOptions) (resp azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewIotDpsResourceServerTransport creates a new instance of IotDpsResourceServerTransport with the provided implementation.
// The returned IotDpsResourceServerTransport instance is connected to an instance of armdeviceprovisioningservices.IotDpsResourceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIotDpsResourceServerTransport(srv *IotDpsResourceServer) *IotDpsResourceServerTransport {
	return &IotDpsResourceServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientCreateOrUpdateResponse]](),
		beginCreateOrUpdatePrivateEndpointConnection: newTracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientCreateOrUpdatePrivateEndpointConnectionResponse]](),
		beginDelete:                          newTracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientDeleteResponse]](),
		beginDeletePrivateEndpointConnection: newTracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientDeletePrivateEndpointConnectionResponse]](),
		newListByResourceGroupPager:          newTracker[azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:           newTracker[azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListBySubscriptionResponse]](),
		newListKeysPager:                     newTracker[azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListKeysResponse]](),
		newListValidSKUsPager:                newTracker[azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListValidSKUsResponse]](),
		beginUpdate:                          newTracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientUpdateResponse]](),
	}
}

// IotDpsResourceServerTransport connects instances of armdeviceprovisioningservices.IotDpsResourceClient to instances of IotDpsResourceServer.
// Don't use this type directly, use NewIotDpsResourceServerTransport instead.
type IotDpsResourceServerTransport struct {
	srv                                          *IotDpsResourceServer
	beginCreateOrUpdate                          *tracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientCreateOrUpdateResponse]]
	beginCreateOrUpdatePrivateEndpointConnection *tracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientCreateOrUpdatePrivateEndpointConnectionResponse]]
	beginDelete                                  *tracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientDeleteResponse]]
	beginDeletePrivateEndpointConnection         *tracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientDeletePrivateEndpointConnectionResponse]]
	newListByResourceGroupPager                  *tracker[azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListByResourceGroupResponse]]
	newListBySubscriptionPager                   *tracker[azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListBySubscriptionResponse]]
	newListKeysPager                             *tracker[azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListKeysResponse]]
	newListValidSKUsPager                        *tracker[azfake.PagerResponder[armdeviceprovisioningservices.IotDpsResourceClientListValidSKUsResponse]]
	beginUpdate                                  *tracker[azfake.PollerResponder[armdeviceprovisioningservices.IotDpsResourceClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for IotDpsResourceServerTransport.
func (i *IotDpsResourceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IotDpsResourceClient.CheckProvisioningServiceNameAvailability":
		resp, err = i.dispatchCheckProvisioningServiceNameAvailability(req)
	case "IotDpsResourceClient.BeginCreateOrUpdate":
		resp, err = i.dispatchBeginCreateOrUpdate(req)
	case "IotDpsResourceClient.BeginCreateOrUpdatePrivateEndpointConnection":
		resp, err = i.dispatchBeginCreateOrUpdatePrivateEndpointConnection(req)
	case "IotDpsResourceClient.BeginDelete":
		resp, err = i.dispatchBeginDelete(req)
	case "IotDpsResourceClient.BeginDeletePrivateEndpointConnection":
		resp, err = i.dispatchBeginDeletePrivateEndpointConnection(req)
	case "IotDpsResourceClient.Get":
		resp, err = i.dispatchGet(req)
	case "IotDpsResourceClient.GetOperationResult":
		resp, err = i.dispatchGetOperationResult(req)
	case "IotDpsResourceClient.GetPrivateEndpointConnection":
		resp, err = i.dispatchGetPrivateEndpointConnection(req)
	case "IotDpsResourceClient.GetPrivateLinkResources":
		resp, err = i.dispatchGetPrivateLinkResources(req)
	case "IotDpsResourceClient.NewListByResourceGroupPager":
		resp, err = i.dispatchNewListByResourceGroupPager(req)
	case "IotDpsResourceClient.NewListBySubscriptionPager":
		resp, err = i.dispatchNewListBySubscriptionPager(req)
	case "IotDpsResourceClient.NewListKeysPager":
		resp, err = i.dispatchNewListKeysPager(req)
	case "IotDpsResourceClient.ListKeysForKeyName":
		resp, err = i.dispatchListKeysForKeyName(req)
	case "IotDpsResourceClient.ListPrivateEndpointConnections":
		resp, err = i.dispatchListPrivateEndpointConnections(req)
	case "IotDpsResourceClient.ListPrivateLinkResources":
		resp, err = i.dispatchListPrivateLinkResources(req)
	case "IotDpsResourceClient.NewListValidSKUsPager":
		resp, err = i.dispatchNewListValidSKUsPager(req)
	case "IotDpsResourceClient.BeginUpdate":
		resp, err = i.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchCheckProvisioningServiceNameAvailability(req *http.Request) (*http.Response, error) {
	if i.srv.CheckProvisioningServiceNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckProvisioningServiceNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/checkProvisioningServiceNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdeviceprovisioningservices.OperationInputs](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.CheckProvisioningServiceNameAvailability(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NameAvailabilityInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := i.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<provisioningServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdeviceprovisioningservices.ProvisioningServiceDescription](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		provisioningServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("provisioningServiceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, provisioningServiceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		i.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		i.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		i.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchBeginCreateOrUpdatePrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if i.srv.BeginCreateOrUpdatePrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdatePrivateEndpointConnection not implemented")}
	}
	beginCreateOrUpdatePrivateEndpointConnection := i.beginCreateOrUpdatePrivateEndpointConnection.get(req)
	if beginCreateOrUpdatePrivateEndpointConnection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdeviceprovisioningservices.PrivateEndpointConnection](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginCreateOrUpdatePrivateEndpointConnection(req.Context(), resourceGroupNameParam, resourceNameParam, privateEndpointConnectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdatePrivateEndpointConnection = &respr
		i.beginCreateOrUpdatePrivateEndpointConnection.add(req, beginCreateOrUpdatePrivateEndpointConnection)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdatePrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		i.beginCreateOrUpdatePrivateEndpointConnection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdatePrivateEndpointConnection) {
		i.beginCreateOrUpdatePrivateEndpointConnection.remove(req)
	}

	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := i.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<provisioningServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		provisioningServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("provisioningServiceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDelete(req.Context(), provisioningServiceNameParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		i.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound}, resp.StatusCode) {
		i.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		i.beginDelete.remove(req)
	}

	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchBeginDeletePrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDeletePrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeletePrivateEndpointConnection not implemented")}
	}
	beginDeletePrivateEndpointConnection := i.beginDeletePrivateEndpointConnection.get(req)
	if beginDeletePrivateEndpointConnection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginDeletePrivateEndpointConnection(req.Context(), resourceGroupNameParam, resourceNameParam, privateEndpointConnectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeletePrivateEndpointConnection = &respr
		i.beginDeletePrivateEndpointConnection.add(req, beginDeletePrivateEndpointConnection)
	}

	resp, err := server.PollerResponderNext(beginDeletePrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		i.beginDeletePrivateEndpointConnection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeletePrivateEndpointConnection) {
		i.beginDeletePrivateEndpointConnection.remove(req)
	}

	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<provisioningServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	provisioningServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("provisioningServiceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), provisioningServiceNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProvisioningServiceDescription, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchGetOperationResult(req *http.Request) (*http.Response, error) {
	if i.srv.GetOperationResult == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetOperationResult not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<provisioningServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationresults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	provisioningServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("provisioningServiceName")])
	if err != nil {
		return nil, err
	}
	asyncinfoParam, err := url.QueryUnescape(qp.Get("asyncinfo"))
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.GetOperationResult(req.Context(), operationIDParam, resourceGroupNameParam, provisioningServiceNameParam, asyncinfoParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AsyncOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchGetPrivateEndpointConnection(req *http.Request) (*http.Response, error) {
	if i.srv.GetPrivateEndpointConnection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateEndpointConnection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.GetPrivateEndpointConnection(req.Context(), resourceGroupNameParam, resourceNameParam, privateEndpointConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateEndpointConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchGetPrivateLinkResources(req *http.Request) (*http.Response, error) {
	if i.srv.GetPrivateLinkResources == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateLinkResources not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.GetPrivateLinkResources(req.Context(), resourceGroupNameParam, resourceNameParam, groupIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GroupIDInformation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := i.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		i.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armdeviceprovisioningservices.IotDpsResourceClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		i.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := i.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := i.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		i.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armdeviceprovisioningservices.IotDpsResourceClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		i.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchNewListKeysPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListKeysPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListKeysPager not implemented")}
	}
	newListKeysPager := i.newListKeysPager.get(req)
	if newListKeysPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<provisioningServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listkeys`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		provisioningServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("provisioningServiceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListKeysPager(provisioningServiceNameParam, resourceGroupNameParam, nil)
		newListKeysPager = &resp
		i.newListKeysPager.add(req, newListKeysPager)
		server.PagerResponderInjectNextLinks(newListKeysPager, req, func(page *armdeviceprovisioningservices.IotDpsResourceClientListKeysResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListKeysPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListKeysPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListKeysPager) {
		i.newListKeysPager.remove(req)
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchListKeysForKeyName(req *http.Request) (*http.Response, error) {
	if i.srv.ListKeysForKeyName == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListKeysForKeyName not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<provisioningServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/keys/(?P<keyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listkeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	provisioningServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("provisioningServiceName")])
	if err != nil {
		return nil, err
	}
	keyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.ListKeysForKeyName(req.Context(), provisioningServiceNameParam, keyNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SharedAccessSignatureAuthorizationRuleAccessRightsDescription, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchListPrivateEndpointConnections(req *http.Request) (*http.Response, error) {
	if i.srv.ListPrivateEndpointConnections == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPrivateEndpointConnections not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.ListPrivateEndpointConnections(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateEndpointConnectionArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchListPrivateLinkResources(req *http.Request) (*http.Response, error) {
	if i.srv.ListPrivateLinkResources == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPrivateLinkResources not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.ListPrivateLinkResources(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateLinkResources, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchNewListValidSKUsPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListValidSKUsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListValidSKUsPager not implemented")}
	}
	newListValidSKUsPager := i.newListValidSKUsPager.get(req)
	if newListValidSKUsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<provisioningServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		provisioningServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("provisioningServiceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListValidSKUsPager(provisioningServiceNameParam, resourceGroupNameParam, nil)
		newListValidSKUsPager = &resp
		i.newListValidSKUsPager.add(req, newListValidSKUsPager)
		server.PagerResponderInjectNextLinks(newListValidSKUsPager, req, func(page *armdeviceprovisioningservices.IotDpsResourceClientListValidSKUsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListValidSKUsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListValidSKUsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListValidSKUsPager) {
		i.newListValidSKUsPager.remove(req)
	}
	return resp, nil
}

func (i *IotDpsResourceServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := i.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Devices/provisioningServices/(?P<provisioningServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdeviceprovisioningservices.TagsResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		provisioningServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("provisioningServiceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := i.srv.BeginUpdate(req.Context(), resourceGroupNameParam, provisioningServiceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		i.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		i.beginUpdate.remove(req)
	}

	return resp, nil
}
