//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevcenter_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/Skus_ListBySubscription.json
func ExampleSKUsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSKUsClient().NewListBySubscriptionPager(&armdevcenter.SKUsClientListBySubscriptionOptions{Top: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SKUListResult = armdevcenter.SKUListResult{
		// 	Value: []*armdevcenter.SKUInfo{
		// 		{
		// 			Name: to.Ptr("Large"),
		// 			Tier: to.Ptr(armdevcenter.SKUTierPremium),
		// 			Locations: []*string{
		// 				to.Ptr("CentralUS")},
		// 				ResourceType: to.Ptr("projects/pools"),
		// 			},
		// 			{
		// 				Name: to.Ptr("Medium"),
		// 				Tier: to.Ptr(armdevcenter.SKUTierStandard),
		// 				Locations: []*string{
		// 					to.Ptr("CentralUS")},
		// 					ResourceType: to.Ptr("projects/pools"),
		// 			}},
		// 		}
	}
}
