//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevcenter_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/Images_ListByDevCenter.json
func ExampleImagesClient_NewListByDevCenterPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewImagesClient().NewListByDevCenterPager("rg1", "Contoso", &armdevcenter.ImagesClientListByDevCenterOptions{Top: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ImageListResult = armdevcenter.ImageListResult{
		// 	Value: []*armdevcenter.Image{
		// 		{
		// 			Name: to.Ptr("ContosoBaseImage"),
		// 			Type: to.Ptr("Microsoft.DevCenter/devcenters/galleries/images"),
		// 			ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/DevGallery/images/ContosoBaseImage"),
		// 			SystemData: &armdevcenter.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:00:36.993Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:30:36.993Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user1"),
		// 				LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 			},
		// 			Properties: &armdevcenter.ImageProperties{
		// 				Description: to.Ptr("Windows 10 Enterprise + OS Optimizations 1909"),
		// 				Offer: to.Ptr("windows-ent-cpc"),
		// 				ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
		// 				Publisher: to.Ptr("MicrosoftWindowsDesktop"),
		// 				RecommendedMachineConfiguration: &armdevcenter.RecommendedMachineConfiguration{
		// 					Memory: &armdevcenter.ResourceRange{
		// 						Max: to.Ptr[int32](256),
		// 						Min: to.Ptr[int32](128),
		// 					},
		// 					VCPUs: &armdevcenter.ResourceRange{
		// 						Max: to.Ptr[int32](4),
		// 						Min: to.Ptr[int32](2),
		// 					},
		// 				},
		// 				SKU: to.Ptr("19h2-ent-cpc-os-g2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ContosoBaseImage2"),
		// 			Type: to.Ptr("Microsoft.DevCenter/devcenters/galleries/images"),
		// 			ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/DevGallery/images/ContosoBaseImage2"),
		// 			SystemData: &armdevcenter.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:00:36.993Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:30:36.993Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user1"),
		// 				LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 			},
		// 			Properties: &armdevcenter.ImageProperties{
		// 				Description: to.Ptr("Standard Windows Dev/Test image."),
		// 				Offer: to.Ptr("Finance"),
		// 				Publisher: to.Ptr("Contoso"),
		// 				RecommendedMachineConfiguration: &armdevcenter.RecommendedMachineConfiguration{
		// 					Memory: &armdevcenter.ResourceRange{
		// 						Max: to.Ptr[int32](512),
		// 						Min: to.Ptr[int32](256),
		// 					},
		// 					VCPUs: &armdevcenter.ResourceRange{
		// 						Max: to.Ptr[int32](8),
		// 						Min: to.Ptr[int32](4),
		// 					},
		// 				},
		// 				SKU: to.Ptr("Backend"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/Images_ListByGallery.json
func ExampleImagesClient_NewListByGalleryPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewImagesClient().NewListByGalleryPager("rg1", "Contoso", "DevGallery", &armdevcenter.ImagesClientListByGalleryOptions{Top: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ImageListResult = armdevcenter.ImageListResult{
		// 	Value: []*armdevcenter.Image{
		// 		{
		// 			Name: to.Ptr("ContosoBaseImage"),
		// 			Type: to.Ptr("Microsoft.DevCenter/devcenters/galleries/images"),
		// 			ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/DevGallery/images/ContosoBaseImage"),
		// 			SystemData: &armdevcenter.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:00:36.993Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:30:36.993Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user1"),
		// 				LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 			},
		// 			Properties: &armdevcenter.ImageProperties{
		// 				Description: to.Ptr("Windows 10 Enterprise + OS Optimizations 1909"),
		// 				Offer: to.Ptr("windows-ent-cpc"),
		// 				ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
		// 				Publisher: to.Ptr("MicrosoftWindowsDesktop"),
		// 				RecommendedMachineConfiguration: &armdevcenter.RecommendedMachineConfiguration{
		// 					Memory: &armdevcenter.ResourceRange{
		// 						Max: to.Ptr[int32](256),
		// 						Min: to.Ptr[int32](128),
		// 					},
		// 					VCPUs: &armdevcenter.ResourceRange{
		// 						Max: to.Ptr[int32](4),
		// 						Min: to.Ptr[int32](2),
		// 					},
		// 				},
		// 				SKU: to.Ptr("19h2-ent-cpc-os-g2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ContosoBaseImage2"),
		// 			Type: to.Ptr("Microsoft.DevCenter/devcenters/galleries/images"),
		// 			ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/DevGallery/images/ContosoBaseImage2"),
		// 			SystemData: &armdevcenter.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:00:36.993Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:30:36.993Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user1"),
		// 				LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 			},
		// 			Properties: &armdevcenter.ImageProperties{
		// 				Description: to.Ptr("Standard Windows Dev/Test image."),
		// 				Offer: to.Ptr("Finance"),
		// 				Publisher: to.Ptr("Contoso"),
		// 				RecommendedMachineConfiguration: &armdevcenter.RecommendedMachineConfiguration{
		// 					Memory: &armdevcenter.ResourceRange{
		// 						Max: to.Ptr[int32](512),
		// 						Min: to.Ptr[int32](256),
		// 					},
		// 					VCPUs: &armdevcenter.ResourceRange{
		// 						Max: to.Ptr[int32](8),
		// 						Min: to.Ptr[int32](4),
		// 					},
		// 				},
		// 				SKU: to.Ptr("Backend"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/Images_Get.json
func ExampleImagesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewImagesClient().Get(ctx, "rg1", "Contoso", "DefaultDevGallery", "ContosoBaseImage", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Image = armdevcenter.Image{
	// 	Name: to.Ptr("ContosoBaseImage"),
	// 	Type: to.Ptr("Microsoft.DevCenter/devcenters/galleries/images"),
	// 	ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/DefaultDevGallery/images/ContosoBaseImage"),
	// 	SystemData: &armdevcenter.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:00:36.993Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:30:36.993Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user1"),
	// 		LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdevcenter.ImageProperties{
	// 		Description: to.Ptr("Standard Windows Dev/Test image."),
	// 		Offer: to.Ptr("Finance"),
	// 		ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
	// 		Publisher: to.Ptr("Contoso"),
	// 		RecommendedMachineConfiguration: &armdevcenter.RecommendedMachineConfiguration{
	// 			Memory: &armdevcenter.ResourceRange{
	// 				Max: to.Ptr[int32](512),
	// 				Min: to.Ptr[int32](256),
	// 			},
	// 			VCPUs: &armdevcenter.ResourceRange{
	// 				Max: to.Ptr[int32](8),
	// 				Min: to.Ptr[int32](4),
	// 			},
	// 		},
	// 		SKU: to.Ptr("Backend"),
	// 	},
	// }
}
