//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentmanager

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIKeyAuthentication.
func (a APIKeyAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "in", a.In)
	populate(objectMap, "name", a.Name)
	objectMap["type"] = RestAuthTypeAPIKey
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIKeyAuthentication.
func (a *APIKeyAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "in":
			err = unpopulate(val, "In", &a.In)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSource.
func (a ArtifactSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSource.
func (a *ArtifactSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSourceProperties.
func (a ArtifactSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactRoot", a.ArtifactRoot)
	populate(objectMap, "authentication", a.Authentication)
	populate(objectMap, "sourceType", a.SourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSourceProperties.
func (a *ArtifactSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactRoot":
			err = unpopulate(val, "ArtifactRoot", &a.ArtifactRoot)
			delete(rawMsg, key)
		case "authentication":
			a.Authentication, err = unmarshalAuthenticationClassification(val)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &a.SourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSourcePropertiesAutoGenerated.
func (a ArtifactSourcePropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactRoot", a.ArtifactRoot)
	populate(objectMap, "authentication", a.Authentication)
	populate(objectMap, "sourceType", a.SourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSourcePropertiesAutoGenerated.
func (a *ArtifactSourcePropertiesAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactRoot":
			err = unpopulate(val, "ArtifactRoot", &a.ArtifactRoot)
			delete(rawMsg, key)
		case "authentication":
			a.Authentication, err = unmarshalAuthenticationClassification(val)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &a.SourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Authentication.
func (a Authentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = a.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Authentication.
func (a *Authentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudErrorBody.
func (c CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", c.Code)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudErrorBody.
func (c *CloudErrorBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &c.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &c.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthCheckStepAttributes.
func (h HealthCheckStepAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthyStateDuration", h.HealthyStateDuration)
	populate(objectMap, "maxElasticDuration", h.MaxElasticDuration)
	objectMap["type"] = h.Type
	populate(objectMap, "waitDuration", h.WaitDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthCheckStepAttributes.
func (h *HealthCheckStepAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthyStateDuration":
			err = unpopulate(val, "HealthyStateDuration", &h.HealthyStateDuration)
			delete(rawMsg, key)
		case "maxElasticDuration":
			err = unpopulate(val, "MaxElasticDuration", &h.MaxElasticDuration)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "waitDuration":
			err = unpopulate(val, "WaitDuration", &h.WaitDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthCheckStepProperties.
func (h HealthCheckStepProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", h.Attributes)
	objectMap["stepType"] = StepTypeHealthCheck
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthCheckStepProperties.
func (h *HealthCheckStepProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			h.Attributes, err = unmarshalHealthCheckStepAttributesClassification(val)
			delete(rawMsg, key)
		case "stepType":
			err = unpopulate(val, "StepType", &h.StepType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identityIds", i.IdentityIDs)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Identity.
func (i *Identity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityIds":
			err = unpopulate(val, "IdentityIDs", &i.IdentityIDs)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Message.
func (m Message) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", m.Message)
	populateDateTimeRFC3339(objectMap, "timeStamp", m.TimeStamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Message.
func (m *Message) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateDateTimeRFC3339(val, "TimeStamp", &m.TimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDetail.
func (o OperationDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDetail.
func (o *OperationDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsList.
func (o OperationsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsList.
func (o *OperationsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrePostStep.
func (p PrePostStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "stepId", p.StepID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrePostStep.
func (p *PrePostStep) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "stepId":
			err = unpopulate(val, "StepID", &p.StepID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceOperation.
func (r ResourceOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationId", r.OperationID)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "resourceName", r.ResourceName)
	populate(objectMap, "resourceType", r.ResourceType)
	populate(objectMap, "statusCode", r.StatusCode)
	populate(objectMap, "statusMessage", r.StatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceOperation.
func (r *ResourceOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &r.OperationID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &r.ResourceName)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &r.StatusCode)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &r.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestHealthCheck.
func (r RestHealthCheck) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "request", r.Request)
	populate(objectMap, "response", r.Response)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestHealthCheck.
func (r *RestHealthCheck) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &r.Request)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &r.Response)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestHealthCheckStepAttributes.
func (r RestHealthCheckStepAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthyStateDuration", r.HealthyStateDuration)
	populate(objectMap, "maxElasticDuration", r.MaxElasticDuration)
	populate(objectMap, "properties", r.Properties)
	objectMap["type"] = "REST"
	populate(objectMap, "waitDuration", r.WaitDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestHealthCheckStepAttributes.
func (r *RestHealthCheckStepAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthyStateDuration":
			err = unpopulate(val, "HealthyStateDuration", &r.HealthyStateDuration)
			delete(rawMsg, key)
		case "maxElasticDuration":
			err = unpopulate(val, "MaxElasticDuration", &r.MaxElasticDuration)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "waitDuration":
			err = unpopulate(val, "WaitDuration", &r.WaitDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestParameters.
func (r RestParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "healthChecks", r.HealthChecks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestParameters.
func (r *RestParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "healthChecks":
			err = unpopulate(val, "HealthChecks", &r.HealthChecks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestRequest.
func (r RestRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", r.Authentication)
	populate(objectMap, "method", r.Method)
	populate(objectMap, "uri", r.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestRequest.
func (r *RestRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			r.Authentication, err = unmarshalRestRequestAuthenticationClassification(val)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &r.Method)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &r.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestRequestAuthentication.
func (r RestRequestAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = r.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestRequestAuthentication.
func (r *RestRequestAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestResponse.
func (r RestResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regex", r.Regex)
	populate(objectMap, "successStatusCodes", r.SuccessStatusCodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestResponse.
func (r *RestResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regex":
			err = unpopulate(val, "Regex", &r.Regex)
			delete(rawMsg, key)
		case "successStatusCodes":
			err = unpopulate(val, "SuccessStatusCodes", &r.SuccessStatusCodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestResponseRegex.
func (r RestResponseRegex) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchQuantifier", r.MatchQuantifier)
	populate(objectMap, "matches", r.Matches)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestResponseRegex.
func (r *RestResponseRegex) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchQuantifier":
			err = unpopulate(val, "MatchQuantifier", &r.MatchQuantifier)
			delete(rawMsg, key)
		case "matches":
			err = unpopulate(val, "Matches", &r.Matches)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Rollout.
func (r Rollout) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Rollout.
func (r *Rollout) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &r.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutIdentityAuthentication.
func (r RolloutIdentityAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = RestAuthTypeRolloutIdentity
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutIdentityAuthentication.
func (r *RolloutIdentityAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutOperationInfo.
func (r RolloutOperationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "error", r.Error)
	populate(objectMap, "retryAttempt", r.RetryAttempt)
	populate(objectMap, "skipSucceededOnRetry", r.SkipSucceededOnRetry)
	populateDateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutOperationInfo.
func (r *RolloutOperationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &r.Error)
			delete(rawMsg, key)
		case "retryAttempt":
			err = unpopulate(val, "RetryAttempt", &r.RetryAttempt)
			delete(rawMsg, key)
		case "skipSucceededOnRetry":
			err = unpopulate(val, "SkipSucceededOnRetry", &r.SkipSucceededOnRetry)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutProperties.
func (r RolloutProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactSourceId", r.ArtifactSourceID)
	populate(objectMap, "buildVersion", r.BuildVersion)
	populate(objectMap, "operationInfo", r.OperationInfo)
	populate(objectMap, "services", r.Services)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "stepGroups", r.StepGroups)
	populate(objectMap, "targetServiceTopologyId", r.TargetServiceTopologyID)
	populate(objectMap, "totalRetryAttempts", r.TotalRetryAttempts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutProperties.
func (r *RolloutProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactSourceId":
			err = unpopulate(val, "ArtifactSourceID", &r.ArtifactSourceID)
			delete(rawMsg, key)
		case "buildVersion":
			err = unpopulate(val, "BuildVersion", &r.BuildVersion)
			delete(rawMsg, key)
		case "operationInfo":
			err = unpopulate(val, "OperationInfo", &r.OperationInfo)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &r.Services)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "stepGroups":
			err = unpopulate(val, "StepGroups", &r.StepGroups)
			delete(rawMsg, key)
		case "targetServiceTopologyId":
			err = unpopulate(val, "TargetServiceTopologyID", &r.TargetServiceTopologyID)
			delete(rawMsg, key)
		case "totalRetryAttempts":
			err = unpopulate(val, "TotalRetryAttempts", &r.TotalRetryAttempts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutPropertiesAutoGenerated.
func (r RolloutPropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationInfo", r.OperationInfo)
	populate(objectMap, "services", r.Services)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "totalRetryAttempts", r.TotalRetryAttempts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutPropertiesAutoGenerated.
func (r *RolloutPropertiesAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationInfo":
			err = unpopulate(val, "OperationInfo", &r.OperationInfo)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &r.Services)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "totalRetryAttempts":
			err = unpopulate(val, "TotalRetryAttempts", &r.TotalRetryAttempts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutRequest.
func (r RolloutRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "identity", r.Identity)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutRequest.
func (r *RolloutRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &r.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutRequestProperties.
func (r RolloutRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactSourceId", r.ArtifactSourceID)
	populate(objectMap, "buildVersion", r.BuildVersion)
	populate(objectMap, "stepGroups", r.StepGroups)
	populate(objectMap, "targetServiceTopologyId", r.TargetServiceTopologyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutRequestProperties.
func (r *RolloutRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactSourceId":
			err = unpopulate(val, "ArtifactSourceID", &r.ArtifactSourceID)
			delete(rawMsg, key)
		case "buildVersion":
			err = unpopulate(val, "BuildVersion", &r.BuildVersion)
			delete(rawMsg, key)
		case "stepGroups":
			err = unpopulate(val, "StepGroups", &r.StepGroups)
			delete(rawMsg, key)
		case "targetServiceTopologyId":
			err = unpopulate(val, "TargetServiceTopologyID", &r.TargetServiceTopologyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutStep.
func (r RolloutStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "messages", r.Messages)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "operationInfo", r.OperationInfo)
	populate(objectMap, "resourceOperations", r.ResourceOperations)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "stepGroup", r.StepGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutStep.
func (r *RolloutStep) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "messages":
			err = unpopulate(val, "Messages", &r.Messages)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "operationInfo":
			err = unpopulate(val, "OperationInfo", &r.OperationInfo)
			delete(rawMsg, key)
		case "resourceOperations":
			err = unpopulate(val, "ResourceOperations", &r.ResourceOperations)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "stepGroup":
			err = unpopulate(val, "StepGroup", &r.StepGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SasAuthentication.
func (s SasAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	objectMap["type"] = "Sas"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SasAuthentication.
func (s *SasAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SasProperties.
func (s SasProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sasUri", s.SasURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SasProperties.
func (s *SasProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sasUri":
			err = unpopulate(val, "SasURI", &s.SasURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "serviceUnits", s.ServiceUnits)
	populate(objectMap, "targetLocation", s.TargetLocation)
	populate(objectMap, "targetSubscriptionId", s.TargetSubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Service.
func (s *Service) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "serviceUnits":
			err = unpopulate(val, "ServiceUnits", &s.ServiceUnits)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &s.TargetLocation)
			delete(rawMsg, key)
		case "targetSubscriptionId":
			err = unpopulate(val, "TargetSubscriptionID", &s.TargetSubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProperties.
func (s ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetLocation", s.TargetLocation)
	populate(objectMap, "targetSubscriptionId", s.TargetSubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProperties.
func (s *ServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &s.TargetLocation)
			delete(rawMsg, key)
		case "targetSubscriptionId":
			err = unpopulate(val, "TargetSubscriptionID", &s.TargetSubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResource.
func (s ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResource.
func (s *ServiceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceProperties.
func (s ServiceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetLocation", s.TargetLocation)
	populate(objectMap, "targetSubscriptionId", s.TargetSubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceProperties.
func (s *ServiceResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &s.TargetLocation)
			delete(rawMsg, key)
		case "targetSubscriptionId":
			err = unpopulate(val, "TargetSubscriptionID", &s.TargetSubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTopologyProperties.
func (s ServiceTopologyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactSourceId", s.ArtifactSourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTopologyProperties.
func (s *ServiceTopologyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactSourceId":
			err = unpopulate(val, "ArtifactSourceID", &s.ArtifactSourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTopologyResource.
func (s ServiceTopologyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTopologyResource.
func (s *ServiceTopologyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTopologyResourceProperties.
func (s ServiceTopologyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactSourceId", s.ArtifactSourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTopologyResourceProperties.
func (s *ServiceTopologyResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactSourceId":
			err = unpopulate(val, "ArtifactSourceID", &s.ArtifactSourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUnit.
func (s ServiceUnit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifacts", s.Artifacts)
	populate(objectMap, "deploymentMode", s.DeploymentMode)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "steps", s.Steps)
	populate(objectMap, "targetResourceGroup", s.TargetResourceGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUnit.
func (s *ServiceUnit) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifacts":
			err = unpopulate(val, "Artifacts", &s.Artifacts)
			delete(rawMsg, key)
		case "deploymentMode":
			err = unpopulate(val, "DeploymentMode", &s.DeploymentMode)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "steps":
			err = unpopulate(val, "Steps", &s.Steps)
			delete(rawMsg, key)
		case "targetResourceGroup":
			err = unpopulate(val, "TargetResourceGroup", &s.TargetResourceGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUnitArtifacts.
func (s ServiceUnitArtifacts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parametersArtifactSourceRelativePath", s.ParametersArtifactSourceRelativePath)
	populate(objectMap, "parametersUri", s.ParametersURI)
	populate(objectMap, "templateArtifactSourceRelativePath", s.TemplateArtifactSourceRelativePath)
	populate(objectMap, "templateUri", s.TemplateURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUnitArtifacts.
func (s *ServiceUnitArtifacts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parametersArtifactSourceRelativePath":
			err = unpopulate(val, "ParametersArtifactSourceRelativePath", &s.ParametersArtifactSourceRelativePath)
			delete(rawMsg, key)
		case "parametersUri":
			err = unpopulate(val, "ParametersURI", &s.ParametersURI)
			delete(rawMsg, key)
		case "templateArtifactSourceRelativePath":
			err = unpopulate(val, "TemplateArtifactSourceRelativePath", &s.TemplateArtifactSourceRelativePath)
			delete(rawMsg, key)
		case "templateUri":
			err = unpopulate(val, "TemplateURI", &s.TemplateURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUnitProperties.
func (s ServiceUnitProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifacts", s.Artifacts)
	populate(objectMap, "deploymentMode", s.DeploymentMode)
	populate(objectMap, "targetResourceGroup", s.TargetResourceGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUnitProperties.
func (s *ServiceUnitProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifacts":
			err = unpopulate(val, "Artifacts", &s.Artifacts)
			delete(rawMsg, key)
		case "deploymentMode":
			err = unpopulate(val, "DeploymentMode", &s.DeploymentMode)
			delete(rawMsg, key)
		case "targetResourceGroup":
			err = unpopulate(val, "TargetResourceGroup", &s.TargetResourceGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUnitResource.
func (s ServiceUnitResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUnitResource.
func (s *ServiceUnitResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUnitResourceProperties.
func (s ServiceUnitResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifacts", s.Artifacts)
	populate(objectMap, "deploymentMode", s.DeploymentMode)
	populate(objectMap, "targetResourceGroup", s.TargetResourceGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUnitResourceProperties.
func (s *ServiceUnitResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifacts":
			err = unpopulate(val, "Artifacts", &s.Artifacts)
			delete(rawMsg, key)
		case "deploymentMode":
			err = unpopulate(val, "DeploymentMode", &s.DeploymentMode)
			delete(rawMsg, key)
		case "targetResourceGroup":
			err = unpopulate(val, "TargetResourceGroup", &s.TargetResourceGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StepGroup.
func (s StepGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOnStepGroups", s.DependsOnStepGroups)
	populate(objectMap, "deploymentTargetId", s.DeploymentTargetID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "postDeploymentSteps", s.PostDeploymentSteps)
	populate(objectMap, "preDeploymentSteps", s.PreDeploymentSteps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StepGroup.
func (s *StepGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOnStepGroups":
			err = unpopulate(val, "DependsOnStepGroups", &s.DependsOnStepGroups)
			delete(rawMsg, key)
		case "deploymentTargetId":
			err = unpopulate(val, "DeploymentTargetID", &s.DeploymentTargetID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "postDeploymentSteps":
			err = unpopulate(val, "PostDeploymentSteps", &s.PostDeploymentSteps)
			delete(rawMsg, key)
		case "preDeploymentSteps":
			err = unpopulate(val, "PreDeploymentSteps", &s.PreDeploymentSteps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StepOperationInfo.
func (s StepOperationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationId", s.CorrelationID)
	populate(objectMap, "deploymentName", s.DeploymentName)
	populateDateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "error", s.Error)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTime", s.LastUpdatedTime)
	populateDateTimeRFC3339(objectMap, "startTime", s.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StepOperationInfo.
func (s *StepOperationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &s.CorrelationID)
			delete(rawMsg, key)
		case "deploymentName":
			err = unpopulate(val, "DeploymentName", &s.DeploymentName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &s.Error)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTime", &s.LastUpdatedTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StepProperties.
func (s StepProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["stepType"] = s.StepType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StepProperties.
func (s *StepProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "stepType":
			err = unpopulate(val, "StepType", &s.StepType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StepResource.
func (s StepResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StepResource.
func (s *StepResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			s.Properties, err = unmarshalStepPropertiesClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WaitStepAttributes.
func (w WaitStepAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", w.Duration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WaitStepAttributes.
func (w *WaitStepAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &w.Duration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WaitStepProperties.
func (w WaitStepProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", w.Attributes)
	objectMap["stepType"] = StepTypeWait
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WaitStepProperties.
func (w *WaitStepProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &w.Attributes)
			delete(rawMsg, key)
		case "stepType":
			err = unpopulate(val, "StepType", &w.StepType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
