//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatashare_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datashare/armdatashare"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/ShareSubscriptions_CancelSynchronization.json
func ExampleShareSubscriptionsClient_BeginCancelSynchronization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewShareSubscriptionsClient().BeginCancelSynchronization(ctx, "SampleResourceGroup", "Account1", "ShareSubscription1", armdatashare.ShareSubscriptionSynchronization{
		SynchronizationID: to.Ptr("7d0536a6-3fa5-43de-b152-3d07c4f6b2bb"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ShareSubscriptionSynchronization = armdatashare.ShareSubscriptionSynchronization{
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-06-30T02:37:48.497Z"); return t}()),
	// 	Status: to.Ptr("Cancelled"),
	// 	SynchronizationID: to.Ptr("343c4772-ad68-41aa-91b9-bab1c92f9c27"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/ShareSubscriptions_ListSourceShareSynchronizationSettings.json
func ExampleShareSubscriptionsClient_NewListSourceShareSynchronizationSettingsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewShareSubscriptionsClient().NewListSourceShareSynchronizationSettingsPager("SampleResourceGroup", "Account1", "ShareSub1", &armdatashare.ShareSubscriptionsClientListSourceShareSynchronizationSettingsOptions{SkipToken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SourceShareSynchronizationSettingList = armdatashare.SourceShareSynchronizationSettingList{
		// 	Value: []armdatashare.SourceShareSynchronizationSettingClassification{
		// 		&armdatashare.ScheduledSourceSynchronizationSetting{
		// 			Kind: to.Ptr(armdatashare.SourceShareSynchronizationSettingKindScheduleBased),
		// 			Properties: &armdatashare.ScheduledSourceShareSynchronizationSettingProperties{
		// 				RecurrenceInterval: to.Ptr(armdatashare.RecurrenceIntervalHour),
		// 				SynchronizationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-03-15T19:45:58.000Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/ShareSubscriptions_ListSynchronizationDetails.json
func ExampleShareSubscriptionsClient_NewListSynchronizationDetailsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewShareSubscriptionsClient().NewListSynchronizationDetailsPager("SampleResourceGroup", "Account1", "ShareSub1", armdatashare.ShareSubscriptionSynchronization{
		SynchronizationID: to.Ptr("7d0536a6-3fa5-43de-b152-3d07c4f6b2bb"),
	}, &armdatashare.ShareSubscriptionsClientListSynchronizationDetailsOptions{SkipToken: nil,
		Filter:  nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SynchronizationDetailsList = armdatashare.SynchronizationDetailsList{
		// 	Value: []*armdatashare.SynchronizationDetails{
		// 		{
		// 			Name: to.Ptr("datasetmapping1"),
		// 			DataSetID: to.Ptr("7d0536a6-3fa5-43de-b152-3d07c4f6b2bb"),
		// 			DataSetType: to.Ptr(armdatashare.DataSetTypeBlob),
		// 			DurationMs: to.Ptr[int32](2000),
		// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-14T04:47:52.961Z"); return t}()),
		// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-14T04:47:52.961Z"); return t}()),
		// 			Status: to.Ptr("Completed"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/ShareSubscriptions_ListSynchronizations.json
func ExampleShareSubscriptionsClient_NewListSynchronizationsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewShareSubscriptionsClient().NewListSynchronizationsPager("SampleResourceGroup", "Account1", "ShareSub1", &armdatashare.ShareSubscriptionsClientListSynchronizationsOptions{SkipToken: nil,
		Filter:  nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ShareSubscriptionSynchronizationList = armdatashare.ShareSubscriptionSynchronizationList{
		// 	Value: []*armdatashare.ShareSubscriptionSynchronization{
		// 		{
		// 			DurationMs: to.Ptr[int32](2000),
		// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-14T04:47:52.961Z"); return t}()),
		// 			Message: to.Ptr("nda"),
		// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-14T04:47:52.961Z"); return t}()),
		// 			Status: to.Ptr("Completed"),
		// 			SynchronizationID: to.Ptr("runId"),
		// 			SynchronizationMode: to.Ptr(armdatashare.SynchronizationModeIncremental),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/ShareSubscriptions_Synchronize.json
func ExampleShareSubscriptionsClient_BeginSynchronize() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewShareSubscriptionsClient().BeginSynchronize(ctx, "SampleResourceGroup", "Account1", "ShareSubscription1", armdatashare.Synchronize{
		SynchronizationMode: to.Ptr(armdatashare.SynchronizationModeIncremental),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ShareSubscriptionSynchronization = armdatashare.ShareSubscriptionSynchronization{
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-06-30T02:37:48.497Z"); return t}()),
	// 	Status: to.Ptr("Succeeded"),
	// 	SynchronizationID: to.Ptr("343c4772-ad68-41aa-91b9-bab1c92f9c27"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/ShareSubscriptions_Get.json
func ExampleShareSubscriptionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewShareSubscriptionsClient().Get(ctx, "SampleResourceGroup", "Account1", "ShareSubscription1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ShareSubscription = armdatashare.ShareSubscription{
	// 	Name: to.Ptr("ShareSubscription1"),
	// 	Type: to.Ptr("Microsoft.DataShare/accounts/shareSubscriptions"),
	// 	ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/sharesubscriptions/ShareSubscription1"),
	// 	Properties: &armdatashare.ShareSubscriptionProperties{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-01-17T22:32:36.818Z"); return t}()),
	// 		ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-08-26T22:33:24.578Z"); return t}()),
	// 		InvitationID: to.Ptr("4256e2cf-0f82-4865-961b-12f83333f487"),
	// 		ProviderEmail: to.Ptr("jack.rose@microsoft.com"),
	// 		ProviderName: to.Ptr("Jack Rose"),
	// 		ProviderTenantName: to.Ptr("ShareSenderCompanyName"),
	// 		ProvisioningState: to.Ptr(armdatashare.ProvisioningStateSucceeded),
	// 		ShareDescription: to.Ptr("Some share"),
	// 		ShareKind: to.Ptr(armdatashare.ShareKindCopyBased),
	// 		ShareName: to.Ptr("share1"),
	// 		ShareSubscriptionStatus: to.Ptr(armdatashare.ShareSubscriptionStatusActive),
	// 		ShareTerms: to.Ptr("Confidential"),
	// 		SourceShareLocation: to.Ptr("eastus2"),
	// 		UserEmail: to.Ptr("john.smith@microsoft.com"),
	// 		UserName: to.Ptr("John Smith"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/ShareSubscriptions_Create.json
func ExampleShareSubscriptionsClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewShareSubscriptionsClient().Create(ctx, "SampleResourceGroup", "Account1", "ShareSubscription1", armdatashare.ShareSubscription{
		Properties: &armdatashare.ShareSubscriptionProperties{
			ExpirationDate:      to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-08-26T22:33:24.578Z"); return t }()),
			InvitationID:        to.Ptr("12345678-1234-1234-12345678abd"),
			SourceShareLocation: to.Ptr("eastus2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ShareSubscription = armdatashare.ShareSubscription{
	// 	Name: to.Ptr("ShareSubscription1"),
	// 	Type: to.Ptr("Microsoft.DataShare/accounts/shareSubscriptions"),
	// 	ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/sharesubscriptions/ShareSubscription1"),
	// 	Properties: &armdatashare.ShareSubscriptionProperties{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-01-17T22:32:36.818Z"); return t}()),
	// 		ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-08-26T22:33:24.578Z"); return t}()),
	// 		InvitationID: to.Ptr("4256e2cf-0f82-4865-961b-12f83333f487"),
	// 		ProviderEmail: to.Ptr("jack.rose@microsoft.com"),
	// 		ProviderName: to.Ptr("Jack Rose"),
	// 		ProviderTenantName: to.Ptr("Microsoft"),
	// 		ShareDescription: to.Ptr("Some share"),
	// 		ShareKind: to.Ptr(armdatashare.ShareKindCopyBased),
	// 		ShareName: to.Ptr("share1"),
	// 		ShareSubscriptionStatus: to.Ptr(armdatashare.ShareSubscriptionStatusActive),
	// 		ShareTerms: to.Ptr("Confidential"),
	// 		SourceShareLocation: to.Ptr("eastus2"),
	// 		UserEmail: to.Ptr("john.smith@microsoft.com"),
	// 		UserName: to.Ptr("John Smith"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/ShareSubscriptions_Delete.json
func ExampleShareSubscriptionsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewShareSubscriptionsClient().BeginDelete(ctx, "SampleResourceGroup", "Account1", "ShareSubscription1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationResponse = armdatashare.OperationResponse{
	// 	Status: to.Ptr(armdatashare.StatusSucceeded),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/datashare/resource-manager/Microsoft.DataShare/stable/2020-09-01/examples/ShareSubscriptions_ListByAccount.json
func ExampleShareSubscriptionsClient_NewListByAccountPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatashare.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewShareSubscriptionsClient().NewListByAccountPager("SampleResourceGroup", "Account1", &armdatashare.ShareSubscriptionsClientListByAccountOptions{SkipToken: nil,
		Filter:  nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ShareSubscriptionList = armdatashare.ShareSubscriptionList{
		// 	Value: []*armdatashare.ShareSubscription{
		// 		{
		// 			Name: to.Ptr("ShareSubscription1"),
		// 			Type: to.Ptr("Microsoft.DataShare/accounts/shareSubscriptions"),
		// 			ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/sharesubscriptions/ShareSubscription1"),
		// 			Properties: &armdatashare.ShareSubscriptionProperties{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-11-14T06:15:15.681Z"); return t}()),
		// 				ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-08-26T22:33:24.578Z"); return t}()),
		// 				InvitationID: to.Ptr("12345678-1234-1234-12345678abd"),
		// 				ProviderEmail: to.Ptr("jack.rose@microsoft.com"),
		// 				ProviderName: to.Ptr("Jack Rose"),
		// 				ProviderTenantName: to.Ptr("Microsoft"),
		// 				ShareDescription: to.Ptr("Some share"),
		// 				ShareKind: to.Ptr(armdatashare.ShareKindCopyBased),
		// 				ShareName: to.Ptr("share1"),
		// 				ShareSubscriptionStatus: to.Ptr(armdatashare.ShareSubscriptionStatusActive),
		// 				ShareTerms: to.Ptr("Confidential"),
		// 				SourceShareLocation: to.Ptr("eastus2"),
		// 				UserEmail: to.Ptr("john.smith@microsoft.com"),
		// 				UserName: to.Ptr("johnsmith@microsoft.com"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ShareSubscription1"),
		// 			Type: to.Ptr("Microsoft.DataShare/accounts/shareSubscriptions"),
		// 			ID: to.Ptr("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.DataShare/accounts/Account1/sharesubscriptions/ShareSubscription1"),
		// 			Properties: &armdatashare.ShareSubscriptionProperties{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T22:32:36.818Z"); return t}()),
		// 				ExpirationDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-08-26T22:33:24.578Z"); return t}()),
		// 				InvitationID: to.Ptr("4256e2cf-0f82-4865-961b-12f83333f487"),
		// 				ProviderEmail: to.Ptr("jack.rose@microsoft.com"),
		// 				ProviderName: to.Ptr("Jack Rose"),
		// 				ProviderTenantName: to.Ptr("Microsoft"),
		// 				ShareDescription: to.Ptr("Some share"),
		// 				ShareKind: to.Ptr(armdatashare.ShareKindCopyBased),
		// 				ShareName: to.Ptr("share1"),
		// 				ShareSubscriptionStatus: to.Ptr(armdatashare.ShareSubscriptionStatusActive),
		// 				ShareTerms: to.Ptr("Confidential"),
		// 				SourceShareLocation: to.Ptr("eastus2"),
		// 				UserEmail: to.Ptr("john.smith@microsoft.com"),
		// 				UserName: to.Ptr("John Smith"),
		// 			},
		// 	}},
		// }
	}
}
