//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dataprotection/armdataprotection/v3"
	"net/http"
	"net/url"
	"regexp"
)

// DppResourceGuardProxyServer is a fake server for instances of the armdataprotection.DppResourceGuardProxyClient type.
type DppResourceGuardProxyServer struct {
	// CreateOrUpdate is the fake for method DppResourceGuardProxyClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, vaultName string, resourceGuardProxyName string, parameters armdataprotection.ResourceGuardProxyBaseResource, options *armdataprotection.DppResourceGuardProxyClientCreateOrUpdateOptions) (resp azfake.Responder[armdataprotection.DppResourceGuardProxyClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method DppResourceGuardProxyClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, vaultName string, resourceGuardProxyName string, options *armdataprotection.DppResourceGuardProxyClientDeleteOptions) (resp azfake.Responder[armdataprotection.DppResourceGuardProxyClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DppResourceGuardProxyClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, vaultName string, resourceGuardProxyName string, options *armdataprotection.DppResourceGuardProxyClientGetOptions) (resp azfake.Responder[armdataprotection.DppResourceGuardProxyClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DppResourceGuardProxyClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, vaultName string, options *armdataprotection.DppResourceGuardProxyClientListOptions) (resp azfake.PagerResponder[armdataprotection.DppResourceGuardProxyClientListResponse])

	// UnlockDelete is the fake for method DppResourceGuardProxyClient.UnlockDelete
	// HTTP status codes to indicate success: http.StatusOK
	UnlockDelete func(ctx context.Context, resourceGroupName string, vaultName string, resourceGuardProxyName string, parameters armdataprotection.UnlockDeleteRequest, options *armdataprotection.DppResourceGuardProxyClientUnlockDeleteOptions) (resp azfake.Responder[armdataprotection.DppResourceGuardProxyClientUnlockDeleteResponse], errResp azfake.ErrorResponder)
}

// NewDppResourceGuardProxyServerTransport creates a new instance of DppResourceGuardProxyServerTransport with the provided implementation.
// The returned DppResourceGuardProxyServerTransport instance is connected to an instance of armdataprotection.DppResourceGuardProxyClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDppResourceGuardProxyServerTransport(srv *DppResourceGuardProxyServer) *DppResourceGuardProxyServerTransport {
	return &DppResourceGuardProxyServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armdataprotection.DppResourceGuardProxyClientListResponse]](),
	}
}

// DppResourceGuardProxyServerTransport connects instances of armdataprotection.DppResourceGuardProxyClient to instances of DppResourceGuardProxyServer.
// Don't use this type directly, use NewDppResourceGuardProxyServerTransport instead.
type DppResourceGuardProxyServerTransport struct {
	srv          *DppResourceGuardProxyServer
	newListPager *tracker[azfake.PagerResponder[armdataprotection.DppResourceGuardProxyClientListResponse]]
}

// Do implements the policy.Transporter interface for DppResourceGuardProxyServerTransport.
func (d *DppResourceGuardProxyServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DppResourceGuardProxyClient.CreateOrUpdate":
		resp, err = d.dispatchCreateOrUpdate(req)
	case "DppResourceGuardProxyClient.Delete":
		resp, err = d.dispatchDelete(req)
	case "DppResourceGuardProxyClient.Get":
		resp, err = d.dispatchGet(req)
	case "DppResourceGuardProxyClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	case "DppResourceGuardProxyClient.UnlockDelete":
		resp, err = d.dispatchUnlockDelete(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DppResourceGuardProxyServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupResourceGuardProxies/(?P<resourceGuardProxyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdataprotection.ResourceGuardProxyBaseResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGuardProxyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardProxyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, vaultNameParam, resourceGuardProxyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourceGuardProxyBaseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DppResourceGuardProxyServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if d.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupResourceGuardProxies/(?P<resourceGuardProxyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGuardProxyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardProxyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Delete(req.Context(), resourceGroupNameParam, vaultNameParam, resourceGuardProxyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DppResourceGuardProxyServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupResourceGuardProxies/(?P<resourceGuardProxyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGuardProxyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardProxyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, vaultNameParam, resourceGuardProxyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourceGuardProxyBaseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DppResourceGuardProxyServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupResourceGuardProxies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListPager(resourceGroupNameParam, vaultNameParam, nil)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdataprotection.DppResourceGuardProxyClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}

func (d *DppResourceGuardProxyServerTransport) dispatchUnlockDelete(req *http.Request) (*http.Response, error) {
	if d.srv.UnlockDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method UnlockDelete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupResourceGuardProxies/(?P<resourceGuardProxyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/unlockDelete`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdataprotection.UnlockDeleteRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGuardProxyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardProxyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.UnlockDelete(req.Context(), resourceGroupNameParam, vaultNameParam, resourceGuardProxyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UnlockDeleteResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
