//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatalakestore

import "time"

// Account - Data Lake Store account information.
type Account struct {
	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The Key Vault encryption identity, if any.
	Identity *EncryptionIdentity

	// READ-ONLY; The resource location.
	Location *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The Data Lake Store account properties.
	Properties *AccountProperties

	// READ-ONLY; The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource type.
	Type *string
}

// AccountBasic - Basic Data Lake Store account information, returned on list calls.
type AccountBasic struct {
	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource location.
	Location *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The basic Data Lake Store account properties.
	Properties *AccountPropertiesBasic

	// READ-ONLY; The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource type.
	Type *string
}

// AccountListResult - Data Lake Store account list information response.
type AccountListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The results of the list operation.
	Value []*AccountBasic
}

// AccountProperties - Data Lake Store account properties information.
type AccountProperties struct {
	// READ-ONLY; The unique identifier associated with this Data Lake Store account.
	AccountID *string

	// READ-ONLY; The account creation time.
	CreationTime *time.Time

	// READ-ONLY; The commitment tier in use for the current month.
	CurrentTier *TierType

	// READ-ONLY; The default owner group for all new folders and files created in the Data Lake Store account.
	DefaultGroup *string

	// READ-ONLY; The Key Vault encryption configuration.
	EncryptionConfig *EncryptionConfig

	// READ-ONLY; The current state of encryption provisioning for this Data Lake Store account.
	EncryptionProvisioningState *EncryptionProvisioningState

	// READ-ONLY; The current state of encryption for this Data Lake Store account.
	EncryptionState *EncryptionState

	// READ-ONLY; The full CName endpoint for this account.
	Endpoint *string

	// READ-ONLY; The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall
	// is disabled, this is not enforced.
	FirewallAllowAzureIPs *FirewallAllowAzureIPsState

	// READ-ONLY; The list of firewall rules associated with this Data Lake Store account.
	FirewallRules []*FirewallRule

	// READ-ONLY; The current state of the IP address firewall for this Data Lake Store account.
	FirewallState *FirewallState

	// READ-ONLY; The account last modified time.
	LastModifiedTime *time.Time

	// READ-ONLY; The commitment tier to use for next month.
	NewTier *TierType

	// READ-ONLY; The provisioning status of the Data Lake Store account.
	ProvisioningState *DataLakeStoreAccountStatus

	// READ-ONLY; The state of the Data Lake Store account.
	State *DataLakeStoreAccountState

	// READ-ONLY; The current state of the trusted identity provider feature for this Data Lake Store account.
	TrustedIDProviderState *TrustedIDProviderState

	// READ-ONLY; The list of trusted identity providers associated with this Data Lake Store account.
	TrustedIDProviders []*TrustedIDProvider

	// READ-ONLY; The list of virtual network rules associated with this Data Lake Store account.
	VirtualNetworkRules []*VirtualNetworkRule
}

// AccountPropertiesBasic - The basic account specific properties that are associated with an underlying Data Lake Store account.
type AccountPropertiesBasic struct {
	// READ-ONLY; The unique identifier associated with this Data Lake Store account.
	AccountID *string

	// READ-ONLY; The account creation time.
	CreationTime *time.Time

	// READ-ONLY; The full CName endpoint for this account.
	Endpoint *string

	// READ-ONLY; The account last modified time.
	LastModifiedTime *time.Time

	// READ-ONLY; The provisioning status of the Data Lake Store account.
	ProvisioningState *DataLakeStoreAccountStatus

	// READ-ONLY; The state of the Data Lake Store account.
	State *DataLakeStoreAccountState
}

// CapabilityInformation - Subscription-level properties and limits for Data Lake Store.
type CapabilityInformation struct {
	// READ-ONLY; The current number of accounts under this subscription.
	AccountCount *int32

	// READ-ONLY; The maximum supported number of accounts under this subscription.
	MaxAccountCount *int32

	// READ-ONLY; The Boolean value of true or false to indicate the maintenance state.
	MigrationState *bool

	// READ-ONLY; The subscription state.
	State *SubscriptionState

	// READ-ONLY; The subscription credentials that uniquely identifies the subscription.
	SubscriptionID *string
}

// CheckNameAvailabilityParameters - Data Lake Store account name availability check parameters.
type CheckNameAvailabilityParameters struct {
	// REQUIRED; The Data Lake Store name to check availability for.
	Name *string

	// REQUIRED; The resource type. Note: This should not be set by the user, as the constant value is Microsoft.DataLakeStore/accounts
	Type *CheckNameAvailabilityParametersType
}

type CreateDataLakeStoreAccountParameters struct {
	// REQUIRED; The resource location.
	Location *string

	// The Key Vault encryption identity, if any.
	Identity *EncryptionIdentity

	// The Data Lake Store account properties to use for creating.
	Properties *CreateDataLakeStoreAccountProperties

	// The resource tags.
	Tags map[string]*string
}

type CreateDataLakeStoreAccountProperties struct {
	// The default owner group for all new folders and files created in the Data Lake Store account.
	DefaultGroup *string

	// The Key Vault encryption configuration.
	EncryptionConfig *EncryptionConfig

	// The current state of encryption for this Data Lake Store account.
	EncryptionState *EncryptionState

	// The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled,
	// this is not enforced.
	FirewallAllowAzureIPs *FirewallAllowAzureIPsState

	// The list of firewall rules associated with this Data Lake Store account.
	FirewallRules []*CreateFirewallRuleWithAccountParameters

	// The current state of the IP address firewall for this Data Lake Store account.
	FirewallState *FirewallState

	// The commitment tier to use for next month.
	NewTier *TierType

	// The current state of the trusted identity provider feature for this Data Lake Store account.
	TrustedIDProviderState *TrustedIDProviderState

	// The list of trusted identity providers associated with this Data Lake Store account.
	TrustedIDProviders []*CreateTrustedIDProviderWithAccountParameters

	// The list of virtual network rules associated with this Data Lake Store account.
	VirtualNetworkRules []*CreateVirtualNetworkRuleWithAccountParameters
}

// CreateFirewallRuleWithAccountParameters - The parameters used to create a new firewall rule while creating a new Data Lake
// Store account.
type CreateFirewallRuleWithAccountParameters struct {
	// REQUIRED; The unique name of the firewall rule to create.
	Name *string

	// REQUIRED; The firewall rule properties to use when creating a new firewall rule.
	Properties *CreateOrUpdateFirewallRuleProperties
}

// CreateOrUpdateFirewallRuleParameters - The parameters used to create a new firewall rule.
type CreateOrUpdateFirewallRuleParameters struct {
	// REQUIRED; The firewall rule properties to use when creating a new firewall rule.
	Properties *CreateOrUpdateFirewallRuleProperties
}

// CreateOrUpdateFirewallRuleProperties - The firewall rule properties to use when creating a new firewall rule.
type CreateOrUpdateFirewallRuleProperties struct {
	// REQUIRED; The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same
	// protocol.
	EndIPAddress *string

	// REQUIRED; The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same
	// protocol.
	StartIPAddress *string
}

// CreateOrUpdateTrustedIDProviderParameters - The parameters used to create a new trusted identity provider.
type CreateOrUpdateTrustedIDProviderParameters struct {
	// REQUIRED; The trusted identity provider properties to use when creating a new trusted identity provider.
	Properties *CreateOrUpdateTrustedIDProviderProperties
}

// CreateOrUpdateTrustedIDProviderProperties - The trusted identity provider properties to use when creating a new trusted
// identity provider.
type CreateOrUpdateTrustedIDProviderProperties struct {
	// REQUIRED; The URL of this trusted identity provider.
	IDProvider *string
}

// CreateOrUpdateVirtualNetworkRuleParameters - The parameters used to create a new virtual network rule.
type CreateOrUpdateVirtualNetworkRuleParameters struct {
	// REQUIRED; The virtual network rule properties to use when creating a new virtual network rule.
	Properties *CreateOrUpdateVirtualNetworkRuleProperties
}

// CreateOrUpdateVirtualNetworkRuleProperties - The virtual network rule properties to use when creating a new virtual network
// rule.
type CreateOrUpdateVirtualNetworkRuleProperties struct {
	// REQUIRED; The resource identifier for the subnet.
	SubnetID *string
}

// CreateTrustedIDProviderWithAccountParameters - The parameters used to create a new trusted identity provider while creating
// a new Data Lake Store account.
type CreateTrustedIDProviderWithAccountParameters struct {
	// REQUIRED; The unique name of the trusted identity provider to create.
	Name *string

	// REQUIRED; The trusted identity provider properties to use when creating a new trusted identity provider.
	Properties *CreateOrUpdateTrustedIDProviderProperties
}

// CreateVirtualNetworkRuleWithAccountParameters - The parameters used to create a new virtual network rule while creating
// a new Data Lake Store account.
type CreateVirtualNetworkRuleWithAccountParameters struct {
	// REQUIRED; The unique name of the virtual network rule to create.
	Name *string

	// REQUIRED; The virtual network rule properties to use when creating a new virtual network rule.
	Properties *CreateOrUpdateVirtualNetworkRuleProperties
}

// EncryptionConfig - The encryption configuration for the account.
type EncryptionConfig struct {
	// REQUIRED; The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'.
	Type *EncryptionConfigType

	// The Key Vault information for connecting to user managed encryption keys.
	KeyVaultMetaInfo *KeyVaultMetaInfo
}

// EncryptionIdentity - The encryption identity properties.
type EncryptionIdentity struct {
	// CONSTANT; The type of encryption being used. Currently the only supported type is 'SystemAssigned'.
	// Field has constant value "SystemAssigned", any specified value is ignored.
	Type *string

	// READ-ONLY; The principal identifier associated with the encryption.
	PrincipalID *string

	// READ-ONLY; The tenant identifier associated with the encryption.
	TenantID *string
}

// FirewallRule - Data Lake Store firewall rule information.
type FirewallRule struct {
	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The firewall rule properties.
	Properties *FirewallRuleProperties

	// READ-ONLY; The resource type.
	Type *string
}

// FirewallRuleListResult - Data Lake Store firewall rule list information.
type FirewallRuleListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The results of the list operation.
	Value []*FirewallRule
}

// FirewallRuleProperties - The firewall rule properties.
type FirewallRuleProperties struct {
	// READ-ONLY; The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same
	// protocol.
	EndIPAddress *string

	// READ-ONLY; The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the
	// same protocol.
	StartIPAddress *string
}

// KeyVaultMetaInfo - Metadata information used by account encryption.
type KeyVaultMetaInfo struct {
	// REQUIRED; The name of the user managed encryption key.
	EncryptionKeyName *string

	// REQUIRED; The version of the user managed encryption key.
	EncryptionKeyVersion *string

	// REQUIRED; The resource identifier for the user managed Key Vault being used to encrypt.
	KeyVaultResourceID *string
}

// NameAvailabilityInformation - Data Lake Store account name availability result information.
type NameAvailabilityInformation struct {
	// READ-ONLY; The message describing why the Data Lake Store account name is not available, if nameAvailable is false.
	Message *string

	// READ-ONLY; The Boolean value of true or false to indicate whether the Data Lake Store account name is available or not.
	NameAvailable *bool

	// READ-ONLY; The reason why the Data Lake Store account name is not available, if nameAvailable is false.
	Reason *string
}

// Operation - An available operation for Data Lake Store.
type Operation struct {
	// The display information for the operation.
	Display *OperationDisplay

	// READ-ONLY; The name of the operation.
	Name *string

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin
}

// OperationDisplay - The display information for a particular operation.
type OperationDisplay struct {
	// READ-ONLY; A friendly description of the operation.
	Description *string

	// READ-ONLY; A friendly name of the operation.
	Operation *string

	// READ-ONLY; The resource provider of the operation.
	Provider *string

	// READ-ONLY; The resource type of the operation.
	Resource *string
}

// OperationListResult - The list of available operations for Data Lake Store.
type OperationListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The results of the list operation.
	Value []*Operation
}

// Resource - The resource model definition.
type Resource struct {
	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource location.
	Location *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource type.
	Type *string
}

// SubResource - The resource model definition for a nested resource.
type SubResource struct {
	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// TrustedIDProvider - Data Lake Store trusted identity provider information.
type TrustedIDProvider struct {
	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The trusted identity provider properties.
	Properties *TrustedIDProviderProperties

	// READ-ONLY; The resource type.
	Type *string
}

// TrustedIDProviderListResult - Data Lake Store trusted identity provider list information.
type TrustedIDProviderListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The results of the list operation.
	Value []*TrustedIDProvider
}

// TrustedIDProviderProperties - The trusted identity provider properties.
type TrustedIDProviderProperties struct {
	// READ-ONLY; The URL of this trusted identity provider.
	IDProvider *string
}

// UpdateDataLakeStoreAccountParameters - Data Lake Store account information to update.
type UpdateDataLakeStoreAccountParameters struct {
	// The Data Lake Store account properties to update.
	Properties *UpdateDataLakeStoreAccountProperties

	// Resource tags
	Tags map[string]*string
}

// UpdateDataLakeStoreAccountProperties - Data Lake Store account properties information to be updated.
type UpdateDataLakeStoreAccountProperties struct {
	// The default owner group for all new folders and files created in the Data Lake Store account.
	DefaultGroup *string

	// Used for rotation of user managed Key Vault keys. Can only be used to rotate a user managed encryption Key Vault key.
	EncryptionConfig *UpdateEncryptionConfig

	// The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled,
	// this is not enforced.
	FirewallAllowAzureIPs *FirewallAllowAzureIPsState

	// The list of firewall rules associated with this Data Lake Store account.
	FirewallRules []*UpdateFirewallRuleWithAccountParameters

	// The current state of the IP address firewall for this Data Lake Store account. Disabling the firewall does not remove existing
	// rules, they will just be ignored until the firewall is re-enabled.
	FirewallState *FirewallState

	// The commitment tier to use for next month.
	NewTier *TierType

	// The current state of the trusted identity provider feature for this Data Lake Store account. Disabling trusted identity
	// provider functionality does not remove the providers, they will just be ignored
	// until this feature is re-enabled.
	TrustedIDProviderState *TrustedIDProviderState

	// The list of trusted identity providers associated with this Data Lake Store account.
	TrustedIDProviders []*UpdateTrustedIDProviderWithAccountParameters

	// The list of virtual network rules associated with this Data Lake Store account.
	VirtualNetworkRules []*UpdateVirtualNetworkRuleWithAccountParameters
}

// UpdateEncryptionConfig - The encryption configuration used to update a user managed Key Vault key.
type UpdateEncryptionConfig struct {
	// The updated Key Vault key to use in user managed key rotation.
	KeyVaultMetaInfo *UpdateKeyVaultMetaInfo
}

// UpdateFirewallRuleParameters - The parameters used to update a firewall rule.
type UpdateFirewallRuleParameters struct {
	// The firewall rule properties to use when updating a firewall rule.
	Properties *UpdateFirewallRuleProperties
}

// UpdateFirewallRuleProperties - The firewall rule properties to use when updating a firewall rule.
type UpdateFirewallRuleProperties struct {
	// The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	EndIPAddress *string

	// The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
	StartIPAddress *string
}

// UpdateFirewallRuleWithAccountParameters - The parameters used to update a firewall rule while updating a Data Lake Store
// account.
type UpdateFirewallRuleWithAccountParameters struct {
	// REQUIRED; The unique name of the firewall rule to update.
	Name *string

	// The firewall rule properties to use when updating a firewall rule.
	Properties *UpdateFirewallRuleProperties
}

// UpdateKeyVaultMetaInfo - The Key Vault update information used for user managed key rotation.
type UpdateKeyVaultMetaInfo struct {
	// The version of the user managed encryption key to update through a key rotation.
	EncryptionKeyVersion *string
}

// UpdateTrustedIDProviderParameters - The parameters used to update a trusted identity provider.
type UpdateTrustedIDProviderParameters struct {
	// The trusted identity provider properties to use when updating a trusted identity provider.
	Properties *UpdateTrustedIDProviderProperties
}

// UpdateTrustedIDProviderProperties - The trusted identity provider properties to use when updating a trusted identity provider.
type UpdateTrustedIDProviderProperties struct {
	// The URL of this trusted identity provider.
	IDProvider *string
}

// UpdateTrustedIDProviderWithAccountParameters - The parameters used to update a trusted identity provider while updating
// a Data Lake Store account.
type UpdateTrustedIDProviderWithAccountParameters struct {
	// REQUIRED; The unique name of the trusted identity provider to update.
	Name *string

	// The trusted identity provider properties to use when updating a trusted identity provider.
	Properties *UpdateTrustedIDProviderProperties
}

// UpdateVirtualNetworkRuleParameters - The parameters used to update a virtual network rule.
type UpdateVirtualNetworkRuleParameters struct {
	// The virtual network rule properties to use when updating a virtual network rule.
	Properties *UpdateVirtualNetworkRuleProperties
}

// UpdateVirtualNetworkRuleProperties - The virtual network rule properties to use when updating a virtual network rule.
type UpdateVirtualNetworkRuleProperties struct {
	// The resource identifier for the subnet.
	SubnetID *string
}

// UpdateVirtualNetworkRuleWithAccountParameters - The parameters used to update a virtual network rule while updating a Data
// Lake Store account.
type UpdateVirtualNetworkRuleWithAccountParameters struct {
	// REQUIRED; The unique name of the virtual network rule to update.
	Name *string

	// The virtual network rule properties to use when updating a virtual network rule.
	Properties *UpdateVirtualNetworkRuleProperties
}

// Usage - Describes the Resource Usage.
type Usage struct {
	// READ-ONLY; Gets the current count of the allocated resources in the subscription.
	CurrentValue *int32

	// READ-ONLY; Resource identifier.
	ID *string

	// READ-ONLY; Gets the maximum count of the resources that can be allocated in the subscription.
	Limit *int32

	// READ-ONLY; Gets the name of the type of usage.
	Name *UsageName

	// READ-ONLY; Gets the unit of measurement.
	Unit *UsageUnit
}

// UsageListResult - The response from the List Usages operation.
type UsageListResult struct {
	// Gets or sets the list of Storage Resource Usages.
	Value []*Usage
}

// UsageName - The usage names that can be used.
type UsageName struct {
	// READ-ONLY; Gets a localized string describing the resource name.
	LocalizedValue *string

	// READ-ONLY; Gets a string describing the resource name.
	Value *string
}

// VirtualNetworkRule - Data Lake Store virtual network rule information.
type VirtualNetworkRule struct {
	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The virtual network rule properties.
	Properties *VirtualNetworkRuleProperties

	// READ-ONLY; The resource type.
	Type *string
}

// VirtualNetworkRuleListResult - Data Lake Store virtual network rule list information.
type VirtualNetworkRuleListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The results of the list operation.
	Value []*VirtualNetworkRule
}

// VirtualNetworkRuleProperties - The virtual network rule properties.
type VirtualNetworkRuleProperties struct {
	// READ-ONLY; The resource identifier for the subnet.
	SubnetID *string
}
