//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datalake-analytics/armdatalakeanalytics"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
	"strconv"
)

// StorageAccountsServer is a fake server for instances of the armdatalakeanalytics.StorageAccountsClient type.
type StorageAccountsServer struct {
	// Add is the fake for method StorageAccountsClient.Add
	// HTTP status codes to indicate success: http.StatusOK
	Add func(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, parameters armdatalakeanalytics.AddStorageAccountParameters, options *armdatalakeanalytics.StorageAccountsClientAddOptions) (resp azfake.Responder[armdatalakeanalytics.StorageAccountsClientAddResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method StorageAccountsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, options *armdatalakeanalytics.StorageAccountsClientDeleteOptions) (resp azfake.Responder[armdatalakeanalytics.StorageAccountsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method StorageAccountsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, options *armdatalakeanalytics.StorageAccountsClientGetOptions) (resp azfake.Responder[armdatalakeanalytics.StorageAccountsClientGetResponse], errResp azfake.ErrorResponder)

	// GetStorageContainer is the fake for method StorageAccountsClient.GetStorageContainer
	// HTTP status codes to indicate success: http.StatusOK
	GetStorageContainer func(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, containerName string, options *armdatalakeanalytics.StorageAccountsClientGetStorageContainerOptions) (resp azfake.Responder[armdatalakeanalytics.StorageAccountsClientGetStorageContainerResponse], errResp azfake.ErrorResponder)

	// NewListByAccountPager is the fake for method StorageAccountsClient.NewListByAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAccountPager func(resourceGroupName string, accountName string, options *armdatalakeanalytics.StorageAccountsClientListByAccountOptions) (resp azfake.PagerResponder[armdatalakeanalytics.StorageAccountsClientListByAccountResponse])

	// NewListSasTokensPager is the fake for method StorageAccountsClient.NewListSasTokensPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSasTokensPager func(resourceGroupName string, accountName string, storageAccountName string, containerName string, options *armdatalakeanalytics.StorageAccountsClientListSasTokensOptions) (resp azfake.PagerResponder[armdatalakeanalytics.StorageAccountsClientListSasTokensResponse])

	// NewListStorageContainersPager is the fake for method StorageAccountsClient.NewListStorageContainersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListStorageContainersPager func(resourceGroupName string, accountName string, storageAccountName string, options *armdatalakeanalytics.StorageAccountsClientListStorageContainersOptions) (resp azfake.PagerResponder[armdatalakeanalytics.StorageAccountsClientListStorageContainersResponse])

	// Update is the fake for method StorageAccountsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, accountName string, storageAccountName string, options *armdatalakeanalytics.StorageAccountsClientUpdateOptions) (resp azfake.Responder[armdatalakeanalytics.StorageAccountsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewStorageAccountsServerTransport creates a new instance of StorageAccountsServerTransport with the provided implementation.
// The returned StorageAccountsServerTransport instance is connected to an instance of armdatalakeanalytics.StorageAccountsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStorageAccountsServerTransport(srv *StorageAccountsServer) *StorageAccountsServerTransport {
	return &StorageAccountsServerTransport{
		srv:                           srv,
		newListByAccountPager:         newTracker[azfake.PagerResponder[armdatalakeanalytics.StorageAccountsClientListByAccountResponse]](),
		newListSasTokensPager:         newTracker[azfake.PagerResponder[armdatalakeanalytics.StorageAccountsClientListSasTokensResponse]](),
		newListStorageContainersPager: newTracker[azfake.PagerResponder[armdatalakeanalytics.StorageAccountsClientListStorageContainersResponse]](),
	}
}

// StorageAccountsServerTransport connects instances of armdatalakeanalytics.StorageAccountsClient to instances of StorageAccountsServer.
// Don't use this type directly, use NewStorageAccountsServerTransport instead.
type StorageAccountsServerTransport struct {
	srv                           *StorageAccountsServer
	newListByAccountPager         *tracker[azfake.PagerResponder[armdatalakeanalytics.StorageAccountsClientListByAccountResponse]]
	newListSasTokensPager         *tracker[azfake.PagerResponder[armdatalakeanalytics.StorageAccountsClientListSasTokensResponse]]
	newListStorageContainersPager *tracker[azfake.PagerResponder[armdatalakeanalytics.StorageAccountsClientListStorageContainersResponse]]
}

// Do implements the policy.Transporter interface for StorageAccountsServerTransport.
func (s *StorageAccountsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StorageAccountsClient.Add":
		resp, err = s.dispatchAdd(req)
	case "StorageAccountsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "StorageAccountsClient.Get":
		resp, err = s.dispatchGet(req)
	case "StorageAccountsClient.GetStorageContainer":
		resp, err = s.dispatchGetStorageContainer(req)
	case "StorageAccountsClient.NewListByAccountPager":
		resp, err = s.dispatchNewListByAccountPager(req)
	case "StorageAccountsClient.NewListSasTokensPager":
		resp, err = s.dispatchNewListSasTokensPager(req)
	case "StorageAccountsClient.NewListStorageContainersPager":
		resp, err = s.dispatchNewListStorageContainersPager(req)
	case "StorageAccountsClient.Update":
		resp, err = s.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StorageAccountsServerTransport) dispatchAdd(req *http.Request) (*http.Response, error) {
	if s.srv.Add == nil {
		return nil, &nonRetriableError{errors.New("fake for method Add not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccounts/(?P<storageAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatalakeanalytics.AddStorageAccountParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	storageAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Add(req.Context(), resourceGroupNameParam, accountNameParam, storageAccountNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StorageAccountsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccounts/(?P<storageAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	storageAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, accountNameParam, storageAccountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StorageAccountsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccounts/(?P<storageAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	storageAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, storageAccountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StorageAccountInformation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StorageAccountsServerTransport) dispatchGetStorageContainer(req *http.Request) (*http.Response, error) {
	if s.srv.GetStorageContainer == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetStorageContainer not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccounts/(?P<storageAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	storageAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetStorageContainer(req.Context(), resourceGroupNameParam, accountNameParam, storageAccountNameParam, containerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StorageContainer, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StorageAccountsServerTransport) dispatchNewListByAccountPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAccountPager not implemented")}
	}
	newListByAccountPager := s.newListByAccountPager.get(req)
	if newListByAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccounts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		countUnescaped, err := url.QueryUnescape(qp.Get("$count"))
		if err != nil {
			return nil, err
		}
		countParam, err := parseOptional(countUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armdatalakeanalytics.StorageAccountsClientListByAccountOptions
		if filterParam != nil || topParam != nil || skipParam != nil || selectParam != nil || orderbyParam != nil || countParam != nil {
			options = &armdatalakeanalytics.StorageAccountsClientListByAccountOptions{
				Filter:  filterParam,
				Top:     topParam,
				Skip:    skipParam,
				Select:  selectParam,
				Orderby: orderbyParam,
				Count:   countParam,
			}
		}
		resp := s.srv.NewListByAccountPager(resourceGroupNameParam, accountNameParam, options)
		newListByAccountPager = &resp
		s.newListByAccountPager.add(req, newListByAccountPager)
		server.PagerResponderInjectNextLinks(newListByAccountPager, req, func(page *armdatalakeanalytics.StorageAccountsClientListByAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAccountPager) {
		s.newListByAccountPager.remove(req)
	}
	return resp, nil
}

func (s *StorageAccountsServerTransport) dispatchNewListSasTokensPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSasTokensPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSasTokensPager not implemented")}
	}
	newListSasTokensPager := s.newListSasTokensPager.get(req)
	if newListSasTokensPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccounts/(?P<storageAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSasTokens`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		storageAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListSasTokensPager(resourceGroupNameParam, accountNameParam, storageAccountNameParam, containerNameParam, nil)
		newListSasTokensPager = &resp
		s.newListSasTokensPager.add(req, newListSasTokensPager)
		server.PagerResponderInjectNextLinks(newListSasTokensPager, req, func(page *armdatalakeanalytics.StorageAccountsClientListSasTokensResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSasTokensPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSasTokensPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSasTokensPager) {
		s.newListSasTokensPager.remove(req)
	}
	return resp, nil
}

func (s *StorageAccountsServerTransport) dispatchNewListStorageContainersPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListStorageContainersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListStorageContainersPager not implemented")}
	}
	newListStorageContainersPager := s.newListStorageContainersPager.get(req)
	if newListStorageContainersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccounts/(?P<storageAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		storageAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListStorageContainersPager(resourceGroupNameParam, accountNameParam, storageAccountNameParam, nil)
		newListStorageContainersPager = &resp
		s.newListStorageContainersPager.add(req, newListStorageContainersPager)
		server.PagerResponderInjectNextLinks(newListStorageContainersPager, req, func(page *armdatalakeanalytics.StorageAccountsClientListStorageContainersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListStorageContainersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListStorageContainersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListStorageContainersPager) {
		s.newListStorageContainersPager.remove(req)
	}
	return resp, nil
}

func (s *StorageAccountsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccounts/(?P<storageAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatalakeanalytics.UpdateStorageAccountParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	storageAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountName")])
	if err != nil {
		return nil, err
	}
	var options *armdatalakeanalytics.StorageAccountsClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdatalakeanalytics.StorageAccountsClientUpdateOptions{
			Parameters: &body,
		}
	}
	respr, errRespr := s.srv.Update(req.Context(), resourceGroupNameParam, accountNameParam, storageAccountNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
