//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datadog/armdatadog"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// MonitoredSubscriptionsServer is a fake server for instances of the armdatadog.MonitoredSubscriptionsClient type.
type MonitoredSubscriptionsServer struct {
	// BeginCreateorUpdate is the fake for method MonitoredSubscriptionsClient.BeginCreateorUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateorUpdate func(ctx context.Context, resourceGroupName string, monitorName string, configurationName string, options *armdatadog.MonitoredSubscriptionsClientBeginCreateorUpdateOptions) (resp azfake.PollerResponder[armdatadog.MonitoredSubscriptionsClientCreateorUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method MonitoredSubscriptionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, monitorName string, configurationName string, options *armdatadog.MonitoredSubscriptionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdatadog.MonitoredSubscriptionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MonitoredSubscriptionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, monitorName string, configurationName string, options *armdatadog.MonitoredSubscriptionsClientGetOptions) (resp azfake.Responder[armdatadog.MonitoredSubscriptionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method MonitoredSubscriptionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, monitorName string, options *armdatadog.MonitoredSubscriptionsClientListOptions) (resp azfake.PagerResponder[armdatadog.MonitoredSubscriptionsClientListResponse])

	// BeginUpdate is the fake for method MonitoredSubscriptionsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, monitorName string, configurationName string, options *armdatadog.MonitoredSubscriptionsClientBeginUpdateOptions) (resp azfake.PollerResponder[armdatadog.MonitoredSubscriptionsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewMonitoredSubscriptionsServerTransport creates a new instance of MonitoredSubscriptionsServerTransport with the provided implementation.
// The returned MonitoredSubscriptionsServerTransport instance is connected to an instance of armdatadog.MonitoredSubscriptionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMonitoredSubscriptionsServerTransport(srv *MonitoredSubscriptionsServer) *MonitoredSubscriptionsServerTransport {
	return &MonitoredSubscriptionsServerTransport{
		srv:                 srv,
		beginCreateorUpdate: newTracker[azfake.PollerResponder[armdatadog.MonitoredSubscriptionsClientCreateorUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armdatadog.MonitoredSubscriptionsClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armdatadog.MonitoredSubscriptionsClientListResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armdatadog.MonitoredSubscriptionsClientUpdateResponse]](),
	}
}

// MonitoredSubscriptionsServerTransport connects instances of armdatadog.MonitoredSubscriptionsClient to instances of MonitoredSubscriptionsServer.
// Don't use this type directly, use NewMonitoredSubscriptionsServerTransport instead.
type MonitoredSubscriptionsServerTransport struct {
	srv                 *MonitoredSubscriptionsServer
	beginCreateorUpdate *tracker[azfake.PollerResponder[armdatadog.MonitoredSubscriptionsClientCreateorUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armdatadog.MonitoredSubscriptionsClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armdatadog.MonitoredSubscriptionsClientListResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armdatadog.MonitoredSubscriptionsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for MonitoredSubscriptionsServerTransport.
func (m *MonitoredSubscriptionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MonitoredSubscriptionsClient.BeginCreateorUpdate":
		resp, err = m.dispatchBeginCreateorUpdate(req)
	case "MonitoredSubscriptionsClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "MonitoredSubscriptionsClient.Get":
		resp, err = m.dispatchGet(req)
	case "MonitoredSubscriptionsClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "MonitoredSubscriptionsClient.BeginUpdate":
		resp, err = m.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MonitoredSubscriptionsServerTransport) dispatchBeginCreateorUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateorUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateorUpdate not implemented")}
	}
	beginCreateorUpdate := m.beginCreateorUpdate.get(req)
	if beginCreateorUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/monitoredSubscriptions/(?P<configurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdatadog.MonitoredSubscriptionProperties](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		configurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationName")])
		if err != nil {
			return nil, err
		}
		var options *armdatadog.MonitoredSubscriptionsClientBeginCreateorUpdateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armdatadog.MonitoredSubscriptionsClientBeginCreateorUpdateOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginCreateorUpdate(req.Context(), resourceGroupNameParam, monitorNameParam, configurationNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateorUpdate = &respr
		m.beginCreateorUpdate.add(req, beginCreateorUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateorUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateorUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateorUpdate) {
		m.beginCreateorUpdate.remove(req)
	}

	return resp, nil
}

func (m *MonitoredSubscriptionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/monitoredSubscriptions/(?P<configurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		configurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, monitorNameParam, configurationNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *MonitoredSubscriptionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/monitoredSubscriptions/(?P<configurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	configurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, monitorNameParam, configurationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MonitoredSubscriptionProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitoredSubscriptionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/monitoredSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListPager(resourceGroupNameParam, monitorNameParam, nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *MonitoredSubscriptionsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := m.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/monitoredSubscriptions/(?P<configurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdatadog.MonitoredSubscriptionProperties](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		configurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configurationName")])
		if err != nil {
			return nil, err
		}
		var options *armdatadog.MonitoredSubscriptionsClientBeginUpdateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armdatadog.MonitoredSubscriptionsClientBeginUpdateOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginUpdate(req.Context(), resourceGroupNameParam, monitorNameParam, configurationNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		m.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		m.beginUpdate.remove(req)
	}

	return resp, nil
}
