//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataboxedge

import "encoding/json"

func unmarshalAddonClassification(rawMsg json.RawMessage) (AddonClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AddonClassification
	switch m["kind"] {
	case string(AddonTypeArcForKubernetes):
		b = &ArcAddon{}
	case string(AddonTypeIotEdge):
		b = &IoTAddon{}
	default:
		b = &Addon{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAddonClassificationArray(rawMsg json.RawMessage) ([]AddonClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AddonClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAddonClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalRoleClassification(rawMsg json.RawMessage) (RoleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RoleClassification
	switch m["kind"] {
	case string(RoleTypesCloudEdgeManagement):
		b = &CloudEdgeManagementRole{}
	case string(RoleTypesIOT):
		b = &IoTRole{}
	case string(RoleTypesKubernetes):
		b = &KubernetesRole{}
	case string(RoleTypesMEC):
		b = &MECRole{}
	default:
		b = &Role{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalRoleClassificationArray(rawMsg json.RawMessage) ([]RoleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]RoleClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalRoleClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalTriggerClassification(rawMsg json.RawMessage) (TriggerClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b TriggerClassification
	switch m["kind"] {
	case string(TriggerEventTypeFileEvent):
		b = &FileEventTrigger{}
	case string(TriggerEventTypePeriodicTimerEvent):
		b = &PeriodicTimerEventTrigger{}
	default:
		b = &Trigger{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalTriggerClassificationArray(rawMsg json.RawMessage) ([]TriggerClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]TriggerClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalTriggerClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}
