//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerinsights

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AssignmentPrincipal.
func (a AssignmentPrincipal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", a.PrincipalID)
	populate(objectMap, "principalMetadata", a.PrincipalMetadata)
	populate(objectMap, "principalType", a.PrincipalType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssignmentPrincipal.
func (a *AssignmentPrincipal) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		case "principalMetadata":
			err = unpopulate(val, "PrincipalMetadata", &a.PrincipalMetadata)
			delete(rawMsg, key)
		case "principalType":
			err = unpopulate(val, "PrincipalType", &a.PrincipalType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationPolicy.
func (a AuthorizationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "permissions", a.Permissions)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "primaryKey", a.PrimaryKey)
	populate(objectMap, "secondaryKey", a.SecondaryKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationPolicy.
func (a *AuthorizationPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "permissions":
			err = unpopulate(val, "Permissions", &a.Permissions)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &a.PrimaryKey)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &a.SecondaryKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationPolicyListResult.
func (a AuthorizationPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationPolicyListResult.
func (a *AuthorizationPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationPolicyResourceFormat.
func (a AuthorizationPolicyResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationPolicyResourceFormat.
func (a *AuthorizationPolicyResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobConnectorProperties.
func (a AzureBlobConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionKeyVaultUrl", a.ConnectionKeyVaultURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobConnectorProperties.
func (a *AzureBlobConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionKeyVaultUrl":
			err = unpopulate(val, "ConnectionKeyVaultURL", &a.ConnectionKeyVaultURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CanonicalProfileDefinition.
func (c CanonicalProfileDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canonicalProfileId", c.CanonicalProfileID)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CanonicalProfileDefinition.
func (c *CanonicalProfileDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canonicalProfileId":
			err = unpopulate(val, "CanonicalProfileID", &c.CanonicalProfileID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CanonicalProfileDefinitionPropertiesItem.
func (c CanonicalProfileDefinitionPropertiesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "profileName", c.ProfileName)
	populate(objectMap, "profilePropertyName", c.ProfilePropertyName)
	populate(objectMap, "rank", c.Rank)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CanonicalProfileDefinitionPropertiesItem.
func (c *CanonicalProfileDefinitionPropertiesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "profileName":
			err = unpopulate(val, "ProfileName", &c.ProfileName)
			delete(rawMsg, key)
		case "profilePropertyName":
			err = unpopulate(val, "ProfilePropertyName", &c.ProfilePropertyName)
			delete(rawMsg, key)
		case "rank":
			err = unpopulate(val, "Rank", &c.Rank)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Connector.
func (c Connector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectorId", c.ConnectorID)
	populate(objectMap, "connectorName", c.ConnectorName)
	populate(objectMap, "connectorProperties", c.ConnectorProperties)
	populate(objectMap, "connectorType", c.ConnectorType)
	populateDateTimeRFC3339(objectMap, "created", c.Created)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "isInternal", c.IsInternal)
	populateDateTimeRFC3339(objectMap, "lastModified", c.LastModified)
	populate(objectMap, "state", c.State)
	populate(objectMap, "tenantId", c.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Connector.
func (c *Connector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectorId":
			err = unpopulate(val, "ConnectorID", &c.ConnectorID)
			delete(rawMsg, key)
		case "connectorName":
			err = unpopulate(val, "ConnectorName", &c.ConnectorName)
			delete(rawMsg, key)
		case "connectorProperties":
			err = unpopulate(val, "ConnectorProperties", &c.ConnectorProperties)
			delete(rawMsg, key)
		case "connectorType":
			err = unpopulate(val, "ConnectorType", &c.ConnectorType)
			delete(rawMsg, key)
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &c.Created)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "isInternal":
			err = unpopulate(val, "IsInternal", &c.IsInternal)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateDateTimeRFC3339(val, "LastModified", &c.LastModified)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorListResult.
func (c ConnectorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorListResult.
func (c *ConnectorListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorMapping.
func (c ConnectorMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectorMappingName", c.ConnectorMappingName)
	populate(objectMap, "connectorName", c.ConnectorName)
	populate(objectMap, "connectorType", c.ConnectorType)
	populateDateTimeRFC3339(objectMap, "created", c.Created)
	populate(objectMap, "dataFormatId", c.DataFormatID)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "entityType", c.EntityType)
	populate(objectMap, "entityTypeName", c.EntityTypeName)
	populateDateTimeRFC3339(objectMap, "lastModified", c.LastModified)
	populate(objectMap, "mappingProperties", c.MappingProperties)
	populateDateTimeRFC3339(objectMap, "nextRunTime", c.NextRunTime)
	populate(objectMap, "runId", c.RunID)
	populate(objectMap, "state", c.State)
	populate(objectMap, "tenantId", c.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorMapping.
func (c *ConnectorMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectorMappingName":
			err = unpopulate(val, "ConnectorMappingName", &c.ConnectorMappingName)
			delete(rawMsg, key)
		case "connectorName":
			err = unpopulate(val, "ConnectorName", &c.ConnectorName)
			delete(rawMsg, key)
		case "connectorType":
			err = unpopulate(val, "ConnectorType", &c.ConnectorType)
			delete(rawMsg, key)
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &c.Created)
			delete(rawMsg, key)
		case "dataFormatId":
			err = unpopulate(val, "DataFormatID", &c.DataFormatID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "entityType":
			err = unpopulate(val, "EntityType", &c.EntityType)
			delete(rawMsg, key)
		case "entityTypeName":
			err = unpopulate(val, "EntityTypeName", &c.EntityTypeName)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateDateTimeRFC3339(val, "LastModified", &c.LastModified)
			delete(rawMsg, key)
		case "mappingProperties":
			err = unpopulate(val, "MappingProperties", &c.MappingProperties)
			delete(rawMsg, key)
		case "nextRunTime":
			err = unpopulateDateTimeRFC3339(val, "NextRunTime", &c.NextRunTime)
			delete(rawMsg, key)
		case "runId":
			err = unpopulate(val, "RunID", &c.RunID)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorMappingAvailability.
func (c ConnectorMappingAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "frequency", c.Frequency)
	populate(objectMap, "interval", c.Interval)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorMappingAvailability.
func (c *ConnectorMappingAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "frequency":
			err = unpopulate(val, "Frequency", &c.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &c.Interval)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorMappingCompleteOperation.
func (c ConnectorMappingCompleteOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completionOperationType", c.CompletionOperationType)
	populate(objectMap, "destinationFolder", c.DestinationFolder)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorMappingCompleteOperation.
func (c *ConnectorMappingCompleteOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completionOperationType":
			err = unpopulate(val, "CompletionOperationType", &c.CompletionOperationType)
			delete(rawMsg, key)
		case "destinationFolder":
			err = unpopulate(val, "DestinationFolder", &c.DestinationFolder)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorMappingErrorManagement.
func (c ConnectorMappingErrorManagement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorLimit", c.ErrorLimit)
	populate(objectMap, "errorManagementType", c.ErrorManagementType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorMappingErrorManagement.
func (c *ConnectorMappingErrorManagement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorLimit":
			err = unpopulate(val, "ErrorLimit", &c.ErrorLimit)
			delete(rawMsg, key)
		case "errorManagementType":
			err = unpopulate(val, "ErrorManagementType", &c.ErrorManagementType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorMappingFormat.
func (c ConnectorMappingFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acceptLanguage", c.AcceptLanguage)
	populate(objectMap, "arraySeparator", c.ArraySeparator)
	populate(objectMap, "columnDelimiter", c.ColumnDelimiter)
	objectMap["formatType"] = "TextFormat"
	populate(objectMap, "quoteCharacter", c.QuoteCharacter)
	populate(objectMap, "quoteEscapeCharacter", c.QuoteEscapeCharacter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorMappingFormat.
func (c *ConnectorMappingFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acceptLanguage":
			err = unpopulate(val, "AcceptLanguage", &c.AcceptLanguage)
			delete(rawMsg, key)
		case "arraySeparator":
			err = unpopulate(val, "ArraySeparator", &c.ArraySeparator)
			delete(rawMsg, key)
		case "columnDelimiter":
			err = unpopulate(val, "ColumnDelimiter", &c.ColumnDelimiter)
			delete(rawMsg, key)
		case "formatType":
			err = unpopulate(val, "FormatType", &c.FormatType)
			delete(rawMsg, key)
		case "quoteCharacter":
			err = unpopulate(val, "QuoteCharacter", &c.QuoteCharacter)
			delete(rawMsg, key)
		case "quoteEscapeCharacter":
			err = unpopulate(val, "QuoteEscapeCharacter", &c.QuoteEscapeCharacter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorMappingListResult.
func (c ConnectorMappingListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorMappingListResult.
func (c *ConnectorMappingListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorMappingProperties.
func (c ConnectorMappingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availability", c.Availability)
	populate(objectMap, "completeOperation", c.CompleteOperation)
	populate(objectMap, "errorManagement", c.ErrorManagement)
	populate(objectMap, "fileFilter", c.FileFilter)
	populate(objectMap, "folderPath", c.FolderPath)
	populate(objectMap, "format", c.Format)
	populate(objectMap, "hasHeader", c.HasHeader)
	populate(objectMap, "structure", c.Structure)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorMappingProperties.
func (c *ConnectorMappingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availability":
			err = unpopulate(val, "Availability", &c.Availability)
			delete(rawMsg, key)
		case "completeOperation":
			err = unpopulate(val, "CompleteOperation", &c.CompleteOperation)
			delete(rawMsg, key)
		case "errorManagement":
			err = unpopulate(val, "ErrorManagement", &c.ErrorManagement)
			delete(rawMsg, key)
		case "fileFilter":
			err = unpopulate(val, "FileFilter", &c.FileFilter)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &c.FolderPath)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &c.Format)
			delete(rawMsg, key)
		case "hasHeader":
			err = unpopulate(val, "HasHeader", &c.HasHeader)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &c.Structure)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorMappingResourceFormat.
func (c ConnectorMappingResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorMappingResourceFormat.
func (c *ConnectorMappingResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorMappingStructure.
func (c ConnectorMappingStructure) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columnName", c.ColumnName)
	populate(objectMap, "customFormatSpecifier", c.CustomFormatSpecifier)
	populate(objectMap, "isEncrypted", c.IsEncrypted)
	populate(objectMap, "propertyName", c.PropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorMappingStructure.
func (c *ConnectorMappingStructure) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnName":
			err = unpopulate(val, "ColumnName", &c.ColumnName)
			delete(rawMsg, key)
		case "customFormatSpecifier":
			err = unpopulate(val, "CustomFormatSpecifier", &c.CustomFormatSpecifier)
			delete(rawMsg, key)
		case "isEncrypted":
			err = unpopulate(val, "IsEncrypted", &c.IsEncrypted)
			delete(rawMsg, key)
		case "propertyName":
			err = unpopulate(val, "PropertyName", &c.PropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectorResourceFormat.
func (c ConnectorResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectorResourceFormat.
func (c *ConnectorResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrmConnectorEntities.
func (c CrmConnectorEntities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "isProfile", c.IsProfile)
	populate(objectMap, "logicalName", c.LogicalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrmConnectorEntities.
func (c *CrmConnectorEntities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "isProfile":
			err = unpopulate(val, "IsProfile", &c.IsProfile)
			delete(rawMsg, key)
		case "logicalName":
			err = unpopulate(val, "LogicalName", &c.LogicalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrmConnectorProperties.
func (c CrmConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", c.AccessToken)
	populate(objectMap, "connectionString", c.ConnectionString)
	populate(objectMap, "entities", c.Entities)
	populate(objectMap, "organizationId", c.OrganizationID)
	populate(objectMap, "organizationUrl", c.OrganizationURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrmConnectorProperties.
func (c *CrmConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			err = unpopulate(val, "AccessToken", &c.AccessToken)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &c.ConnectionString)
			delete(rawMsg, key)
		case "entities":
			err = unpopulate(val, "Entities", &c.Entities)
			delete(rawMsg, key)
		case "organizationId":
			err = unpopulate(val, "OrganizationID", &c.OrganizationID)
			delete(rawMsg, key)
		case "organizationUrl":
			err = unpopulate(val, "OrganizationURL", &c.OrganizationURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataSource.
func (d DataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataSourceReferenceId", d.DataSourceReferenceID)
	populate(objectMap, "dataSourceType", d.DataSourceType)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataSource.
func (d *DataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSourceReferenceId":
			err = unpopulate(val, "DataSourceReferenceID", &d.DataSourceReferenceID)
			delete(rawMsg, key)
		case "dataSourceType":
			err = unpopulate(val, "DataSourceType", &d.DataSourceType)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataSourcePrecedence.
func (d DataSourcePrecedence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataSource", d.DataSource)
	populate(objectMap, "precedence", d.Precedence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataSourcePrecedence.
func (d *DataSourcePrecedence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSource":
			err = unpopulate(val, "DataSource", &d.DataSource)
			delete(rawMsg, key)
		case "precedence":
			err = unpopulate(val, "Precedence", &d.Precedence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnrichingKpi.
func (e EnrichingKpi) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aliases", e.Aliases)
	populate(objectMap, "calculationWindow", e.CalculationWindow)
	populate(objectMap, "calculationWindowFieldName", e.CalculationWindowFieldName)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "displayName", e.DisplayName)
	populate(objectMap, "entityType", e.EntityType)
	populate(objectMap, "entityTypeName", e.EntityTypeName)
	populate(objectMap, "expression", e.Expression)
	populate(objectMap, "extracts", e.Extracts)
	populate(objectMap, "filter", e.Filter)
	populate(objectMap, "function", e.Function)
	populate(objectMap, "groupBy", e.GroupBy)
	populate(objectMap, "groupByMetadata", e.GroupByMetadata)
	populate(objectMap, "kpiName", e.KpiName)
	populate(objectMap, "participantProfilesMetadata", e.ParticipantProfilesMetadata)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "tenantId", e.TenantID)
	populate(objectMap, "thresHolds", e.ThresHolds)
	populate(objectMap, "unit", e.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnrichingKpi.
func (e *EnrichingKpi) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aliases":
			err = unpopulate(val, "Aliases", &e.Aliases)
			delete(rawMsg, key)
		case "calculationWindow":
			err = unpopulate(val, "CalculationWindow", &e.CalculationWindow)
			delete(rawMsg, key)
		case "calculationWindowFieldName":
			err = unpopulate(val, "CalculationWindowFieldName", &e.CalculationWindowFieldName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &e.DisplayName)
			delete(rawMsg, key)
		case "entityType":
			err = unpopulate(val, "EntityType", &e.EntityType)
			delete(rawMsg, key)
		case "entityTypeName":
			err = unpopulate(val, "EntityTypeName", &e.EntityTypeName)
			delete(rawMsg, key)
		case "expression":
			err = unpopulate(val, "Expression", &e.Expression)
			delete(rawMsg, key)
		case "extracts":
			err = unpopulate(val, "Extracts", &e.Extracts)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &e.Filter)
			delete(rawMsg, key)
		case "function":
			err = unpopulate(val, "Function", &e.Function)
			delete(rawMsg, key)
		case "groupBy":
			err = unpopulate(val, "GroupBy", &e.GroupBy)
			delete(rawMsg, key)
		case "groupByMetadata":
			err = unpopulate(val, "GroupByMetadata", &e.GroupByMetadata)
			delete(rawMsg, key)
		case "kpiName":
			err = unpopulate(val, "KpiName", &e.KpiName)
			delete(rawMsg, key)
		case "participantProfilesMetadata":
			err = unpopulate(val, "ParticipantProfilesMetadata", &e.ParticipantProfilesMetadata)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &e.TenantID)
			delete(rawMsg, key)
		case "thresHolds":
			err = unpopulate(val, "ThresHolds", &e.ThresHolds)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &e.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EntityTypeDefinition.
func (e EntityTypeDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiEntitySetName", e.APIEntitySetName)
	populate(objectMap, "attributes", e.Attributes)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "displayName", e.DisplayName)
	populate(objectMap, "entityType", e.EntityType)
	populate(objectMap, "fields", e.Fields)
	populate(objectMap, "instancesCount", e.InstancesCount)
	populate(objectMap, "largeImage", e.LargeImage)
	populateDateTimeRFC3339(objectMap, "lastChangedUtc", e.LastChangedUTC)
	populate(objectMap, "localizedAttributes", e.LocalizedAttributes)
	populate(objectMap, "mediumImage", e.MediumImage)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "schemaItemTypeLink", e.SchemaItemTypeLink)
	populate(objectMap, "smallImage", e.SmallImage)
	populate(objectMap, "tenantId", e.TenantID)
	populate(objectMap, "timestampFieldName", e.TimestampFieldName)
	populate(objectMap, "typeName", e.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EntityTypeDefinition.
func (e *EntityTypeDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiEntitySetName":
			err = unpopulate(val, "APIEntitySetName", &e.APIEntitySetName)
			delete(rawMsg, key)
		case "attributes":
			err = unpopulate(val, "Attributes", &e.Attributes)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &e.DisplayName)
			delete(rawMsg, key)
		case "entityType":
			err = unpopulate(val, "EntityType", &e.EntityType)
			delete(rawMsg, key)
		case "fields":
			err = unpopulate(val, "Fields", &e.Fields)
			delete(rawMsg, key)
		case "instancesCount":
			err = unpopulate(val, "InstancesCount", &e.InstancesCount)
			delete(rawMsg, key)
		case "largeImage":
			err = unpopulate(val, "LargeImage", &e.LargeImage)
			delete(rawMsg, key)
		case "lastChangedUtc":
			err = unpopulateDateTimeRFC3339(val, "LastChangedUTC", &e.LastChangedUTC)
			delete(rawMsg, key)
		case "localizedAttributes":
			err = unpopulate(val, "LocalizedAttributes", &e.LocalizedAttributes)
			delete(rawMsg, key)
		case "mediumImage":
			err = unpopulate(val, "MediumImage", &e.MediumImage)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "schemaItemTypeLink":
			err = unpopulate(val, "SchemaItemTypeLink", &e.SchemaItemTypeLink)
			delete(rawMsg, key)
		case "smallImage":
			err = unpopulate(val, "SmallImage", &e.SmallImage)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &e.TenantID)
			delete(rawMsg, key)
		case "timestampFieldName":
			err = unpopulate(val, "TimestampFieldName", &e.TimestampFieldName)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &e.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetImageUploadURLInput.
func (g GetImageUploadURLInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entityType", g.EntityType)
	populate(objectMap, "entityTypeName", g.EntityTypeName)
	populate(objectMap, "relativePath", g.RelativePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetImageUploadURLInput.
func (g *GetImageUploadURLInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityType":
			err = unpopulate(val, "EntityType", &g.EntityType)
			delete(rawMsg, key)
		case "entityTypeName":
			err = unpopulate(val, "EntityTypeName", &g.EntityTypeName)
			delete(rawMsg, key)
		case "relativePath":
			err = unpopulate(val, "RelativePath", &g.RelativePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Hub.
func (h Hub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "location", h.Location)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "tags", h.Tags)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Hub.
func (h *Hub) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &h.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &h.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubBillingInfoFormat.
func (h HubBillingInfoFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxUnits", h.MaxUnits)
	populate(objectMap, "minUnits", h.MinUnits)
	populate(objectMap, "skuName", h.SKUName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubBillingInfoFormat.
func (h *HubBillingInfoFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxUnits":
			err = unpopulate(val, "MaxUnits", &h.MaxUnits)
			delete(rawMsg, key)
		case "minUnits":
			err = unpopulate(val, "MinUnits", &h.MinUnits)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &h.SKUName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubListResult.
func (h HubListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubListResult.
func (h *HubListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubPropertiesFormat.
func (h HubPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiEndpoint", h.APIEndpoint)
	populate(objectMap, "hubBillingInfo", h.HubBillingInfo)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "tenantFeatures", h.TenantFeatures)
	populate(objectMap, "webEndpoint", h.WebEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubPropertiesFormat.
func (h *HubPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiEndpoint":
			err = unpopulate(val, "APIEndpoint", &h.APIEndpoint)
			delete(rawMsg, key)
		case "hubBillingInfo":
			err = unpopulate(val, "HubBillingInfo", &h.HubBillingInfo)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "tenantFeatures":
			err = unpopulate(val, "TenantFeatures", &h.TenantFeatures)
			delete(rawMsg, key)
		case "webEndpoint":
			err = unpopulate(val, "WebEndpoint", &h.WebEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageDefinition.
func (i ImageDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentUrl", i.ContentURL)
	populate(objectMap, "imageExists", i.ImageExists)
	populate(objectMap, "relativePath", i.RelativePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageDefinition.
func (i *ImageDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentUrl":
			err = unpopulate(val, "ContentURL", &i.ContentURL)
			delete(rawMsg, key)
		case "imageExists":
			err = unpopulate(val, "ImageExists", &i.ImageExists)
			delete(rawMsg, key)
		case "relativePath":
			err = unpopulate(val, "RelativePath", &i.RelativePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InteractionListResult.
func (i InteractionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InteractionListResult.
func (i *InteractionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InteractionResourceFormat.
func (i InteractionResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InteractionResourceFormat.
func (i *InteractionResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InteractionTypeDefinition.
func (i InteractionTypeDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiEntitySetName", i.APIEntitySetName)
	populate(objectMap, "attributes", i.Attributes)
	populate(objectMap, "dataSourcePrecedenceRules", i.DataSourcePrecedenceRules)
	populate(objectMap, "defaultDataSource", i.DefaultDataSource)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "displayName", i.DisplayName)
	populate(objectMap, "entityType", i.EntityType)
	populate(objectMap, "fields", i.Fields)
	populate(objectMap, "idPropertyNames", i.IDPropertyNames)
	populate(objectMap, "instancesCount", i.InstancesCount)
	populate(objectMap, "isActivity", i.IsActivity)
	populate(objectMap, "largeImage", i.LargeImage)
	populateDateTimeRFC3339(objectMap, "lastChangedUtc", i.LastChangedUTC)
	populate(objectMap, "localizedAttributes", i.LocalizedAttributes)
	populate(objectMap, "mediumImage", i.MediumImage)
	populate(objectMap, "participantProfiles", i.ParticipantProfiles)
	populate(objectMap, "primaryParticipantProfilePropertyName", i.PrimaryParticipantProfilePropertyName)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "schemaItemTypeLink", i.SchemaItemTypeLink)
	populate(objectMap, "smallImage", i.SmallImage)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "timestampFieldName", i.TimestampFieldName)
	populate(objectMap, "typeName", i.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InteractionTypeDefinition.
func (i *InteractionTypeDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiEntitySetName":
			err = unpopulate(val, "APIEntitySetName", &i.APIEntitySetName)
			delete(rawMsg, key)
		case "attributes":
			err = unpopulate(val, "Attributes", &i.Attributes)
			delete(rawMsg, key)
		case "dataSourcePrecedenceRules":
			err = unpopulate(val, "DataSourcePrecedenceRules", &i.DataSourcePrecedenceRules)
			delete(rawMsg, key)
		case "defaultDataSource":
			err = unpopulate(val, "DefaultDataSource", &i.DefaultDataSource)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &i.DisplayName)
			delete(rawMsg, key)
		case "entityType":
			err = unpopulate(val, "EntityType", &i.EntityType)
			delete(rawMsg, key)
		case "fields":
			err = unpopulate(val, "Fields", &i.Fields)
			delete(rawMsg, key)
		case "idPropertyNames":
			err = unpopulate(val, "IDPropertyNames", &i.IDPropertyNames)
			delete(rawMsg, key)
		case "instancesCount":
			err = unpopulate(val, "InstancesCount", &i.InstancesCount)
			delete(rawMsg, key)
		case "isActivity":
			err = unpopulate(val, "IsActivity", &i.IsActivity)
			delete(rawMsg, key)
		case "largeImage":
			err = unpopulate(val, "LargeImage", &i.LargeImage)
			delete(rawMsg, key)
		case "lastChangedUtc":
			err = unpopulateDateTimeRFC3339(val, "LastChangedUTC", &i.LastChangedUTC)
			delete(rawMsg, key)
		case "localizedAttributes":
			err = unpopulate(val, "LocalizedAttributes", &i.LocalizedAttributes)
			delete(rawMsg, key)
		case "mediumImage":
			err = unpopulate(val, "MediumImage", &i.MediumImage)
			delete(rawMsg, key)
		case "participantProfiles":
			err = unpopulate(val, "ParticipantProfiles", &i.ParticipantProfiles)
			delete(rawMsg, key)
		case "primaryParticipantProfilePropertyName":
			err = unpopulate(val, "PrimaryParticipantProfilePropertyName", &i.PrimaryParticipantProfilePropertyName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "schemaItemTypeLink":
			err = unpopulate(val, "SchemaItemTypeLink", &i.SchemaItemTypeLink)
			delete(rawMsg, key)
		case "smallImage":
			err = unpopulate(val, "SmallImage", &i.SmallImage)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		case "timestampFieldName":
			err = unpopulate(val, "TimestampFieldName", &i.TimestampFieldName)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &i.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KpiAlias.
func (k KpiAlias) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aliasName", k.AliasName)
	populate(objectMap, "expression", k.Expression)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KpiAlias.
func (k *KpiAlias) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aliasName":
			err = unpopulate(val, "AliasName", &k.AliasName)
			delete(rawMsg, key)
		case "expression":
			err = unpopulate(val, "Expression", &k.Expression)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KpiDefinition.
func (k KpiDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aliases", k.Aliases)
	populate(objectMap, "calculationWindow", k.CalculationWindow)
	populate(objectMap, "calculationWindowFieldName", k.CalculationWindowFieldName)
	populate(objectMap, "description", k.Description)
	populate(objectMap, "displayName", k.DisplayName)
	populate(objectMap, "entityType", k.EntityType)
	populate(objectMap, "entityTypeName", k.EntityTypeName)
	populate(objectMap, "expression", k.Expression)
	populate(objectMap, "extracts", k.Extracts)
	populate(objectMap, "filter", k.Filter)
	populate(objectMap, "function", k.Function)
	populate(objectMap, "groupBy", k.GroupBy)
	populate(objectMap, "groupByMetadata", k.GroupByMetadata)
	populate(objectMap, "kpiName", k.KpiName)
	populate(objectMap, "participantProfilesMetadata", k.ParticipantProfilesMetadata)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	populate(objectMap, "tenantId", k.TenantID)
	populate(objectMap, "thresHolds", k.ThresHolds)
	populate(objectMap, "unit", k.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KpiDefinition.
func (k *KpiDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aliases":
			err = unpopulate(val, "Aliases", &k.Aliases)
			delete(rawMsg, key)
		case "calculationWindow":
			err = unpopulate(val, "CalculationWindow", &k.CalculationWindow)
			delete(rawMsg, key)
		case "calculationWindowFieldName":
			err = unpopulate(val, "CalculationWindowFieldName", &k.CalculationWindowFieldName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &k.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &k.DisplayName)
			delete(rawMsg, key)
		case "entityType":
			err = unpopulate(val, "EntityType", &k.EntityType)
			delete(rawMsg, key)
		case "entityTypeName":
			err = unpopulate(val, "EntityTypeName", &k.EntityTypeName)
			delete(rawMsg, key)
		case "expression":
			err = unpopulate(val, "Expression", &k.Expression)
			delete(rawMsg, key)
		case "extracts":
			err = unpopulate(val, "Extracts", &k.Extracts)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &k.Filter)
			delete(rawMsg, key)
		case "function":
			err = unpopulate(val, "Function", &k.Function)
			delete(rawMsg, key)
		case "groupBy":
			err = unpopulate(val, "GroupBy", &k.GroupBy)
			delete(rawMsg, key)
		case "groupByMetadata":
			err = unpopulate(val, "GroupByMetadata", &k.GroupByMetadata)
			delete(rawMsg, key)
		case "kpiName":
			err = unpopulate(val, "KpiName", &k.KpiName)
			delete(rawMsg, key)
		case "participantProfilesMetadata":
			err = unpopulate(val, "ParticipantProfilesMetadata", &k.ParticipantProfilesMetadata)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &k.TenantID)
			delete(rawMsg, key)
		case "thresHolds":
			err = unpopulate(val, "ThresHolds", &k.ThresHolds)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &k.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KpiExtract.
func (k KpiExtract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expression", k.Expression)
	populate(objectMap, "extractName", k.ExtractName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KpiExtract.
func (k *KpiExtract) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expression":
			err = unpopulate(val, "Expression", &k.Expression)
			delete(rawMsg, key)
		case "extractName":
			err = unpopulate(val, "ExtractName", &k.ExtractName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KpiGroupByMetadata.
func (k KpiGroupByMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", k.DisplayName)
	populate(objectMap, "fieldName", k.FieldName)
	populate(objectMap, "fieldType", k.FieldType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KpiGroupByMetadata.
func (k *KpiGroupByMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &k.DisplayName)
			delete(rawMsg, key)
		case "fieldName":
			err = unpopulate(val, "FieldName", &k.FieldName)
			delete(rawMsg, key)
		case "fieldType":
			err = unpopulate(val, "FieldType", &k.FieldType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KpiListResult.
func (k KpiListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", k.NextLink)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KpiListResult.
func (k *KpiListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &k.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KpiParticipantProfilesMetadata.
func (k KpiParticipantProfilesMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "typeName", k.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KpiParticipantProfilesMetadata.
func (k *KpiParticipantProfilesMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "typeName":
			err = unpopulate(val, "TypeName", &k.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KpiResourceFormat.
func (k KpiResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KpiResourceFormat.
func (k *KpiResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KpiThresholds.
func (k KpiThresholds) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "increasingKpi", k.IncreasingKpi)
	populate(objectMap, "lowerLimit", k.LowerLimit)
	populate(objectMap, "upperLimit", k.UpperLimit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KpiThresholds.
func (k *KpiThresholds) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "increasingKpi":
			err = unpopulate(val, "IncreasingKpi", &k.IncreasingKpi)
			delete(rawMsg, key)
		case "lowerLimit":
			err = unpopulate(val, "LowerLimit", &k.LowerLimit)
			delete(rawMsg, key)
		case "upperLimit":
			err = unpopulate(val, "UpperLimit", &k.UpperLimit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkDefinition.
func (l LinkDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "linkName", l.LinkName)
	populate(objectMap, "mappings", l.Mappings)
	populate(objectMap, "operationType", l.OperationType)
	populate(objectMap, "participantPropertyReferences", l.ParticipantPropertyReferences)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "referenceOnly", l.ReferenceOnly)
	populate(objectMap, "sourceEntityType", l.SourceEntityType)
	populate(objectMap, "sourceEntityTypeName", l.SourceEntityTypeName)
	populate(objectMap, "targetEntityType", l.TargetEntityType)
	populate(objectMap, "targetEntityTypeName", l.TargetEntityTypeName)
	populate(objectMap, "tenantId", l.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkDefinition.
func (l *LinkDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "linkName":
			err = unpopulate(val, "LinkName", &l.LinkName)
			delete(rawMsg, key)
		case "mappings":
			err = unpopulate(val, "Mappings", &l.Mappings)
			delete(rawMsg, key)
		case "operationType":
			err = unpopulate(val, "OperationType", &l.OperationType)
			delete(rawMsg, key)
		case "participantPropertyReferences":
			err = unpopulate(val, "ParticipantPropertyReferences", &l.ParticipantPropertyReferences)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "referenceOnly":
			err = unpopulate(val, "ReferenceOnly", &l.ReferenceOnly)
			delete(rawMsg, key)
		case "sourceEntityType":
			err = unpopulate(val, "SourceEntityType", &l.SourceEntityType)
			delete(rawMsg, key)
		case "sourceEntityTypeName":
			err = unpopulate(val, "SourceEntityTypeName", &l.SourceEntityTypeName)
			delete(rawMsg, key)
		case "targetEntityType":
			err = unpopulate(val, "TargetEntityType", &l.TargetEntityType)
			delete(rawMsg, key)
		case "targetEntityTypeName":
			err = unpopulate(val, "TargetEntityTypeName", &l.TargetEntityTypeName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &l.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkListResult.
func (l LinkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkListResult.
func (l *LinkListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkResourceFormat.
func (l LinkResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkResourceFormat.
func (l *LinkResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetadataDefinitionBase.
func (m MetadataDefinitionBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", m.Attributes)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "largeImage", m.LargeImage)
	populate(objectMap, "localizedAttributes", m.LocalizedAttributes)
	populate(objectMap, "mediumImage", m.MediumImage)
	populate(objectMap, "smallImage", m.SmallImage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetadataDefinitionBase.
func (m *MetadataDefinitionBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &m.Attributes)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "largeImage":
			err = unpopulate(val, "LargeImage", &m.LargeImage)
			delete(rawMsg, key)
		case "localizedAttributes":
			err = unpopulate(val, "LocalizedAttributes", &m.LocalizedAttributes)
			delete(rawMsg, key)
		case "mediumImage":
			err = unpopulate(val, "MediumImage", &m.MediumImage)
			delete(rawMsg, key)
		case "smallImage":
			err = unpopulate(val, "SmallImage", &m.SmallImage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Participant.
func (p Participant) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "participantName", p.ParticipantName)
	populate(objectMap, "participantPropertyReferences", p.ParticipantPropertyReferences)
	populate(objectMap, "profileTypeName", p.ProfileTypeName)
	populate(objectMap, "role", p.Role)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Participant.
func (p *Participant) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "participantName":
			err = unpopulate(val, "ParticipantName", &p.ParticipantName)
			delete(rawMsg, key)
		case "participantPropertyReferences":
			err = unpopulate(val, "ParticipantPropertyReferences", &p.ParticipantPropertyReferences)
			delete(rawMsg, key)
		case "profileTypeName":
			err = unpopulate(val, "ProfileTypeName", &p.ProfileTypeName)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &p.Role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ParticipantProfilePropertyReference.
func (p ParticipantProfilePropertyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "interactionPropertyName", p.InteractionPropertyName)
	populate(objectMap, "profilePropertyName", p.ProfilePropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ParticipantProfilePropertyReference.
func (p *ParticipantProfilePropertyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "interactionPropertyName":
			err = unpopulate(val, "InteractionPropertyName", &p.InteractionPropertyName)
			delete(rawMsg, key)
		case "profilePropertyName":
			err = unpopulate(val, "ProfilePropertyName", &p.ProfilePropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ParticipantPropertyReference.
func (p ParticipantPropertyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourcePropertyName", p.SourcePropertyName)
	populate(objectMap, "targetPropertyName", p.TargetPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ParticipantPropertyReference.
func (p *ParticipantPropertyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourcePropertyName":
			err = unpopulate(val, "SourcePropertyName", &p.SourcePropertyName)
			delete(rawMsg, key)
		case "targetPropertyName":
			err = unpopulate(val, "TargetPropertyName", &p.TargetPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Prediction.
func (p Prediction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoAnalyze", p.AutoAnalyze)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "grades", p.Grades)
	populate(objectMap, "involvedInteractionTypes", p.InvolvedInteractionTypes)
	populate(objectMap, "involvedKpiTypes", p.InvolvedKpiTypes)
	populate(objectMap, "involvedRelationships", p.InvolvedRelationships)
	populate(objectMap, "mappings", p.Mappings)
	populate(objectMap, "negativeOutcomeExpression", p.NegativeOutcomeExpression)
	populate(objectMap, "positiveOutcomeExpression", p.PositiveOutcomeExpression)
	populate(objectMap, "predictionName", p.PredictionName)
	populate(objectMap, "primaryProfileType", p.PrimaryProfileType)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "scopeExpression", p.ScopeExpression)
	populate(objectMap, "scoreLabel", p.ScoreLabel)
	populate(objectMap, "systemGeneratedEntities", p.SystemGeneratedEntities)
	populate(objectMap, "tenantId", p.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Prediction.
func (p *Prediction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoAnalyze":
			err = unpopulate(val, "AutoAnalyze", &p.AutoAnalyze)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "grades":
			err = unpopulate(val, "Grades", &p.Grades)
			delete(rawMsg, key)
		case "involvedInteractionTypes":
			err = unpopulate(val, "InvolvedInteractionTypes", &p.InvolvedInteractionTypes)
			delete(rawMsg, key)
		case "involvedKpiTypes":
			err = unpopulate(val, "InvolvedKpiTypes", &p.InvolvedKpiTypes)
			delete(rawMsg, key)
		case "involvedRelationships":
			err = unpopulate(val, "InvolvedRelationships", &p.InvolvedRelationships)
			delete(rawMsg, key)
		case "mappings":
			err = unpopulate(val, "Mappings", &p.Mappings)
			delete(rawMsg, key)
		case "negativeOutcomeExpression":
			err = unpopulate(val, "NegativeOutcomeExpression", &p.NegativeOutcomeExpression)
			delete(rawMsg, key)
		case "positiveOutcomeExpression":
			err = unpopulate(val, "PositiveOutcomeExpression", &p.PositiveOutcomeExpression)
			delete(rawMsg, key)
		case "predictionName":
			err = unpopulate(val, "PredictionName", &p.PredictionName)
			delete(rawMsg, key)
		case "primaryProfileType":
			err = unpopulate(val, "PrimaryProfileType", &p.PrimaryProfileType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "scopeExpression":
			err = unpopulate(val, "ScopeExpression", &p.ScopeExpression)
			delete(rawMsg, key)
		case "scoreLabel":
			err = unpopulate(val, "ScoreLabel", &p.ScoreLabel)
			delete(rawMsg, key)
		case "systemGeneratedEntities":
			err = unpopulate(val, "SystemGeneratedEntities", &p.SystemGeneratedEntities)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &p.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredictionDistributionDefinition.
func (p PredictionDistributionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "distributions", p.Distributions)
	populate(objectMap, "totalNegatives", p.TotalNegatives)
	populate(objectMap, "totalPositives", p.TotalPositives)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredictionDistributionDefinition.
func (p *PredictionDistributionDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "distributions":
			err = unpopulate(val, "Distributions", &p.Distributions)
			delete(rawMsg, key)
		case "totalNegatives":
			err = unpopulate(val, "TotalNegatives", &p.TotalNegatives)
			delete(rawMsg, key)
		case "totalPositives":
			err = unpopulate(val, "TotalPositives", &p.TotalPositives)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredictionDistributionDefinitionDistributionsItem.
func (p PredictionDistributionDefinitionDistributionsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "negatives", p.Negatives)
	populate(objectMap, "negativesAboveThreshold", p.NegativesAboveThreshold)
	populate(objectMap, "positives", p.Positives)
	populate(objectMap, "positivesAboveThreshold", p.PositivesAboveThreshold)
	populate(objectMap, "scoreThreshold", p.ScoreThreshold)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredictionDistributionDefinitionDistributionsItem.
func (p *PredictionDistributionDefinitionDistributionsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "negatives":
			err = unpopulate(val, "Negatives", &p.Negatives)
			delete(rawMsg, key)
		case "negativesAboveThreshold":
			err = unpopulate(val, "NegativesAboveThreshold", &p.NegativesAboveThreshold)
			delete(rawMsg, key)
		case "positives":
			err = unpopulate(val, "Positives", &p.Positives)
			delete(rawMsg, key)
		case "positivesAboveThreshold":
			err = unpopulate(val, "PositivesAboveThreshold", &p.PositivesAboveThreshold)
			delete(rawMsg, key)
		case "scoreThreshold":
			err = unpopulate(val, "ScoreThreshold", &p.ScoreThreshold)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredictionGradesItem.
func (p PredictionGradesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "gradeName", p.GradeName)
	populate(objectMap, "maxScoreThreshold", p.MaxScoreThreshold)
	populate(objectMap, "minScoreThreshold", p.MinScoreThreshold)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredictionGradesItem.
func (p *PredictionGradesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "gradeName":
			err = unpopulate(val, "GradeName", &p.GradeName)
			delete(rawMsg, key)
		case "maxScoreThreshold":
			err = unpopulate(val, "MaxScoreThreshold", &p.MaxScoreThreshold)
			delete(rawMsg, key)
		case "minScoreThreshold":
			err = unpopulate(val, "MinScoreThreshold", &p.MinScoreThreshold)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredictionListResult.
func (p PredictionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredictionListResult.
func (p *PredictionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredictionMappings.
func (p PredictionMappings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "grade", p.Grade)
	populate(objectMap, "reason", p.Reason)
	populate(objectMap, "score", p.Score)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredictionMappings.
func (p *PredictionMappings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "grade":
			err = unpopulate(val, "Grade", &p.Grade)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &p.Reason)
			delete(rawMsg, key)
		case "score":
			err = unpopulate(val, "Score", &p.Score)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredictionModelStatus.
func (p PredictionModelStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", p.Message)
	populate(objectMap, "modelVersion", p.ModelVersion)
	populate(objectMap, "predictionGuidId", p.PredictionGUIDID)
	populate(objectMap, "predictionName", p.PredictionName)
	populate(objectMap, "signalsUsed", p.SignalsUsed)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "tenantId", p.TenantID)
	populate(objectMap, "testSetCount", p.TestSetCount)
	populate(objectMap, "trainingAccuracy", p.TrainingAccuracy)
	populate(objectMap, "trainingSetCount", p.TrainingSetCount)
	populate(objectMap, "validationSetCount", p.ValidationSetCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredictionModelStatus.
func (p *PredictionModelStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &p.Message)
			delete(rawMsg, key)
		case "modelVersion":
			err = unpopulate(val, "ModelVersion", &p.ModelVersion)
			delete(rawMsg, key)
		case "predictionGuidId":
			err = unpopulate(val, "PredictionGUIDID", &p.PredictionGUIDID)
			delete(rawMsg, key)
		case "predictionName":
			err = unpopulate(val, "PredictionName", &p.PredictionName)
			delete(rawMsg, key)
		case "signalsUsed":
			err = unpopulate(val, "SignalsUsed", &p.SignalsUsed)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &p.TenantID)
			delete(rawMsg, key)
		case "testSetCount":
			err = unpopulate(val, "TestSetCount", &p.TestSetCount)
			delete(rawMsg, key)
		case "trainingAccuracy":
			err = unpopulate(val, "TrainingAccuracy", &p.TrainingAccuracy)
			delete(rawMsg, key)
		case "trainingSetCount":
			err = unpopulate(val, "TrainingSetCount", &p.TrainingSetCount)
			delete(rawMsg, key)
		case "validationSetCount":
			err = unpopulate(val, "ValidationSetCount", &p.ValidationSetCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredictionResourceFormat.
func (p PredictionResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredictionResourceFormat.
func (p *PredictionResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredictionSystemGeneratedEntities.
func (p PredictionSystemGeneratedEntities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "generatedInteractionTypes", p.GeneratedInteractionTypes)
	populate(objectMap, "generatedKpis", p.GeneratedKpis)
	populate(objectMap, "generatedLinks", p.GeneratedLinks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredictionSystemGeneratedEntities.
func (p *PredictionSystemGeneratedEntities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "generatedInteractionTypes":
			err = unpopulate(val, "GeneratedInteractionTypes", &p.GeneratedInteractionTypes)
			delete(rawMsg, key)
		case "generatedKpis":
			err = unpopulate(val, "GeneratedKpis", &p.GeneratedKpis)
			delete(rawMsg, key)
		case "generatedLinks":
			err = unpopulate(val, "GeneratedLinks", &p.GeneratedLinks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PredictionTrainingResults.
func (p PredictionTrainingResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canonicalProfiles", p.CanonicalProfiles)
	populate(objectMap, "predictionDistribution", p.PredictionDistribution)
	populate(objectMap, "primaryProfileInstanceCount", p.PrimaryProfileInstanceCount)
	populate(objectMap, "scoreName", p.ScoreName)
	populate(objectMap, "tenantId", p.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PredictionTrainingResults.
func (p *PredictionTrainingResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canonicalProfiles":
			err = unpopulate(val, "CanonicalProfiles", &p.CanonicalProfiles)
			delete(rawMsg, key)
		case "predictionDistribution":
			err = unpopulate(val, "PredictionDistribution", &p.PredictionDistribution)
			delete(rawMsg, key)
		case "primaryProfileInstanceCount":
			err = unpopulate(val, "PrimaryProfileInstanceCount", &p.PrimaryProfileInstanceCount)
			delete(rawMsg, key)
		case "scoreName":
			err = unpopulate(val, "ScoreName", &p.ScoreName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &p.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileEnumValidValuesFormat.
func (p ProfileEnumValidValuesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValueNames", p.LocalizedValueNames)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileEnumValidValuesFormat.
func (p *ProfileEnumValidValuesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValueNames":
			err = unpopulate(val, "LocalizedValueNames", &p.LocalizedValueNames)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileListResult.
func (p ProfileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileListResult.
func (p *ProfileListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileResourceFormat.
func (p ProfileResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileResourceFormat.
func (p *ProfileResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileTypeDefinition.
func (p ProfileTypeDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiEntitySetName", p.APIEntitySetName)
	populate(objectMap, "attributes", p.Attributes)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "entityType", p.EntityType)
	populate(objectMap, "fields", p.Fields)
	populate(objectMap, "instancesCount", p.InstancesCount)
	populate(objectMap, "largeImage", p.LargeImage)
	populateDateTimeRFC3339(objectMap, "lastChangedUtc", p.LastChangedUTC)
	populate(objectMap, "localizedAttributes", p.LocalizedAttributes)
	populate(objectMap, "mediumImage", p.MediumImage)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "schemaItemTypeLink", p.SchemaItemTypeLink)
	populate(objectMap, "smallImage", p.SmallImage)
	populate(objectMap, "strongIds", p.StrongIDs)
	populate(objectMap, "tenantId", p.TenantID)
	populate(objectMap, "timestampFieldName", p.TimestampFieldName)
	populate(objectMap, "typeName", p.TypeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileTypeDefinition.
func (p *ProfileTypeDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiEntitySetName":
			err = unpopulate(val, "APIEntitySetName", &p.APIEntitySetName)
			delete(rawMsg, key)
		case "attributes":
			err = unpopulate(val, "Attributes", &p.Attributes)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "entityType":
			err = unpopulate(val, "EntityType", &p.EntityType)
			delete(rawMsg, key)
		case "fields":
			err = unpopulate(val, "Fields", &p.Fields)
			delete(rawMsg, key)
		case "instancesCount":
			err = unpopulate(val, "InstancesCount", &p.InstancesCount)
			delete(rawMsg, key)
		case "largeImage":
			err = unpopulate(val, "LargeImage", &p.LargeImage)
			delete(rawMsg, key)
		case "lastChangedUtc":
			err = unpopulateDateTimeRFC3339(val, "LastChangedUTC", &p.LastChangedUTC)
			delete(rawMsg, key)
		case "localizedAttributes":
			err = unpopulate(val, "LocalizedAttributes", &p.LocalizedAttributes)
			delete(rawMsg, key)
		case "mediumImage":
			err = unpopulate(val, "MediumImage", &p.MediumImage)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "schemaItemTypeLink":
			err = unpopulate(val, "SchemaItemTypeLink", &p.SchemaItemTypeLink)
			delete(rawMsg, key)
		case "smallImage":
			err = unpopulate(val, "SmallImage", &p.SmallImage)
			delete(rawMsg, key)
		case "strongIds":
			err = unpopulate(val, "StrongIDs", &p.StrongIDs)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &p.TenantID)
			delete(rawMsg, key)
		case "timestampFieldName":
			err = unpopulate(val, "TimestampFieldName", &p.TimestampFieldName)
			delete(rawMsg, key)
		case "typeName":
			err = unpopulate(val, "TypeName", &p.TypeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PropertyDefinition.
func (p PropertyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arrayValueSeparator", p.ArrayValueSeparator)
	populate(objectMap, "dataSourcePrecedenceRules", p.DataSourcePrecedenceRules)
	populate(objectMap, "enumValidValues", p.EnumValidValues)
	populate(objectMap, "fieldName", p.FieldName)
	populate(objectMap, "fieldType", p.FieldType)
	populate(objectMap, "isArray", p.IsArray)
	populate(objectMap, "isAvailableInGraph", p.IsAvailableInGraph)
	populate(objectMap, "isEnum", p.IsEnum)
	populate(objectMap, "isFlagEnum", p.IsFlagEnum)
	populate(objectMap, "isImage", p.IsImage)
	populate(objectMap, "isLocalizedString", p.IsLocalizedString)
	populate(objectMap, "isName", p.IsName)
	populate(objectMap, "isRequired", p.IsRequired)
	populate(objectMap, "maxLength", p.MaxLength)
	populate(objectMap, "propertyId", p.PropertyID)
	populate(objectMap, "schemaItemPropLink", p.SchemaItemPropLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PropertyDefinition.
func (p *PropertyDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arrayValueSeparator":
			err = unpopulate(val, "ArrayValueSeparator", &p.ArrayValueSeparator)
			delete(rawMsg, key)
		case "dataSourcePrecedenceRules":
			err = unpopulate(val, "DataSourcePrecedenceRules", &p.DataSourcePrecedenceRules)
			delete(rawMsg, key)
		case "enumValidValues":
			err = unpopulate(val, "EnumValidValues", &p.EnumValidValues)
			delete(rawMsg, key)
		case "fieldName":
			err = unpopulate(val, "FieldName", &p.FieldName)
			delete(rawMsg, key)
		case "fieldType":
			err = unpopulate(val, "FieldType", &p.FieldType)
			delete(rawMsg, key)
		case "isArray":
			err = unpopulate(val, "IsArray", &p.IsArray)
			delete(rawMsg, key)
		case "isAvailableInGraph":
			err = unpopulate(val, "IsAvailableInGraph", &p.IsAvailableInGraph)
			delete(rawMsg, key)
		case "isEnum":
			err = unpopulate(val, "IsEnum", &p.IsEnum)
			delete(rawMsg, key)
		case "isFlagEnum":
			err = unpopulate(val, "IsFlagEnum", &p.IsFlagEnum)
			delete(rawMsg, key)
		case "isImage":
			err = unpopulate(val, "IsImage", &p.IsImage)
			delete(rawMsg, key)
		case "isLocalizedString":
			err = unpopulate(val, "IsLocalizedString", &p.IsLocalizedString)
			delete(rawMsg, key)
		case "isName":
			err = unpopulate(val, "IsName", &p.IsName)
			delete(rawMsg, key)
		case "isRequired":
			err = unpopulate(val, "IsRequired", &p.IsRequired)
			delete(rawMsg, key)
		case "maxLength":
			err = unpopulate(val, "MaxLength", &p.MaxLength)
			delete(rawMsg, key)
		case "propertyId":
			err = unpopulate(val, "PropertyID", &p.PropertyID)
			delete(rawMsg, key)
		case "schemaItemPropLink":
			err = unpopulate(val, "SchemaItemPropLink", &p.SchemaItemPropLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipDefinition.
func (r RelationshipDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cardinality", r.Cardinality)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "displayName", r.DisplayName)
	populateDateTimeRFC3339(objectMap, "expiryDateTimeUtc", r.ExpiryDateTimeUTC)
	populate(objectMap, "fields", r.Fields)
	populate(objectMap, "lookupMappings", r.LookupMappings)
	populate(objectMap, "profileType", r.ProfileType)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "relatedProfileType", r.RelatedProfileType)
	populate(objectMap, "relationshipGuidId", r.RelationshipGUIDID)
	populate(objectMap, "relationshipName", r.RelationshipName)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipDefinition.
func (r *RelationshipDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cardinality":
			err = unpopulate(val, "Cardinality", &r.Cardinality)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "expiryDateTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "ExpiryDateTimeUTC", &r.ExpiryDateTimeUTC)
			delete(rawMsg, key)
		case "fields":
			err = unpopulate(val, "Fields", &r.Fields)
			delete(rawMsg, key)
		case "lookupMappings":
			err = unpopulate(val, "LookupMappings", &r.LookupMappings)
			delete(rawMsg, key)
		case "profileType":
			err = unpopulate(val, "ProfileType", &r.ProfileType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "relatedProfileType":
			err = unpopulate(val, "RelatedProfileType", &r.RelatedProfileType)
			delete(rawMsg, key)
		case "relationshipGuidId":
			err = unpopulate(val, "RelationshipGUIDID", &r.RelationshipGUIDID)
			delete(rawMsg, key)
		case "relationshipName":
			err = unpopulate(val, "RelationshipName", &r.RelationshipName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipLinkDefinition.
func (r RelationshipLinkDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "interactionType", r.InteractionType)
	populate(objectMap, "linkName", r.LinkName)
	populate(objectMap, "mappings", r.Mappings)
	populate(objectMap, "profilePropertyReferences", r.ProfilePropertyReferences)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "relatedProfilePropertyReferences", r.RelatedProfilePropertyReferences)
	populate(objectMap, "relationshipGuidId", r.RelationshipGUIDID)
	populate(objectMap, "relationshipName", r.RelationshipName)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipLinkDefinition.
func (r *RelationshipLinkDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "interactionType":
			err = unpopulate(val, "InteractionType", &r.InteractionType)
			delete(rawMsg, key)
		case "linkName":
			err = unpopulate(val, "LinkName", &r.LinkName)
			delete(rawMsg, key)
		case "mappings":
			err = unpopulate(val, "Mappings", &r.Mappings)
			delete(rawMsg, key)
		case "profilePropertyReferences":
			err = unpopulate(val, "ProfilePropertyReferences", &r.ProfilePropertyReferences)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "relatedProfilePropertyReferences":
			err = unpopulate(val, "RelatedProfilePropertyReferences", &r.RelatedProfilePropertyReferences)
			delete(rawMsg, key)
		case "relationshipGuidId":
			err = unpopulate(val, "RelationshipGUIDID", &r.RelationshipGUIDID)
			delete(rawMsg, key)
		case "relationshipName":
			err = unpopulate(val, "RelationshipName", &r.RelationshipName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipLinkFieldMapping.
func (r RelationshipLinkFieldMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "interactionFieldName", r.InteractionFieldName)
	populate(objectMap, "linkType", r.LinkType)
	populate(objectMap, "relationshipFieldName", r.RelationshipFieldName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipLinkFieldMapping.
func (r *RelationshipLinkFieldMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "interactionFieldName":
			err = unpopulate(val, "InteractionFieldName", &r.InteractionFieldName)
			delete(rawMsg, key)
		case "linkType":
			err = unpopulate(val, "LinkType", &r.LinkType)
			delete(rawMsg, key)
		case "relationshipFieldName":
			err = unpopulate(val, "RelationshipFieldName", &r.RelationshipFieldName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipLinkListResult.
func (r RelationshipLinkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipLinkListResult.
func (r *RelationshipLinkListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipLinkResourceFormat.
func (r RelationshipLinkResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipLinkResourceFormat.
func (r *RelationshipLinkResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipListResult.
func (r RelationshipListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipListResult.
func (r *RelationshipListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipResourceFormat.
func (r RelationshipResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipResourceFormat.
func (r *RelationshipResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipTypeFieldMapping.
func (r RelationshipTypeFieldMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "profileFieldName", r.ProfileFieldName)
	populate(objectMap, "relatedProfileKeyProperty", r.RelatedProfileKeyProperty)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipTypeFieldMapping.
func (r *RelationshipTypeFieldMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "profileFieldName":
			err = unpopulate(val, "ProfileFieldName", &r.ProfileFieldName)
			delete(rawMsg, key)
		case "relatedProfileKeyProperty":
			err = unpopulate(val, "RelatedProfileKeyProperty", &r.RelatedProfileKeyProperty)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipTypeMapping.
func (r RelationshipTypeMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fieldMappings", r.FieldMappings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipTypeMapping.
func (r *RelationshipTypeMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fieldMappings":
			err = unpopulate(val, "FieldMappings", &r.FieldMappings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationshipsLookup.
func (r RelationshipsLookup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "existingRelationshipName", r.ExistingRelationshipName)
	populate(objectMap, "profileName", r.ProfileName)
	populate(objectMap, "profilePropertyReferences", r.ProfilePropertyReferences)
	populate(objectMap, "relatedProfileName", r.RelatedProfileName)
	populate(objectMap, "relatedProfilePropertyReferences", r.RelatedProfilePropertyReferences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationshipsLookup.
func (r *RelationshipsLookup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "existingRelationshipName":
			err = unpopulate(val, "ExistingRelationshipName", &r.ExistingRelationshipName)
			delete(rawMsg, key)
		case "profileName":
			err = unpopulate(val, "ProfileName", &r.ProfileName)
			delete(rawMsg, key)
		case "profilePropertyReferences":
			err = unpopulate(val, "ProfilePropertyReferences", &r.ProfilePropertyReferences)
			delete(rawMsg, key)
		case "relatedProfileName":
			err = unpopulate(val, "RelatedProfileName", &r.RelatedProfileName)
			delete(rawMsg, key)
		case "relatedProfilePropertyReferences":
			err = unpopulate(val, "RelatedProfilePropertyReferences", &r.RelatedProfilePropertyReferences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSetDescription.
func (r ResourceSetDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "elements", r.Elements)
	populate(objectMap, "exceptions", r.Exceptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSetDescription.
func (r *ResourceSetDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "elements":
			err = unpopulate(val, "Elements", &r.Elements)
			delete(rawMsg, key)
		case "exceptions":
			err = unpopulate(val, "Exceptions", &r.Exceptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Role.
func (r Role) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "roleName", r.RoleName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Role.
func (r *Role) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "roleName":
			err = unpopulate(val, "RoleName", &r.RoleName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignment.
func (r RoleAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignmentName", r.AssignmentName)
	populate(objectMap, "conflationPolicies", r.ConflationPolicies)
	populate(objectMap, "connectors", r.Connectors)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "interactions", r.Interactions)
	populate(objectMap, "kpis", r.Kpis)
	populate(objectMap, "links", r.Links)
	populate(objectMap, "principals", r.Principals)
	populate(objectMap, "profiles", r.Profiles)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "relationshipLinks", r.RelationshipLinks)
	populate(objectMap, "relationships", r.Relationships)
	populate(objectMap, "role", r.Role)
	populate(objectMap, "roleAssignments", r.RoleAssignments)
	populate(objectMap, "sasPolicies", r.SasPolicies)
	populate(objectMap, "segments", r.Segments)
	populate(objectMap, "tenantId", r.TenantID)
	populate(objectMap, "views", r.Views)
	populate(objectMap, "widgetTypes", r.WidgetTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignment.
func (r *RoleAssignment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignmentName":
			err = unpopulate(val, "AssignmentName", &r.AssignmentName)
			delete(rawMsg, key)
		case "conflationPolicies":
			err = unpopulate(val, "ConflationPolicies", &r.ConflationPolicies)
			delete(rawMsg, key)
		case "connectors":
			err = unpopulate(val, "Connectors", &r.Connectors)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "interactions":
			err = unpopulate(val, "Interactions", &r.Interactions)
			delete(rawMsg, key)
		case "kpis":
			err = unpopulate(val, "Kpis", &r.Kpis)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &r.Links)
			delete(rawMsg, key)
		case "principals":
			err = unpopulate(val, "Principals", &r.Principals)
			delete(rawMsg, key)
		case "profiles":
			err = unpopulate(val, "Profiles", &r.Profiles)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "relationshipLinks":
			err = unpopulate(val, "RelationshipLinks", &r.RelationshipLinks)
			delete(rawMsg, key)
		case "relationships":
			err = unpopulate(val, "Relationships", &r.Relationships)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &r.Role)
			delete(rawMsg, key)
		case "roleAssignments":
			err = unpopulate(val, "RoleAssignments", &r.RoleAssignments)
			delete(rawMsg, key)
		case "sasPolicies":
			err = unpopulate(val, "SasPolicies", &r.SasPolicies)
			delete(rawMsg, key)
		case "segments":
			err = unpopulate(val, "Segments", &r.Segments)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		case "views":
			err = unpopulate(val, "Views", &r.Views)
			delete(rawMsg, key)
		case "widgetTypes":
			err = unpopulate(val, "WidgetTypes", &r.WidgetTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentListResult.
func (r RoleAssignmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentListResult.
func (r *RoleAssignmentListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentResourceFormat.
func (r RoleAssignmentResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentResourceFormat.
func (r *RoleAssignmentResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleListResult.
func (r RoleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleListResult.
func (r *RoleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleResourceFormat.
func (r RoleResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleResourceFormat.
func (r *RoleResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SalesforceConnectorProperties.
func (s SalesforceConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "salesforcetables", s.Salesforcetables)
	populate(objectMap, "usersetting", s.Usersetting)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SalesforceConnectorProperties.
func (s *SalesforceConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "salesforcetables":
			err = unpopulate(val, "Salesforcetables", &s.Salesforcetables)
			delete(rawMsg, key)
		case "usersetting":
			err = unpopulate(val, "Usersetting", &s.Usersetting)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SalesforceDiscoverSetting.
func (s SalesforceDiscoverSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "salesforceConnectionStringSecretUrl", s.SalesforceConnectionStringSecretURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SalesforceDiscoverSetting.
func (s *SalesforceDiscoverSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "salesforceConnectionStringSecretUrl":
			err = unpopulate(val, "SalesforceConnectionStringSecretURL", &s.SalesforceConnectionStringSecretURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SalesforceTable.
func (s SalesforceTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isProfile", s.IsProfile)
	populate(objectMap, "tableCategory", s.TableCategory)
	populate(objectMap, "tableName", s.TableName)
	populate(objectMap, "tableRemarks", s.TableRemarks)
	populate(objectMap, "tableSchema", s.TableSchema)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SalesforceTable.
func (s *SalesforceTable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isProfile":
			err = unpopulate(val, "IsProfile", &s.IsProfile)
			delete(rawMsg, key)
		case "tableCategory":
			err = unpopulate(val, "TableCategory", &s.TableCategory)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &s.TableName)
			delete(rawMsg, key)
		case "tableRemarks":
			err = unpopulate(val, "TableRemarks", &s.TableRemarks)
			delete(rawMsg, key)
		case "tableSchema":
			err = unpopulate(val, "TableSchema", &s.TableSchema)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StrongID.
func (s StrongID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "keyPropertyNames", s.KeyPropertyNames)
	populate(objectMap, "strongIdName", s.StrongIDName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StrongID.
func (s *StrongID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "keyPropertyNames":
			err = unpopulate(val, "KeyPropertyNames", &s.KeyPropertyNames)
			delete(rawMsg, key)
		case "strongIdName":
			err = unpopulate(val, "StrongIDName", &s.StrongIDName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SuggestRelationshipLinksResponse.
func (s SuggestRelationshipLinksResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "interactionName", s.InteractionName)
	populate(objectMap, "suggestedRelationships", s.SuggestedRelationships)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SuggestRelationshipLinksResponse.
func (s *SuggestRelationshipLinksResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "interactionName":
			err = unpopulate(val, "InteractionName", &s.InteractionName)
			delete(rawMsg, key)
		case "suggestedRelationships":
			err = unpopulate(val, "SuggestedRelationships", &s.SuggestedRelationships)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TypePropertiesMapping.
func (t TypePropertiesMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkType", t.LinkType)
	populate(objectMap, "sourcePropertyName", t.SourcePropertyName)
	populate(objectMap, "targetPropertyName", t.TargetPropertyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TypePropertiesMapping.
func (t *TypePropertiesMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkType":
			err = unpopulate(val, "LinkType", &t.LinkType)
			delete(rawMsg, key)
		case "sourcePropertyName":
			err = unpopulate(val, "SourcePropertyName", &t.SourcePropertyName)
			delete(rawMsg, key)
		case "targetPropertyName":
			err = unpopulate(val, "TargetPropertyName", &t.TargetPropertyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type View.
func (v View) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changed", v.Changed)
	populateDateTimeRFC3339(objectMap, "created", v.Created)
	populate(objectMap, "definition", v.Definition)
	populate(objectMap, "displayName", v.DisplayName)
	populate(objectMap, "tenantId", v.TenantID)
	populate(objectMap, "userId", v.UserID)
	populate(objectMap, "viewName", v.ViewName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type View.
func (v *View) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changed":
			err = unpopulateDateTimeRFC3339(val, "Changed", &v.Changed)
			delete(rawMsg, key)
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &v.Created)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &v.Definition)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &v.DisplayName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &v.TenantID)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &v.UserID)
			delete(rawMsg, key)
		case "viewName":
			err = unpopulate(val, "ViewName", &v.ViewName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ViewListResult.
func (v ViewListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ViewListResult.
func (v *ViewListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ViewResourceFormat.
func (v ViewResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ViewResourceFormat.
func (v *ViewResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WidgetType.
func (w WidgetType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "changed", w.Changed)
	populateDateTimeRFC3339(objectMap, "created", w.Created)
	populate(objectMap, "definition", w.Definition)
	populate(objectMap, "description", w.Description)
	populate(objectMap, "displayName", w.DisplayName)
	populate(objectMap, "imageUrl", w.ImageURL)
	populate(objectMap, "tenantId", w.TenantID)
	populate(objectMap, "widgetTypeName", w.WidgetTypeName)
	populate(objectMap, "widgetVersion", w.WidgetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WidgetType.
func (w *WidgetType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changed":
			err = unpopulateDateTimeRFC3339(val, "Changed", &w.Changed)
			delete(rawMsg, key)
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &w.Created)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &w.Definition)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &w.DisplayName)
			delete(rawMsg, key)
		case "imageUrl":
			err = unpopulate(val, "ImageURL", &w.ImageURL)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &w.TenantID)
			delete(rawMsg, key)
		case "widgetTypeName":
			err = unpopulate(val, "WidgetTypeName", &w.WidgetTypeName)
			delete(rawMsg, key)
		case "widgetVersion":
			err = unpopulate(val, "WidgetVersion", &w.WidgetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WidgetTypeListResult.
func (w WidgetTypeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WidgetTypeListResult.
func (w *WidgetTypeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WidgetTypeResourceFormat.
func (w WidgetTypeResourceFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WidgetTypeResourceFormat.
func (w *WidgetTypeResourceFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
