//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerinsights

import "time"

// AssignmentPrincipal - The AssignmentPrincipal
type AssignmentPrincipal struct {
	// REQUIRED; The principal id being assigned to.
	PrincipalID *string

	// REQUIRED; The Type of the principal ID.
	PrincipalType *string

	// Other metadata for the principal.
	PrincipalMetadata map[string]*string
}

// AuthorizationPolicy - The authorization policy.
type AuthorizationPolicy struct {
	// REQUIRED; The permissions associated with the policy.
	Permissions []*PermissionTypes

	// Primary key associated with the policy.
	PrimaryKey *string

	// Secondary key associated with the policy.
	SecondaryKey *string

	// READ-ONLY; Name of the policy.
	PolicyName *string
}

// AuthorizationPolicyListResult - The response of list authorization policy operation.
type AuthorizationPolicyListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*AuthorizationPolicyResourceFormat
}

// AuthorizationPolicyResourceFormat - The authorization policy resource format.
type AuthorizationPolicyResourceFormat struct {
	// The authorization policy.
	Properties *AuthorizationPolicy

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AzureBlobConnectorProperties - The Azure Blob connector properties.
type AzureBlobConnectorProperties struct {
	// REQUIRED; The connection KeyVault URL.
	ConnectionKeyVaultURL *string
}

// CanonicalProfileDefinition - Definition of canonical profile.
type CanonicalProfileDefinition struct {
	// Canonical profile ID.
	CanonicalProfileID *int32

	// Properties of the canonical profile.
	Properties []*CanonicalProfileDefinitionPropertiesItem
}

// CanonicalProfileDefinitionPropertiesItem - The definition of a canonical profile property.
type CanonicalProfileDefinitionPropertiesItem struct {
	// Profile name.
	ProfileName *string

	// Property name of profile.
	ProfilePropertyName *string

	// The rank.
	Rank *int32

	// Type of canonical property value.
	Type *CanonicalPropertyValueType

	// Value of the canonical property.
	Value *string
}

// Connector - Properties of connector.
type Connector struct {
	// REQUIRED; The connector properties.
	ConnectorProperties map[string]any

	// REQUIRED; Type of connector.
	ConnectorType *ConnectorTypes

	// Name of the connector.
	ConnectorName *string

	// Description of the connector.
	Description *string

	// Display name of the connector.
	DisplayName *string

	// If this is an internal connector.
	IsInternal *bool

	// READ-ONLY; ID of the connector.
	ConnectorID *int32

	// READ-ONLY; The created time.
	Created *time.Time

	// READ-ONLY; The last modified time.
	LastModified *time.Time

	// READ-ONLY; State of connector.
	State *ConnectorStates

	// READ-ONLY; The hub name.
	TenantID *string
}

// ConnectorListResult - The response of list connector operation.
type ConnectorListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*ConnectorResourceFormat
}

// ConnectorMapping - The connector mapping definition.
type ConnectorMapping struct {
	// REQUIRED; Defines which entity type the file should map to.
	EntityType *EntityTypes

	// REQUIRED; The mapping entity name.
	EntityTypeName *string

	// REQUIRED; The properties of the mapping.
	MappingProperties *ConnectorMappingProperties

	// Type of connector.
	ConnectorType *ConnectorTypes

	// The description of the connector mapping.
	Description *string

	// Display name for the connector mapping.
	DisplayName *string

	// READ-ONLY; The connector mapping name
	ConnectorMappingName *string

	// READ-ONLY; The connector name.
	ConnectorName *string

	// READ-ONLY; The created time.
	Created *time.Time

	// READ-ONLY; The DataFormat ID.
	DataFormatID *string

	// READ-ONLY; The last modified time.
	LastModified *time.Time

	// READ-ONLY; The next run time based on customer's settings.
	NextRunTime *time.Time

	// READ-ONLY; The RunId.
	RunID *string

	// READ-ONLY; State of connector mapping.
	State *ConnectorMappingStates

	// READ-ONLY; The hub name.
	TenantID *string
}

// ConnectorMappingAvailability - Connector mapping property availability.
type ConnectorMappingAvailability struct {
	// REQUIRED; The interval of the given frequency to use.
	Interval *int32

	// The frequency to update.
	Frequency *FrequencyTypes
}

// ConnectorMappingCompleteOperation - The complete operation.
type ConnectorMappingCompleteOperation struct {
	// The type of completion operation.
	CompletionOperationType *CompletionOperationTypes

	// The destination folder where files will be moved to once the import is done.
	DestinationFolder *string
}

// ConnectorMappingErrorManagement - The error management.
type ConnectorMappingErrorManagement struct {
	// REQUIRED; The type of error management to use for the mapping.
	ErrorManagementType *ErrorManagementTypes

	// The error limit allowed while importing data.
	ErrorLimit *int32
}

// ConnectorMappingFormat - Connector mapping property format.
type ConnectorMappingFormat struct {
	// CONSTANT; The type mapping format.
	// Field has constant value "TextFormat", any specified value is ignored.
	FormatType *string

	// The oData language.
	AcceptLanguage *string

	// Character separating array elements.
	ArraySeparator *string

	// The character that signifies a break between columns.
	ColumnDelimiter *string

	// Quote character, used to indicate enquoted fields.
	QuoteCharacter *string

	// Escape character for quotes, can be the same as the quoteCharacter.
	QuoteEscapeCharacter *string
}

// ConnectorMappingListResult - The response of list connector mapping operation.
type ConnectorMappingListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*ConnectorMappingResourceFormat
}

// ConnectorMappingProperties - The connector mapping properties.
type ConnectorMappingProperties struct {
	// REQUIRED; The availability of mapping property.
	Availability *ConnectorMappingAvailability

	// REQUIRED; The operation after import is done.
	CompleteOperation *ConnectorMappingCompleteOperation

	// REQUIRED; The error management setting for the mapping.
	ErrorManagement *ConnectorMappingErrorManagement

	// REQUIRED; The format of mapping property.
	Format *ConnectorMappingFormat

	// REQUIRED; Ingestion mapping information at property level.
	Structure []*ConnectorMappingStructure

	// The file filter for the mapping.
	FileFilter *string

	// The folder path for the mapping.
	FolderPath *string

	// If the file contains a header or not.
	HasHeader *bool
}

// ConnectorMappingResourceFormat - The connector mapping resource format.
type ConnectorMappingResourceFormat struct {
	// The connector mapping definition.
	Properties *ConnectorMapping

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ConnectorMappingStructure - Connector mapping property structure.
type ConnectorMappingStructure struct {
	// REQUIRED; The column name of the import file.
	ColumnName *string

	// REQUIRED; The property name of the mapping entity.
	PropertyName *string

	// Custom format specifier for input parsing.
	CustomFormatSpecifier *string

	// Indicates if the column is encrypted.
	IsEncrypted *bool
}

// ConnectorResourceFormat - The connector resource format.
type ConnectorResourceFormat struct {
	// Properties of connector.
	Properties *Connector

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CrmConnectorEntities - The CRM connector entities.
type CrmConnectorEntities struct {
	// REQUIRED; The logical name.
	LogicalName *string

	// The display name.
	DisplayName *string

	// Indicating whether this is profile.
	IsProfile *bool
}

// CrmConnectorProperties - The CRM connector properties.
type CrmConnectorProperties struct {
	// REQUIRED; The entities like account, contact, opportunity.
	Entities []*CrmConnectorEntities

	// REQUIRED; The organization ID.
	OrganizationID *string

	// REQUIRED; The organization URL.
	OrganizationURL *string

	// The access token.
	AccessToken *string

	// The connection string.
	ConnectionString *string
}

// DataSource - Data Source is a way for us to know the source of instances. A single type can have data coming in from multiple
// places. In activities we use this to determine precedence rules.
type DataSource struct {
	// READ-ONLY; The data source reference id.
	DataSourceReferenceID *string

	// READ-ONLY; The data source type.
	DataSourceType *DataSourceType

	// READ-ONLY; The data source ID.
	ID *int32

	// READ-ONLY; The data source name
	Name *string

	// READ-ONLY; The data source status.
	Status *Status
}

// DataSourcePrecedence - The data source precedence is a way to know the precedence of each data source.
type DataSourcePrecedence struct {
	// Data Source is a way for us to know the source of instances. A single type can have data coming in from multiple places.
	// In activities we use this to determine precedence rules.
	DataSource *DataSource

	// the precedence value.
	Precedence *int32
}

// EnrichingKpi - The enriching KPI definition.
type EnrichingKpi struct {
	// REQUIRED; The calculation window.
	CalculationWindow *CalculationWindowTypes

	// REQUIRED; The mapping entity type.
	EntityType *EntityTypes

	// REQUIRED; The mapping entity name.
	EntityTypeName *string

	// REQUIRED; The computation expression for the KPI.
	Expression *string

	// REQUIRED; The computation function for the KPI.
	Function *KpiFunctions

	// The aliases.
	Aliases []*KpiAlias

	// Name of calculation window field.
	CalculationWindowFieldName *string

	// Localized description for the KPI.
	Description map[string]*string

	// Localized display name for the KPI.
	DisplayName map[string]*string

	// The KPI extracts.
	Extracts []*KpiExtract

	// The filter expression for the KPI.
	Filter *string

	// the group by properties for the KPI.
	GroupBy []*string

	// The KPI thresholds.
	ThresHolds *KpiThresholds

	// The unit of measurement for the KPI.
	Unit *string

	// READ-ONLY; The KPI GroupByMetadata.
	GroupByMetadata []*KpiGroupByMetadata

	// READ-ONLY; The KPI name.
	KpiName *string

	// READ-ONLY; The participant profiles.
	ParticipantProfilesMetadata []*KpiParticipantProfilesMetadata

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; The hub name.
	TenantID *string
}

// EntityTypeDefinition - Describes an entity.
type EntityTypeDefinition struct {
	// The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
	APIEntitySetName *string

	// The attributes for the Type.
	Attributes map[string][]*string

	// Localized descriptions for the property.
	Description map[string]*string

	// Localized display names for the property.
	DisplayName map[string]*string

	// Type of entity.
	EntityType *EntityTypes

	// The properties of the Profile.
	Fields []*PropertyDefinition

	// The instance count.
	InstancesCount *int32

	// Large Image associated with the Property or EntityType.
	LargeImage *string

	// Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string

	// Medium Image associated with the Property or EntityType.
	MediumImage *string

	// The schema org link. This helps ACI identify and suggest semantic models.
	SchemaItemTypeLink *string

	// Small Image associated with the Property or EntityType.
	SmallImage *string

	// The timestamp property name. Represents the time when the interaction or profile update happened.
	TimestampFieldName *string

	// The name of the entity.
	TypeName *string

	// READ-ONLY; The last changed time for the type definition.
	LastChangedUTC *time.Time

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; The hub name.
	TenantID *string
}

// GetImageUploadURLInput - Input type for getting image upload url.
type GetImageUploadURLInput struct {
	// Type of entity. Can be Profile or Interaction.
	EntityType *string

	// Name of the entity type.
	EntityTypeName *string

	// Relative path of the image.
	RelativePath *string
}

// Hub resource.
type Hub struct {
	// Resource location.
	Location *string

	// Properties of hub.
	Properties *HubPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// HubBillingInfoFormat - Hub billing info.
type HubBillingInfoFormat struct {
	// The maximum number of units can be used. One unit is 10,000 Profiles and 100,000 Interactions.
	MaxUnits *int32

	// The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
	MinUnits *int32

	// The sku name.
	SKUName *string
}

// HubListResult - Response of list hub operation.
type HubListResult struct {
	// Link for next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*Hub
}

// HubPropertiesFormat - Properties of hub.
type HubPropertiesFormat struct {
	// Billing settings of the hub.
	HubBillingInfo *HubBillingInfoFormat

	// The bit flags for enabled hub features. Bit 0 is set to 1 indicates graph is enabled, or disabled if set to 0. Bit 1 is
	// set to 1 indicates the hub is disabled, or enabled if set to 0.
	TenantFeatures *int32

	// READ-ONLY; API endpoint URL of the hub.
	APIEndpoint *string

	// READ-ONLY; Provisioning state of the hub.
	ProvisioningState *string

	// READ-ONLY; Web endpoint URL of the hub.
	WebEndpoint *string
}

// ImageDefinition - The image definition.
type ImageDefinition struct {
	// Content URL for the image blob.
	ContentURL *string

	// Whether image exists already.
	ImageExists *bool

	// Relative path of the image.
	RelativePath *string
}

// InteractionListResult - The response of list interaction operation.
type InteractionListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*InteractionResourceFormat
}

// InteractionResourceFormat - The interaction resource format.
type InteractionResourceFormat struct {
	// The Interaction Type Definition
	Properties *InteractionTypeDefinition

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// InteractionTypeDefinition - The Interaction Type Definition
type InteractionTypeDefinition struct {
	// The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
	APIEntitySetName *string

	// The attributes for the Type.
	Attributes map[string][]*string

	// Default data source is specifically used in cases where data source is not specified in an instance.
	DefaultDataSource *DataSource

	// Localized descriptions for the property.
	Description map[string]*string

	// Localized display names for the property.
	DisplayName map[string]*string

	// Type of entity.
	EntityType *EntityTypes

	// The properties of the Profile.
	Fields []*PropertyDefinition

	// The id property names. Properties which uniquely identify an interaction instance.
	IDPropertyNames []*string

	// The instance count.
	InstancesCount *int32

	// An interaction can be tagged as an activity only during create. This enables the interaction to be editable and can enable
	// merging of properties from multiple data sources based on precedence, which
	// is defined at a link level.
	IsActivity *bool

	// Large Image associated with the Property or EntityType.
	LargeImage *string

	// Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string

	// Medium Image associated with the Property or EntityType.
	MediumImage *string

	// Profiles that participated in the interaction.
	ParticipantProfiles []*Participant

	// The primary participant property name for an interaction ,This is used to logically represent the agent of the interaction,
	// Specify the participant name here from ParticipantName.
	PrimaryParticipantProfilePropertyName *string

	// The schema org link. This helps ACI identify and suggest semantic models.
	SchemaItemTypeLink *string

	// Small Image associated with the Property or EntityType.
	SmallImage *string

	// The timestamp property name. Represents the time when the interaction or profile update happened.
	TimestampFieldName *string

	// The name of the entity.
	TypeName *string

	// READ-ONLY; This is specific to interactions modeled as activities. Data sources are used to determine where data is stored
	// and also in precedence rules.
	DataSourcePrecedenceRules []*DataSourcePrecedence

	// READ-ONLY; The last changed time for the type definition.
	LastChangedUTC *time.Time

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; The hub name.
	TenantID *string
}

// KpiAlias - The KPI alias.
type KpiAlias struct {
	// REQUIRED; KPI alias name.
	AliasName *string

	// REQUIRED; The expression.
	Expression *string
}

// KpiDefinition - Defines the KPI Threshold limits.
type KpiDefinition struct {
	// REQUIRED; The calculation window.
	CalculationWindow *CalculationWindowTypes

	// REQUIRED; The mapping entity type.
	EntityType *EntityTypes

	// REQUIRED; The mapping entity name.
	EntityTypeName *string

	// REQUIRED; The computation expression for the KPI.
	Expression *string

	// REQUIRED; The computation function for the KPI.
	Function *KpiFunctions

	// The aliases.
	Aliases []*KpiAlias

	// Name of calculation window field.
	CalculationWindowFieldName *string

	// Localized description for the KPI.
	Description map[string]*string

	// Localized display name for the KPI.
	DisplayName map[string]*string

	// The KPI extracts.
	Extracts []*KpiExtract

	// The filter expression for the KPI.
	Filter *string

	// the group by properties for the KPI.
	GroupBy []*string

	// The KPI thresholds.
	ThresHolds *KpiThresholds

	// The unit of measurement for the KPI.
	Unit *string

	// READ-ONLY; The KPI GroupByMetadata.
	GroupByMetadata []*KpiGroupByMetadata

	// READ-ONLY; The KPI name.
	KpiName *string

	// READ-ONLY; The participant profiles.
	ParticipantProfilesMetadata []*KpiParticipantProfilesMetadata

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; The hub name.
	TenantID *string
}

// KpiExtract - The KPI extract.
type KpiExtract struct {
	// REQUIRED; The expression.
	Expression *string

	// REQUIRED; KPI extract name.
	ExtractName *string
}

// KpiGroupByMetadata - The KPI GroupBy field metadata.
type KpiGroupByMetadata struct {
	// The display name.
	DisplayName map[string]*string

	// The name of the field.
	FieldName *string

	// The type of the field.
	FieldType *string
}

// KpiListResult - The response of list KPI operation.
type KpiListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*KpiResourceFormat
}

// KpiParticipantProfilesMetadata - The KPI participant profile metadata.
type KpiParticipantProfilesMetadata struct {
	// REQUIRED; Name of the type.
	TypeName *string
}

// KpiResourceFormat - The KPI resource format.
type KpiResourceFormat struct {
	// Defines the KPI Threshold limits.
	Properties *KpiDefinition

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// KpiThresholds - Defines the KPI Threshold limits.
type KpiThresholds struct {
	// REQUIRED; Whether or not the KPI is an increasing KPI.
	IncreasingKpi *bool

	// REQUIRED; The lower threshold limit.
	LowerLimit *float64

	// REQUIRED; The upper threshold limit.
	UpperLimit *float64
}

// LinkDefinition - The definition of Link.
type LinkDefinition struct {
	// REQUIRED; The properties that represent the participating profile.
	ParticipantPropertyReferences []*ParticipantPropertyReference

	// REQUIRED; Type of source entity.
	SourceEntityType *EntityType

	// REQUIRED; Name of the source Entity Type.
	SourceEntityTypeName *string

	// REQUIRED; Type of target entity.
	TargetEntityType *EntityType

	// REQUIRED; Name of the target Entity Type.
	TargetEntityTypeName *string

	// Localized descriptions for the Link.
	Description map[string]*string

	// Localized display name for the Link.
	DisplayName map[string]*string

	// The set of properties mappings between the source and target Types.
	Mappings []*TypePropertiesMapping

	// Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only.
	OperationType *InstanceOperationType

	// Indicating whether the link is reference only link. This flag is ignored if the Mappings are defined. If the mappings are
	// not defined and it is set to true, links processing will not create or update
	// profiles.
	ReferenceOnly *bool

	// READ-ONLY; The link name.
	LinkName *string

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; The hub name.
	TenantID *string
}

// LinkListResult - The response of list link operation.
type LinkListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*LinkResourceFormat
}

// LinkResourceFormat - The link resource format.
type LinkResourceFormat struct {
	// The definition of Link.
	Properties *LinkDefinition

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// MetadataDefinitionBase - The Metadata definition base.
type MetadataDefinitionBase struct {
	// The attributes for the Type.
	Attributes map[string][]*string

	// Localized descriptions for the property.
	Description map[string]*string

	// Localized display names for the property.
	DisplayName map[string]*string

	// Large Image associated with the Property or EntityType.
	LargeImage *string

	// Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string

	// Medium Image associated with the Property or EntityType.
	MediumImage *string

	// Small Image associated with the Property or EntityType.
	SmallImage *string
}

// Operation - A Customer Insights REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string

	// READ-ONLY; Service provider: Microsoft.CustomerInsights
	Provider *string

	// READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string
}

// OperationListResult - Result of the request to list Customer Insights operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; List of Customer Insights operations supported by the Microsoft.CustomerInsights resource provider.
	Value []*Operation
}

// Participant - Describes a profile type participating in an interaction.
type Participant struct {
	// REQUIRED; Participant name.
	ParticipantName *string

	// REQUIRED; The property references.
	ParticipantPropertyReferences []*ParticipantPropertyReference

	// REQUIRED; Profile type name.
	ProfileTypeName *string

	// Localized descriptions.
	Description map[string]*string

	// Localized display name.
	DisplayName map[string]*string

	// The role that the participant is playing in the interaction.
	Role *string
}

// ParticipantProfilePropertyReference - The participant profile property reference.
type ParticipantProfilePropertyReference struct {
	// REQUIRED; The source interaction property that maps to the target profile property.
	InteractionPropertyName *string

	// REQUIRED; The target profile property that maps to the source interaction property.
	ProfilePropertyName *string
}

// ParticipantPropertyReference - The participant property reference.
type ParticipantPropertyReference struct {
	// REQUIRED; The source property that maps to the target property.
	SourcePropertyName *string

	// REQUIRED; The target property that maps to the source property.
	TargetPropertyName *string
}

// Prediction - The prediction definition.
type Prediction struct {
	// REQUIRED; Whether do auto analyze.
	AutoAnalyze *bool

	// REQUIRED; Definition of the link mapping of prediction.
	Mappings *PredictionMappings

	// REQUIRED; Negative outcome expression.
	NegativeOutcomeExpression *string

	// REQUIRED; Positive outcome expression.
	PositiveOutcomeExpression *string

	// REQUIRED; Primary profile type.
	PrimaryProfileType *string

	// REQUIRED; Scope expression.
	ScopeExpression *string

	// REQUIRED; Score label.
	ScoreLabel *string

	// Description of the prediction.
	Description map[string]*string

	// Display name of the prediction.
	DisplayName map[string]*string

	// The prediction grades.
	Grades []*PredictionGradesItem

	// Interaction types involved in the prediction.
	InvolvedInteractionTypes []*string

	// KPI types involved in the prediction.
	InvolvedKpiTypes []*string

	// Relationships involved in the prediction.
	InvolvedRelationships []*string

	// Name of the prediction.
	PredictionName *string

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; System generated entities.
	SystemGeneratedEntities *PredictionSystemGeneratedEntities

	// READ-ONLY; The hub name.
	TenantID *string
}

// PredictionDistributionDefinition - The definition of the prediction distribution.
type PredictionDistributionDefinition struct {
	// Distributions of the prediction.
	Distributions []*PredictionDistributionDefinitionDistributionsItem

	// Total negatives in the distribution.
	TotalNegatives *int64

	// Total positive in the distribution.
	TotalPositives *int64
}

// PredictionDistributionDefinitionDistributionsItem - The definition of a prediction distribution.
type PredictionDistributionDefinitionDistributionsItem struct {
	// Number of negatives.
	Negatives *int64

	// Number of negatives above threshold.
	NegativesAboveThreshold *int64

	// Number of positives.
	Positives *int64

	// Number of positives above threshold.
	PositivesAboveThreshold *int64

	// Score threshold.
	ScoreThreshold *int32
}

// PredictionGradesItem - The definition of a prediction grade.
type PredictionGradesItem struct {
	// Name of the grade.
	GradeName *string

	// Maximum score threshold.
	MaxScoreThreshold *int32

	// Minimum score threshold.
	MinScoreThreshold *int32
}

// PredictionListResult - The response of list predictions operation.
type PredictionListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*PredictionResourceFormat
}

// PredictionMappings - Definition of the link mapping of prediction.
type PredictionMappings struct {
	// REQUIRED; The grade of the link mapping.
	Grade *string

	// REQUIRED; The reason of the link mapping.
	Reason *string

	// REQUIRED; The score of the link mapping.
	Score *string
}

// PredictionModelStatus - The prediction model status.
type PredictionModelStatus struct {
	// REQUIRED; Prediction model life cycle. When prediction is in PendingModelConfirmation status, it is allowed to update the
	// status to PendingFeaturing or Active through API.
	Status *PredictionModelLifeCycle

	// READ-ONLY; The model status message.
	Message *string

	// READ-ONLY; Version of the model.
	ModelVersion *string

	// READ-ONLY; The prediction GUID ID.
	PredictionGUIDID *string

	// READ-ONLY; The prediction name.
	PredictionName *string

	// READ-ONLY; The signals used.
	SignalsUsed *int32

	// READ-ONLY; The hub name.
	TenantID *string

	// READ-ONLY; Count of the test set.
	TestSetCount *int32

	// READ-ONLY; The training accuracy.
	TrainingAccuracy *float64

	// READ-ONLY; Count of the training set.
	TrainingSetCount *int32

	// READ-ONLY; Count of the validation set.
	ValidationSetCount *int32
}

// PredictionResourceFormat - The prediction resource format.
type PredictionResourceFormat struct {
	// The prediction definition.
	Properties *Prediction

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PredictionSystemGeneratedEntities - System generated entities.
type PredictionSystemGeneratedEntities struct {
	// Generated interaction types.
	GeneratedInteractionTypes []*string

	// Generated KPIs.
	GeneratedKpis map[string]*string

	// Generated links.
	GeneratedLinks []*string
}

// PredictionTrainingResults - The training results of the prediction.
type PredictionTrainingResults struct {
	// READ-ONLY; Canonical profiles.
	CanonicalProfiles []*CanonicalProfileDefinition

	// READ-ONLY; Prediction distribution.
	PredictionDistribution *PredictionDistributionDefinition

	// READ-ONLY; Instance count of the primary profile.
	PrimaryProfileInstanceCount *int64

	// READ-ONLY; Score name.
	ScoreName *string

	// READ-ONLY; The hub name.
	TenantID *string
}

// ProfileEnumValidValuesFormat - Valid enum values in case of an enum property.
type ProfileEnumValidValuesFormat struct {
	// Localized names of the enum member.
	LocalizedValueNames map[string]*string

	// The integer value of the enum member.
	Value *int32
}

// ProfileListResult - The response of list profile operation.
type ProfileListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*ProfileResourceFormat
}

// ProfileResourceFormat - The profile resource format.
type ProfileResourceFormat struct {
	// The profile type definition.
	Properties *ProfileTypeDefinition

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ProfileTypeDefinition - The profile type definition.
type ProfileTypeDefinition struct {
	// The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
	APIEntitySetName *string

	// The attributes for the Type.
	Attributes map[string][]*string

	// Localized descriptions for the property.
	Description map[string]*string

	// Localized display names for the property.
	DisplayName map[string]*string

	// Type of entity.
	EntityType *EntityTypes

	// The properties of the Profile.
	Fields []*PropertyDefinition

	// The instance count.
	InstancesCount *int32

	// Large Image associated with the Property or EntityType.
	LargeImage *string

	// Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string

	// Medium Image associated with the Property or EntityType.
	MediumImage *string

	// The schema org link. This helps ACI identify and suggest semantic models.
	SchemaItemTypeLink *string

	// Small Image associated with the Property or EntityType.
	SmallImage *string

	// The strong IDs.
	StrongIDs []*StrongID

	// The timestamp property name. Represents the time when the interaction or profile update happened.
	TimestampFieldName *string

	// The name of the entity.
	TypeName *string

	// READ-ONLY; The last changed time for the type definition.
	LastChangedUTC *time.Time

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; The hub name.
	TenantID *string
}

// PropertyDefinition - Property definition.
type PropertyDefinition struct {
	// REQUIRED; Name of the property.
	FieldName *string

	// REQUIRED; Type of the property.
	FieldType *string

	// Array value separator for properties with isArray set.
	ArrayValueSeparator *string

	// Describes valid values for an enum property.
	EnumValidValues []*ProfileEnumValidValuesFormat

	// Indicates if the property is actually an array of the fieldType above on the data api.
	IsArray *bool

	// Whether property is available in graph or not.
	IsAvailableInGraph *bool

	// Indicates if the property is an enum.
	IsEnum *bool

	// Indicates if the property is an flag enum.
	IsFlagEnum *bool

	// Whether the property is an Image.
	IsImage *bool

	// Whether the property is a localized string.
	IsLocalizedString *bool

	// Whether the property is a name or a part of name.
	IsName *bool

	// Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check
	// for required field.
	IsRequired *bool

	// Max length of string. Used only if type is string.
	MaxLength *int32

	// The ID associated with the property.
	PropertyID *string

	// URL encoded schema.org item prop link for the property.
	SchemaItemPropLink *string

	// READ-ONLY; This is specific to interactions modeled as activities. Data sources are used to determine where data is stored
	// and also in precedence rules.
	DataSourcePrecedenceRules []*DataSourcePrecedence
}

// ProxyResource - Common properties of proxy resource.
type ProxyResource struct {
	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RelationshipDefinition - The definition of Relationship.
type RelationshipDefinition struct {
	// REQUIRED; Profile type.
	ProfileType *string

	// REQUIRED; Related profile being referenced.
	RelatedProfileType *string

	// The Relationship Cardinality.
	Cardinality *CardinalityTypes

	// Localized descriptions for the Relationship.
	Description map[string]*string

	// Localized display name for the Relationship.
	DisplayName map[string]*string

	// The expiry date time in UTC.
	ExpiryDateTimeUTC *time.Time

	// The properties of the Relationship.
	Fields []*PropertyDefinition

	// Optional property to be used to map fields in profile to their strong ids in related profile.
	LookupMappings []*RelationshipTypeMapping

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; The relationship guid id.
	RelationshipGUIDID *string

	// READ-ONLY; The Relationship name.
	RelationshipName *string

	// READ-ONLY; The hub name.
	TenantID *string
}

// RelationshipLinkDefinition - The definition of relationship link.
type RelationshipLinkDefinition struct {
	// REQUIRED; The InteractionType associated with the Relationship Link.
	InteractionType *string

	// REQUIRED; The property references for the Profile of the Relationship.
	ProfilePropertyReferences []*ParticipantProfilePropertyReference

	// REQUIRED; The property references for the Related Profile of the Relationship.
	RelatedProfilePropertyReferences []*ParticipantProfilePropertyReference

	// REQUIRED; The Relationship associated with the Link.
	RelationshipName *string

	// Localized descriptions for the Relationship Link.
	Description map[string]*string

	// Localized display name for the Relationship Link.
	DisplayName map[string]*string

	// The mappings between Interaction and Relationship fields.
	Mappings []*RelationshipLinkFieldMapping

	// READ-ONLY; The name of the Relationship Link.
	LinkName *string

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; The relationship guid id.
	RelationshipGUIDID *string

	// READ-ONLY; The hub name.
	TenantID *string
}

// RelationshipLinkFieldMapping - The fields mapping for Relationships.
type RelationshipLinkFieldMapping struct {
	// REQUIRED; The field name on the Interaction Type.
	InteractionFieldName *string

	// REQUIRED; The field name on the Relationship metadata.
	RelationshipFieldName *string

	// Link type.
	LinkType *LinkTypes
}

// RelationshipLinkListResult - The response of list relationship link operation.
type RelationshipLinkListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*RelationshipLinkResourceFormat
}

// RelationshipLinkResourceFormat - The relationship link resource format.
type RelationshipLinkResourceFormat struct {
	// The definition of relationship link.
	Properties *RelationshipLinkDefinition

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RelationshipListResult - The response of list relationship operation.
type RelationshipListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*RelationshipResourceFormat
}

// RelationshipResourceFormat - The relationship resource format.
type RelationshipResourceFormat struct {
	// The definition of Relationship.
	Properties *RelationshipDefinition

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RelationshipTypeFieldMapping - Map a field of profile to its corresponding StrongId in Related Profile.
type RelationshipTypeFieldMapping struct {
	// REQUIRED; Specifies the fieldName in profile.
	ProfileFieldName *string

	// REQUIRED; Specifies the KeyProperty (from StrongId) of the related profile.
	RelatedProfileKeyProperty *string
}

// RelationshipTypeMapping - Maps fields in Profile to their corresponding StrongIds in Related Profile.
type RelationshipTypeMapping struct {
	// REQUIRED; Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are
	// composite key as well.
	FieldMappings []*RelationshipTypeFieldMapping
}

// RelationshipsLookup - The definition of suggested relationship for the type.
type RelationshipsLookup struct {
	// READ-ONLY; The name of existing Relationship.
	ExistingRelationshipName *string

	// READ-ONLY; The relationship profile.
	ProfileName *string

	// READ-ONLY; The property references for the profile type.
	ProfilePropertyReferences []*ParticipantProfilePropertyReference

	// READ-ONLY; The related profile.
	RelatedProfileName *string

	// READ-ONLY; The property references for the related profile type.
	RelatedProfilePropertyReferences []*ParticipantProfilePropertyReference
}

// Resource - Common properties of Azure resource.
type Resource struct {
	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceSetDescription - The resource set description.
type ResourceSetDescription struct {
	// The elements included in the set.
	Elements []*string

	// The elements that are not included in the set, in case elements contains '*' indicating 'all'.
	Exceptions []*string
}

// Role - The Role definition.
type Role struct {
	// The description of the role.
	Description *string

	// The role name.
	RoleName *string
}

// RoleAssignment - The Role Assignment definition.
type RoleAssignment struct {
	// REQUIRED; The principals being assigned to.
	Principals []*AssignmentPrincipal

	// REQUIRED; Type of roles.
	Role *RoleTypes

	// Widget types set for the assignment.
	ConflationPolicies *ResourceSetDescription

	// Connectors set for the assignment.
	Connectors *ResourceSetDescription

	// Localized description for the metadata.
	Description map[string]*string

	// Localized display names for the metadata.
	DisplayName map[string]*string

	// Interactions set for the assignment.
	Interactions *ResourceSetDescription

	// Kpis set for the assignment.
	Kpis *ResourceSetDescription

	// Links set for the assignment.
	Links *ResourceSetDescription

	// Profiles set for the assignment.
	Profiles *ResourceSetDescription

	// The Role assignments set for the relationship links.
	RelationshipLinks *ResourceSetDescription

	// The Role assignments set for the relationships.
	Relationships *ResourceSetDescription

	// The Role assignments set for the assignment.
	RoleAssignments *ResourceSetDescription

	// Sas Policies set for the assignment.
	SasPolicies *ResourceSetDescription

	// The Role assignments set for the assignment.
	Segments *ResourceSetDescription

	// Views set for the assignment.
	Views *ResourceSetDescription

	// Widget types set for the assignment.
	WidgetTypes *ResourceSetDescription

	// READ-ONLY; The name of the metadata object.
	AssignmentName *string

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates

	// READ-ONLY; The hub name.
	TenantID *string
}

// RoleAssignmentListResult - The response of list role assignment operation.
type RoleAssignmentListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*RoleAssignmentResourceFormat
}

// RoleAssignmentResourceFormat - The Role Assignment resource format.
type RoleAssignmentResourceFormat struct {
	// The Role Assignment definition.
	Properties *RoleAssignment

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RoleListResult - The response of list role assignment operation.
type RoleListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*RoleResourceFormat
}

// RoleResourceFormat - The role resource format.
type RoleResourceFormat struct {
	// The Role definition.
	Properties *Role

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SalesforceConnectorProperties - The Salesforce connector properties.
type SalesforceConnectorProperties struct {
	// REQUIRED; The Salesforce tables.
	Salesforcetables []*SalesforceTable

	// REQUIRED; The user settings.
	Usersetting *SalesforceDiscoverSetting
}

// SalesforceDiscoverSetting - Salesforce discover setting.
type SalesforceDiscoverSetting struct {
	// REQUIRED; The salesforce connection string secret URL.
	SalesforceConnectionStringSecretURL *string
}

// SalesforceTable - Salesforce table.
type SalesforceTable struct {
	// REQUIRED; The table category.
	TableCategory *string

	// REQUIRED; The name of the table.
	TableName *string

	// REQUIRED; The table schema.
	TableSchema *string

	// Indicating whether this instance is profile.
	IsProfile *string

	// The table remarks.
	TableRemarks *string
}

// StrongID - Property/Properties which represent a unique ID.
type StrongID struct {
	// REQUIRED; The properties which make up the unique ID.
	KeyPropertyNames []*string

	// REQUIRED; The Name identifying the strong ID.
	StrongIDName *string

	// Localized descriptions.
	Description map[string]*string

	// Localized display name.
	DisplayName map[string]*string
}

// SuggestRelationshipLinksResponse - The response of suggest relationship links operation.
type SuggestRelationshipLinksResponse struct {
	// READ-ONLY; The interaction name.
	InteractionName *string

	// READ-ONLY; Suggested relationships for the type.
	SuggestedRelationships []*RelationshipsLookup
}

// TypePropertiesMapping - Metadata for a Link's property mapping.
type TypePropertiesMapping struct {
	// REQUIRED; Property name on the source Entity Type.
	SourcePropertyName *string

	// REQUIRED; Property name on the target Entity Type.
	TargetPropertyName *string

	// Link type.
	LinkType *LinkTypes
}

// View - The view in Customer 360 web application.
type View struct {
	// REQUIRED; View definition.
	Definition *string

	// Localized display name for the view.
	DisplayName map[string]*string

	// the user ID.
	UserID *string

	// READ-ONLY; Date time when view was last modified.
	Changed *time.Time

	// READ-ONLY; Date time when view was created.
	Created *time.Time

	// READ-ONLY; the hub name.
	TenantID *string

	// READ-ONLY; Name of the view.
	ViewName *string
}

// ViewListResult - The response of list view operation.
type ViewListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*ViewResourceFormat
}

// ViewResourceFormat - The view resource format.
type ViewResourceFormat struct {
	// The view in Customer 360 web application.
	Properties *View

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WidgetType - Definition of WidgetType.
type WidgetType struct {
	// REQUIRED; Definition for widget type.
	Definition *string

	// Description for widget type.
	Description *string

	// Localized display name for the widget type.
	DisplayName map[string]*string

	// The image URL.
	ImageURL *string

	// The widget version.
	WidgetVersion *string

	// READ-ONLY; Date time when widget type was last modified.
	Changed *time.Time

	// READ-ONLY; Date time when widget type was created.
	Created *time.Time

	// READ-ONLY; The hub name.
	TenantID *string

	// READ-ONLY; Name of the widget type.
	WidgetTypeName *string
}

// WidgetTypeListResult - The response of list widget type operation.
type WidgetTypeListResult struct {
	// Link to the next set of results.
	NextLink *string

	// Results of the list operation.
	Value []*WidgetTypeResourceFormat
}

// WidgetTypeResourceFormat - The WidgetTypeResourceFormat
type WidgetTypeResourceFormat struct {
	// Definition of WidgetType.
	Properties *WidgetType

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}
