//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AuthorizationPoliciesClient contains the methods for the AuthorizationPolicies group.
// Don't use this type directly, use NewAuthorizationPoliciesClient() instead.
type AuthorizationPoliciesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewAuthorizationPoliciesClient creates a new instance of AuthorizationPoliciesClient with the specified values.
//   - subscriptionID - Gets subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID
//     forms part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAuthorizationPoliciesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AuthorizationPoliciesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AuthorizationPoliciesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Creates an authorization policy or updates an existing authorization policy.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - authorizationPolicyName - The name of the policy.
//   - parameters - Parameters supplied to the CreateOrUpdate authorization policy operation.
//   - options - AuthorizationPoliciesClientCreateOrUpdateOptions contains the optional parameters for the AuthorizationPoliciesClient.CreateOrUpdate
//     method.
func (client *AuthorizationPoliciesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, parameters AuthorizationPolicyResourceFormat, options *AuthorizationPoliciesClientCreateOrUpdateOptions) (AuthorizationPoliciesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "AuthorizationPoliciesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, hubName, authorizationPolicyName, parameters, options)
	if err != nil {
		return AuthorizationPoliciesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AuthorizationPoliciesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return AuthorizationPoliciesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *AuthorizationPoliciesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, parameters AuthorizationPolicyResourceFormat, options *AuthorizationPoliciesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if authorizationPolicyName == "" {
		return nil, errors.New("parameter authorizationPolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{authorizationPolicyName}", url.PathEscape(authorizationPolicyName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *AuthorizationPoliciesClient) createOrUpdateHandleResponse(resp *http.Response) (AuthorizationPoliciesClientCreateOrUpdateResponse, error) {
	result := AuthorizationPoliciesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AuthorizationPolicyResourceFormat); err != nil {
		return AuthorizationPoliciesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Get - Gets an authorization policy in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - authorizationPolicyName - The name of the policy.
//   - options - AuthorizationPoliciesClientGetOptions contains the optional parameters for the AuthorizationPoliciesClient.Get
//     method.
func (client *AuthorizationPoliciesClient) Get(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, options *AuthorizationPoliciesClientGetOptions) (AuthorizationPoliciesClientGetResponse, error) {
	var err error
	const operationName = "AuthorizationPoliciesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, hubName, authorizationPolicyName, options)
	if err != nil {
		return AuthorizationPoliciesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AuthorizationPoliciesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AuthorizationPoliciesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *AuthorizationPoliciesClient) getCreateRequest(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, options *AuthorizationPoliciesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if authorizationPolicyName == "" {
		return nil, errors.New("parameter authorizationPolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{authorizationPolicyName}", url.PathEscape(authorizationPolicyName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AuthorizationPoliciesClient) getHandleResponse(resp *http.Response) (AuthorizationPoliciesClientGetResponse, error) {
	result := AuthorizationPoliciesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AuthorizationPolicyResourceFormat); err != nil {
		return AuthorizationPoliciesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByHubPager - Gets all the authorization policies in a specified hub.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - options - AuthorizationPoliciesClientListByHubOptions contains the optional parameters for the AuthorizationPoliciesClient.NewListByHubPager
//     method.
func (client *AuthorizationPoliciesClient) NewListByHubPager(resourceGroupName string, hubName string, options *AuthorizationPoliciesClientListByHubOptions) *runtime.Pager[AuthorizationPoliciesClientListByHubResponse] {
	return runtime.NewPager(runtime.PagingHandler[AuthorizationPoliciesClientListByHubResponse]{
		More: func(page AuthorizationPoliciesClientListByHubResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AuthorizationPoliciesClientListByHubResponse) (AuthorizationPoliciesClientListByHubResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AuthorizationPoliciesClient.NewListByHubPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByHubCreateRequest(ctx, resourceGroupName, hubName, options)
			}, nil)
			if err != nil {
				return AuthorizationPoliciesClientListByHubResponse{}, err
			}
			return client.listByHubHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByHubCreateRequest creates the ListByHub request.
func (client *AuthorizationPoliciesClient) listByHubCreateRequest(ctx context.Context, resourceGroupName string, hubName string, options *AuthorizationPoliciesClientListByHubOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByHubHandleResponse handles the ListByHub response.
func (client *AuthorizationPoliciesClient) listByHubHandleResponse(resp *http.Response) (AuthorizationPoliciesClientListByHubResponse, error) {
	result := AuthorizationPoliciesClientListByHubResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AuthorizationPolicyListResult); err != nil {
		return AuthorizationPoliciesClientListByHubResponse{}, err
	}
	return result, nil
}

// RegeneratePrimaryKey - Regenerates the primary policy key of the specified authorization policy.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - authorizationPolicyName - The name of the policy.
//   - options - AuthorizationPoliciesClientRegeneratePrimaryKeyOptions contains the optional parameters for the AuthorizationPoliciesClient.RegeneratePrimaryKey
//     method.
func (client *AuthorizationPoliciesClient) RegeneratePrimaryKey(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, options *AuthorizationPoliciesClientRegeneratePrimaryKeyOptions) (AuthorizationPoliciesClientRegeneratePrimaryKeyResponse, error) {
	var err error
	const operationName = "AuthorizationPoliciesClient.RegeneratePrimaryKey"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.regeneratePrimaryKeyCreateRequest(ctx, resourceGroupName, hubName, authorizationPolicyName, options)
	if err != nil {
		return AuthorizationPoliciesClientRegeneratePrimaryKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AuthorizationPoliciesClientRegeneratePrimaryKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AuthorizationPoliciesClientRegeneratePrimaryKeyResponse{}, err
	}
	resp, err := client.regeneratePrimaryKeyHandleResponse(httpResp)
	return resp, err
}

// regeneratePrimaryKeyCreateRequest creates the RegeneratePrimaryKey request.
func (client *AuthorizationPoliciesClient) regeneratePrimaryKeyCreateRequest(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, options *AuthorizationPoliciesClientRegeneratePrimaryKeyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}/regeneratePrimaryKey"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if authorizationPolicyName == "" {
		return nil, errors.New("parameter authorizationPolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{authorizationPolicyName}", url.PathEscape(authorizationPolicyName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// regeneratePrimaryKeyHandleResponse handles the RegeneratePrimaryKey response.
func (client *AuthorizationPoliciesClient) regeneratePrimaryKeyHandleResponse(resp *http.Response) (AuthorizationPoliciesClientRegeneratePrimaryKeyResponse, error) {
	result := AuthorizationPoliciesClientRegeneratePrimaryKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AuthorizationPolicy); err != nil {
		return AuthorizationPoliciesClientRegeneratePrimaryKeyResponse{}, err
	}
	return result, nil
}

// RegenerateSecondaryKey - Regenerates the secondary policy key of the specified authorization policy.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-04-26
//   - resourceGroupName - The name of the resource group.
//   - hubName - The name of the hub.
//   - authorizationPolicyName - The name of the policy.
//   - options - AuthorizationPoliciesClientRegenerateSecondaryKeyOptions contains the optional parameters for the AuthorizationPoliciesClient.RegenerateSecondaryKey
//     method.
func (client *AuthorizationPoliciesClient) RegenerateSecondaryKey(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, options *AuthorizationPoliciesClientRegenerateSecondaryKeyOptions) (AuthorizationPoliciesClientRegenerateSecondaryKeyResponse, error) {
	var err error
	const operationName = "AuthorizationPoliciesClient.RegenerateSecondaryKey"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.regenerateSecondaryKeyCreateRequest(ctx, resourceGroupName, hubName, authorizationPolicyName, options)
	if err != nil {
		return AuthorizationPoliciesClientRegenerateSecondaryKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AuthorizationPoliciesClientRegenerateSecondaryKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AuthorizationPoliciesClientRegenerateSecondaryKeyResponse{}, err
	}
	resp, err := client.regenerateSecondaryKeyHandleResponse(httpResp)
	return resp, err
}

// regenerateSecondaryKeyCreateRequest creates the RegenerateSecondaryKey request.
func (client *AuthorizationPoliciesClient) regenerateSecondaryKeyCreateRequest(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, options *AuthorizationPoliciesClientRegenerateSecondaryKeyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/authorizationPolicies/{authorizationPolicyName}/regenerateSecondaryKey"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if authorizationPolicyName == "" {
		return nil, errors.New("parameter authorizationPolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{authorizationPolicyName}", url.PathEscape(authorizationPolicyName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// regenerateSecondaryKeyHandleResponse handles the RegenerateSecondaryKey response.
func (client *AuthorizationPoliciesClient) regenerateSecondaryKeyHandleResponse(resp *http.Response) (AuthorizationPoliciesClientRegenerateSecondaryKeyResponse, error) {
	result := AuthorizationPoliciesClientRegenerateSecondaryKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AuthorizationPolicy); err != nil {
		return AuthorizationPoliciesClientRegenerateSecondaryKeyResponse{}, err
	}
	return result, nil
}
