//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// GenerateDetailedCostReportOperationResultsServer is a fake server for instances of the armcostmanagement.GenerateDetailedCostReportOperationResultsClient type.
type GenerateDetailedCostReportOperationResultsServer struct {
	// BeginGet is the fake for method GenerateDetailedCostReportOperationResultsClient.BeginGet
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGet func(ctx context.Context, operationID string, scope string, options *armcostmanagement.GenerateDetailedCostReportOperationResultsClientBeginGetOptions) (resp azfake.PollerResponder[armcostmanagement.GenerateDetailedCostReportOperationResultsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewGenerateDetailedCostReportOperationResultsServerTransport creates a new instance of GenerateDetailedCostReportOperationResultsServerTransport with the provided implementation.
// The returned GenerateDetailedCostReportOperationResultsServerTransport instance is connected to an instance of armcostmanagement.GenerateDetailedCostReportOperationResultsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGenerateDetailedCostReportOperationResultsServerTransport(srv *GenerateDetailedCostReportOperationResultsServer) *GenerateDetailedCostReportOperationResultsServerTransport {
	return &GenerateDetailedCostReportOperationResultsServerTransport{
		srv:      srv,
		beginGet: newTracker[azfake.PollerResponder[armcostmanagement.GenerateDetailedCostReportOperationResultsClientGetResponse]](),
	}
}

// GenerateDetailedCostReportOperationResultsServerTransport connects instances of armcostmanagement.GenerateDetailedCostReportOperationResultsClient to instances of GenerateDetailedCostReportOperationResultsServer.
// Don't use this type directly, use NewGenerateDetailedCostReportOperationResultsServerTransport instead.
type GenerateDetailedCostReportOperationResultsServerTransport struct {
	srv      *GenerateDetailedCostReportOperationResultsServer
	beginGet *tracker[azfake.PollerResponder[armcostmanagement.GenerateDetailedCostReportOperationResultsClientGetResponse]]
}

// Do implements the policy.Transporter interface for GenerateDetailedCostReportOperationResultsServerTransport.
func (g *GenerateDetailedCostReportOperationResultsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GenerateDetailedCostReportOperationResultsClient.BeginGet":
		resp, err = g.dispatchBeginGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GenerateDetailedCostReportOperationResultsServerTransport) dispatchBeginGet(req *http.Request) (*http.Response, error) {
	if g.srv.BeginGet == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGet not implemented")}
	}
	beginGet := g.beginGet.get(req)
	if beginGet == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/operationResults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
		if err != nil {
			return nil, err
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginGet(req.Context(), operationIDParam, scopeParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGet = &respr
		g.beginGet.add(req, beginGet)
	}

	resp, err := server.PollerResponderNext(beginGet, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginGet.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGet) {
		g.beginGet.remove(req)
	}

	return resp, nil
}
