//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcostmanagement_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportsGetByBillingAccount.json
func ExampleExportsClient_List_exportsGetByBillingAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().List(ctx, "providers/Microsoft.Billing/billingAccounts/123456", &armcostmanagement.ExportsClientListOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportListResult = armcostmanagement.ExportListResult{
	// 	Value: []*armcostmanagement.Export{
	// 		{
	// 			Name: to.Ptr("TestExport1"),
	// 			Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/123456/providers/Microsoft.CostManagement/exports/TestExport1"),
	// 			Properties: &armcostmanagement.ExportProperties{
	// 				Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 				Definition: &armcostmanagement.ExportDefinition{
	// 					Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 					DataSet: &armcostmanagement.ExportDataset{
	// 						Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 							Columns: []*string{
	// 								to.Ptr("Date"),
	// 								to.Ptr("MeterId"),
	// 								to.Ptr("ResourceId"),
	// 								to.Ptr("ResourceLocation"),
	// 								to.Ptr("Quantity")},
	// 							},
	// 							Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 						},
	// 						TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 							From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 							To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 						},
	// 						Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 					},
	// 					DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 						Destination: &armcostmanagement.ExportDeliveryDestination{
	// 							Container: to.Ptr("exports"),
	// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 							RootFolderPath: to.Ptr("ad-hoc"),
	// 						},
	// 					},
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("TestExport2"),
	// 				Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/123456/providers/Microsoft.CostManagement/exports/TestExport2"),
	// 				Properties: &armcostmanagement.ExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeWeekToDate),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ad-hoc"),
	// 							},
	// 						},
	// 						Schedule: &armcostmanagement.ExportSchedule{
	// 							Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 							RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 						},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportsGetByDepartment.json
func ExampleExportsClient_List_exportsGetByDepartment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().List(ctx, "providers/Microsoft.Billing/billingAccounts/12/departments/123", &armcostmanagement.ExportsClientListOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportListResult = armcostmanagement.ExportListResult{
	// 	Value: []*armcostmanagement.Export{
	// 		{
	// 			Name: to.Ptr("TestExport1"),
	// 			Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12/departments/1234/providers/Microsoft.CostManagement/exports/TestExport1"),
	// 			Properties: &armcostmanagement.ExportProperties{
	// 				Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 				Definition: &armcostmanagement.ExportDefinition{
	// 					Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 					DataSet: &armcostmanagement.ExportDataset{
	// 						Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 							Columns: []*string{
	// 								to.Ptr("Date"),
	// 								to.Ptr("MeterId"),
	// 								to.Ptr("ResourceId"),
	// 								to.Ptr("ResourceLocation"),
	// 								to.Ptr("Quantity")},
	// 							},
	// 							Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 						},
	// 						TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 							From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 							To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 						},
	// 						Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 					},
	// 					DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 						Destination: &armcostmanagement.ExportDeliveryDestination{
	// 							Container: to.Ptr("exports"),
	// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 							RootFolderPath: to.Ptr("ad-hoc"),
	// 						},
	// 					},
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("TestExport2"),
	// 				Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12/departments/1234/providers/Microsoft.CostManagement/exports/TestExport2"),
	// 				Properties: &armcostmanagement.ExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeWeekToDate),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ad-hoc"),
	// 							},
	// 						},
	// 						Schedule: &armcostmanagement.ExportSchedule{
	// 							Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 							RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 						},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportsGetByEnrollmentAccount.json
func ExampleExportsClient_List_exportsGetByEnrollmentAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().List(ctx, "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456", &armcostmanagement.ExportsClientListOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportListResult = armcostmanagement.ExportListResult{
	// 	Value: []*armcostmanagement.Export{
	// 		{
	// 			Name: to.Ptr("TestExport1"),
	// 			Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/Microsoft.CostManagement/exports/TestExport1"),
	// 			Properties: &armcostmanagement.ExportProperties{
	// 				Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 				Definition: &armcostmanagement.ExportDefinition{
	// 					Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 					DataSet: &armcostmanagement.ExportDataset{
	// 						Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 							Columns: []*string{
	// 								to.Ptr("Date"),
	// 								to.Ptr("MeterId"),
	// 								to.Ptr("ResourceId"),
	// 								to.Ptr("ResourceLocation"),
	// 								to.Ptr("Quantity")},
	// 							},
	// 							Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 						},
	// 						TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 							From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 							To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 						},
	// 						Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 					},
	// 					DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 						Destination: &armcostmanagement.ExportDeliveryDestination{
	// 							Container: to.Ptr("exports"),
	// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 							RootFolderPath: to.Ptr("ad-hoc"),
	// 						},
	// 					},
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("TestExport2"),
	// 				Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/Microsoft.CostManagement/exports/TestExport2"),
	// 				Properties: &armcostmanagement.ExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeWeekToDate),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ad-hoc"),
	// 							},
	// 						},
	// 						Schedule: &armcostmanagement.ExportSchedule{
	// 							Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 							RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 						},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportsGetByManagementGroup.json
func ExampleExportsClient_List_exportsGetByManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().List(ctx, "providers/Microsoft.Management/managementGroups/TestMG", &armcostmanagement.ExportsClientListOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportListResult = armcostmanagement.ExportListResult{
	// 	Value: []*armcostmanagement.Export{
	// 		{
	// 			Name: to.Ptr("TestExport1"),
	// 			Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 			ID: to.Ptr("providers/Microsoft.Management/managementGroups/TestMG/providers/Microsoft.CostManagement/exports/TestExport1"),
	// 			Properties: &armcostmanagement.ExportProperties{
	// 				Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 				Definition: &armcostmanagement.ExportDefinition{
	// 					Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 					DataSet: &armcostmanagement.ExportDataset{
	// 						Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 							Columns: []*string{
	// 								to.Ptr("Date"),
	// 								to.Ptr("MeterId"),
	// 								to.Ptr("ResourceId"),
	// 								to.Ptr("ResourceLocation"),
	// 								to.Ptr("Quantity")},
	// 							},
	// 							Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 						},
	// 						TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 							From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 							To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 						},
	// 						Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 					},
	// 					DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 						Destination: &armcostmanagement.ExportDeliveryDestination{
	// 							Container: to.Ptr("exports"),
	// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 							RootFolderPath: to.Ptr("ad-hoc"),
	// 						},
	// 					},
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("TestExport2"),
	// 				Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 				ID: to.Ptr("providers/Microsoft.Management/managementGroups/TestMG/providers/Microsoft.CostManagement/exports/TestExport2"),
	// 				Properties: &armcostmanagement.ExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeWeekToDate),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ad-hoc"),
	// 							},
	// 						},
	// 						Schedule: &armcostmanagement.ExportSchedule{
	// 							Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 							RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 						},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportsGetByResourceGroup.json
func ExampleExportsClient_List_exportsGetByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().List(ctx, "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG", &armcostmanagement.ExportsClientListOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportListResult = armcostmanagement.ExportListResult{
	// 	Value: []*armcostmanagement.Export{
	// 		{
	// 			Name: to.Ptr("TestExport1"),
	// 			Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 			ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.CostManagement/exports/TestExport1"),
	// 			Properties: &armcostmanagement.ExportProperties{
	// 				Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 				Definition: &armcostmanagement.ExportDefinition{
	// 					Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 					DataSet: &armcostmanagement.ExportDataset{
	// 						Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 							Columns: []*string{
	// 								to.Ptr("Date"),
	// 								to.Ptr("MeterId"),
	// 								to.Ptr("ResourceId"),
	// 								to.Ptr("ResourceLocation"),
	// 								to.Ptr("Quantity")},
	// 							},
	// 							Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 						},
	// 						TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 							From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 							To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 						},
	// 						Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 					},
	// 					DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 						Destination: &armcostmanagement.ExportDeliveryDestination{
	// 							Container: to.Ptr("exports"),
	// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 							RootFolderPath: to.Ptr("ad-hoc"),
	// 						},
	// 					},
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("TestExport2"),
	// 				Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 				ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.CostManagement/exports/TestExport2"),
	// 				Properties: &armcostmanagement.ExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeWeekToDate),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ad-hoc"),
	// 							},
	// 						},
	// 						Schedule: &armcostmanagement.ExportSchedule{
	// 							Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 							RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 						},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportsGetBySubscription.json
func ExampleExportsClient_List_exportsGetBySubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().List(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", &armcostmanagement.ExportsClientListOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportListResult = armcostmanagement.ExportListResult{
	// 	Value: []*armcostmanagement.Export{
	// 		{
	// 			Name: to.Ptr("TestExport1"),
	// 			Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 			ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/exports/TestExport1"),
	// 			Properties: &armcostmanagement.ExportProperties{
	// 				Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 				Definition: &armcostmanagement.ExportDefinition{
	// 					Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 					DataSet: &armcostmanagement.ExportDataset{
	// 						Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 							Columns: []*string{
	// 								to.Ptr("Date"),
	// 								to.Ptr("MeterId"),
	// 								to.Ptr("ResourceId"),
	// 								to.Ptr("ResourceLocation"),
	// 								to.Ptr("Quantity")},
	// 							},
	// 							Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 						},
	// 						TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 							From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 							To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 						},
	// 						Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 					},
	// 					DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 						Destination: &armcostmanagement.ExportDeliveryDestination{
	// 							Container: to.Ptr("exports"),
	// 							ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 							RootFolderPath: to.Ptr("ad-hoc"),
	// 						},
	// 					},
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("TestExport2"),
	// 				Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 				ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/exports/TestExport2"),
	// 				Properties: &armcostmanagement.ExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeWeekToDate),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ad-hoc"),
	// 							},
	// 						},
	// 						Schedule: &armcostmanagement.ExportSchedule{
	// 							Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 							RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 						},
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportGetByBillingAccount.json
func ExampleExportsClient_Get_exportGetByBillingAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().Get(ctx, "providers/Microsoft.Billing/billingAccounts/123456", "TestExport", &armcostmanagement.ExportsClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccount-Id}/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-05-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportGetByDepartment.json
func ExampleExportsClient_Get_exportGetByDepartment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().Get(ctx, "providers/Microsoft.Billing/billingAccounts/12/departments/1234", "TestExport", &armcostmanagement.ExportsClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12/departments/1234/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-30T00:00:00.000Z"); return t}()),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportGetByEnrollmentAccount.json
func ExampleExportsClient_Get_exportGetByEnrollmentAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().Get(ctx, "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456", "TestExport", &armcostmanagement.ExportsClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-09-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportGetByManagementGroup.json
func ExampleExportsClient_Get_exportGetByManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().Get(ctx, "providers/Microsoft.Management/managementGroups/TestMG", "TestExport", &armcostmanagement.ExportsClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("providers/Microsoft.Management/managementGroups/TestMG/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("UsageDate"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("InstanceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("UsageQuantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-09-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportGetByResourceGroup.json
func ExampleExportsClient_Get_exportGetByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().Get(ctx, "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG", "TestExport", &armcostmanagement.ExportsClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-30T00:00:00.000Z"); return t}()),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportGetBySubscription.json
func ExampleExportsClient_Get_exportGetBySubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().Get(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "TestExport", &armcostmanagement.ExportsClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-06-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-07-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportCreateOrUpdateByBillingAccount.json
func ExampleExportsClient_CreateOrUpdate_exportCreateOrUpdateByBillingAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().CreateOrUpdate(ctx, "providers/Microsoft.Billing/billingAccounts/123456", "TestExport", armcostmanagement.Export{
		Properties: &armcostmanagement.ExportProperties{
			Format: to.Ptr(armcostmanagement.FormatTypeCSV),
			Definition: &armcostmanagement.ExportDefinition{
				Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
				DataSet: &armcostmanagement.ExportDataset{
					Configuration: &armcostmanagement.ExportDatasetConfiguration{
						Columns: []*string{
							to.Ptr("Date"),
							to.Ptr("MeterId"),
							to.Ptr("ResourceId"),
							to.Ptr("ResourceLocation"),
							to.Ptr("Quantity")},
					},
					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
				},
				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
			},
			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
				Destination: &armcostmanagement.ExportDeliveryDestination{
					Container:      to.Ptr("exports"),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
					RootFolderPath: to.Ptr("ad-hoc"),
				},
			},
			Schedule: &armcostmanagement.ExportSchedule{
				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t }()),
					To:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t }()),
				},
				Status: to.Ptr(armcostmanagement.StatusTypeActive),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/123456/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 			Schedule: &armcostmanagement.ExportSchedule{
	// 				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportCreateOrUpdateByDepartment.json
func ExampleExportsClient_CreateOrUpdate_exportCreateOrUpdateByDepartment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().CreateOrUpdate(ctx, "providers/Microsoft.Billing/billingAccounts/12/departments/1234", "TestExport", armcostmanagement.Export{
		Properties: &armcostmanagement.ExportProperties{
			Format: to.Ptr(armcostmanagement.FormatTypeCSV),
			Definition: &armcostmanagement.ExportDefinition{
				Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
				DataSet: &armcostmanagement.ExportDataset{
					Configuration: &armcostmanagement.ExportDatasetConfiguration{
						Columns: []*string{
							to.Ptr("Date"),
							to.Ptr("MeterId"),
							to.Ptr("ResourceId"),
							to.Ptr("ResourceLocation"),
							to.Ptr("Quantity")},
					},
					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
				},
				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
			},
			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
				Destination: &armcostmanagement.ExportDeliveryDestination{
					Container:      to.Ptr("exports"),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
					RootFolderPath: to.Ptr("ad-hoc"),
				},
			},
			Schedule: &armcostmanagement.ExportSchedule{
				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t }()),
					To:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t }()),
				},
				Status: to.Ptr(armcostmanagement.StatusTypeActive),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12/departments/1234/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 			Schedule: &armcostmanagement.ExportSchedule{
	// 				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportCreateOrUpdateByEnrollmentAccount.json
func ExampleExportsClient_CreateOrUpdate_exportCreateOrUpdateByEnrollmentAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().CreateOrUpdate(ctx, "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456", "TestExport", armcostmanagement.Export{
		Properties: &armcostmanagement.ExportProperties{
			Format: to.Ptr(armcostmanagement.FormatTypeCSV),
			Definition: &armcostmanagement.ExportDefinition{
				Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
				DataSet: &armcostmanagement.ExportDataset{
					Configuration: &armcostmanagement.ExportDatasetConfiguration{
						Columns: []*string{
							to.Ptr("Date"),
							to.Ptr("MeterId"),
							to.Ptr("ResourceId"),
							to.Ptr("ResourceLocation"),
							to.Ptr("Quantity")},
					},
					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
				},
				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
			},
			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
				Destination: &armcostmanagement.ExportDeliveryDestination{
					Container:      to.Ptr("exports"),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
					RootFolderPath: to.Ptr("ad-hoc"),
				},
			},
			Schedule: &armcostmanagement.ExportSchedule{
				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t }()),
					To:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t }()),
				},
				Status: to.Ptr(armcostmanagement.StatusTypeActive),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 			Schedule: &armcostmanagement.ExportSchedule{
	// 				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportCreateOrUpdateByManagementGroup.json
func ExampleExportsClient_CreateOrUpdate_exportCreateOrUpdateByManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().CreateOrUpdate(ctx, "providers/Microsoft.Management/managementGroups/TestMG", "TestExport", armcostmanagement.Export{
		Properties: &armcostmanagement.ExportProperties{
			Format: to.Ptr(armcostmanagement.FormatTypeCSV),
			Definition: &armcostmanagement.ExportDefinition{
				Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
				DataSet: &armcostmanagement.ExportDataset{
					Configuration: &armcostmanagement.ExportDatasetConfiguration{
						Columns: []*string{
							to.Ptr("Date"),
							to.Ptr("MeterId"),
							to.Ptr("ResourceId"),
							to.Ptr("ResourceLocation"),
							to.Ptr("Quantity")},
					},
					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
				},
				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
			},
			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
				Destination: &armcostmanagement.ExportDeliveryDestination{
					Container:      to.Ptr("exports"),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
					RootFolderPath: to.Ptr("ad-hoc"),
				},
			},
			Schedule: &armcostmanagement.ExportSchedule{
				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t }()),
					To:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t }()),
				},
				Status: to.Ptr(armcostmanagement.StatusTypeActive),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("providers/Microsoft.Management/managementGroups/TestMG/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 			Schedule: &armcostmanagement.ExportSchedule{
	// 				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportCreateOrUpdateByResourceGroup.json
func ExampleExportsClient_CreateOrUpdate_exportCreateOrUpdateByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().CreateOrUpdate(ctx, "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG", "TestExport", armcostmanagement.Export{
		Properties: &armcostmanagement.ExportProperties{
			Format: to.Ptr(armcostmanagement.FormatTypeCSV),
			Definition: &armcostmanagement.ExportDefinition{
				Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
				DataSet: &armcostmanagement.ExportDataset{
					Configuration: &armcostmanagement.ExportDatasetConfiguration{
						Columns: []*string{
							to.Ptr("Date"),
							to.Ptr("MeterId"),
							to.Ptr("ResourceId"),
							to.Ptr("ResourceLocation"),
							to.Ptr("Quantity")},
					},
					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
				},
				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
			},
			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
				Destination: &armcostmanagement.ExportDeliveryDestination{
					Container:      to.Ptr("exports"),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
					RootFolderPath: to.Ptr("ad-hoc"),
				},
			},
			Schedule: &armcostmanagement.ExportSchedule{
				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t }()),
					To:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t }()),
				},
				Status: to.Ptr(armcostmanagement.StatusTypeActive),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 			Schedule: &armcostmanagement.ExportSchedule{
	// 				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportCreateOrUpdateBySubscription.json
func ExampleExportsClient_CreateOrUpdate_exportCreateOrUpdateBySubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().CreateOrUpdate(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "TestExport", armcostmanagement.Export{
		Properties: &armcostmanagement.ExportProperties{
			Format: to.Ptr(armcostmanagement.FormatTypeCSV),
			Definition: &armcostmanagement.ExportDefinition{
				Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
				DataSet: &armcostmanagement.ExportDataset{
					Configuration: &armcostmanagement.ExportDatasetConfiguration{
						Columns: []*string{
							to.Ptr("Date"),
							to.Ptr("MeterId"),
							to.Ptr("ResourceId"),
							to.Ptr("ResourceLocation"),
							to.Ptr("Quantity")},
					},
					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
				},
				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
			},
			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
				Destination: &armcostmanagement.ExportDeliveryDestination{
					Container:      to.Ptr("exports"),
					ResourceID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
					RootFolderPath: to.Ptr("ad-hoc"),
				},
			},
			Schedule: &armcostmanagement.ExportSchedule{
				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t }()),
					To:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t }()),
				},
				Status: to.Ptr(armcostmanagement.StatusTypeActive),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Export = armcostmanagement.Export{
	// 	Name: to.Ptr("TestExport"),
	// 	Type: to.Ptr("Microsoft.CostManagement/exports"),
	// 	ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/exports/TestExport"),
	// 	Properties: &armcostmanagement.ExportProperties{
	// 		Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 		Definition: &armcostmanagement.ExportDefinition{
	// 			Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 			DataSet: &armcostmanagement.ExportDataset{
	// 				Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 					Columns: []*string{
	// 						to.Ptr("Date"),
	// 						to.Ptr("MeterId"),
	// 						to.Ptr("ResourceId"),
	// 						to.Ptr("ResourceLocation"),
	// 						to.Ptr("Quantity")},
	// 					},
	// 					Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 				},
	// 				Timeframe: to.Ptr(armcostmanagement.TimeframeTypeMonthToDate),
	// 			},
	// 			DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 				Destination: &armcostmanagement.ExportDeliveryDestination{
	// 					Container: to.Ptr("exports"),
	// 					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 					RootFolderPath: to.Ptr("ad-hoc"),
	// 				},
	// 			},
	// 			Schedule: &armcostmanagement.ExportSchedule{
	// 				Recurrence: to.Ptr(armcostmanagement.RecurrenceTypeWeekly),
	// 				RecurrencePeriod: &armcostmanagement.ExportRecurrencePeriod{
	// 					From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 					To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 				},
	// 				Status: to.Ptr(armcostmanagement.StatusTypeActive),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportDeleteByBillingAccount.json
func ExampleExportsClient_Delete_exportDeleteByBillingAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Delete(ctx, "providers/Microsoft.Billing/billingAccounts/123456", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportDeleteByDepartment.json
func ExampleExportsClient_Delete_exportDeleteByDepartment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Delete(ctx, "providers/Microsoft.Billing/billingAccounts/12/departments/1234", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportDeleteByEnrollmentAccount.json
func ExampleExportsClient_Delete_exportDeleteByEnrollmentAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Delete(ctx, "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportDeleteByManagementGroup.json
func ExampleExportsClient_Delete_exportDeleteByManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Delete(ctx, "providers/Microsoft.Management/managementGroups/TestMG", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportDeleteByResourceGroup.json
func ExampleExportsClient_Delete_exportDeleteByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Delete(ctx, "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportDeleteBySubscription.json
func ExampleExportsClient_Delete_exportDeleteBySubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Delete(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunByBillingAccount.json
func ExampleExportsClient_Execute_exportRunByBillingAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Execute(ctx, "providers/Microsoft.Billing/billingAccounts/123456", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunByDepartment.json
func ExampleExportsClient_Execute_exportRunByDepartment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Execute(ctx, "providers/Microsoft.Billing/billingAccounts/12/departments/1234", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunByEnrollmentAccount.json
func ExampleExportsClient_Execute_exportRunByEnrollmentAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Execute(ctx, "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunByManagementGroup.json
func ExampleExportsClient_Execute_exportRunByManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Execute(ctx, "providers/Microsoft.Management/managementGroups/TestMG", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunByResourceGroup.json
func ExampleExportsClient_Execute_exportRunByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Execute(ctx, "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunBySubscription.json
func ExampleExportsClient_Execute_exportRunBySubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewExportsClient().Execute(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunHistoryGetByBillingAccount.json
func ExampleExportsClient_GetExecutionHistory_exportRunHistoryGetByBillingAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().GetExecutionHistory(ctx, "providers/Microsoft.Billing/billingAccounts/123456", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportExecutionListResult = armcostmanagement.ExportExecutionListResult{
	// 	Value: []*armcostmanagement.ExportRun{
	// 		{
	// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccount-id}/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/1e25d58a-a3b0-4916-9542-6e04a89bc100"),
	// 			Properties: &armcostmanagement.ExportRunProperties{
	// 				ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeOnDemand),
	// 				FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_1e25d58a-a3b0-4916-9542-6e04a89bc100.csv"),
	// 				ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:28.037Z"); return t}()),
	// 				ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:16.912Z"); return t}()),
	// 				RunSettings: &armcostmanagement.CommonExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 							},
	// 						},
	// 					},
	// 					Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 					SubmittedBy: to.Ptr("john.doe@gmail.com"),
	// 					SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:15.601Z"); return t}()),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/{billingAccount-id}/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/11ac6811-dca3-46ad-b326-4704cf0c58ef"),
	// 				Properties: &armcostmanagement.ExportRunProperties{
	// 					ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeScheduled),
	// 					FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_11ac6811-dca3-46ad-b326-4704cf0c58ef.csv"),
	// 					ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:04:19.722Z"); return t}()),
	// 					ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					RunSettings: &armcostmanagement.CommonExportProperties{
	// 						Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 						Definition: &armcostmanagement.ExportDefinition{
	// 							Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 							DataSet: &armcostmanagement.ExportDataset{
	// 								Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 									Columns: []*string{
	// 										to.Ptr("Date"),
	// 										to.Ptr("MeterId"),
	// 										to.Ptr("ResourceId"),
	// 										to.Ptr("ResourceLocation"),
	// 										to.Ptr("Quantity")},
	// 									},
	// 									Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 								},
	// 								TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 									From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 									To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 								},
	// 								Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 							},
	// 							DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 								Destination: &armcostmanagement.ExportDeliveryDestination{
	// 									Container: to.Ptr("exports"),
	// 									ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 									RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 								},
	// 							},
	// 						},
	// 						Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 						SubmittedBy: to.Ptr("System"),
	// 						SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunHistoryGetByDepartment.json
func ExampleExportsClient_GetExecutionHistory_exportRunHistoryGetByDepartment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().GetExecutionHistory(ctx, "providers/Microsoft.Billing/billingAccounts/12/departments/1234", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportExecutionListResult = armcostmanagement.ExportExecutionListResult{
	// 	Value: []*armcostmanagement.ExportRun{
	// 		{
	// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12/departments/1234/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/1e25d58a-a3b0-4916-9542-6e04a89bc100"),
	// 			Properties: &armcostmanagement.ExportRunProperties{
	// 				ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeOnDemand),
	// 				FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_1e25d58a-a3b0-4916-9542-6e04a89bc100.csv"),
	// 				ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:28.037Z"); return t}()),
	// 				ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:16.912Z"); return t}()),
	// 				RunSettings: &armcostmanagement.CommonExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 							},
	// 						},
	// 					},
	// 					Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 					SubmittedBy: to.Ptr("john.doe@gmail.com"),
	// 					SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:15.601Z"); return t}()),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12/departments/1234/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/11ac6811-dca3-46ad-b326-4704cf0c58ef"),
	// 				Properties: &armcostmanagement.ExportRunProperties{
	// 					ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeScheduled),
	// 					FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_11ac6811-dca3-46ad-b326-4704cf0c58ef.csv"),
	// 					ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:04:19.722Z"); return t}()),
	// 					ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					RunSettings: &armcostmanagement.CommonExportProperties{
	// 						Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 						Definition: &armcostmanagement.ExportDefinition{
	// 							Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 							DataSet: &armcostmanagement.ExportDataset{
	// 								Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 									Columns: []*string{
	// 										to.Ptr("Date"),
	// 										to.Ptr("MeterId"),
	// 										to.Ptr("ResourceId"),
	// 										to.Ptr("ResourceLocation"),
	// 										to.Ptr("Quantity")},
	// 									},
	// 									Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 								},
	// 								TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 									From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 									To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 								},
	// 								Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 							},
	// 							DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 								Destination: &armcostmanagement.ExportDeliveryDestination{
	// 									Container: to.Ptr("exports"),
	// 									ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 									RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 								},
	// 							},
	// 						},
	// 						Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 						SubmittedBy: to.Ptr("System"),
	// 						SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunHistoryGetByEnrollmentAccount.json
func ExampleExportsClient_GetExecutionHistory_exportRunHistoryGetByEnrollmentAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().GetExecutionHistory(ctx, "providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportExecutionListResult = armcostmanagement.ExportExecutionListResult{
	// 	Value: []*armcostmanagement.ExportRun{
	// 		{
	// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/1e25d58a-a3b0-4916-9542-6e04a89bc100"),
	// 			Properties: &armcostmanagement.ExportRunProperties{
	// 				ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeOnDemand),
	// 				FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_1e25d58a-a3b0-4916-9542-6e04a89bc100.csv"),
	// 				ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:28.037Z"); return t}()),
	// 				ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:16.912Z"); return t}()),
	// 				RunSettings: &armcostmanagement.CommonExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 							},
	// 						},
	// 					},
	// 					Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 					SubmittedBy: to.Ptr("john.doe@gmail.com"),
	// 					SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:15.601Z"); return t}()),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/11ac6811-dca3-46ad-b326-4704cf0c58ef"),
	// 				Properties: &armcostmanagement.ExportRunProperties{
	// 					ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeScheduled),
	// 					FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_11ac6811-dca3-46ad-b326-4704cf0c58ef.csv"),
	// 					ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:04:19.722Z"); return t}()),
	// 					ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					RunSettings: &armcostmanagement.CommonExportProperties{
	// 						Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 						Definition: &armcostmanagement.ExportDefinition{
	// 							Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 							DataSet: &armcostmanagement.ExportDataset{
	// 								Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 									Columns: []*string{
	// 										to.Ptr("Date"),
	// 										to.Ptr("MeterId"),
	// 										to.Ptr("ResourceId"),
	// 										to.Ptr("ResourceLocation"),
	// 										to.Ptr("Quantity")},
	// 									},
	// 									Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 								},
	// 								TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 									From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 									To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 								},
	// 								Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 							},
	// 							DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 								Destination: &armcostmanagement.ExportDeliveryDestination{
	// 									Container: to.Ptr("exports"),
	// 									ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 									RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 								},
	// 							},
	// 						},
	// 						Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 						SubmittedBy: to.Ptr("System"),
	// 						SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunHistoryGetByManagementGroup.json
func ExampleExportsClient_GetExecutionHistory_exportRunHistoryGetByManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().GetExecutionHistory(ctx, "providers/Microsoft.Management/managementGroups/TestMG", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportExecutionListResult = armcostmanagement.ExportExecutionListResult{
	// 	Value: []*armcostmanagement.ExportRun{
	// 		{
	// 			ID: to.Ptr("providers/Microsoft.Management/managementGroups/TestMG/providers/Microsoft.CostManagement/exports/TestExport/Run/1e25d58a-a3b0-4916-9542-6e04a89bc100"),
	// 			Properties: &armcostmanagement.ExportRunProperties{
	// 				ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeOnDemand),
	// 				FileName: to.Ptr("ScheduledForTestExport/TestExportSchedule/20180729-20180804/TestExportSchedule_1e25d58a-a3b0-4916-9542-6e04a89bc100.csv"),
	// 				ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:28.037Z"); return t}()),
	// 				ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:16.912Z"); return t}()),
	// 				RunSettings: &armcostmanagement.CommonExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 							},
	// 						},
	// 					},
	// 					Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 					SubmittedBy: to.Ptr("john.doe@gmail.com"),
	// 					SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:15.601Z"); return t}()),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("providers/Microsoft.Management/managementGroups/TestMG/providers/Microsoft.CostManagement/exports/TestExport/Run/11ac6811-dca3-46ad-b326-4704cf0c58ef"),
	// 				Properties: &armcostmanagement.ExportRunProperties{
	// 					ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeScheduled),
	// 					FileName: to.Ptr("ScheduledForTestExport/TestExportSchedule/20180729-20180804/TestExportSchedule_11ac6811-dca3-46ad-b326-4704cf0c58ef.csv"),
	// 					ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:04:19.722Z"); return t}()),
	// 					ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					RunSettings: &armcostmanagement.CommonExportProperties{
	// 						Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 						Definition: &armcostmanagement.ExportDefinition{
	// 							Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 							DataSet: &armcostmanagement.ExportDataset{
	// 								Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 									Columns: []*string{
	// 										to.Ptr("Date"),
	// 										to.Ptr("MeterId"),
	// 										to.Ptr("ResourceId"),
	// 										to.Ptr("ResourceLocation"),
	// 										to.Ptr("Quantity")},
	// 									},
	// 									Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 								},
	// 								TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 									From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 									To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 								},
	// 								Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 							},
	// 							DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 								Destination: &armcostmanagement.ExportDeliveryDestination{
	// 									Container: to.Ptr("exports"),
	// 									ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 									RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 								},
	// 							},
	// 						},
	// 						Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 						SubmittedBy: to.Ptr("System"),
	// 						SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunHistoryGetByResourceGroup.json
func ExampleExportsClient_GetExecutionHistory_exportRunHistoryGetByResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().GetExecutionHistory(ctx, "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportExecutionListResult = armcostmanagement.ExportExecutionListResult{
	// 	Value: []*armcostmanagement.ExportRun{
	// 		{
	// 			ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/1e25d58a-a3b0-4916-9542-6e04a89bc100"),
	// 			Properties: &armcostmanagement.ExportRunProperties{
	// 				ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeOnDemand),
	// 				FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_1e25d58a-a3b0-4916-9542-6e04a89bc100.csv"),
	// 				ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:28.037Z"); return t}()),
	// 				ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:16.912Z"); return t}()),
	// 				RunSettings: &armcostmanagement.CommonExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 							},
	// 						},
	// 					},
	// 					Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 					SubmittedBy: to.Ptr("john.doe@gmail.com"),
	// 					SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:15.601Z"); return t}()),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/11ac6811-dca3-46ad-b326-4704cf0c58ef"),
	// 				Properties: &armcostmanagement.ExportRunProperties{
	// 					ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeScheduled),
	// 					FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_11ac6811-dca3-46ad-b326-4704cf0c58ef.csv"),
	// 					ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:04:19.722Z"); return t}()),
	// 					ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					RunSettings: &armcostmanagement.CommonExportProperties{
	// 						Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 						Definition: &armcostmanagement.ExportDefinition{
	// 							Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 							DataSet: &armcostmanagement.ExportDataset{
	// 								Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 									Columns: []*string{
	// 										to.Ptr("Date"),
	// 										to.Ptr("MeterId"),
	// 										to.Ptr("ResourceId"),
	// 										to.Ptr("ResourceLocation"),
	// 										to.Ptr("Quantity")},
	// 									},
	// 									Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 								},
	// 								TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 									From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 									To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 								},
	// 								Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 							},
	// 							DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 								Destination: &armcostmanagement.ExportDeliveryDestination{
	// 									Container: to.Ptr("exports"),
	// 									ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 									RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 								},
	// 							},
	// 						},
	// 						Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 						SubmittedBy: to.Ptr("System"),
	// 						SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					},
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExportRunHistoryGetBySubscription.json
func ExampleExportsClient_GetExecutionHistory_exportRunHistoryGetBySubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExportsClient().GetExecutionHistory(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "TestExport", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExportExecutionListResult = armcostmanagement.ExportExecutionListResult{
	// 	Value: []*armcostmanagement.ExportRun{
	// 		{
	// 			ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/1e25d58a-a3b0-4916-9542-6e04a89bc100"),
	// 			Properties: &armcostmanagement.ExportRunProperties{
	// 				ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeOnDemand),
	// 				FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_1e25d58a-a3b0-4916-9542-6e04a89bc100.csv"),
	// 				ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:28.037Z"); return t}()),
	// 				ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:16.912Z"); return t}()),
	// 				RunSettings: &armcostmanagement.CommonExportProperties{
	// 					Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 					Definition: &armcostmanagement.ExportDefinition{
	// 						Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 						DataSet: &armcostmanagement.ExportDataset{
	// 							Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 								Columns: []*string{
	// 									to.Ptr("Date"),
	// 									to.Ptr("MeterId"),
	// 									to.Ptr("ResourceId"),
	// 									to.Ptr("ResourceLocation"),
	// 									to.Ptr("Quantity")},
	// 								},
	// 								Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 							},
	// 							TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 								From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 								To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 							},
	// 							Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 						},
	// 						DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 							Destination: &armcostmanagement.ExportDeliveryDestination{
	// 								Container: to.Ptr("exports"),
	// 								ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 								RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 							},
	// 						},
	// 					},
	// 					Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 					SubmittedBy: to.Ptr("john.doe@gmail.com"),
	// 					SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T07:52:15.601Z"); return t}()),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/exports/JohnDoeSchedule/Run/11ac6811-dca3-46ad-b326-4704cf0c58ef"),
	// 				Properties: &armcostmanagement.ExportRunProperties{
	// 					ExecutionType: to.Ptr(armcostmanagement.ExecutionTypeScheduled),
	// 					FileName: to.Ptr("ScheduledTestsForJohnDoe/JohnDoeSchedule/20180729-20180804/JohnDoeSchedule_11ac6811-dca3-46ad-b326-4704cf0c58ef.csv"),
	// 					ProcessingEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:04:19.722Z"); return t}()),
	// 					ProcessingStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					RunSettings: &armcostmanagement.CommonExportProperties{
	// 						Format: to.Ptr(armcostmanagement.FormatTypeCSV),
	// 						Definition: &armcostmanagement.ExportDefinition{
	// 							Type: to.Ptr(armcostmanagement.ExportTypeActualCost),
	// 							DataSet: &armcostmanagement.ExportDataset{
	// 								Configuration: &armcostmanagement.ExportDatasetConfiguration{
	// 									Columns: []*string{
	// 										to.Ptr("Date"),
	// 										to.Ptr("MeterId"),
	// 										to.Ptr("ResourceId"),
	// 										to.Ptr("ResourceLocation"),
	// 										to.Ptr("Quantity")},
	// 									},
	// 									Granularity: to.Ptr(armcostmanagement.GranularityTypeDaily),
	// 								},
	// 								TimePeriod: &armcostmanagement.ExportTimePeriod{
	// 									From: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-01T00:00:00.000Z"); return t}()),
	// 									To: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-31T00:00:00.000Z"); return t}()),
	// 								},
	// 								Timeframe: to.Ptr(armcostmanagement.TimeframeTypeCustom),
	// 							},
	// 							DeliveryInfo: &armcostmanagement.ExportDeliveryInfo{
	// 								Destination: &armcostmanagement.ExportDeliveryDestination{
	// 									Container: to.Ptr("exports"),
	// 									ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Storage/storageAccounts/ccmeastusdiag182"),
	// 									RootFolderPath: to.Ptr("ScheduledTestsForJohnDoe"),
	// 								},
	// 							},
	// 						},
	// 						Status: to.Ptr(armcostmanagement.ExecutionStatusCompleted),
	// 						SubmittedBy: to.Ptr("System"),
	// 						SubmittedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-03T09:03:58.571Z"); return t}()),
	// 					},
	// 			}},
	// 		}
}
