//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcostmanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/BillingAccountDimensionsList.json
func ExampleDimensionsClient_NewListPager_billingAccountDimensionsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/100", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2018-05-01_2018-05-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/providers/microsoft.CostManagement/dimensions_ResourceGroup_2018-05-01_2018-05-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/providers/microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("thoroetrg01"),
		// 						to.Ptr("default-notificationhubs-westus"),
		// 						to.Ptr("jedikeyvaultrg"),
		// 						to.Ptr("contosocodeflow8d4a"),
		// 						to.Ptr("noobaa")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCABillingAccountDimensionsList.json
func ExampleDimensionsClient_NewListPager_billingAccountDimensionsListMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/providers/microsoft.CostManagement/dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](377),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/providers/microsoft.CostManagement/dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource type"),
		// 				Category: to.Ptr("ResourceType"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](37),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/BillingAccountDimensionsListExpandAndTop.json
func ExampleDimensionsClient_NewListPager_billingAccountDimensionsListExpandAndTopLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/100", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/providers/microsoft.CostManagement/dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/providers/microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("microsoft.automation/automationaccounts"),
		// 						to.Ptr("microsoft.databricks/workspaces"),
		// 						to.Ptr("microsoft.dbformysql/servers"),
		// 						to.Ptr("microsoft.containerregistry/registries"),
		// 						to.Ptr("microsoft.search/searchservices")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCABillingAccountDimensionsListExpandAndTop.json
func ExampleDimensionsClient_NewListPager_billingAccountDimensionsListExpandAndTopMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/providers/microsoft.CostManagement/dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/providers/microsoft.CostManagement/dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("microsoft.automation/automationaccounts"),
		// 						to.Ptr("microsoft.databricks/workspaces"),
		// 						to.Ptr("microsoft.dbformysql/servers"),
		// 						to.Ptr("microsoft.containerregistry/registries"),
		// 						to.Ptr("microsoft.search/searchservices")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/BillingAccountDimensionsListWithFilter.json
func ExampleDimensionsClient_NewListPager_billingAccountDimensionsListWithFilterLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/100", &armcostmanagement.DimensionsClientListOptions{Filter: to.Ptr("properties/category eq 'resourceId'"),
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/providers/microsoft.CostManagement/dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource Id"),
		// 				Category: to.Ptr("ResourceId"),
		// 				Data: []*string{
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/urphealthaccount"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/srphytenaccount"),
		// 					to.Ptr("/subscriptions/67e24f6b-1ec2-4c90-993a-dc2d25b00b6c/resourcegroups/defaultresourcegroup-eus/providers/microsoft.operationalinsights/workspaces/defaultworkspace-67e24f6b-1ec2-4c90-993a-dc2d25b00b6c-eus"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg-sql-ha/providers/microsoft.compute/virtualmachines/sql-4qqp1"),
		// 					to.Ptr("/subscriptions/a98d6dc5-eb8f-46cf-8938-f1fb08f03706/resourcegroups/databricks-rg-testwsp-xijmsdubneexm/providers/microsoft.compute/disks/488cdb42bf74474a98075415be3f806c-containerrootvolume")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](1409),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCABillingAccountDimensionsListWithFilter.json
func ExampleDimensionsClient_NewListPager_billingAccountDimensionsListWithFilterMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789", &armcostmanagement.DimensionsClientListOptions{Filter: to.Ptr("properties/category eq 'resourceId'"),
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceId_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/providers/microsoft.CostManagement/dimensions_ResourceId_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource Id"),
		// 				Category: to.Ptr("ResourceId"),
		// 				Data: []*string{
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/urphealthaccount"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/srphytenaccount"),
		// 					to.Ptr("/subscriptions/67e24f6b-1ec2-4c90-993a-dc2d25b00b6c/resourcegroups/defaultresourcegroup-eus/providers/microsoft.operationalinsights/workspaces/defaultworkspace-67e24f6b-1ec2-4c90-993a-dc2d25b00b6c-eus"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg-sql-ha/providers/microsoft.compute/virtualmachines/sql-4qqp1"),
		// 					to.Ptr("/subscriptions/a98d6dc5-eb8f-46cf-8938-f1fb08f03706/resourcegroups/databricks-rg-testwsp-xijmsdubneexm/providers/microsoft.compute/disks/488cdb42bf74474a98075415be3f806c-containerrootvolume")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](1409),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCABillingProfileDimensionsList.json
func ExampleDimensionsClient_NewListPager_billingProfileDimensionsListMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/providers/microsoft.CostManagement/dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](377),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/providers/microsoft.CostManagement/dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource type"),
		// 				Category: to.Ptr("ResourceType"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](37),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCABillingProfileDimensionsListExpandAndTop.json
func ExampleDimensionsClient_NewListPager_billingProfileDimensionsListExpandAndTopMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/providers/microsoft.CostManagement/dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/providers/microsoft.CostManagement/dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("microsoft.automation/automationaccounts"),
		// 						to.Ptr("microsoft.databricks/workspaces"),
		// 						to.Ptr("microsoft.dbformysql/servers"),
		// 						to.Ptr("microsoft.containerregistry/registries"),
		// 						to.Ptr("microsoft.search/searchservices")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCABillingProfileDimensionsListWithFilter.json
func ExampleDimensionsClient_NewListPager_billingProfileDimensionsListWithFilterMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579", &armcostmanagement.DimensionsClientListOptions{Filter: to.Ptr("properties/category eq 'resourceId'"),
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceId_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/providers/microsoft.CostManagement/dimensions_ResourceId_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource Id"),
		// 				Category: to.Ptr("ResourceId"),
		// 				Data: []*string{
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/urphealthaccount"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/srphytenaccount"),
		// 					to.Ptr("/subscriptions/67e24f6b-1ec2-4c90-993a-dc2d25b00b6c/resourcegroups/defaultresourcegroup-eus/providers/microsoft.operationalinsights/workspaces/defaultworkspace-67e24f6b-1ec2-4c90-993a-dc2d25b00b6c-eus"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg-sql-ha/providers/microsoft.compute/virtualmachines/sql-4qqp1"),
		// 					to.Ptr("/subscriptions/a98d6dc5-eb8f-46cf-8938-f1fb08f03706/resourcegroups/databricks-rg-testwsp-xijmsdubneexm/providers/microsoft.compute/disks/488cdb42bf74474a98075415be3f806c-containerrootvolume")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](1409),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCACustomerDimensionsList.json
func ExampleDimensionsClient_NewListPager_customerDimensionsListMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789/customers/5678", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/customers/5678/providers/microsoft.CostManagement/dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](377),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/customers/5678/providers/microsoft.CostManagement/dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource type"),
		// 				Category: to.Ptr("ResourceType"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](37),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCACustomerDimensionsListExpandAndTop.json
func ExampleDimensionsClient_NewListPager_customerDimensionsListExpandAndTopMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789/customers/5678", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/customers/5678/providers/microsoft.CostManagement/dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/customers/5678/providers/microsoft.CostManagement/dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("microsoft.automation/automationaccounts"),
		// 						to.Ptr("microsoft.databricks/workspaces"),
		// 						to.Ptr("microsoft.dbformysql/servers"),
		// 						to.Ptr("microsoft.containerregistry/registries"),
		// 						to.Ptr("microsoft.search/searchservices")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCACustomerDimensionsListWithFilter.json
func ExampleDimensionsClient_NewListPager_customerDimensionsListWithFilterMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789/customers/5678", &armcostmanagement.DimensionsClientListOptions{Filter: to.Ptr("properties/category eq 'resourceId'"),
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceId_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/customers/5678/providers/microsoft.CostManagement/dimensions_ResourceId_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource Id"),
		// 				Category: to.Ptr("ResourceId"),
		// 				Data: []*string{
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/urphealthaccount"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/srphytenaccount"),
		// 					to.Ptr("/subscriptions/67e24f6b-1ec2-4c90-993a-dc2d25b00b6c/resourcegroups/defaultresourcegroup-eus/providers/microsoft.operationalinsights/workspaces/defaultworkspace-67e24f6b-1ec2-4c90-993a-dc2d25b00b6c-eus"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg-sql-ha/providers/microsoft.compute/virtualmachines/sql-4qqp1"),
		// 					to.Ptr("/subscriptions/a98d6dc5-eb8f-46cf-8938-f1fb08f03706/resourcegroups/databricks-rg-testwsp-xijmsdubneexm/providers/microsoft.compute/disks/488cdb42bf74474a98075415be3f806c-containerrootvolume")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](1409),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/DepartmentDimensionsList.json
func ExampleDimensionsClient_NewListPager_departmentDimensionsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/100/departments/123", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2018-05-01_2018-05-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/departments/123/providers/microsoft.CostManagement/dimensions_ResourceGroup_2018-05-01_2018-05-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/departments/123/providers/microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("thoroetrg01"),
		// 						to.Ptr("default-notificationhubs-westus"),
		// 						to.Ptr("jedikeyvaultrg"),
		// 						to.Ptr("contosocodeflow8d4a"),
		// 						to.Ptr("noobaa")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/DepartmentDimensionsListExpandAndTop.json
func ExampleDimensionsClient_NewListPager_departmentDimensionsListExpandAndTopLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/100/departments/123", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/departments/123/providers/microsoft.CostManagement/dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/departments/123/providers/microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("microsoft.automation/automationaccounts"),
		// 						to.Ptr("microsoft.databricks/workspaces"),
		// 						to.Ptr("microsoft.dbformysql/servers"),
		// 						to.Ptr("microsoft.containerregistry/registries"),
		// 						to.Ptr("microsoft.search/searchservices")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/DepartmentDimensionsListWithFilter.json
func ExampleDimensionsClient_NewListPager_departmentDimensionsListWithFilterLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/100/departments/123", &armcostmanagement.DimensionsClientListOptions{Filter: to.Ptr("properties/category eq 'resourceId'"),
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/departments/123/providers/microsoft.CostManagement/dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource Id"),
		// 				Category: to.Ptr("ResourceId"),
		// 				Data: []*string{
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/urphealthaccount"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/srphytenaccount"),
		// 					to.Ptr("/subscriptions/67e24f6b-1ec2-4c90-993a-dc2d25b00b6c/resourcegroups/defaultresourcegroup-eus/providers/microsoft.operationalinsights/workspaces/defaultworkspace-67e24f6b-1ec2-4c90-993a-dc2d25b00b6c-eus"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg-sql-ha/providers/microsoft.compute/virtualmachines/sql-4qqp1"),
		// 					to.Ptr("/subscriptions/a98d6dc5-eb8f-46cf-8938-f1fb08f03706/resourcegroups/databricks-rg-testwsp-xijmsdubneexm/providers/microsoft.compute/disks/488cdb42bf74474a98075415be3f806c-containerrootvolume")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](1409),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/EnrollmentAccountDimensionsList.json
func ExampleDimensionsClient_NewListPager_enrollmentAccountDimensionsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2018-05-01_2018-05-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/microsoft.CostManagement/dimensions_ResourceGroup_2018-05-01_2018-05-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](377),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource type"),
		// 				Category: to.Ptr("ResourceType"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](37),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/EnrollmentAccountDimensionsListExpandAndTop.json
func ExampleDimensionsClient_NewListPager_enrollmentAccountDimensionsListExpandAndTopLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/microsoft.CostManagement/dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("microsoft.automation/automationaccounts"),
		// 						to.Ptr("microsoft.databricks/workspaces"),
		// 						to.Ptr("microsoft.dbformysql/servers"),
		// 						to.Ptr("microsoft.containerregistry/registries"),
		// 						to.Ptr("microsoft.search/searchservices")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/EnrollmentAccountDimensionsListWithFilter.json
func ExampleDimensionsClient_NewListPager_enrollmentAccountDimensionsListWithFilterLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456", &armcostmanagement.DimensionsClientListOptions{Filter: to.Ptr("properties/category eq 'resourceId'"),
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/100/enrollmentAccounts/456/providers/microsoft.CostManagement/dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource Id"),
		// 				Category: to.Ptr("ResourceId"),
		// 				Data: []*string{
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/urphealthaccount"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/srphytenaccount"),
		// 					to.Ptr("/subscriptions/67e24f6b-1ec2-4c90-993a-dc2d25b00b6c/resourcegroups/defaultresourcegroup-eus/providers/microsoft.operationalinsights/workspaces/defaultworkspace-67e24f6b-1ec2-4c90-993a-dc2d25b00b6c-eus"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg-sql-ha/providers/microsoft.compute/virtualmachines/sql-4qqp1"),
		// 					to.Ptr("/subscriptions/a98d6dc5-eb8f-46cf-8938-f1fb08f03706/resourcegroups/databricks-rg-testwsp-xijmsdubneexm/providers/microsoft.compute/disks/488cdb42bf74474a98075415be3f806c-containerrootvolume")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](1409),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCAInvoiceSectionDimensionsList.json
func ExampleDimensionsClient_NewListPager_invoiceSectionDimensionsListMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/invoiceSections/9876", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/invoiceSections/9876/providers/microsoft.CostManagement/dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](377),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/invoiceSections/9876/providers/microsoft.CostManagement/dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource type"),
		// 				Category: to.Ptr("ResourceType"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](37),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCAInvoiceSectionDimensionsListExpandAndTop.json
func ExampleDimensionsClient_NewListPager_invoiceSectionDimensionsListExpandAndTopMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/invoiceSections/9876", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/invoiceSections/9876/providers/microsoft.CostManagement/dimensions_ResourceGroup_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/invoiceSections/9876/providers/microsoft.CostManagement/dimensions_ResourceType_2019-10-01_2019-10-31"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("microsoft.automation/automationaccounts"),
		// 						to.Ptr("microsoft.databricks/workspaces"),
		// 						to.Ptr("microsoft.dbformysql/servers"),
		// 						to.Ptr("microsoft.containerregistry/registries"),
		// 						to.Ptr("microsoft.search/searchservices")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/MCAInvoiceSectionDimensionsListWithFilter.json
func ExampleDimensionsClient_NewListPager_invoiceSectionDimensionsListWithFilterMca() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/invoiceSections/9876", &armcostmanagement.DimensionsClientListOptions{Filter: to.Ptr("properties/category eq 'resourceId'"),
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceId_2019-10-01_2019-10-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Billing/billingAccounts/12345:6789/billingProfiles/13579/invoiceSections/9876/providers/microsoft.CostManagement/dimensions_ResourceId_2019-10-01_2019-10-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource Id"),
		// 				Category: to.Ptr("ResourceId"),
		// 				Data: []*string{
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/urphealthaccount"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/srphytenaccount"),
		// 					to.Ptr("/subscriptions/67e24f6b-1ec2-4c90-993a-dc2d25b00b6c/resourcegroups/defaultresourcegroup-eus/providers/microsoft.operationalinsights/workspaces/defaultworkspace-67e24f6b-1ec2-4c90-993a-dc2d25b00b6c-eus"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg-sql-ha/providers/microsoft.compute/virtualmachines/sql-4qqp1"),
		// 					to.Ptr("/subscriptions/a98d6dc5-eb8f-46cf-8938-f1fb08f03706/resourcegroups/databricks-rg-testwsp-xijmsdubneexm/providers/microsoft.compute/disks/488cdb42bf74474a98075415be3f806c-containerrootvolume")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](1409),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-10-01T07:00:00.000Z"); return t}()),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ManagementGroupDimensionsList.json
func ExampleDimensionsClient_NewListPager_managementGroupDimensionsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Management/managementGroups/MyMgId", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2018-05-01_2018-05-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Management/managementGroups/MyMgId/providers/microsoft.CostManagement/dimensions_ResourceGroup_2018-05-01_2018-05-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](377),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Management/managementGroups/MyMgId/providers/microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource type"),
		// 				Category: to.Ptr("ResourceType"),
		// 				Data: []*string{
		// 				},
		// 				FilterEnabled: to.Ptr(true),
		// 				GroupingEnabled: to.Ptr(true),
		// 				Total: to.Ptr[int32](37),
		// 				UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 				UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ManagementGroupDimensionsListExpandAndTop.json
func ExampleDimensionsClient_NewListPager_managementGroupDimensionsListExpandAndTopLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Management/managementGroups/MyMgId", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Management/managementGroups/MyMgId/providers/microsoft.CostManagement/dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](377),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.Management/managementGroups/MyMgId/providers/microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("microsoft.automation/automationaccounts"),
		// 						to.Ptr("microsoft.databricks/workspaces"),
		// 						to.Ptr("microsoft.dbformysql/servers"),
		// 						to.Ptr("microsoft.containerregistry/registries"),
		// 						to.Ptr("microsoft.search/searchservices")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](37),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ManagementGroupDimensionsListWithFilter.json
func ExampleDimensionsClient_NewListPager_managementGroupDimensionsListWithFilterLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("providers/Microsoft.Management/managementGroups/MyMgId", &armcostmanagement.DimensionsClientListOptions{Filter: to.Ptr("properties/category eq 'resourceId'"),
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.Management/managementGroups/MyMgId/providers/microsoft.CostManagement/dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource Id"),
		// 				Category: to.Ptr("ResourceId"),
		// 				Data: []*string{
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/urphealthaccount"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/srphytenaccount"),
		// 					to.Ptr("/subscriptions/67e24f6b-1ec2-4c90-993a-dc2d25b00b6c/resourcegroups/defaultresourcegroup-eus/providers/microsoft.operationalinsights/workspaces/defaultworkspace-67e24f6b-1ec2-4c90-993a-dc2d25b00b6c-eus"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg-sql-ha/providers/microsoft.compute/virtualmachines/sql-4qqp1"),
		// 					to.Ptr("/subscriptions/a98d6dc5-eb8f-46cf-8938-f1fb08f03706/resourcegroups/databricks-rg-testwsp-xijmsdubneexm/providers/microsoft.compute/disks/488cdb42bf74474a98075415be3f806c-containerrootvolume")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](1409),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ResourceGroupDimensionsList.json
func ExampleDimensionsClient_NewListPager_resourceGroupDimensionsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/system.orlando", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/system.orlando/providers/microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource type"),
		// 				Category: to.Ptr("ResourceType"),
		// 				Data: []*string{
		// 					to.Ptr("microsoft.storage/storageaccounts")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](1),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/system.orlando/providers/microsoft.CostManagement/dimensions_ResourceId_2018-05-01_2018-05-31_5"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource Id"),
		// 					Category: to.Ptr("ResourceId"),
		// 					Data: []*string{
		// 						to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/authprod"),
		// 						to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/systemevents"),
		// 						to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/armadminprod"),
		// 						to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/srphytenaccount"),
		// 						to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/system.orlando/providers/microsoft.storage/storageaccounts/publicsystemportal")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](27),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/SubscriptionDimensionsList.json
func ExampleDimensionsClient_NewListPager_subscriptionDimensionsListLegacy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", &armcostmanagement.DimensionsClientListOptions{Filter: nil,
		Expand:    to.Ptr("properties/data"),
		Skiptoken: nil,
		Top:       to.Ptr[int32](5),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 			ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/dimensions_ResourceGroup_2018-05-01_2018-05-31_5"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource group"),
		// 				Category: to.Ptr("ResourceGroup"),
		// 				Data: []*string{
		// 					to.Ptr("dcrg"),
		// 					to.Ptr("rg"),
		// 					to.Ptr("offlinegalleryrg"),
		// 					to.Ptr("system.orlando.adminkeyvault"),
		// 					to.Ptr("system.orlando.keyvault")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](68),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Type: to.Ptr("microsoft.CostManagement/dimensions"),
		// 				ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/dimensions_ResourceType_2018-05-01_2018-05-31_5"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource type"),
		// 					Category: to.Ptr("ResourceType"),
		// 					Data: []*string{
		// 						to.Ptr("microsoft.storage/storageaccounts"),
		// 						to.Ptr("microsoft.web.admin/role"),
		// 						to.Ptr("microsoft.sql/servers"),
		// 						to.Ptr("microsoft.compute/virtualmachines")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](4),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-31T07:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-05-01T07:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExternalBillingAccountsDimensions.json
func ExampleDimensionsClient_NewByExternalCloudProviderTypePager_externalBillingAccountDimensionList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewByExternalCloudProviderTypePager(armcostmanagement.ExternalCloudProviderTypeExternalBillingAccounts, "100", &armcostmanagement.DimensionsClientByExternalCloudProviderTypeOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceType_2019-12-01_2019-12-31"),
		// 			Type: to.Ptr("microsoft.consumption/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.CostManagement/externalBillingAccounts/100/dimensions_ResourceType_2019-12-01_2019-12-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource type"),
		// 				Category: to.Ptr("ResourceType"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](0),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-31T00:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-01T00:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceId_2019-12-01_2019-12-31"),
		// 				Type: to.Ptr("microsoft.consumption/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.CostManagement/externalBillingAccounts/100/dimensions_ResourceId_2019-12-01_2019-12-31"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource ID"),
		// 					Category: to.Ptr("ResourceId"),
		// 					Data: []*string{
		// 						to.Ptr("thoroetrg01"),
		// 						to.Ptr("default-notificationhubs-westus"),
		// 						to.Ptr("jedikeyvaultrg"),
		// 						to.Ptr("contosocodeflow8d4a"),
		// 						to.Ptr("noobaa")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](0),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-31T00:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-01T00:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/ExternalSubscriptionsDimensions.json
func ExampleDimensionsClient_NewByExternalCloudProviderTypePager_externalSubscriptionDimensionList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDimensionsClient().NewByExternalCloudProviderTypePager(armcostmanagement.ExternalCloudProviderTypeExternalSubscriptions, "100", &armcostmanagement.DimensionsClientByExternalCloudProviderTypeOptions{Filter: nil,
		Expand:    nil,
		Skiptoken: nil,
		Top:       nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DimensionsListResult = armcostmanagement.DimensionsListResult{
		// 	Value: []*armcostmanagement.Dimension{
		// 		{
		// 			Name: to.Ptr("dimensions_ResourceType_2019-12-01_2019-12-31"),
		// 			Type: to.Ptr("microsoft.consumption/dimensions"),
		// 			ID: to.Ptr("providers/Microsoft.CostManagement/externalSubscriptions/123/dimensions_ResourceType_2019-12-01_2019-12-31"),
		// 			Properties: &armcostmanagement.DimensionProperties{
		// 				Description: to.Ptr("Resource type"),
		// 				Category: to.Ptr("ResourceType"),
		// 				Data: []*string{
		// 					to.Ptr("thoroetrg01"),
		// 					to.Ptr("default-notificationhubs-westus"),
		// 					to.Ptr("jedikeyvaultrg"),
		// 					to.Ptr("contosocodeflow8d4a"),
		// 					to.Ptr("noobaa")},
		// 					FilterEnabled: to.Ptr(true),
		// 					GroupingEnabled: to.Ptr(true),
		// 					Total: to.Ptr[int32](0),
		// 					UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-31T00:00:00.000Z"); return t}()),
		// 					UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-01T00:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("dimensions_ResourceId_2019-12-01_2019-12-31"),
		// 				Type: to.Ptr("microsoft.consumption/dimensions"),
		// 				ID: to.Ptr("providers/Microsoft.CostManagement/externalSubscriptions/123/dimensions_ResourceId_2019-12-01_2019-12-31"),
		// 				Properties: &armcostmanagement.DimensionProperties{
		// 					Description: to.Ptr("Resource ID"),
		// 					Category: to.Ptr("ResourceId"),
		// 					Data: []*string{
		// 						to.Ptr("thoroetrg01"),
		// 						to.Ptr("default-notificationhubs-westus"),
		// 						to.Ptr("jedikeyvaultrg"),
		// 						to.Ptr("contosocodeflow8d4a"),
		// 						to.Ptr("noobaa")},
		// 						FilterEnabled: to.Ptr(true),
		// 						GroupingEnabled: to.Ptr(true),
		// 						Total: to.Ptr[int32](0),
		// 						UsageEnd: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-31T00:00:00.000Z"); return t}()),
		// 						UsageStart: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-01T00:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}
