//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcontainerservicefleet_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerservicefleet/armcontainerservicefleet"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/containerservice/resource-manager/Microsoft.ContainerService/fleet/preview/2024-02-02-preview/examples/UpdateRuns_ListByFleet.json
func ExampleUpdateRunsClient_NewListByFleetPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservicefleet.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUpdateRunsClient().NewListByFleetPager("rg1", "fleet1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UpdateRunListResult = armcontainerservicefleet.UpdateRunListResult{
		// 	Value: []*armcontainerservicefleet.UpdateRun{
		// 		{
		// 			Name: to.Ptr("run1"),
		// 			Type: to.Ptr("Microsoft.ContainerService/fleets/updateRuns"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/fleets/myFleet/updateRuns/run1"),
		// 			SystemData: &armcontainerservicefleet.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
		// 				CreatedBy: to.Ptr("@contoso.com"),
		// 				CreatedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("@contoso.com"),
		// 				LastModifiedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
		// 			},
		// 			ETag: to.Ptr("\"EtagValue\""),
		// 			Properties: &armcontainerservicefleet.UpdateRunProperties{
		// 				ManagedClusterUpdate: &armcontainerservicefleet.ManagedClusterUpdate{
		// 					NodeImageSelection: &armcontainerservicefleet.NodeImageSelection{
		// 						Type: to.Ptr(armcontainerservicefleet.NodeImageSelectionTypeLatest),
		// 					},
		// 					Upgrade: &armcontainerservicefleet.ManagedClusterUpgradeSpec{
		// 						Type: to.Ptr(armcontainerservicefleet.ManagedClusterUpgradeTypeFull),
		// 						KubernetesVersion: to.Ptr("1.26.1"),
		// 					},
		// 				},
		// 				ProvisioningState: to.Ptr(armcontainerservicefleet.UpdateRunProvisioningStateSucceeded),
		// 				Status: &armcontainerservicefleet.UpdateRunStatus{
		// 					Stages: []*armcontainerservicefleet.UpdateStageStatus{
		// 						{
		// 							Name: to.Ptr("stage1"),
		// 							AfterStageWaitStatus: &armcontainerservicefleet.WaitStatus{
		// 								Status: &armcontainerservicefleet.UpdateStatus{
		// 									State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
		// 								},
		// 								WaitDurationInSeconds: to.Ptr[int32](3600),
		// 							},
		// 							Groups: []*armcontainerservicefleet.UpdateGroupStatus{
		// 								{
		// 									Name: to.Ptr("group-a"),
		// 									Members: []*armcontainerservicefleet.MemberUpdateStatus{
		// 										{
		// 											Name: to.Ptr("member-one"),
		// 											ClusterResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myClusters/providers/Microsoft.ContainerService/managedClusters/myCluster"),
		// 											Status: &armcontainerservicefleet.UpdateStatus{
		// 												State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
		// 											},
		// 									}},
		// 									Status: &armcontainerservicefleet.UpdateStatus{
		// 										State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
		// 									},
		// 							}},
		// 							Status: &armcontainerservicefleet.UpdateStatus{
		// 								State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
		// 							},
		// 					}},
		// 					Status: &armcontainerservicefleet.UpdateStatus{
		// 						State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
		// 					},
		// 				},
		// 				Strategy: &armcontainerservicefleet.UpdateRunStrategy{
		// 					Stages: []*armcontainerservicefleet.UpdateStage{
		// 						{
		// 							Name: to.Ptr("stage1"),
		// 							AfterStageWaitInSeconds: to.Ptr[int32](3600),
		// 							Groups: []*armcontainerservicefleet.UpdateGroup{
		// 								{
		// 									Name: to.Ptr("group-a"),
		// 							}},
		// 					}},
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/containerservice/resource-manager/Microsoft.ContainerService/fleet/preview/2024-02-02-preview/examples/UpdateRuns_Get.json
func ExampleUpdateRunsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservicefleet.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewUpdateRunsClient().Get(ctx, "rg1", "fleet1", "run1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.UpdateRun = armcontainerservicefleet.UpdateRun{
	// 	Name: to.Ptr("run1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/fleets/updateRuns"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/fleets/myFleet/updateRuns/run1"),
	// 	SystemData: &armcontainerservicefleet.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 		CreatedBy: to.Ptr("@contoso.com"),
	// 		CreatedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("@contoso.com"),
	// 		LastModifiedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 	},
	// 	ETag: to.Ptr("\"EtagValue\""),
	// 	Properties: &armcontainerservicefleet.UpdateRunProperties{
	// 		ManagedClusterUpdate: &armcontainerservicefleet.ManagedClusterUpdate{
	// 			NodeImageSelection: &armcontainerservicefleet.NodeImageSelection{
	// 				Type: to.Ptr(armcontainerservicefleet.NodeImageSelectionTypeLatest),
	// 			},
	// 			Upgrade: &armcontainerservicefleet.ManagedClusterUpgradeSpec{
	// 				Type: to.Ptr(armcontainerservicefleet.ManagedClusterUpgradeTypeFull),
	// 				KubernetesVersion: to.Ptr("1.26.1"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armcontainerservicefleet.UpdateRunProvisioningStateSucceeded),
	// 		Status: &armcontainerservicefleet.UpdateRunStatus{
	// 			Stages: []*armcontainerservicefleet.UpdateStageStatus{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitStatus: &armcontainerservicefleet.WaitStatus{
	// 						Status: &armcontainerservicefleet.UpdateStatus{
	// 							State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 						},
	// 						WaitDurationInSeconds: to.Ptr[int32](3600),
	// 					},
	// 					Groups: []*armcontainerservicefleet.UpdateGroupStatus{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 							Members: []*armcontainerservicefleet.MemberUpdateStatus{
	// 								{
	// 									Name: to.Ptr("member-one"),
	// 									ClusterResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myClusters/providers/Microsoft.ContainerService/managedClusters/myCluster"),
	// 									Status: &armcontainerservicefleet.UpdateStatus{
	// 										State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 									},
	// 							}},
	// 							Status: &armcontainerservicefleet.UpdateStatus{
	// 								State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 							},
	// 					}},
	// 					Status: &armcontainerservicefleet.UpdateStatus{
	// 						State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 					},
	// 			}},
	// 			Status: &armcontainerservicefleet.UpdateStatus{
	// 				State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 			},
	// 		},
	// 		Strategy: &armcontainerservicefleet.UpdateRunStrategy{
	// 			Stages: []*armcontainerservicefleet.UpdateStage{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitInSeconds: to.Ptr[int32](3600),
	// 					Groups: []*armcontainerservicefleet.UpdateGroup{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 					}},
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/containerservice/resource-manager/Microsoft.ContainerService/fleet/preview/2024-02-02-preview/examples/UpdateRuns_CreateOrUpdate.json
func ExampleUpdateRunsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservicefleet.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewUpdateRunsClient().BeginCreateOrUpdate(ctx, "rg1", "fleet1", "run1", armcontainerservicefleet.UpdateRun{
		Properties: &armcontainerservicefleet.UpdateRunProperties{
			ManagedClusterUpdate: &armcontainerservicefleet.ManagedClusterUpdate{
				NodeImageSelection: &armcontainerservicefleet.NodeImageSelection{
					Type: to.Ptr(armcontainerservicefleet.NodeImageSelectionTypeLatest),
				},
				Upgrade: &armcontainerservicefleet.ManagedClusterUpgradeSpec{
					Type:              to.Ptr(armcontainerservicefleet.ManagedClusterUpgradeTypeFull),
					KubernetesVersion: to.Ptr("1.26.1"),
				},
			},
			Strategy: &armcontainerservicefleet.UpdateRunStrategy{
				Stages: []*armcontainerservicefleet.UpdateStage{
					{
						Name:                    to.Ptr("stage1"),
						AfterStageWaitInSeconds: to.Ptr[int32](3600),
						Groups: []*armcontainerservicefleet.UpdateGroup{
							{
								Name: to.Ptr("group-a"),
							}},
					}},
			},
			UpdateStrategyID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/fleets/myFleet/updateStrategies/strategy1"),
		},
	}, &armcontainerservicefleet.UpdateRunsClientBeginCreateOrUpdateOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.UpdateRun = armcontainerservicefleet.UpdateRun{
	// 	Name: to.Ptr("run1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/fleets/updateRuns"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/fleets/myFleet/updateRuns/run1"),
	// 	SystemData: &armcontainerservicefleet.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 		CreatedBy: to.Ptr("@contoso.com"),
	// 		CreatedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("@contoso.com"),
	// 		LastModifiedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 	},
	// 	ETag: to.Ptr("\"EtagValue\""),
	// 	Properties: &armcontainerservicefleet.UpdateRunProperties{
	// 		ManagedClusterUpdate: &armcontainerservicefleet.ManagedClusterUpdate{
	// 			NodeImageSelection: &armcontainerservicefleet.NodeImageSelection{
	// 				Type: to.Ptr(armcontainerservicefleet.NodeImageSelectionTypeLatest),
	// 			},
	// 			Upgrade: &armcontainerservicefleet.ManagedClusterUpgradeSpec{
	// 				Type: to.Ptr(armcontainerservicefleet.ManagedClusterUpgradeTypeFull),
	// 				KubernetesVersion: to.Ptr("1.26.1"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armcontainerservicefleet.UpdateRunProvisioningStateSucceeded),
	// 		Status: &armcontainerservicefleet.UpdateRunStatus{
	// 			Stages: []*armcontainerservicefleet.UpdateStageStatus{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitStatus: &armcontainerservicefleet.WaitStatus{
	// 						Status: &armcontainerservicefleet.UpdateStatus{
	// 							State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 						},
	// 						WaitDurationInSeconds: to.Ptr[int32](3600),
	// 					},
	// 					Groups: []*armcontainerservicefleet.UpdateGroupStatus{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 							Members: []*armcontainerservicefleet.MemberUpdateStatus{
	// 								{
	// 									Name: to.Ptr("member-one"),
	// 									ClusterResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myClusters/providers/Microsoft.ContainerService/managedClusters/myCluster"),
	// 									Status: &armcontainerservicefleet.UpdateStatus{
	// 										State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 									},
	// 							}},
	// 							Status: &armcontainerservicefleet.UpdateStatus{
	// 								State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 							},
	// 					}},
	// 					Status: &armcontainerservicefleet.UpdateStatus{
	// 						State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 					},
	// 			}},
	// 			Status: &armcontainerservicefleet.UpdateStatus{
	// 				State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 			},
	// 		},
	// 		Strategy: &armcontainerservicefleet.UpdateRunStrategy{
	// 			Stages: []*armcontainerservicefleet.UpdateStage{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitInSeconds: to.Ptr[int32](3600),
	// 					Groups: []*armcontainerservicefleet.UpdateGroup{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 					}},
	// 			}},
	// 		},
	// 		UpdateStrategyID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/fleets/myFleet/updateStrategies/strategy1"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/containerservice/resource-manager/Microsoft.ContainerService/fleet/preview/2024-02-02-preview/examples/UpdateRuns_Delete.json
func ExampleUpdateRunsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservicefleet.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewUpdateRunsClient().BeginDelete(ctx, "rg1", "fleet1", "run1", &armcontainerservicefleet.UpdateRunsClientBeginDeleteOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/containerservice/resource-manager/Microsoft.ContainerService/fleet/preview/2024-02-02-preview/examples/UpdateRuns_Skip.json
func ExampleUpdateRunsClient_BeginSkip() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservicefleet.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewUpdateRunsClient().BeginSkip(ctx, "rg1", "fleet1", "run1", armcontainerservicefleet.SkipProperties{
		Targets: []*armcontainerservicefleet.SkipTarget{
			{
				Name: to.Ptr("member-one"),
				Type: to.Ptr(armcontainerservicefleet.TargetTypeMember),
			},
			{
				Name: to.Ptr("stage1"),
				Type: to.Ptr(armcontainerservicefleet.TargetTypeAfterStageWait),
			}},
	}, &armcontainerservicefleet.UpdateRunsClientBeginSkipOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.UpdateRun = armcontainerservicefleet.UpdateRun{
	// 	Name: to.Ptr("run1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/fleets/updateRuns"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/fleets/myFleet/updateRuns/run1"),
	// 	SystemData: &armcontainerservicefleet.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:09:08.395Z"); return t}()),
	// 		CreatedBy: to.Ptr("@contoso.com"),
	// 		CreatedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("@contoso.com"),
	// 		LastModifiedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 	},
	// 	ETag: to.Ptr("\"EtagValue\""),
	// 	Properties: &armcontainerservicefleet.UpdateRunProperties{
	// 		ManagedClusterUpdate: &armcontainerservicefleet.ManagedClusterUpdate{
	// 			NodeImageSelection: &armcontainerservicefleet.NodeImageSelection{
	// 				Type: to.Ptr(armcontainerservicefleet.NodeImageSelectionTypeLatest),
	// 			},
	// 			Upgrade: &armcontainerservicefleet.ManagedClusterUpgradeSpec{
	// 				Type: to.Ptr(armcontainerservicefleet.ManagedClusterUpgradeTypeFull),
	// 				KubernetesVersion: to.Ptr("1.26.1"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armcontainerservicefleet.UpdateRunProvisioningStateSucceeded),
	// 		Status: &armcontainerservicefleet.UpdateRunStatus{
	// 			Stages: []*armcontainerservicefleet.UpdateStageStatus{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitStatus: &armcontainerservicefleet.WaitStatus{
	// 						Status: &armcontainerservicefleet.UpdateStatus{
	// 							State: to.Ptr(armcontainerservicefleet.UpdateStateSkipped),
	// 						},
	// 						WaitDurationInSeconds: to.Ptr[int32](3600),
	// 					},
	// 					Groups: []*armcontainerservicefleet.UpdateGroupStatus{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 							Members: []*armcontainerservicefleet.MemberUpdateStatus{
	// 								{
	// 									Name: to.Ptr("member-one"),
	// 									ClusterResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myClusters/providers/Microsoft.ContainerService/managedClusters/myCluster-1"),
	// 									Status: &armcontainerservicefleet.UpdateStatus{
	// 										State: to.Ptr(armcontainerservicefleet.UpdateStateSkipped),
	// 									},
	// 							}},
	// 							Status: &armcontainerservicefleet.UpdateStatus{
	// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 								State: to.Ptr(armcontainerservicefleet.UpdateStateSkipped),
	// 							},
	// 						},
	// 						{
	// 							Name: to.Ptr("group-b"),
	// 							Members: []*armcontainerservicefleet.MemberUpdateStatus{
	// 								{
	// 									Name: to.Ptr("member-two"),
	// 									ClusterResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myClusters/providers/Microsoft.ContainerService/managedClusters/myCluster-2"),
	// 									Status: &armcontainerservicefleet.UpdateStatus{
	// 										State: to.Ptr(armcontainerservicefleet.UpdateStateRunning),
	// 									},
	// 							}},
	// 							Status: &armcontainerservicefleet.UpdateStatus{
	// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 								State: to.Ptr(armcontainerservicefleet.UpdateStateRunning),
	// 							},
	// 					}},
	// 					Status: &armcontainerservicefleet.UpdateStatus{
	// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 						State: to.Ptr(armcontainerservicefleet.UpdateStateRunning),
	// 					},
	// 			}},
	// 			Status: &armcontainerservicefleet.UpdateStatus{
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 				State: to.Ptr(armcontainerservicefleet.UpdateStateRunning),
	// 			},
	// 		},
	// 		Strategy: &armcontainerservicefleet.UpdateRunStrategy{
	// 			Stages: []*armcontainerservicefleet.UpdateStage{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitInSeconds: to.Ptr[int32](3600),
	// 					Groups: []*armcontainerservicefleet.UpdateGroup{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 						},
	// 						{
	// 							Name: to.Ptr("group-b"),
	// 					}},
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/containerservice/resource-manager/Microsoft.ContainerService/fleet/preview/2024-02-02-preview/examples/UpdateRuns_Start.json
func ExampleUpdateRunsClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservicefleet.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewUpdateRunsClient().BeginStart(ctx, "rg1", "fleet1", "run1", &armcontainerservicefleet.UpdateRunsClientBeginStartOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.UpdateRun = armcontainerservicefleet.UpdateRun{
	// 	Name: to.Ptr("run1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/fleets/updateRuns"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/fleets/myFleet/updateRuns/run1"),
	// 	SystemData: &armcontainerservicefleet.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:09:08.395Z"); return t}()),
	// 		CreatedBy: to.Ptr("@contoso.com"),
	// 		CreatedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("@contoso.com"),
	// 		LastModifiedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 	},
	// 	ETag: to.Ptr("\"EtagValue\""),
	// 	Properties: &armcontainerservicefleet.UpdateRunProperties{
	// 		ManagedClusterUpdate: &armcontainerservicefleet.ManagedClusterUpdate{
	// 			NodeImageSelection: &armcontainerservicefleet.NodeImageSelection{
	// 				Type: to.Ptr(armcontainerservicefleet.NodeImageSelectionTypeLatest),
	// 			},
	// 			Upgrade: &armcontainerservicefleet.ManagedClusterUpgradeSpec{
	// 				Type: to.Ptr(armcontainerservicefleet.ManagedClusterUpgradeTypeFull),
	// 				KubernetesVersion: to.Ptr("1.26.1"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armcontainerservicefleet.UpdateRunProvisioningStateSucceeded),
	// 		Status: &armcontainerservicefleet.UpdateRunStatus{
	// 			Stages: []*armcontainerservicefleet.UpdateStageStatus{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitStatus: &armcontainerservicefleet.WaitStatus{
	// 						Status: &armcontainerservicefleet.UpdateStatus{
	// 							State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 						},
	// 						WaitDurationInSeconds: to.Ptr[int32](3600),
	// 					},
	// 					Groups: []*armcontainerservicefleet.UpdateGroupStatus{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 							Members: []*armcontainerservicefleet.MemberUpdateStatus{
	// 								{
	// 									Name: to.Ptr("member-one"),
	// 									ClusterResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myClusters/providers/Microsoft.ContainerService/managedClusters/myCluster"),
	// 									Status: &armcontainerservicefleet.UpdateStatus{
	// 										State: to.Ptr(armcontainerservicefleet.UpdateStateRunning),
	// 									},
	// 							}},
	// 							Status: &armcontainerservicefleet.UpdateStatus{
	// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 								State: to.Ptr(armcontainerservicefleet.UpdateStateRunning),
	// 							},
	// 					}},
	// 					Status: &armcontainerservicefleet.UpdateStatus{
	// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 						State: to.Ptr(armcontainerservicefleet.UpdateStateRunning),
	// 					},
	// 			}},
	// 			Status: &armcontainerservicefleet.UpdateStatus{
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 				State: to.Ptr(armcontainerservicefleet.UpdateStateRunning),
	// 			},
	// 		},
	// 		Strategy: &armcontainerservicefleet.UpdateRunStrategy{
	// 			Stages: []*armcontainerservicefleet.UpdateStage{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitInSeconds: to.Ptr[int32](3600),
	// 					Groups: []*armcontainerservicefleet.UpdateGroup{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 					}},
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/containerservice/resource-manager/Microsoft.ContainerService/fleet/preview/2024-02-02-preview/examples/UpdateRuns_Stop.json
func ExampleUpdateRunsClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservicefleet.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewUpdateRunsClient().BeginStop(ctx, "rg1", "fleet1", "run1", &armcontainerservicefleet.UpdateRunsClientBeginStopOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.UpdateRun = armcontainerservicefleet.UpdateRun{
	// 	Name: to.Ptr("run1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/fleets/updateRuns"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/fleets/myFleet/updateRuns/run1"),
	// 	SystemData: &armcontainerservicefleet.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:09:08.395Z"); return t}()),
	// 		CreatedBy: to.Ptr("@contoso.com"),
	// 		CreatedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("@contoso.com"),
	// 		LastModifiedByType: to.Ptr(armcontainerservicefleet.CreatedByTypeUser),
	// 	},
	// 	ETag: to.Ptr("\"EtagValue\""),
	// 	Properties: &armcontainerservicefleet.UpdateRunProperties{
	// 		ManagedClusterUpdate: &armcontainerservicefleet.ManagedClusterUpdate{
	// 			NodeImageSelection: &armcontainerservicefleet.NodeImageSelection{
	// 				Type: to.Ptr(armcontainerservicefleet.NodeImageSelectionTypeLatest),
	// 			},
	// 			Upgrade: &armcontainerservicefleet.ManagedClusterUpgradeSpec{
	// 				Type: to.Ptr(armcontainerservicefleet.ManagedClusterUpgradeTypeFull),
	// 				KubernetesVersion: to.Ptr("1.26.1"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armcontainerservicefleet.UpdateRunProvisioningStateSucceeded),
	// 		Status: &armcontainerservicefleet.UpdateRunStatus{
	// 			Stages: []*armcontainerservicefleet.UpdateStageStatus{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitStatus: &armcontainerservicefleet.WaitStatus{
	// 						Status: &armcontainerservicefleet.UpdateStatus{
	// 							State: to.Ptr(armcontainerservicefleet.UpdateStateNotStarted),
	// 						},
	// 						WaitDurationInSeconds: to.Ptr[int32](3600),
	// 					},
	// 					Groups: []*armcontainerservicefleet.UpdateGroupStatus{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 							Members: []*armcontainerservicefleet.MemberUpdateStatus{
	// 								{
	// 									Name: to.Ptr("member-one"),
	// 									ClusterResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myClusters/providers/Microsoft.ContainerService/managedClusters/myCluster"),
	// 									Status: &armcontainerservicefleet.UpdateStatus{
	// 										State: to.Ptr(armcontainerservicefleet.UpdateStateStopping),
	// 									},
	// 							}},
	// 							Status: &armcontainerservicefleet.UpdateStatus{
	// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 								State: to.Ptr(armcontainerservicefleet.UpdateStateStopping),
	// 							},
	// 					}},
	// 					Status: &armcontainerservicefleet.UpdateStatus{
	// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 						State: to.Ptr(armcontainerservicefleet.UpdateStateStopping),
	// 					},
	// 			}},
	// 			Status: &armcontainerservicefleet.UpdateStatus{
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-03-01T01:10:08.395Z"); return t}()),
	// 				State: to.Ptr(armcontainerservicefleet.UpdateStateStopping),
	// 			},
	// 		},
	// 		Strategy: &armcontainerservicefleet.UpdateRunStrategy{
	// 			Stages: []*armcontainerservicefleet.UpdateStage{
	// 				{
	// 					Name: to.Ptr("stage1"),
	// 					AfterStageWaitInSeconds: to.Ptr[int32](3600),
	// 					Groups: []*armcontainerservicefleet.UpdateGroup{
	// 						{
	// 							Name: to.Ptr("group-a"),
	// 					}},
	// 			}},
	// 		},
	// 	},
	// }
}
