//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerservicefleet/armcontainerservicefleet"
	"net/http"
	"net/url"
	"regexp"
)

// FleetMembersServer is a fake server for instances of the armcontainerservicefleet.FleetMembersClient type.
type FleetMembersServer struct {
	// BeginCreate is the fake for method FleetMembersClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, fleetName string, fleetMemberName string, resource armcontainerservicefleet.FleetMember, options *armcontainerservicefleet.FleetMembersClientBeginCreateOptions) (resp azfake.PollerResponder[armcontainerservicefleet.FleetMembersClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method FleetMembersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, fleetName string, fleetMemberName string, options *armcontainerservicefleet.FleetMembersClientBeginDeleteOptions) (resp azfake.PollerResponder[armcontainerservicefleet.FleetMembersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method FleetMembersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, fleetName string, fleetMemberName string, options *armcontainerservicefleet.FleetMembersClientGetOptions) (resp azfake.Responder[armcontainerservicefleet.FleetMembersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByFleetPager is the fake for method FleetMembersClient.NewListByFleetPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByFleetPager func(resourceGroupName string, fleetName string, options *armcontainerservicefleet.FleetMembersClientListByFleetOptions) (resp azfake.PagerResponder[armcontainerservicefleet.FleetMembersClientListByFleetResponse])

	// BeginUpdate is the fake for method FleetMembersClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, fleetName string, fleetMemberName string, properties armcontainerservicefleet.FleetMemberUpdate, options *armcontainerservicefleet.FleetMembersClientBeginUpdateOptions) (resp azfake.PollerResponder[armcontainerservicefleet.FleetMembersClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewFleetMembersServerTransport creates a new instance of FleetMembersServerTransport with the provided implementation.
// The returned FleetMembersServerTransport instance is connected to an instance of armcontainerservicefleet.FleetMembersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFleetMembersServerTransport(srv *FleetMembersServer) *FleetMembersServerTransport {
	return &FleetMembersServerTransport{
		srv:                 srv,
		beginCreate:         newTracker[azfake.PollerResponder[armcontainerservicefleet.FleetMembersClientCreateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armcontainerservicefleet.FleetMembersClientDeleteResponse]](),
		newListByFleetPager: newTracker[azfake.PagerResponder[armcontainerservicefleet.FleetMembersClientListByFleetResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armcontainerservicefleet.FleetMembersClientUpdateResponse]](),
	}
}

// FleetMembersServerTransport connects instances of armcontainerservicefleet.FleetMembersClient to instances of FleetMembersServer.
// Don't use this type directly, use NewFleetMembersServerTransport instead.
type FleetMembersServerTransport struct {
	srv                 *FleetMembersServer
	beginCreate         *tracker[azfake.PollerResponder[armcontainerservicefleet.FleetMembersClientCreateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armcontainerservicefleet.FleetMembersClientDeleteResponse]]
	newListByFleetPager *tracker[azfake.PagerResponder[armcontainerservicefleet.FleetMembersClientListByFleetResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armcontainerservicefleet.FleetMembersClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for FleetMembersServerTransport.
func (f *FleetMembersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FleetMembersClient.BeginCreate":
		resp, err = f.dispatchBeginCreate(req)
	case "FleetMembersClient.BeginDelete":
		resp, err = f.dispatchBeginDelete(req)
	case "FleetMembersClient.Get":
		resp, err = f.dispatchGet(req)
	case "FleetMembersClient.NewListByFleetPager":
		resp, err = f.dispatchNewListByFleetPager(req)
	case "FleetMembersClient.BeginUpdate":
		resp, err = f.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FleetMembersServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if f.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := f.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/fleets/(?P<fleetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/members/(?P<fleetMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerservicefleet.FleetMember](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
		fleetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fleetName")])
		if err != nil {
			return nil, err
		}
		fleetMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fleetMemberName")])
		if err != nil {
			return nil, err
		}
		var options *armcontainerservicefleet.FleetMembersClientBeginCreateOptions
		if ifMatchParam != nil || ifNoneMatchParam != nil {
			options = &armcontainerservicefleet.FleetMembersClientBeginCreateOptions{
				IfMatch:     ifMatchParam,
				IfNoneMatch: ifNoneMatchParam,
			}
		}
		respr, errRespr := f.srv.BeginCreate(req.Context(), resourceGroupNameParam, fleetNameParam, fleetMemberNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		f.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		f.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		f.beginCreate.remove(req)
	}

	return resp, nil
}

func (f *FleetMembersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if f.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := f.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/fleets/(?P<fleetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/members/(?P<fleetMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		fleetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fleetName")])
		if err != nil {
			return nil, err
		}
		fleetMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fleetMemberName")])
		if err != nil {
			return nil, err
		}
		var options *armcontainerservicefleet.FleetMembersClientBeginDeleteOptions
		if ifMatchParam != nil {
			options = &armcontainerservicefleet.FleetMembersClientBeginDeleteOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := f.srv.BeginDelete(req.Context(), resourceGroupNameParam, fleetNameParam, fleetMemberNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		f.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		f.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		f.beginDelete.remove(req)
	}

	return resp, nil
}

func (f *FleetMembersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if f.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/fleets/(?P<fleetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/members/(?P<fleetMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fleetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fleetName")])
	if err != nil {
		return nil, err
	}
	fleetMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fleetMemberName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Get(req.Context(), resourceGroupNameParam, fleetNameParam, fleetMemberNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FleetMember, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FleetMembersServerTransport) dispatchNewListByFleetPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListByFleetPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByFleetPager not implemented")}
	}
	newListByFleetPager := f.newListByFleetPager.get(req)
	if newListByFleetPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/fleets/(?P<fleetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/members`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fleetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fleetName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListByFleetPager(resourceGroupNameParam, fleetNameParam, nil)
		newListByFleetPager = &resp
		f.newListByFleetPager.add(req, newListByFleetPager)
		server.PagerResponderInjectNextLinks(newListByFleetPager, req, func(page *armcontainerservicefleet.FleetMembersClientListByFleetResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByFleetPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListByFleetPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByFleetPager) {
		f.newListByFleetPager.remove(req)
	}
	return resp, nil
}

func (f *FleetMembersServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if f.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := f.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/fleets/(?P<fleetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/members/(?P<fleetMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerservicefleet.FleetMemberUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		fleetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fleetName")])
		if err != nil {
			return nil, err
		}
		fleetMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fleetMemberName")])
		if err != nil {
			return nil, err
		}
		var options *armcontainerservicefleet.FleetMembersClientBeginUpdateOptions
		if ifMatchParam != nil {
			options = &armcontainerservicefleet.FleetMembersClientBeginUpdateOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := f.srv.BeginUpdate(req.Context(), resourceGroupNameParam, fleetNameParam, fleetMemberNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		f.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		f.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		f.beginUpdate.remove(req)
	}

	return resp, nil
}
