//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
	"net/http"
	"net/url"
	"regexp"
)

// ReservationsDetailsServer is a fake server for instances of the armconsumption.ReservationsDetailsClient type.
type ReservationsDetailsServer struct {
	// NewListPager is the fake for method ReservationsDetailsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceScope string, options *armconsumption.ReservationsDetailsClientListOptions) (resp azfake.PagerResponder[armconsumption.ReservationsDetailsClientListResponse])

	// NewListByReservationOrderPager is the fake for method ReservationsDetailsClient.NewListByReservationOrderPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByReservationOrderPager func(reservationOrderID string, filter string, options *armconsumption.ReservationsDetailsClientListByReservationOrderOptions) (resp azfake.PagerResponder[armconsumption.ReservationsDetailsClientListByReservationOrderResponse])

	// NewListByReservationOrderAndReservationPager is the fake for method ReservationsDetailsClient.NewListByReservationOrderAndReservationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByReservationOrderAndReservationPager func(reservationOrderID string, reservationID string, filter string, options *armconsumption.ReservationsDetailsClientListByReservationOrderAndReservationOptions) (resp azfake.PagerResponder[armconsumption.ReservationsDetailsClientListByReservationOrderAndReservationResponse])
}

// NewReservationsDetailsServerTransport creates a new instance of ReservationsDetailsServerTransport with the provided implementation.
// The returned ReservationsDetailsServerTransport instance is connected to an instance of armconsumption.ReservationsDetailsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReservationsDetailsServerTransport(srv *ReservationsDetailsServer) *ReservationsDetailsServerTransport {
	return &ReservationsDetailsServerTransport{
		srv:                            srv,
		newListPager:                   newTracker[azfake.PagerResponder[armconsumption.ReservationsDetailsClientListResponse]](),
		newListByReservationOrderPager: newTracker[azfake.PagerResponder[armconsumption.ReservationsDetailsClientListByReservationOrderResponse]](),
		newListByReservationOrderAndReservationPager: newTracker[azfake.PagerResponder[armconsumption.ReservationsDetailsClientListByReservationOrderAndReservationResponse]](),
	}
}

// ReservationsDetailsServerTransport connects instances of armconsumption.ReservationsDetailsClient to instances of ReservationsDetailsServer.
// Don't use this type directly, use NewReservationsDetailsServerTransport instead.
type ReservationsDetailsServerTransport struct {
	srv                                          *ReservationsDetailsServer
	newListPager                                 *tracker[azfake.PagerResponder[armconsumption.ReservationsDetailsClientListResponse]]
	newListByReservationOrderPager               *tracker[azfake.PagerResponder[armconsumption.ReservationsDetailsClientListByReservationOrderResponse]]
	newListByReservationOrderAndReservationPager *tracker[azfake.PagerResponder[armconsumption.ReservationsDetailsClientListByReservationOrderAndReservationResponse]]
}

// Do implements the policy.Transporter interface for ReservationsDetailsServerTransport.
func (r *ReservationsDetailsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReservationsDetailsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "ReservationsDetailsClient.NewListByReservationOrderPager":
		resp, err = r.dispatchNewListByReservationOrderPager(req)
	case "ReservationsDetailsClient.NewListByReservationOrderAndReservationPager":
		resp, err = r.dispatchNewListByReservationOrderAndReservationPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReservationsDetailsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/reservationDetails`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
		if err != nil {
			return nil, err
		}
		startDateUnescaped, err := url.QueryUnescape(qp.Get("startDate"))
		if err != nil {
			return nil, err
		}
		startDateParam := getOptional(startDateUnescaped)
		endDateUnescaped, err := url.QueryUnescape(qp.Get("endDate"))
		if err != nil {
			return nil, err
		}
		endDateParam := getOptional(endDateUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		reservationIDUnescaped, err := url.QueryUnescape(qp.Get("reservationId"))
		if err != nil {
			return nil, err
		}
		reservationIDParam := getOptional(reservationIDUnescaped)
		reservationOrderIDUnescaped, err := url.QueryUnescape(qp.Get("reservationOrderId"))
		if err != nil {
			return nil, err
		}
		reservationOrderIDParam := getOptional(reservationOrderIDUnescaped)
		var options *armconsumption.ReservationsDetailsClientListOptions
		if startDateParam != nil || endDateParam != nil || filterParam != nil || reservationIDParam != nil || reservationOrderIDParam != nil {
			options = &armconsumption.ReservationsDetailsClientListOptions{
				StartDate:          startDateParam,
				EndDate:            endDateParam,
				Filter:             filterParam,
				ReservationID:      reservationIDParam,
				ReservationOrderID: reservationOrderIDParam,
			}
		}
		resp := r.srv.NewListPager(resourceScopeParam, options)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armconsumption.ReservationsDetailsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *ReservationsDetailsServerTransport) dispatchNewListByReservationOrderPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByReservationOrderPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByReservationOrderPager not implemented")}
	}
	newListByReservationOrderPager := r.newListByReservationOrderPager.get(req)
	if newListByReservationOrderPager == nil {
		const regexStr = `/providers/Microsoft\.Capacity/reservationorders/(?P<reservationOrderId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/reservationDetails`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		reservationOrderIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("reservationOrderId")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByReservationOrderPager(reservationOrderIDParam, filterParam, nil)
		newListByReservationOrderPager = &resp
		r.newListByReservationOrderPager.add(req, newListByReservationOrderPager)
		server.PagerResponderInjectNextLinks(newListByReservationOrderPager, req, func(page *armconsumption.ReservationsDetailsClientListByReservationOrderResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByReservationOrderPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByReservationOrderPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByReservationOrderPager) {
		r.newListByReservationOrderPager.remove(req)
	}
	return resp, nil
}

func (r *ReservationsDetailsServerTransport) dispatchNewListByReservationOrderAndReservationPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByReservationOrderAndReservationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByReservationOrderAndReservationPager not implemented")}
	}
	newListByReservationOrderAndReservationPager := r.newListByReservationOrderAndReservationPager.get(req)
	if newListByReservationOrderAndReservationPager == nil {
		const regexStr = `/providers/Microsoft\.Capacity/reservationorders/(?P<reservationOrderId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reservations/(?P<reservationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/reservationDetails`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		reservationOrderIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("reservationOrderId")])
		if err != nil {
			return nil, err
		}
		reservationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("reservationId")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByReservationOrderAndReservationPager(reservationOrderIDParam, reservationIDParam, filterParam, nil)
		newListByReservationOrderAndReservationPager = &resp
		r.newListByReservationOrderAndReservationPager.add(req, newListByReservationOrderAndReservationPager)
		server.PagerResponderInjectNextLinks(newListByReservationOrderAndReservationPager, req, func(page *armconsumption.ReservationsDetailsClientListByReservationOrderAndReservationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByReservationOrderAndReservationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByReservationOrderAndReservationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByReservationOrderAndReservationPager) {
		r.newListByReservationOrderAndReservationPager.remove(req)
	}
	return resp, nil
}
