//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
	"net/http"
	"net/url"
	"regexp"
)

// EventsServer is a fake server for instances of the armconsumption.EventsClient type.
type EventsServer struct {
	// NewListByBillingAccountPager is the fake for method EventsClient.NewListByBillingAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingAccountPager func(billingAccountID string, options *armconsumption.EventsClientListByBillingAccountOptions) (resp azfake.PagerResponder[armconsumption.EventsClientListByBillingAccountResponse])

	// NewListByBillingProfilePager is the fake for method EventsClient.NewListByBillingProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingProfilePager func(billingAccountID string, billingProfileID string, startDate string, endDate string, options *armconsumption.EventsClientListByBillingProfileOptions) (resp azfake.PagerResponder[armconsumption.EventsClientListByBillingProfileResponse])
}

// NewEventsServerTransport creates a new instance of EventsServerTransport with the provided implementation.
// The returned EventsServerTransport instance is connected to an instance of armconsumption.EventsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEventsServerTransport(srv *EventsServer) *EventsServerTransport {
	return &EventsServerTransport{
		srv:                          srv,
		newListByBillingAccountPager: newTracker[azfake.PagerResponder[armconsumption.EventsClientListByBillingAccountResponse]](),
		newListByBillingProfilePager: newTracker[azfake.PagerResponder[armconsumption.EventsClientListByBillingProfileResponse]](),
	}
}

// EventsServerTransport connects instances of armconsumption.EventsClient to instances of EventsServer.
// Don't use this type directly, use NewEventsServerTransport instead.
type EventsServerTransport struct {
	srv                          *EventsServer
	newListByBillingAccountPager *tracker[azfake.PagerResponder[armconsumption.EventsClientListByBillingAccountResponse]]
	newListByBillingProfilePager *tracker[azfake.PagerResponder[armconsumption.EventsClientListByBillingProfileResponse]]
}

// Do implements the policy.Transporter interface for EventsServerTransport.
func (e *EventsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EventsClient.NewListByBillingAccountPager":
		resp, err = e.dispatchNewListByBillingAccountPager(req)
	case "EventsClient.NewListByBillingProfilePager":
		resp, err = e.dispatchNewListByBillingProfilePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EventsServerTransport) dispatchNewListByBillingAccountPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByBillingAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingAccountPager not implemented")}
	}
	newListByBillingAccountPager := e.newListByBillingAccountPager.get(req)
	if newListByBillingAccountPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/events`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armconsumption.EventsClientListByBillingAccountOptions
		if filterParam != nil {
			options = &armconsumption.EventsClientListByBillingAccountOptions{
				Filter: filterParam,
			}
		}
		resp := e.srv.NewListByBillingAccountPager(billingAccountIDParam, options)
		newListByBillingAccountPager = &resp
		e.newListByBillingAccountPager.add(req, newListByBillingAccountPager)
		server.PagerResponderInjectNextLinks(newListByBillingAccountPager, req, func(page *armconsumption.EventsClientListByBillingAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByBillingAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingAccountPager) {
		e.newListByBillingAccountPager.remove(req)
	}
	return resp, nil
}

func (e *EventsServerTransport) dispatchNewListByBillingProfilePager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByBillingProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingProfilePager not implemented")}
	}
	newListByBillingProfilePager := e.newListByBillingProfilePager.get(req)
	if newListByBillingProfilePager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/events`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountId")])
		if err != nil {
			return nil, err
		}
		billingProfileIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileId")])
		if err != nil {
			return nil, err
		}
		startDateParam, err := url.QueryUnescape(qp.Get("startDate"))
		if err != nil {
			return nil, err
		}
		endDateParam, err := url.QueryUnescape(qp.Get("endDate"))
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListByBillingProfilePager(billingAccountIDParam, billingProfileIDParam, startDateParam, endDateParam, nil)
		newListByBillingProfilePager = &resp
		e.newListByBillingProfilePager.add(req, newListByBillingProfilePager)
		server.PagerResponderInjectNextLinks(newListByBillingProfilePager, req, func(page *armconsumption.EventsClientListByBillingProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByBillingProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingProfilePager) {
		e.newListByBillingProfilePager.remove(req)
	}
	return resp, nil
}
