//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
	"net/http"
	"net/url"
	"regexp"
)

// ChargesServer is a fake server for instances of the armconsumption.ChargesClient type.
type ChargesServer struct {
	// List is the fake for method ChargesClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, scope string, options *armconsumption.ChargesClientListOptions) (resp azfake.Responder[armconsumption.ChargesClientListResponse], errResp azfake.ErrorResponder)
}

// NewChargesServerTransport creates a new instance of ChargesServerTransport with the provided implementation.
// The returned ChargesServerTransport instance is connected to an instance of armconsumption.ChargesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewChargesServerTransport(srv *ChargesServer) *ChargesServerTransport {
	return &ChargesServerTransport{srv: srv}
}

// ChargesServerTransport connects instances of armconsumption.ChargesClient to instances of ChargesServer.
// Don't use this type directly, use NewChargesServerTransport instead.
type ChargesServerTransport struct {
	srv *ChargesServer
}

// Do implements the policy.Transporter interface for ChargesServerTransport.
func (c *ChargesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ChargesClient.List":
		resp, err = c.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ChargesServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if c.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/charges`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	startDateUnescaped, err := url.QueryUnescape(qp.Get("startDate"))
	if err != nil {
		return nil, err
	}
	startDateParam := getOptional(startDateUnescaped)
	endDateUnescaped, err := url.QueryUnescape(qp.Get("endDate"))
	if err != nil {
		return nil, err
	}
	endDateParam := getOptional(endDateUnescaped)
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
	if err != nil {
		return nil, err
	}
	applyParam := getOptional(applyUnescaped)
	var options *armconsumption.ChargesClientListOptions
	if startDateParam != nil || endDateParam != nil || filterParam != nil || applyParam != nil {
		options = &armconsumption.ChargesClientListOptions{
			StartDate: startDateParam,
			EndDate:   endDateParam,
			Filter:    filterParam,
			Apply:     applyParam,
		}
	}
	respr, errRespr := c.srv.List(req.Context(), scopeParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ChargesListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
