//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/connectedvmware/armconnectedvmware"
	"net/http"
	"net/url"
	"regexp"
)

// InventoryItemsServer is a fake server for instances of the armconnectedvmware.InventoryItemsClient type.
type InventoryItemsServer struct {
	// Create is the fake for method InventoryItemsClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, resourceGroupName string, vcenterName string, inventoryItemName string, body armconnectedvmware.InventoryItem, options *armconnectedvmware.InventoryItemsClientCreateOptions) (resp azfake.Responder[armconnectedvmware.InventoryItemsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method InventoryItemsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, vcenterName string, inventoryItemName string, options *armconnectedvmware.InventoryItemsClientDeleteOptions) (resp azfake.Responder[armconnectedvmware.InventoryItemsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method InventoryItemsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, vcenterName string, inventoryItemName string, options *armconnectedvmware.InventoryItemsClientGetOptions) (resp azfake.Responder[armconnectedvmware.InventoryItemsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByVCenterPager is the fake for method InventoryItemsClient.NewListByVCenterPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByVCenterPager func(resourceGroupName string, vcenterName string, options *armconnectedvmware.InventoryItemsClientListByVCenterOptions) (resp azfake.PagerResponder[armconnectedvmware.InventoryItemsClientListByVCenterResponse])
}

// NewInventoryItemsServerTransport creates a new instance of InventoryItemsServerTransport with the provided implementation.
// The returned InventoryItemsServerTransport instance is connected to an instance of armconnectedvmware.InventoryItemsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewInventoryItemsServerTransport(srv *InventoryItemsServer) *InventoryItemsServerTransport {
	return &InventoryItemsServerTransport{
		srv:                   srv,
		newListByVCenterPager: newTracker[azfake.PagerResponder[armconnectedvmware.InventoryItemsClientListByVCenterResponse]](),
	}
}

// InventoryItemsServerTransport connects instances of armconnectedvmware.InventoryItemsClient to instances of InventoryItemsServer.
// Don't use this type directly, use NewInventoryItemsServerTransport instead.
type InventoryItemsServerTransport struct {
	srv                   *InventoryItemsServer
	newListByVCenterPager *tracker[azfake.PagerResponder[armconnectedvmware.InventoryItemsClientListByVCenterResponse]]
}

// Do implements the policy.Transporter interface for InventoryItemsServerTransport.
func (i *InventoryItemsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "InventoryItemsClient.Create":
		resp, err = i.dispatchCreate(req)
	case "InventoryItemsClient.Delete":
		resp, err = i.dispatchDelete(req)
	case "InventoryItemsClient.Get":
		resp, err = i.dispatchGet(req)
	case "InventoryItemsClient.NewListByVCenterPager":
		resp, err = i.dispatchNewListByVCenterPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *InventoryItemsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if i.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/vcenters/(?P<vcenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inventoryItems/(?P<inventoryItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armconnectedvmware.InventoryItem](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vcenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vcenterName")])
	if err != nil {
		return nil, err
	}
	inventoryItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inventoryItemName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Create(req.Context(), resourceGroupNameParam, vcenterNameParam, inventoryItemNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).InventoryItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InventoryItemsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if i.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/vcenters/(?P<vcenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inventoryItems/(?P<inventoryItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vcenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vcenterName")])
	if err != nil {
		return nil, err
	}
	inventoryItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inventoryItemName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Delete(req.Context(), resourceGroupNameParam, vcenterNameParam, inventoryItemNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InventoryItemsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/vcenters/(?P<vcenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inventoryItems/(?P<inventoryItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vcenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vcenterName")])
	if err != nil {
		return nil, err
	}
	inventoryItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inventoryItemName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, vcenterNameParam, inventoryItemNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).InventoryItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InventoryItemsServerTransport) dispatchNewListByVCenterPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByVCenterPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByVCenterPager not implemented")}
	}
	newListByVCenterPager := i.newListByVCenterPager.get(req)
	if newListByVCenterPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/vcenters/(?P<vcenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inventoryItems`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vcenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vcenterName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByVCenterPager(resourceGroupNameParam, vcenterNameParam, nil)
		newListByVCenterPager = &resp
		i.newListByVCenterPager.add(req, newListByVCenterPager)
		server.PagerResponderInjectNextLinks(newListByVCenterPager, req, func(page *armconnectedvmware.InventoryItemsClientListByVCenterResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByVCenterPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByVCenterPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByVCenterPager) {
		i.newListByVCenterPager.remove(req)
	}
	return resp, nil
}
