//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armcompute.ClientFactory type.
type ServerFactory struct {
	AvailabilitySetsServer                      AvailabilitySetsServer
	CapacityReservationGroupsServer             CapacityReservationGroupsServer
	CapacityReservationsServer                  CapacityReservationsServer
	CloudServiceOperatingSystemsServer          CloudServiceOperatingSystemsServer
	CloudServiceRoleInstancesServer             CloudServiceRoleInstancesServer
	CloudServiceRolesServer                     CloudServiceRolesServer
	CloudServicesServer                         CloudServicesServer
	CloudServicesUpdateDomainServer             CloudServicesUpdateDomainServer
	CommunityGalleriesServer                    CommunityGalleriesServer
	CommunityGalleryImageVersionsServer         CommunityGalleryImageVersionsServer
	CommunityGalleryImagesServer                CommunityGalleryImagesServer
	DedicatedHostGroupsServer                   DedicatedHostGroupsServer
	DedicatedHostsServer                        DedicatedHostsServer
	DiskAccessesServer                          DiskAccessesServer
	DiskEncryptionSetsServer                    DiskEncryptionSetsServer
	DiskRestorePointServer                      DiskRestorePointServer
	DisksServer                                 DisksServer
	GalleriesServer                             GalleriesServer
	GalleryApplicationVersionsServer            GalleryApplicationVersionsServer
	GalleryApplicationsServer                   GalleryApplicationsServer
	GalleryImageVersionsServer                  GalleryImageVersionsServer
	GalleryImagesServer                         GalleryImagesServer
	GallerySharingProfileServer                 GallerySharingProfileServer
	ImagesServer                                ImagesServer
	LogAnalyticsServer                          LogAnalyticsServer
	OperationsServer                            OperationsServer
	ProximityPlacementGroupsServer              ProximityPlacementGroupsServer
	ResourceSKUsServer                          ResourceSKUsServer
	RestorePointCollectionsServer               RestorePointCollectionsServer
	RestorePointsServer                         RestorePointsServer
	SSHPublicKeysServer                         SSHPublicKeysServer
	SharedGalleriesServer                       SharedGalleriesServer
	SharedGalleryImageVersionsServer            SharedGalleryImageVersionsServer
	SharedGalleryImagesServer                   SharedGalleryImagesServer
	SnapshotsServer                             SnapshotsServer
	UsageServer                                 UsageServer
	VirtualMachineExtensionImagesServer         VirtualMachineExtensionImagesServer
	VirtualMachineExtensionsServer              VirtualMachineExtensionsServer
	VirtualMachineImagesServer                  VirtualMachineImagesServer
	VirtualMachineImagesEdgeZoneServer          VirtualMachineImagesEdgeZoneServer
	VirtualMachineRunCommandsServer             VirtualMachineRunCommandsServer
	VirtualMachineScaleSetExtensionsServer      VirtualMachineScaleSetExtensionsServer
	VirtualMachineScaleSetRollingUpgradesServer VirtualMachineScaleSetRollingUpgradesServer
	VirtualMachineScaleSetVMExtensionsServer    VirtualMachineScaleSetVMExtensionsServer
	VirtualMachineScaleSetVMRunCommandsServer   VirtualMachineScaleSetVMRunCommandsServer
	VirtualMachineScaleSetVMsServer             VirtualMachineScaleSetVMsServer
	VirtualMachineScaleSetsServer               VirtualMachineScaleSetsServer
	VirtualMachineSizesServer                   VirtualMachineSizesServer
	VirtualMachinesServer                       VirtualMachinesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armcompute.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armcompute.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                           *ServerFactory
	trMu                                          sync.Mutex
	trAvailabilitySetsServer                      *AvailabilitySetsServerTransport
	trCapacityReservationGroupsServer             *CapacityReservationGroupsServerTransport
	trCapacityReservationsServer                  *CapacityReservationsServerTransport
	trCloudServiceOperatingSystemsServer          *CloudServiceOperatingSystemsServerTransport
	trCloudServiceRoleInstancesServer             *CloudServiceRoleInstancesServerTransport
	trCloudServiceRolesServer                     *CloudServiceRolesServerTransport
	trCloudServicesServer                         *CloudServicesServerTransport
	trCloudServicesUpdateDomainServer             *CloudServicesUpdateDomainServerTransport
	trCommunityGalleriesServer                    *CommunityGalleriesServerTransport
	trCommunityGalleryImageVersionsServer         *CommunityGalleryImageVersionsServerTransport
	trCommunityGalleryImagesServer                *CommunityGalleryImagesServerTransport
	trDedicatedHostGroupsServer                   *DedicatedHostGroupsServerTransport
	trDedicatedHostsServer                        *DedicatedHostsServerTransport
	trDiskAccessesServer                          *DiskAccessesServerTransport
	trDiskEncryptionSetsServer                    *DiskEncryptionSetsServerTransport
	trDiskRestorePointServer                      *DiskRestorePointServerTransport
	trDisksServer                                 *DisksServerTransport
	trGalleriesServer                             *GalleriesServerTransport
	trGalleryApplicationVersionsServer            *GalleryApplicationVersionsServerTransport
	trGalleryApplicationsServer                   *GalleryApplicationsServerTransport
	trGalleryImageVersionsServer                  *GalleryImageVersionsServerTransport
	trGalleryImagesServer                         *GalleryImagesServerTransport
	trGallerySharingProfileServer                 *GallerySharingProfileServerTransport
	trImagesServer                                *ImagesServerTransport
	trLogAnalyticsServer                          *LogAnalyticsServerTransport
	trOperationsServer                            *OperationsServerTransport
	trProximityPlacementGroupsServer              *ProximityPlacementGroupsServerTransport
	trResourceSKUsServer                          *ResourceSKUsServerTransport
	trRestorePointCollectionsServer               *RestorePointCollectionsServerTransport
	trRestorePointsServer                         *RestorePointsServerTransport
	trSSHPublicKeysServer                         *SSHPublicKeysServerTransport
	trSharedGalleriesServer                       *SharedGalleriesServerTransport
	trSharedGalleryImageVersionsServer            *SharedGalleryImageVersionsServerTransport
	trSharedGalleryImagesServer                   *SharedGalleryImagesServerTransport
	trSnapshotsServer                             *SnapshotsServerTransport
	trUsageServer                                 *UsageServerTransport
	trVirtualMachineExtensionImagesServer         *VirtualMachineExtensionImagesServerTransport
	trVirtualMachineExtensionsServer              *VirtualMachineExtensionsServerTransport
	trVirtualMachineImagesServer                  *VirtualMachineImagesServerTransport
	trVirtualMachineImagesEdgeZoneServer          *VirtualMachineImagesEdgeZoneServerTransport
	trVirtualMachineRunCommandsServer             *VirtualMachineRunCommandsServerTransport
	trVirtualMachineScaleSetExtensionsServer      *VirtualMachineScaleSetExtensionsServerTransport
	trVirtualMachineScaleSetRollingUpgradesServer *VirtualMachineScaleSetRollingUpgradesServerTransport
	trVirtualMachineScaleSetVMExtensionsServer    *VirtualMachineScaleSetVMExtensionsServerTransport
	trVirtualMachineScaleSetVMRunCommandsServer   *VirtualMachineScaleSetVMRunCommandsServerTransport
	trVirtualMachineScaleSetVMsServer             *VirtualMachineScaleSetVMsServerTransport
	trVirtualMachineScaleSetsServer               *VirtualMachineScaleSetsServerTransport
	trVirtualMachineSizesServer                   *VirtualMachineSizesServerTransport
	trVirtualMachinesServer                       *VirtualMachinesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AvailabilitySetsClient":
		initServer(s, &s.trAvailabilitySetsServer, func() *AvailabilitySetsServerTransport {
			return NewAvailabilitySetsServerTransport(&s.srv.AvailabilitySetsServer)
		})
		resp, err = s.trAvailabilitySetsServer.Do(req)
	case "CapacityReservationGroupsClient":
		initServer(s, &s.trCapacityReservationGroupsServer, func() *CapacityReservationGroupsServerTransport {
			return NewCapacityReservationGroupsServerTransport(&s.srv.CapacityReservationGroupsServer)
		})
		resp, err = s.trCapacityReservationGroupsServer.Do(req)
	case "CapacityReservationsClient":
		initServer(s, &s.trCapacityReservationsServer, func() *CapacityReservationsServerTransport {
			return NewCapacityReservationsServerTransport(&s.srv.CapacityReservationsServer)
		})
		resp, err = s.trCapacityReservationsServer.Do(req)
	case "CloudServiceOperatingSystemsClient":
		initServer(s, &s.trCloudServiceOperatingSystemsServer, func() *CloudServiceOperatingSystemsServerTransport {
			return NewCloudServiceOperatingSystemsServerTransport(&s.srv.CloudServiceOperatingSystemsServer)
		})
		resp, err = s.trCloudServiceOperatingSystemsServer.Do(req)
	case "CloudServiceRoleInstancesClient":
		initServer(s, &s.trCloudServiceRoleInstancesServer, func() *CloudServiceRoleInstancesServerTransport {
			return NewCloudServiceRoleInstancesServerTransport(&s.srv.CloudServiceRoleInstancesServer)
		})
		resp, err = s.trCloudServiceRoleInstancesServer.Do(req)
	case "CloudServiceRolesClient":
		initServer(s, &s.trCloudServiceRolesServer, func() *CloudServiceRolesServerTransport {
			return NewCloudServiceRolesServerTransport(&s.srv.CloudServiceRolesServer)
		})
		resp, err = s.trCloudServiceRolesServer.Do(req)
	case "CloudServicesClient":
		initServer(s, &s.trCloudServicesServer, func() *CloudServicesServerTransport {
			return NewCloudServicesServerTransport(&s.srv.CloudServicesServer)
		})
		resp, err = s.trCloudServicesServer.Do(req)
	case "CloudServicesUpdateDomainClient":
		initServer(s, &s.trCloudServicesUpdateDomainServer, func() *CloudServicesUpdateDomainServerTransport {
			return NewCloudServicesUpdateDomainServerTransport(&s.srv.CloudServicesUpdateDomainServer)
		})
		resp, err = s.trCloudServicesUpdateDomainServer.Do(req)
	case "CommunityGalleriesClient":
		initServer(s, &s.trCommunityGalleriesServer, func() *CommunityGalleriesServerTransport {
			return NewCommunityGalleriesServerTransport(&s.srv.CommunityGalleriesServer)
		})
		resp, err = s.trCommunityGalleriesServer.Do(req)
	case "CommunityGalleryImageVersionsClient":
		initServer(s, &s.trCommunityGalleryImageVersionsServer, func() *CommunityGalleryImageVersionsServerTransport {
			return NewCommunityGalleryImageVersionsServerTransport(&s.srv.CommunityGalleryImageVersionsServer)
		})
		resp, err = s.trCommunityGalleryImageVersionsServer.Do(req)
	case "CommunityGalleryImagesClient":
		initServer(s, &s.trCommunityGalleryImagesServer, func() *CommunityGalleryImagesServerTransport {
			return NewCommunityGalleryImagesServerTransport(&s.srv.CommunityGalleryImagesServer)
		})
		resp, err = s.trCommunityGalleryImagesServer.Do(req)
	case "DedicatedHostGroupsClient":
		initServer(s, &s.trDedicatedHostGroupsServer, func() *DedicatedHostGroupsServerTransport {
			return NewDedicatedHostGroupsServerTransport(&s.srv.DedicatedHostGroupsServer)
		})
		resp, err = s.trDedicatedHostGroupsServer.Do(req)
	case "DedicatedHostsClient":
		initServer(s, &s.trDedicatedHostsServer, func() *DedicatedHostsServerTransport {
			return NewDedicatedHostsServerTransport(&s.srv.DedicatedHostsServer)
		})
		resp, err = s.trDedicatedHostsServer.Do(req)
	case "DiskAccessesClient":
		initServer(s, &s.trDiskAccessesServer, func() *DiskAccessesServerTransport { return NewDiskAccessesServerTransport(&s.srv.DiskAccessesServer) })
		resp, err = s.trDiskAccessesServer.Do(req)
	case "DiskEncryptionSetsClient":
		initServer(s, &s.trDiskEncryptionSetsServer, func() *DiskEncryptionSetsServerTransport {
			return NewDiskEncryptionSetsServerTransport(&s.srv.DiskEncryptionSetsServer)
		})
		resp, err = s.trDiskEncryptionSetsServer.Do(req)
	case "DiskRestorePointClient":
		initServer(s, &s.trDiskRestorePointServer, func() *DiskRestorePointServerTransport {
			return NewDiskRestorePointServerTransport(&s.srv.DiskRestorePointServer)
		})
		resp, err = s.trDiskRestorePointServer.Do(req)
	case "DisksClient":
		initServer(s, &s.trDisksServer, func() *DisksServerTransport { return NewDisksServerTransport(&s.srv.DisksServer) })
		resp, err = s.trDisksServer.Do(req)
	case "GalleriesClient":
		initServer(s, &s.trGalleriesServer, func() *GalleriesServerTransport { return NewGalleriesServerTransport(&s.srv.GalleriesServer) })
		resp, err = s.trGalleriesServer.Do(req)
	case "GalleryApplicationVersionsClient":
		initServer(s, &s.trGalleryApplicationVersionsServer, func() *GalleryApplicationVersionsServerTransport {
			return NewGalleryApplicationVersionsServerTransport(&s.srv.GalleryApplicationVersionsServer)
		})
		resp, err = s.trGalleryApplicationVersionsServer.Do(req)
	case "GalleryApplicationsClient":
		initServer(s, &s.trGalleryApplicationsServer, func() *GalleryApplicationsServerTransport {
			return NewGalleryApplicationsServerTransport(&s.srv.GalleryApplicationsServer)
		})
		resp, err = s.trGalleryApplicationsServer.Do(req)
	case "GalleryImageVersionsClient":
		initServer(s, &s.trGalleryImageVersionsServer, func() *GalleryImageVersionsServerTransport {
			return NewGalleryImageVersionsServerTransport(&s.srv.GalleryImageVersionsServer)
		})
		resp, err = s.trGalleryImageVersionsServer.Do(req)
	case "GalleryImagesClient":
		initServer(s, &s.trGalleryImagesServer, func() *GalleryImagesServerTransport {
			return NewGalleryImagesServerTransport(&s.srv.GalleryImagesServer)
		})
		resp, err = s.trGalleryImagesServer.Do(req)
	case "GallerySharingProfileClient":
		initServer(s, &s.trGallerySharingProfileServer, func() *GallerySharingProfileServerTransport {
			return NewGallerySharingProfileServerTransport(&s.srv.GallerySharingProfileServer)
		})
		resp, err = s.trGallerySharingProfileServer.Do(req)
	case "ImagesClient":
		initServer(s, &s.trImagesServer, func() *ImagesServerTransport { return NewImagesServerTransport(&s.srv.ImagesServer) })
		resp, err = s.trImagesServer.Do(req)
	case "LogAnalyticsClient":
		initServer(s, &s.trLogAnalyticsServer, func() *LogAnalyticsServerTransport { return NewLogAnalyticsServerTransport(&s.srv.LogAnalyticsServer) })
		resp, err = s.trLogAnalyticsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "ProximityPlacementGroupsClient":
		initServer(s, &s.trProximityPlacementGroupsServer, func() *ProximityPlacementGroupsServerTransport {
			return NewProximityPlacementGroupsServerTransport(&s.srv.ProximityPlacementGroupsServer)
		})
		resp, err = s.trProximityPlacementGroupsServer.Do(req)
	case "ResourceSKUsClient":
		initServer(s, &s.trResourceSKUsServer, func() *ResourceSKUsServerTransport { return NewResourceSKUsServerTransport(&s.srv.ResourceSKUsServer) })
		resp, err = s.trResourceSKUsServer.Do(req)
	case "RestorePointCollectionsClient":
		initServer(s, &s.trRestorePointCollectionsServer, func() *RestorePointCollectionsServerTransport {
			return NewRestorePointCollectionsServerTransport(&s.srv.RestorePointCollectionsServer)
		})
		resp, err = s.trRestorePointCollectionsServer.Do(req)
	case "RestorePointsClient":
		initServer(s, &s.trRestorePointsServer, func() *RestorePointsServerTransport {
			return NewRestorePointsServerTransport(&s.srv.RestorePointsServer)
		})
		resp, err = s.trRestorePointsServer.Do(req)
	case "SSHPublicKeysClient":
		initServer(s, &s.trSSHPublicKeysServer, func() *SSHPublicKeysServerTransport {
			return NewSSHPublicKeysServerTransport(&s.srv.SSHPublicKeysServer)
		})
		resp, err = s.trSSHPublicKeysServer.Do(req)
	case "SharedGalleriesClient":
		initServer(s, &s.trSharedGalleriesServer, func() *SharedGalleriesServerTransport {
			return NewSharedGalleriesServerTransport(&s.srv.SharedGalleriesServer)
		})
		resp, err = s.trSharedGalleriesServer.Do(req)
	case "SharedGalleryImageVersionsClient":
		initServer(s, &s.trSharedGalleryImageVersionsServer, func() *SharedGalleryImageVersionsServerTransport {
			return NewSharedGalleryImageVersionsServerTransport(&s.srv.SharedGalleryImageVersionsServer)
		})
		resp, err = s.trSharedGalleryImageVersionsServer.Do(req)
	case "SharedGalleryImagesClient":
		initServer(s, &s.trSharedGalleryImagesServer, func() *SharedGalleryImagesServerTransport {
			return NewSharedGalleryImagesServerTransport(&s.srv.SharedGalleryImagesServer)
		})
		resp, err = s.trSharedGalleryImagesServer.Do(req)
	case "SnapshotsClient":
		initServer(s, &s.trSnapshotsServer, func() *SnapshotsServerTransport { return NewSnapshotsServerTransport(&s.srv.SnapshotsServer) })
		resp, err = s.trSnapshotsServer.Do(req)
	case "UsageClient":
		initServer(s, &s.trUsageServer, func() *UsageServerTransport { return NewUsageServerTransport(&s.srv.UsageServer) })
		resp, err = s.trUsageServer.Do(req)
	case "VirtualMachineExtensionImagesClient":
		initServer(s, &s.trVirtualMachineExtensionImagesServer, func() *VirtualMachineExtensionImagesServerTransport {
			return NewVirtualMachineExtensionImagesServerTransport(&s.srv.VirtualMachineExtensionImagesServer)
		})
		resp, err = s.trVirtualMachineExtensionImagesServer.Do(req)
	case "VirtualMachineExtensionsClient":
		initServer(s, &s.trVirtualMachineExtensionsServer, func() *VirtualMachineExtensionsServerTransport {
			return NewVirtualMachineExtensionsServerTransport(&s.srv.VirtualMachineExtensionsServer)
		})
		resp, err = s.trVirtualMachineExtensionsServer.Do(req)
	case "VirtualMachineImagesClient":
		initServer(s, &s.trVirtualMachineImagesServer, func() *VirtualMachineImagesServerTransport {
			return NewVirtualMachineImagesServerTransport(&s.srv.VirtualMachineImagesServer)
		})
		resp, err = s.trVirtualMachineImagesServer.Do(req)
	case "VirtualMachineImagesEdgeZoneClient":
		initServer(s, &s.trVirtualMachineImagesEdgeZoneServer, func() *VirtualMachineImagesEdgeZoneServerTransport {
			return NewVirtualMachineImagesEdgeZoneServerTransport(&s.srv.VirtualMachineImagesEdgeZoneServer)
		})
		resp, err = s.trVirtualMachineImagesEdgeZoneServer.Do(req)
	case "VirtualMachineRunCommandsClient":
		initServer(s, &s.trVirtualMachineRunCommandsServer, func() *VirtualMachineRunCommandsServerTransport {
			return NewVirtualMachineRunCommandsServerTransport(&s.srv.VirtualMachineRunCommandsServer)
		})
		resp, err = s.trVirtualMachineRunCommandsServer.Do(req)
	case "VirtualMachineScaleSetExtensionsClient":
		initServer(s, &s.trVirtualMachineScaleSetExtensionsServer, func() *VirtualMachineScaleSetExtensionsServerTransport {
			return NewVirtualMachineScaleSetExtensionsServerTransport(&s.srv.VirtualMachineScaleSetExtensionsServer)
		})
		resp, err = s.trVirtualMachineScaleSetExtensionsServer.Do(req)
	case "VirtualMachineScaleSetRollingUpgradesClient":
		initServer(s, &s.trVirtualMachineScaleSetRollingUpgradesServer, func() *VirtualMachineScaleSetRollingUpgradesServerTransport {
			return NewVirtualMachineScaleSetRollingUpgradesServerTransport(&s.srv.VirtualMachineScaleSetRollingUpgradesServer)
		})
		resp, err = s.trVirtualMachineScaleSetRollingUpgradesServer.Do(req)
	case "VirtualMachineScaleSetVMExtensionsClient":
		initServer(s, &s.trVirtualMachineScaleSetVMExtensionsServer, func() *VirtualMachineScaleSetVMExtensionsServerTransport {
			return NewVirtualMachineScaleSetVMExtensionsServerTransport(&s.srv.VirtualMachineScaleSetVMExtensionsServer)
		})
		resp, err = s.trVirtualMachineScaleSetVMExtensionsServer.Do(req)
	case "VirtualMachineScaleSetVMRunCommandsClient":
		initServer(s, &s.trVirtualMachineScaleSetVMRunCommandsServer, func() *VirtualMachineScaleSetVMRunCommandsServerTransport {
			return NewVirtualMachineScaleSetVMRunCommandsServerTransport(&s.srv.VirtualMachineScaleSetVMRunCommandsServer)
		})
		resp, err = s.trVirtualMachineScaleSetVMRunCommandsServer.Do(req)
	case "VirtualMachineScaleSetVMsClient":
		initServer(s, &s.trVirtualMachineScaleSetVMsServer, func() *VirtualMachineScaleSetVMsServerTransport {
			return NewVirtualMachineScaleSetVMsServerTransport(&s.srv.VirtualMachineScaleSetVMsServer)
		})
		resp, err = s.trVirtualMachineScaleSetVMsServer.Do(req)
	case "VirtualMachineScaleSetsClient":
		initServer(s, &s.trVirtualMachineScaleSetsServer, func() *VirtualMachineScaleSetsServerTransport {
			return NewVirtualMachineScaleSetsServerTransport(&s.srv.VirtualMachineScaleSetsServer)
		})
		resp, err = s.trVirtualMachineScaleSetsServer.Do(req)
	case "VirtualMachineSizesClient":
		initServer(s, &s.trVirtualMachineSizesServer, func() *VirtualMachineSizesServerTransport {
			return NewVirtualMachineSizesServerTransport(&s.srv.VirtualMachineSizesServer)
		})
		resp, err = s.trVirtualMachineSizesServer.Do(req)
	case "VirtualMachinesClient":
		initServer(s, &s.trVirtualMachinesServer, func() *VirtualMachinesServerTransport {
			return NewVirtualMachinesServerTransport(&s.srv.VirtualMachinesServer)
		})
		resp, err = s.trVirtualMachinesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
