//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blockchain/armblockchain"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// TransactionNodesServer is a fake server for instances of the armblockchain.TransactionNodesClient type.
type TransactionNodesServer struct {
	// BeginCreate is the fake for method TransactionNodesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, blockchainMemberName string, transactionNodeName string, resourceGroupName string, options *armblockchain.TransactionNodesClientBeginCreateOptions) (resp azfake.PollerResponder[armblockchain.TransactionNodesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method TransactionNodesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, blockchainMemberName string, transactionNodeName string, resourceGroupName string, options *armblockchain.TransactionNodesClientBeginDeleteOptions) (resp azfake.PollerResponder[armblockchain.TransactionNodesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method TransactionNodesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, blockchainMemberName string, transactionNodeName string, resourceGroupName string, options *armblockchain.TransactionNodesClientGetOptions) (resp azfake.Responder[armblockchain.TransactionNodesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method TransactionNodesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(blockchainMemberName string, resourceGroupName string, options *armblockchain.TransactionNodesClientListOptions) (resp azfake.PagerResponder[armblockchain.TransactionNodesClientListResponse])

	// ListAPIKeys is the fake for method TransactionNodesClient.ListAPIKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListAPIKeys func(ctx context.Context, blockchainMemberName string, transactionNodeName string, resourceGroupName string, options *armblockchain.TransactionNodesClientListAPIKeysOptions) (resp azfake.Responder[armblockchain.TransactionNodesClientListAPIKeysResponse], errResp azfake.ErrorResponder)

	// ListRegenerateAPIKeys is the fake for method TransactionNodesClient.ListRegenerateAPIKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListRegenerateAPIKeys func(ctx context.Context, blockchainMemberName string, transactionNodeName string, resourceGroupName string, options *armblockchain.TransactionNodesClientListRegenerateAPIKeysOptions) (resp azfake.Responder[armblockchain.TransactionNodesClientListRegenerateAPIKeysResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method TransactionNodesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, blockchainMemberName string, transactionNodeName string, resourceGroupName string, options *armblockchain.TransactionNodesClientUpdateOptions) (resp azfake.Responder[armblockchain.TransactionNodesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewTransactionNodesServerTransport creates a new instance of TransactionNodesServerTransport with the provided implementation.
// The returned TransactionNodesServerTransport instance is connected to an instance of armblockchain.TransactionNodesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTransactionNodesServerTransport(srv *TransactionNodesServer) *TransactionNodesServerTransport {
	return &TransactionNodesServerTransport{
		srv:          srv,
		beginCreate:  newTracker[azfake.PollerResponder[armblockchain.TransactionNodesClientCreateResponse]](),
		beginDelete:  newTracker[azfake.PollerResponder[armblockchain.TransactionNodesClientDeleteResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armblockchain.TransactionNodesClientListResponse]](),
	}
}

// TransactionNodesServerTransport connects instances of armblockchain.TransactionNodesClient to instances of TransactionNodesServer.
// Don't use this type directly, use NewTransactionNodesServerTransport instead.
type TransactionNodesServerTransport struct {
	srv          *TransactionNodesServer
	beginCreate  *tracker[azfake.PollerResponder[armblockchain.TransactionNodesClientCreateResponse]]
	beginDelete  *tracker[azfake.PollerResponder[armblockchain.TransactionNodesClientDeleteResponse]]
	newListPager *tracker[azfake.PagerResponder[armblockchain.TransactionNodesClientListResponse]]
}

// Do implements the policy.Transporter interface for TransactionNodesServerTransport.
func (t *TransactionNodesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TransactionNodesClient.BeginCreate":
		resp, err = t.dispatchBeginCreate(req)
	case "TransactionNodesClient.BeginDelete":
		resp, err = t.dispatchBeginDelete(req)
	case "TransactionNodesClient.Get":
		resp, err = t.dispatchGet(req)
	case "TransactionNodesClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	case "TransactionNodesClient.ListAPIKeys":
		resp, err = t.dispatchListAPIKeys(req)
	case "TransactionNodesClient.ListRegenerateAPIKeys":
		resp, err = t.dispatchListRegenerateAPIKeys(req)
	case "TransactionNodesClient.Update":
		resp, err = t.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TransactionNodesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if t.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := t.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/transactionNodes/(?P<transactionNodeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armblockchain.TransactionNode](req)
		if err != nil {
			return nil, err
		}
		blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
		if err != nil {
			return nil, err
		}
		transactionNodeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("transactionNodeName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		var options *armblockchain.TransactionNodesClientBeginCreateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armblockchain.TransactionNodesClientBeginCreateOptions{
				TransactionNode: &body,
			}
		}
		respr, errRespr := t.srv.BeginCreate(req.Context(), blockchainMemberNameParam, transactionNodeNameParam, resourceGroupNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		t.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		t.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		t.beginCreate.remove(req)
	}

	return resp, nil
}

func (t *TransactionNodesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if t.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := t.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/transactionNodes/(?P<transactionNodeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
		if err != nil {
			return nil, err
		}
		transactionNodeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("transactionNodeName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginDelete(req.Context(), blockchainMemberNameParam, transactionNodeNameParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		t.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		t.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		t.beginDelete.remove(req)
	}

	return resp, nil
}

func (t *TransactionNodesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/transactionNodes/(?P<transactionNodeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
	if err != nil {
		return nil, err
	}
	transactionNodeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("transactionNodeName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), blockchainMemberNameParam, transactionNodeNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TransactionNode, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TransactionNodesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/transactionNodes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListPager(blockchainMemberNameParam, resourceGroupNameParam, nil)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armblockchain.TransactionNodesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}

func (t *TransactionNodesServerTransport) dispatchListAPIKeys(req *http.Request) (*http.Response, error) {
	if t.srv.ListAPIKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAPIKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/transactionNodes/(?P<transactionNodeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listApiKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
	if err != nil {
		return nil, err
	}
	transactionNodeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("transactionNodeName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.ListAPIKeys(req.Context(), blockchainMemberNameParam, transactionNodeNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKeyCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TransactionNodesServerTransport) dispatchListRegenerateAPIKeys(req *http.Request) (*http.Response, error) {
	if t.srv.ListRegenerateAPIKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListRegenerateAPIKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/transactionNodes/(?P<transactionNodeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateApiKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armblockchain.APIKey](req)
	if err != nil {
		return nil, err
	}
	blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
	if err != nil {
		return nil, err
	}
	transactionNodeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("transactionNodeName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	var options *armblockchain.TransactionNodesClientListRegenerateAPIKeysOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armblockchain.TransactionNodesClientListRegenerateAPIKeysOptions{
			APIKey: &body,
		}
	}
	respr, errRespr := t.srv.ListRegenerateAPIKeys(req.Context(), blockchainMemberNameParam, transactionNodeNameParam, resourceGroupNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKeyCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TransactionNodesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blockchain/blockchainMembers/(?P<blockchainMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/transactionNodes/(?P<transactionNodeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armblockchain.TransactionNodeUpdate](req)
	if err != nil {
		return nil, err
	}
	blockchainMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blockchainMemberName")])
	if err != nil {
		return nil, err
	}
	transactionNodeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("transactionNodeName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	var options *armblockchain.TransactionNodesClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armblockchain.TransactionNodesClientUpdateOptions{
			TransactionNode: &body,
		}
	}
	respr, errRespr := t.srv.Update(req.Context(), blockchainMemberNameParam, transactionNodeNameParam, resourceGroupNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TransactionNode, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
