//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billingbenefits/armbillingbenefits/v2"
	"net/http"
	"net/url"
	"regexp"
)

// SavingsPlanOrderAliasServer is a fake server for instances of the armbillingbenefits.SavingsPlanOrderAliasClient type.
type SavingsPlanOrderAliasServer struct {
	// BeginCreate is the fake for method SavingsPlanOrderAliasClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, savingsPlanOrderAliasName string, body armbillingbenefits.SavingsPlanOrderAliasModel, options *armbillingbenefits.SavingsPlanOrderAliasClientBeginCreateOptions) (resp azfake.PollerResponder[armbillingbenefits.SavingsPlanOrderAliasClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SavingsPlanOrderAliasClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, savingsPlanOrderAliasName string, options *armbillingbenefits.SavingsPlanOrderAliasClientGetOptions) (resp azfake.Responder[armbillingbenefits.SavingsPlanOrderAliasClientGetResponse], errResp azfake.ErrorResponder)
}

// NewSavingsPlanOrderAliasServerTransport creates a new instance of SavingsPlanOrderAliasServerTransport with the provided implementation.
// The returned SavingsPlanOrderAliasServerTransport instance is connected to an instance of armbillingbenefits.SavingsPlanOrderAliasClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSavingsPlanOrderAliasServerTransport(srv *SavingsPlanOrderAliasServer) *SavingsPlanOrderAliasServerTransport {
	return &SavingsPlanOrderAliasServerTransport{
		srv:         srv,
		beginCreate: newTracker[azfake.PollerResponder[armbillingbenefits.SavingsPlanOrderAliasClientCreateResponse]](),
	}
}

// SavingsPlanOrderAliasServerTransport connects instances of armbillingbenefits.SavingsPlanOrderAliasClient to instances of SavingsPlanOrderAliasServer.
// Don't use this type directly, use NewSavingsPlanOrderAliasServerTransport instead.
type SavingsPlanOrderAliasServerTransport struct {
	srv         *SavingsPlanOrderAliasServer
	beginCreate *tracker[azfake.PollerResponder[armbillingbenefits.SavingsPlanOrderAliasClientCreateResponse]]
}

// Do implements the policy.Transporter interface for SavingsPlanOrderAliasServerTransport.
func (s *SavingsPlanOrderAliasServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SavingsPlanOrderAliasClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "SavingsPlanOrderAliasClient.Get":
		resp, err = s.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SavingsPlanOrderAliasServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/providers/Microsoft\.BillingBenefits/savingsPlanOrderAliases/(?P<savingsPlanOrderAliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armbillingbenefits.SavingsPlanOrderAliasModel](req)
		if err != nil {
			return nil, err
		}
		savingsPlanOrderAliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("savingsPlanOrderAliasName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), savingsPlanOrderAliasNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *SavingsPlanOrderAliasServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.BillingBenefits/savingsPlanOrderAliases/(?P<savingsPlanOrderAliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	savingsPlanOrderAliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("savingsPlanOrderAliasName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), savingsPlanOrderAliasNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SavingsPlanOrderAliasModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
