//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armbaremetalinfrastructure_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/baremetalinfrastructure/armbaremetalinfrastructure/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/90115af9fda46f323e5c42c274f2b376108d1d47/specification/baremetalinfrastructure/resource-manager/Microsoft.BareMetalInfrastructure/preview/2023-08-04-preview/examples/AzureBareMetalInstances_Start.json
func ExampleAzureBareMetalInstancesClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbaremetalinfrastructure.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureBareMetalInstancesClient().BeginStart(ctx, "myResourceGroup", "myABMInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatus = armbaremetalinfrastructure.OperationStatus{
	// 	Name: to.Ptr("00000000-0000-0000-0000-000000000001"),
	// 	Error: &armbaremetalinfrastructure.OperationStatusError{
	// 		Code: to.Ptr(""),
	// 		Message: to.Ptr(""),
	// 	},
	// 	StartTime: to.Ptr("2023-08-01T21:17:24.9052926Z"),
	// 	Status: to.Ptr(armbaremetalinfrastructure.AsyncOperationStatus("InProgress")),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/90115af9fda46f323e5c42c274f2b376108d1d47/specification/baremetalinfrastructure/resource-manager/Microsoft.BareMetalInfrastructure/preview/2023-08-04-preview/examples/AzureBareMetalInstances_Restart.json
func ExampleAzureBareMetalInstancesClient_BeginRestart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbaremetalinfrastructure.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureBareMetalInstancesClient().BeginRestart(ctx, "myResourceGroup", "myABMInstance", &armbaremetalinfrastructure.AzureBareMetalInstancesClientBeginRestartOptions{ForceParameter: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatus = armbaremetalinfrastructure.OperationStatus{
	// 	Name: to.Ptr("00000000-0000-0000-0000-0000000000001"),
	// 	Error: &armbaremetalinfrastructure.OperationStatusError{
	// 		Code: to.Ptr(""),
	// 		Message: to.Ptr(""),
	// 	},
	// 	StartTime: to.Ptr("2023-08-01T21:17:24.9052926Z"),
	// 	Status: to.Ptr(armbaremetalinfrastructure.AsyncOperationStatus("InProgress")),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/90115af9fda46f323e5c42c274f2b376108d1d47/specification/baremetalinfrastructure/resource-manager/Microsoft.BareMetalInfrastructure/preview/2023-08-04-preview/examples/AzureBareMetalInstances_Shutdown.json
func ExampleAzureBareMetalInstancesClient_BeginShutdown() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbaremetalinfrastructure.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureBareMetalInstancesClient().BeginShutdown(ctx, "myResourceGroup", "myABMInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatus = armbaremetalinfrastructure.OperationStatus{
	// 	Name: to.Ptr("00000000-0000-0000-0000-000000000001"),
	// 	Error: &armbaremetalinfrastructure.OperationStatusError{
	// 		Code: to.Ptr(""),
	// 		Message: to.Ptr(""),
	// 	},
	// 	StartTime: to.Ptr("2023-08-01T21:17:24.9052926Z"),
	// 	Status: to.Ptr(armbaremetalinfrastructure.AsyncOperationStatus("InProgress")),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/90115af9fda46f323e5c42c274f2b376108d1d47/specification/baremetalinfrastructure/resource-manager/Microsoft.BareMetalInfrastructure/preview/2023-08-04-preview/examples/AzureBareMetalInstances_ListBySubscription.json
func ExampleAzureBareMetalInstancesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbaremetalinfrastructure.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAzureBareMetalInstancesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AzureBareMetalInstancesListResult = armbaremetalinfrastructure.AzureBareMetalInstancesListResult{
		// 	Value: []*armbaremetalinfrastructure.AzureBareMetalInstance{
		// 		{
		// 			Name: to.Ptr("myAzureBareMetalInstance1"),
		// 			Type: to.Ptr("Microsoft.BareMetalInfrastructure/bareMetalInstances"),
		// 			ID: to.Ptr("/subscriptions/57d3422f-467a-448e-b798-ebf490849542/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/bareMetalInstances/myAzureBareMetalInstance1"),
		// 			SystemData: &armbaremetalinfrastructure.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-21T08:01:22.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@microsoft.com"),
		// 				CreatedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-13T08:01:22.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("westus2"),
		// 			Tags: map[string]*string{
		// 				"key": to.Ptr("value"),
		// 			},
		// 			Properties: &armbaremetalinfrastructure.AzureBareMetalInstanceProperties{
		// 				AzureBareMetalInstanceID: to.Ptr("23415635-4d7e-41dc-9598-8194f22c24e1"),
		// 				HardwareProfile: &armbaremetalinfrastructure.HardwareProfile{
		// 					AzureBareMetalInstanceSize: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstanceSizeNamesEnumS72),
		// 					HardwareType: to.Ptr(armbaremetalinfrastructure.AzureBareMetalHardwareTypeNamesEnumCiscoUCS),
		// 				},
		// 				HwRevision: to.Ptr("Rev 4.2"),
		// 				NetworkProfile: &armbaremetalinfrastructure.NetworkProfile{
		// 					CircuitID: to.Ptr("/subscriptions/57d3422f-467a-448e-b798-ebf490849542/resourceGroups/myResourceGroup/providers/Microsoft.Network/expressRouteCircuits/myCircuitId"),
		// 					NetworkInterfaces: []*armbaremetalinfrastructure.NetworkInterface{
		// 						{
		// 							IPAddress: to.Ptr("123.123.123.123"),
		// 					}},
		// 				},
		// 				OSProfile: &armbaremetalinfrastructure.OSProfile{
		// 					ComputerName: to.Ptr("myComputerName"),
		// 					OSType: to.Ptr("SLES 12 SP2"),
		// 					Version: to.Ptr("12 SP2"),
		// 				},
		// 				PowerState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstancePowerStateEnumRestarting),
		// 				ProvisioningState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalProvisioningStatesEnumSucceeded),
		// 				StorageProfile: &armbaremetalinfrastructure.StorageProfile{
		// 					NfsIPAddress: to.Ptr("123.123.119.123"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myAzureBareMetalInstance2"),
		// 			Type: to.Ptr("Microsoft.BareMetalInfrastructure/bareMetalInstances"),
		// 			ID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/bareMetalInstances/myAzureBareMetalInstance2"),
		// 			SystemData: &armbaremetalinfrastructure.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-21T08:01:22.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@microsoft.com"),
		// 				CreatedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-13T08:01:22.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("westus2"),
		// 			Tags: map[string]*string{
		// 				"key": to.Ptr("value"),
		// 			},
		// 			Properties: &armbaremetalinfrastructure.AzureBareMetalInstanceProperties{
		// 				AzureBareMetalInstanceID: to.Ptr("589bce49-9fe6-4dc8-82df-cf6ae25e0cb9"),
		// 				HardwareProfile: &armbaremetalinfrastructure.HardwareProfile{
		// 					AzureBareMetalInstanceSize: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstanceSizeNamesEnumS72),
		// 					HardwareType: to.Ptr(armbaremetalinfrastructure.AzureBareMetalHardwareTypeNamesEnumCiscoUCS),
		// 				},
		// 				HwRevision: to.Ptr("Rev 4.2"),
		// 				NetworkProfile: &armbaremetalinfrastructure.NetworkProfile{
		// 					CircuitID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Network/expressRouteCircuits/myCircuitId"),
		// 					NetworkInterfaces: []*armbaremetalinfrastructure.NetworkInterface{
		// 						{
		// 							IPAddress: to.Ptr("123.123.123.123"),
		// 					}},
		// 				},
		// 				OSProfile: &armbaremetalinfrastructure.OSProfile{
		// 					ComputerName: to.Ptr("myComputerName2"),
		// 					OSType: to.Ptr("SLES 12 SP2"),
		// 					Version: to.Ptr("12 SP2"),
		// 				},
		// 				PowerState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstancePowerStateEnumRestarting),
		// 				ProvisioningState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalProvisioningStatesEnumSucceeded),
		// 				StorageProfile: &armbaremetalinfrastructure.StorageProfile{
		// 					NfsIPAddress: to.Ptr("123.123.119.123"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/90115af9fda46f323e5c42c274f2b376108d1d47/specification/baremetalinfrastructure/resource-manager/Microsoft.BareMetalInfrastructure/preview/2023-08-04-preview/examples/AzureBareMetalInstances_ListByResourceGroup.json
func ExampleAzureBareMetalInstancesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbaremetalinfrastructure.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAzureBareMetalInstancesClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AzureBareMetalInstancesListResult = armbaremetalinfrastructure.AzureBareMetalInstancesListResult{
		// 	Value: []*armbaremetalinfrastructure.AzureBareMetalInstance{
		// 		{
		// 			Name: to.Ptr("myAzureBareMetalInstance1"),
		// 			Type: to.Ptr("Microsoft.BareMetalInfrastructure/azureBareMetalInstances"),
		// 			ID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/azureBareMetalInstances/myAzureBareMetalInstance1"),
		// 			SystemData: &armbaremetalinfrastructure.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-20T23:10:22.682Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@microsoft.com"),
		// 				CreatedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-21T08:01:22.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 				"key": to.Ptr("value"),
		// 			},
		// 			Properties: &armbaremetalinfrastructure.AzureBareMetalInstanceProperties{
		// 				AzureBareMetalInstanceID: to.Ptr("23415635-4d7e-41dc-9598-8194f22c24e1"),
		// 				HardwareProfile: &armbaremetalinfrastructure.HardwareProfile{
		// 					AzureBareMetalInstanceSize: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstanceSizeNamesEnumS72),
		// 					HardwareType: to.Ptr(armbaremetalinfrastructure.AzureBareMetalHardwareTypeNamesEnumCiscoUCS),
		// 				},
		// 				HwRevision: to.Ptr("Rev 3"),
		// 				NetworkProfile: &armbaremetalinfrastructure.NetworkProfile{
		// 					CircuitID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Network/expressRouteCircuit"),
		// 					NetworkInterfaces: []*armbaremetalinfrastructure.NetworkInterface{
		// 						{
		// 							IPAddress: to.Ptr("100.100.100.100"),
		// 					}},
		// 				},
		// 				OSProfile: &armbaremetalinfrastructure.OSProfile{
		// 					ComputerName: to.Ptr("myComputerName1"),
		// 					OSType: to.Ptr("SUSE"),
		// 					SSHPublicKey: to.Ptr("AAAAB3NzaC1yc2EAAAABJQAAAQB/nAmOjTmezNUDKYvEeIRf2YnwM9/uUG1d0BYsc8/tRtx+RGi7N2lUbp728MXGwdnL9od4cItzky/zVdLZE2cycOa18xBK9cOWmcKS0A8FYBxEQWJ/q9YVUgZbFKfYGaGQxsER+A0w/fX8ALuk78ktP31K69LcQgxIsl7rNzxsoOQKJ/CIxOGMMxczYTiEoLvQhapFQMs3FL96didKr/QbrfB1WT6s3838SEaXfgZvLef1YB2xmfhbT9OXFE3FXvh2UPBfN+ffE7iiayQf/2XR+8j4N4bW30DiPtOQLGUrH1y5X/rpNZNlWW2+jGIxqZtgWg7lTy3mXy5x836Sj/6L"),
		// 					Version: to.Ptr("12 SP1"),
		// 				},
		// 				PowerState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstancePowerStateEnumStarted),
		// 				ProvisioningState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalProvisioningStatesEnumSucceeded),
		// 				ProximityPlacementGroup: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Compute/proximityPlacementGroups/myplacementgroup"),
		// 				StorageProfile: &armbaremetalinfrastructure.StorageProfile{
		// 					NfsIPAddress: to.Ptr("200.200.200.200"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myABMInstance2"),
		// 			Type: to.Ptr("Microsoft.BareMetalInfrastructure/azureBareMetalInstances"),
		// 			ID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/azureBareMetalInstances/myABMInstance2"),
		// 			SystemData: &armbaremetalinfrastructure.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-21T08:01:22.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@microsoft.com"),
		// 				CreatedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-13T08:01:22.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 				"key": to.Ptr("value"),
		// 			},
		// 			Properties: &armbaremetalinfrastructure.AzureBareMetalInstanceProperties{
		// 				AzureBareMetalInstanceID: to.Ptr("589bce49-9fe6-4dc8-82df-cf6ae25e0cb9"),
		// 				HardwareProfile: &armbaremetalinfrastructure.HardwareProfile{
		// 					AzureBareMetalInstanceSize: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstanceSizeNamesEnumS384),
		// 					HardwareType: to.Ptr(armbaremetalinfrastructure.AzureBareMetalHardwareTypeNamesEnumHPE),
		// 				},
		// 				HwRevision: to.Ptr("Rev 3"),
		// 				NetworkProfile: &armbaremetalinfrastructure.NetworkProfile{
		// 					CircuitID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Network/expressRouteCircuit"),
		// 					NetworkInterfaces: []*armbaremetalinfrastructure.NetworkInterface{
		// 						{
		// 							IPAddress: to.Ptr("100.100.100.101"),
		// 					}},
		// 				},
		// 				OSProfile: &armbaremetalinfrastructure.OSProfile{
		// 					ComputerName: to.Ptr("myComputerName2"),
		// 					OSType: to.Ptr("SUSE"),
		// 					SSHPublicKey: to.Ptr("AAAAB3NzaC1yc2EAAAABJQAAAQB/nAmOjTmezNUDKYvEeIRf2YnwM9/uUG1d0BYsc8/tRtx+RGi7N2lUbp728MXGwdnL9od4cItzky/zVdLZE2cycOa18xBK9cOWmcKS0A8FYBxEQWJ/q9YVUgZbFKfYGaGQxsER+A0w/fX8ALuk78ktP31K69LcQgxIsl7rNzxsoOQKJ/CIxOGMMxczYTiEoLvQhapFQMs3FL96didKr/QbrfB1WT6s3838SEaXfgZvLef1YB2xmfhbT9OXFE3FXvh2UPBfN+ffE7iiayQf/2XR+8j4N4bW30DiPtOQLGUrH1y5X/rpNZNlWW2+jGIxqZtgWg7lTy3mXy5x836Sj/6L"),
		// 					Version: to.Ptr("12 SP1"),
		// 				},
		// 				PartnerNodeID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/azureBareMetalInstances/myAzureBareMetalInstance1"),
		// 				PowerState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstancePowerStateEnumStarted),
		// 				ProvisioningState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalProvisioningStatesEnumSucceeded),
		// 				ProximityPlacementGroup: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Compute/proximityPlacementGroups/myplacementgroup"),
		// 				StorageProfile: &armbaremetalinfrastructure.StorageProfile{
		// 					NfsIPAddress: to.Ptr("200.200.200.201"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/90115af9fda46f323e5c42c274f2b376108d1d47/specification/baremetalinfrastructure/resource-manager/Microsoft.BareMetalInfrastructure/preview/2023-08-04-preview/examples/AzureBareMetalInstances_Get.json
func ExampleAzureBareMetalInstancesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbaremetalinfrastructure.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAzureBareMetalInstancesClient().Get(ctx, "myResourceGroup", "myAzureBareMetalInstance", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureBareMetalInstance = armbaremetalinfrastructure.AzureBareMetalInstance{
	// 	Name: to.Ptr("myAzureBareMetalInstance"),
	// 	Type: to.Ptr("Microsoft.BareMetalInfrastructure/bareMetalInstances"),
	// 	ID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/bareMetalInstances/myAzureBareMetalInstance"),
	// 	SystemData: &armbaremetalinfrastructure.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-20T23:10:22.682Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@microsoft.com"),
	// 		CreatedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-21T08:01:22.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@microsoft.com"),
	// 		LastModifiedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus2"),
	// 	Tags: map[string]*string{
	// 		"key": to.Ptr("value"),
	// 	},
	// 	Properties: &armbaremetalinfrastructure.AzureBareMetalInstanceProperties{
	// 		AzureBareMetalInstanceID: to.Ptr("23415635-4d7e-41dc-9598-8194f22c24e1"),
	// 		HardwareProfile: &armbaremetalinfrastructure.HardwareProfile{
	// 			AzureBareMetalInstanceSize: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstanceSizeNamesEnumS72),
	// 			HardwareType: to.Ptr(armbaremetalinfrastructure.AzureBareMetalHardwareTypeNamesEnumCiscoUCS),
	// 		},
	// 		HwRevision: to.Ptr("Rev 4.2"),
	// 		NetworkProfile: &armbaremetalinfrastructure.NetworkProfile{
	// 			CircuitID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Network/expressRouteCircuits/myCircuitId"),
	// 			NetworkInterfaces: []*armbaremetalinfrastructure.NetworkInterface{
	// 				{
	// 					IPAddress: to.Ptr("123.123.123.123"),
	// 			}},
	// 		},
	// 		OSProfile: &armbaremetalinfrastructure.OSProfile{
	// 			ComputerName: to.Ptr("myComputerName"),
	// 			OSType: to.Ptr("SLES 12 SP2"),
	// 			Version: to.Ptr("12 SP2"),
	// 		},
	// 		PowerState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstancePowerStateEnumRestarting),
	// 		ProvisioningState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalProvisioningStatesEnumSucceeded),
	// 		StorageProfile: &armbaremetalinfrastructure.StorageProfile{
	// 			NfsIPAddress: to.Ptr("123.123.119.123"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/90115af9fda46f323e5c42c274f2b376108d1d47/specification/baremetalinfrastructure/resource-manager/Microsoft.BareMetalInfrastructure/preview/2023-08-04-preview/examples/AzureBareMetalInstances_PatchTags_Delete.json
func ExampleAzureBareMetalInstancesClient_Update_deleteTagsFieldOfAnAzureBareMetalInstance() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbaremetalinfrastructure.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAzureBareMetalInstancesClient().Update(ctx, "myResourceGroup", "myABMInstance", armbaremetalinfrastructure.Tags{
		Tags: map[string]*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureBareMetalInstance = armbaremetalinfrastructure.AzureBareMetalInstance{
	// 	Name: to.Ptr("myABMInstance"),
	// 	Type: to.Ptr("Microsoft.BareMetalInfrastructure/bareMetalInstances"),
	// 	ID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/bareMetalInstances/myABMInstance"),
	// 	SystemData: &armbaremetalinfrastructure.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-20T23:10:22.682Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@microsoft.com"),
	// 		CreatedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-21T08:01:22.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@microsoft.com"),
	// 		LastModifiedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armbaremetalinfrastructure.AzureBareMetalInstanceProperties{
	// 		AzureBareMetalInstanceID: to.Ptr("23415635-4d7e-41dc-9598-8194f22c24e1"),
	// 		HardwareProfile: &armbaremetalinfrastructure.HardwareProfile{
	// 			AzureBareMetalInstanceSize: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstanceSizeNamesEnumS72),
	// 			HardwareType: to.Ptr(armbaremetalinfrastructure.AzureBareMetalHardwareTypeNamesEnumCiscoUCS),
	// 		},
	// 		HwRevision: to.Ptr("Rev 3"),
	// 		NetworkProfile: &armbaremetalinfrastructure.NetworkProfile{
	// 			CircuitID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Network/expressRouteCircuit"),
	// 			NetworkInterfaces: []*armbaremetalinfrastructure.NetworkInterface{
	// 				{
	// 					IPAddress: to.Ptr("100.100.100.100"),
	// 			}},
	// 		},
	// 		OSProfile: &armbaremetalinfrastructure.OSProfile{
	// 			ComputerName: to.Ptr("myComputerName"),
	// 			OSType: to.Ptr("SUSE"),
	// 			SSHPublicKey: to.Ptr("AAAAB3NzaC1yc2EAAAABJQAAAQB/nAmOjTmezNUDKYvEeIRf2YnwM9/uUG1d0BYsc8/tRtx+RGi7N2lUbp728MXGwdnL9od4cItzky/zVdLZE2cycOa18xBK9cOWmcKS0A8FYBxEQWJ/q9YVUgZbFKfYGaGQxsER+A0w/fX8ALuk78ktP31K69LcQgxIsl7rNzxsoOQKJ/CIxOGMMxczYTiEoLvQhapFQMs3FL96didKr/QbrfB1WT6s3838SEaXfgZvLef1YB2xmfhbT9OXFE3FXvh2UPBfN+ffE7iiayQf/2XR+8j4N4bW30DiPtOQLGUrH1y5X/rpNZNlWW2+jGIxqZtgWg7lTy3mXy5x836Sj/6L"),
	// 			Version: to.Ptr("12 SP1"),
	// 		},
	// 		PartnerNodeID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/bareMetalInstances/myABMInstance2"),
	// 		PowerState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstancePowerStateEnumStarted),
	// 		ProvisioningState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalProvisioningStatesEnumSucceeded),
	// 		ProximityPlacementGroup: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Compute/proximityPlacementGroups/myplacementgroup"),
	// 		StorageProfile: &armbaremetalinfrastructure.StorageProfile{
	// 			NfsIPAddress: to.Ptr("200.200.200.200"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/90115af9fda46f323e5c42c274f2b376108d1d47/specification/baremetalinfrastructure/resource-manager/Microsoft.BareMetalInfrastructure/preview/2023-08-04-preview/examples/AzureBareMetalInstances_PatchTags.json
func ExampleAzureBareMetalInstancesClient_Update_updateTagsFieldOfAnAzureBareMetalInstance() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbaremetalinfrastructure.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAzureBareMetalInstancesClient().Update(ctx, "myResourceGroup", "myABMInstance", armbaremetalinfrastructure.Tags{
		Tags: map[string]*string{
			"testkey": to.Ptr("testvalue"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureBareMetalInstance = armbaremetalinfrastructure.AzureBareMetalInstance{
	// 	Name: to.Ptr("myABMInstance"),
	// 	Type: to.Ptr("Microsoft.BareMetalInfrastructure/bareMetalInstances"),
	// 	ID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/bareMetalInstances/myABMInstance"),
	// 	SystemData: &armbaremetalinfrastructure.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-20T23:10:22.682Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@microsoft.com"),
	// 		CreatedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-21T08:01:22.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@microsoft.com"),
	// 		LastModifiedByType: to.Ptr(armbaremetalinfrastructure.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"testkey": to.Ptr("testvalue"),
	// 	},
	// 	Properties: &armbaremetalinfrastructure.AzureBareMetalInstanceProperties{
	// 		AzureBareMetalInstanceID: to.Ptr("23415635-4d7e-41dc-9598-8194f22c24e1"),
	// 		HardwareProfile: &armbaremetalinfrastructure.HardwareProfile{
	// 			AzureBareMetalInstanceSize: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstanceSizeNamesEnumS72),
	// 			HardwareType: to.Ptr(armbaremetalinfrastructure.AzureBareMetalHardwareTypeNamesEnumCiscoUCS),
	// 		},
	// 		HwRevision: to.Ptr("Rev 3"),
	// 		NetworkProfile: &armbaremetalinfrastructure.NetworkProfile{
	// 			CircuitID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Network/expressRouteCircuit"),
	// 			NetworkInterfaces: []*armbaremetalinfrastructure.NetworkInterface{
	// 				{
	// 					IPAddress: to.Ptr("100.100.100.100"),
	// 			}},
	// 		},
	// 		OSProfile: &armbaremetalinfrastructure.OSProfile{
	// 			ComputerName: to.Ptr("myComputerName"),
	// 			OSType: to.Ptr("SUSE"),
	// 			SSHPublicKey: to.Ptr("AAAAB3NzaC1yc2EAAAABJQAAAQB/nAmOjTmezNUDKYvEeIRf2YnwM9/uUG1d0BYsc8/tRtx+RGi7N2lUbp728MXGwdnL9od4cItzky/zVdLZE2cycOa18xBK9cOWmcKS0A8FYBxEQWJ/q9YVUgZbFKfYGaGQxsER+A0w/fX8ALuk78ktP31K69LcQgxIsl7rNzxsoOQKJ/CIxOGMMxczYTiEoLvQhapFQMs3FL96didKr/QbrfB1WT6s3838SEaXfgZvLef1YB2xmfhbT9OXFE3FXvh2UPBfN+ffE7iiayQf/2XR+8j4N4bW30DiPtOQLGUrH1y5X/rpNZNlWW2+jGIxqZtgWg7lTy3mXy5x836Sj/6L"),
	// 			Version: to.Ptr("12 SP1"),
	// 		},
	// 		PartnerNodeID: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.BareMetalInfrastructure/bareMetalInstances/myABMInstance2"),
	// 		PowerState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalInstancePowerStateEnumStarted),
	// 		ProvisioningState: to.Ptr(armbaremetalinfrastructure.AzureBareMetalProvisioningStatesEnumSucceeded),
	// 		ProximityPlacementGroup: to.Ptr("/subscriptions/f0f4887f-d13c-4943-a8ba-d7da28d2a3fd/resourceGroups/myResourceGroup/providers/Microsoft.Compute/proximityPlacementGroups/myplacementgroup"),
	// 		StorageProfile: &armbaremetalinfrastructure.StorageProfile{
	// 			NfsIPAddress: to.Ptr("200.200.200.200"),
	// 		},
	// 	},
	// }
}
