//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armazurearcdata

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/azurearcdata/armazurearcdata"
	moduleVersion = "v0.7.0"
)

// AccountProvisioningMode - The service account provisioning mode for this Active Directory connector.
type AccountProvisioningMode string

const (
	AccountProvisioningModeAutomatic AccountProvisioningMode = "automatic"
	AccountProvisioningModeManual    AccountProvisioningMode = "manual"
)

// PossibleAccountProvisioningModeValues returns the possible values for the AccountProvisioningMode const type.
func PossibleAccountProvisioningModeValues() []AccountProvisioningMode {
	return []AccountProvisioningMode{
		AccountProvisioningModeAutomatic,
		AccountProvisioningModeManual,
	}
}

// ArcSQLManagedInstanceLicenseType - The license type to apply for this managed instance.
type ArcSQLManagedInstanceLicenseType string

const (
	ArcSQLManagedInstanceLicenseTypeBasePrice        ArcSQLManagedInstanceLicenseType = "BasePrice"
	ArcSQLManagedInstanceLicenseTypeDisasterRecovery ArcSQLManagedInstanceLicenseType = "DisasterRecovery"
	ArcSQLManagedInstanceLicenseTypeLicenseIncluded  ArcSQLManagedInstanceLicenseType = "LicenseIncluded"
)

// PossibleArcSQLManagedInstanceLicenseTypeValues returns the possible values for the ArcSQLManagedInstanceLicenseType const type.
func PossibleArcSQLManagedInstanceLicenseTypeValues() []ArcSQLManagedInstanceLicenseType {
	return []ArcSQLManagedInstanceLicenseType{
		ArcSQLManagedInstanceLicenseTypeBasePrice,
		ArcSQLManagedInstanceLicenseTypeDisasterRecovery,
		ArcSQLManagedInstanceLicenseTypeLicenseIncluded,
	}
}

// ArcSQLServerLicenseType - SQL Server license type.
type ArcSQLServerLicenseType string

const (
	ArcSQLServerLicenseTypeFree      ArcSQLServerLicenseType = "Free"
	ArcSQLServerLicenseTypeHADR      ArcSQLServerLicenseType = "HADR"
	ArcSQLServerLicenseTypePaid      ArcSQLServerLicenseType = "Paid"
	ArcSQLServerLicenseTypeUndefined ArcSQLServerLicenseType = "Undefined"
)

// PossibleArcSQLServerLicenseTypeValues returns the possible values for the ArcSQLServerLicenseType const type.
func PossibleArcSQLServerLicenseTypeValues() []ArcSQLServerLicenseType {
	return []ArcSQLServerLicenseType{
		ArcSQLServerLicenseTypeFree,
		ArcSQLServerLicenseTypeHADR,
		ArcSQLServerLicenseTypePaid,
		ArcSQLServerLicenseTypeUndefined,
	}
}

// ConnectionStatus - The cloud connectivity status.
type ConnectionStatus string

const (
	ConnectionStatusConnected    ConnectionStatus = "Connected"
	ConnectionStatusDisconnected ConnectionStatus = "Disconnected"
	ConnectionStatusRegistered   ConnectionStatus = "Registered"
	ConnectionStatusUnknown      ConnectionStatus = "Unknown"
)

// PossibleConnectionStatusValues returns the possible values for the ConnectionStatus const type.
func PossibleConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{
		ConnectionStatusConnected,
		ConnectionStatusDisconnected,
		ConnectionStatusRegistered,
		ConnectionStatusUnknown,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DefenderStatus - Status of Azure Defender.
type DefenderStatus string

const (
	DefenderStatusProtected   DefenderStatus = "Protected"
	DefenderStatusUnknown     DefenderStatus = "Unknown"
	DefenderStatusUnprotected DefenderStatus = "Unprotected"
)

// PossibleDefenderStatusValues returns the possible values for the DefenderStatus const type.
func PossibleDefenderStatusValues() []DefenderStatus {
	return []DefenderStatus{
		DefenderStatusProtected,
		DefenderStatusUnknown,
		DefenderStatusUnprotected,
	}
}

// EditionType - SQL Server edition.
type EditionType string

const (
	EditionTypeDeveloper  EditionType = "Developer"
	EditionTypeEnterprise EditionType = "Enterprise"
	EditionTypeEvaluation EditionType = "Evaluation"
	EditionTypeExpress    EditionType = "Express"
	EditionTypeStandard   EditionType = "Standard"
	EditionTypeWeb        EditionType = "Web"
)

// PossibleEditionTypeValues returns the possible values for the EditionType const type.
func PossibleEditionTypeValues() []EditionType {
	return []EditionType{
		EditionTypeDeveloper,
		EditionTypeEnterprise,
		EditionTypeEvaluation,
		EditionTypeExpress,
		EditionTypeStandard,
		EditionTypeWeb,
	}
}

// ExtendedLocationTypes - The type of extendedLocation.
type ExtendedLocationTypes string

const (
	ExtendedLocationTypesCustomLocation ExtendedLocationTypes = "CustomLocation"
)

// PossibleExtendedLocationTypesValues returns the possible values for the ExtendedLocationTypes const type.
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return []ExtendedLocationTypes{
		ExtendedLocationTypesCustomLocation,
	}
}

// HostType - Type of host for Azure Arc SQL Server
type HostType string

const (
	HostTypeAWSVirtualMachine HostType = "AWS Virtual Machine"
	HostTypeGCPVirtualMachine HostType = "GCP Virtual Machine"
	HostTypeOther             HostType = "Other"
	HostTypePhysicalServer    HostType = "Physical Server"
	HostTypeVirtualMachine    HostType = "Virtual Machine"
)

// PossibleHostTypeValues returns the possible values for the HostType const type.
func PossibleHostTypeValues() []HostType {
	return []HostType{
		HostTypeAWSVirtualMachine,
		HostTypeGCPVirtualMachine,
		HostTypeOther,
		HostTypePhysicalServer,
		HostTypeVirtualMachine,
	}
}

// Infrastructure - The infrastructure the data controller is running on.
type Infrastructure string

const (
	InfrastructureAlibaba    Infrastructure = "alibaba"
	InfrastructureAws        Infrastructure = "aws"
	InfrastructureAzure      Infrastructure = "azure"
	InfrastructureGcp        Infrastructure = "gcp"
	InfrastructureOnpremises Infrastructure = "onpremises"
	InfrastructureOther      Infrastructure = "other"
)

// PossibleInfrastructureValues returns the possible values for the Infrastructure const type.
func PossibleInfrastructureValues() []Infrastructure {
	return []Infrastructure{
		InfrastructureAlibaba,
		InfrastructureAws,
		InfrastructureAzure,
		InfrastructureGcp,
		InfrastructureOnpremises,
		InfrastructureOther,
	}
}

// OperationOrigin - The intended executor of the operation.
type OperationOrigin string

const (
	OperationOriginSystem OperationOrigin = "system"
	OperationOriginUser   OperationOrigin = "user"
)

// PossibleOperationOriginValues returns the possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{
		OperationOriginSystem,
		OperationOriginUser,
	}
}

// SQLManagedInstanceSKUTier - The pricing tier for the instance.
type SQLManagedInstanceSKUTier string

const (
	SQLManagedInstanceSKUTierBusinessCritical SQLManagedInstanceSKUTier = "BusinessCritical"
	SQLManagedInstanceSKUTierGeneralPurpose   SQLManagedInstanceSKUTier = "GeneralPurpose"
)

// PossibleSQLManagedInstanceSKUTierValues returns the possible values for the SQLManagedInstanceSKUTier const type.
func PossibleSQLManagedInstanceSKUTierValues() []SQLManagedInstanceSKUTier {
	return []SQLManagedInstanceSKUTier{
		SQLManagedInstanceSKUTierBusinessCritical,
		SQLManagedInstanceSKUTierGeneralPurpose,
	}
}

// SQLVersion - SQL Server version.
type SQLVersion string

const (
	SQLVersionSQLServer2012 SQLVersion = "SQL Server 2012"
	SQLVersionSQLServer2014 SQLVersion = "SQL Server 2014"
	SQLVersionSQLServer2016 SQLVersion = "SQL Server 2016"
	SQLVersionSQLServer2017 SQLVersion = "SQL Server 2017"
	SQLVersionSQLServer2019 SQLVersion = "SQL Server 2019"
	SQLVersionSQLServer2022 SQLVersion = "SQL Server 2022"
	SQLVersionUnknown       SQLVersion = "Unknown"
)

// PossibleSQLVersionValues returns the possible values for the SQLVersion const type.
func PossibleSQLVersionValues() []SQLVersion {
	return []SQLVersion{
		SQLVersionSQLServer2012,
		SQLVersionSQLServer2014,
		SQLVersionSQLServer2016,
		SQLVersionSQLServer2017,
		SQLVersionSQLServer2019,
		SQLVersionSQLServer2022,
		SQLVersionUnknown,
	}
}
