//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"io"
	"net/http"
	"net/url"
	"regexp"
)

// RunbookDraftServer is a fake server for instances of the armautomation.RunbookDraftClient type.
type RunbookDraftServer struct {
	// Get is the fake for method RunbookDraftClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, options *armautomation.RunbookDraftClientGetOptions) (resp azfake.Responder[armautomation.RunbookDraftClientGetResponse], errResp azfake.ErrorResponder)

	// GetContent is the fake for method RunbookDraftClient.GetContent
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted, http.StatusNoContent
	GetContent func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, options *armautomation.RunbookDraftClientGetContentOptions) (resp azfake.Responder[armautomation.RunbookDraftClientGetContentResponse], errResp azfake.ErrorResponder)

	// BeginReplaceContent is the fake for method RunbookDraftClient.BeginReplaceContent
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReplaceContent func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, runbookContent io.ReadSeekCloser, options *armautomation.RunbookDraftClientBeginReplaceContentOptions) (resp azfake.PollerResponder[armautomation.RunbookDraftClientReplaceContentResponse], errResp azfake.ErrorResponder)

	// UndoEdit is the fake for method RunbookDraftClient.UndoEdit
	// HTTP status codes to indicate success: http.StatusOK
	UndoEdit func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, options *armautomation.RunbookDraftClientUndoEditOptions) (resp azfake.Responder[armautomation.RunbookDraftClientUndoEditResponse], errResp azfake.ErrorResponder)
}

// NewRunbookDraftServerTransport creates a new instance of RunbookDraftServerTransport with the provided implementation.
// The returned RunbookDraftServerTransport instance is connected to an instance of armautomation.RunbookDraftClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRunbookDraftServerTransport(srv *RunbookDraftServer) *RunbookDraftServerTransport {
	return &RunbookDraftServerTransport{
		srv:                 srv,
		beginReplaceContent: newTracker[azfake.PollerResponder[armautomation.RunbookDraftClientReplaceContentResponse]](),
	}
}

// RunbookDraftServerTransport connects instances of armautomation.RunbookDraftClient to instances of RunbookDraftServer.
// Don't use this type directly, use NewRunbookDraftServerTransport instead.
type RunbookDraftServerTransport struct {
	srv                 *RunbookDraftServer
	beginReplaceContent *tracker[azfake.PollerResponder[armautomation.RunbookDraftClientReplaceContentResponse]]
}

// Do implements the policy.Transporter interface for RunbookDraftServerTransport.
func (r *RunbookDraftServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RunbookDraftClient.Get":
		resp, err = r.dispatchGet(req)
	case "RunbookDraftClient.GetContent":
		resp, err = r.dispatchGetContent(req)
	case "RunbookDraftClient.BeginReplaceContent":
		resp, err = r.dispatchBeginReplaceContent(req)
	case "RunbookDraftClient.UndoEdit":
		resp, err = r.dispatchUndoEdit(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RunbookDraftServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RunbookDraft, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RunbookDraftServerTransport) dispatchGetContent(req *http.Request) (*http.Response, error) {
	if r.srv.GetContent == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetContent not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/content`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetContent(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RunbookDraftServerTransport) dispatchBeginReplaceContent(req *http.Request) (*http.Response, error) {
	if r.srv.BeginReplaceContent == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReplaceContent not implemented")}
	}
	beginReplaceContent := r.beginReplaceContent.get(req)
	if beginReplaceContent == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/content`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginReplaceContent(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, req.Body.(io.ReadSeekCloser), nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReplaceContent = &respr
		r.beginReplaceContent.add(req, beginReplaceContent)
	}

	resp, err := server.PollerResponderNext(beginReplaceContent, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginReplaceContent.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReplaceContent) {
		r.beginReplaceContent.remove(req)
	}

	return resp, nil
}

func (r *RunbookDraftServerTransport) dispatchUndoEdit(req *http.Request) (*http.Response, error) {
	if r.srv.UndoEdit == nil {
		return nil, &nonRetriableError{errors.New("fake for method UndoEdit not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/undoEdit`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.UndoEdit(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RunbookDraftUndoEditResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
